/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.internal;

import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Set;

public class NonDelegatingClassLoader
extends URLClassLoader {
    private final ClassLoader original;
    private final ImmutableSet<String> whiteList;

    public static NonDelegatingClassLoader create(Set<String> whiteList, URLClassLoader original) {
        return NonDelegatingClassLoader.create(whiteList, original.getURLs(), original);
    }

    public static NonDelegatingClassLoader create(Set<String> whiteList, URL[] urls, ClassLoader original) {
        return new NonDelegatingClassLoader(original, urls, whiteList);
    }

    private NonDelegatingClassLoader(ClassLoader original, URL[] urls, Set<String> whiteList) {
        super(urls, (ClassLoader)null);
        this.original = original;
        this.whiteList = ImmutableSet.copyOf(whiteList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name, boolean complete) throws ClassNotFoundException {
        if (this.whiteList.contains((Object)name)) {
            return this.original.loadClass(name);
        }
        try {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> c = this.findLoadedClass(name);
                if (c != null) {
                    return c;
                }
                return this.findClass(name);
            }
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(name, complete);
        }
    }
}

