/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.editor.AttributeAdder;
import proguard.classfile.editor.ClassEditor;
import proguard.classfile.editor.ConstantAdder;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class MemberAdder
extends SimplifiedVisitor
implements MemberVisitor {
    private static final boolean DEBUG = false;
    private static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];
    private final ProgramClass targetClass;
    private final MemberVisitor extraMemberVisitor;
    private final ConstantAdder constantAdder;
    private final ClassEditor classEditor;
    private final ConstantPoolEditor constantPoolEditor;

    public MemberAdder(ProgramClass programClass) {
        this(programClass, null);
    }

    public MemberAdder(ProgramClass programClass, MemberVisitor memberVisitor) {
        this.targetClass = programClass;
        this.extraMemberVisitor = memberVisitor;
        this.constantAdder = new ConstantAdder(programClass);
        this.classEditor = new ClassEditor(programClass);
        this.constantPoolEditor = new ConstantPoolEditor(programClass);
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        int n = programField.getAccessFlags();
        ProgramField programField2 = new ProgramField(n, this.constantAdder.addConstant((Clazz)programClass, programField.u2nameIndex), this.constantAdder.addConstant((Clazz)programClass, programField.u2descriptorIndex), 0, programField.u2attributesCount > 0 ? new Attribute[programField.u2attributesCount] : EMPTY_ATTRIBUTES, programField.referencedClass);
        programField2.setVisitorInfo(programField);
        programField.attributesAccept(programClass, new AttributeAdder(this.targetClass, programField2, false));
        this.classEditor.addField(programField2);
        if (this.extraMemberVisitor != null) {
            this.extraMemberVisitor.visitProgramField(this.targetClass, programField2);
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String string = programMethod.getName(programClass);
        String string2 = programMethod.getDescriptor(programClass);
        int n = programMethod.getAccessFlags();
        ProgramMethod programMethod2 = (ProgramMethod)this.targetClass.findMethod(string, string2);
        if (programMethod2 != null) {
            if ((n & 0x400) != 0) {
                return;
            }
            int n2 = programMethod2.getAccessFlags();
            if ((n2 & 0x400) != 0) {
                programMethod2.u2accessFlags = n & 0xFFFFFFEF;
                programMethod.attributesAccept(programClass, new AttributeAdder(this.targetClass, programMethod2, true));
                return;
            }
        }
        ProgramMethod programMethod3 = new ProgramMethod(n & 0xFFFFFFEF, this.constantAdder.addConstant((Clazz)programClass, programMethod.u2nameIndex), this.constantAdder.addConstant((Clazz)programClass, programMethod.u2descriptorIndex), 0, programMethod.u2attributesCount > 0 ? new Attribute[programMethod.u2attributesCount] : EMPTY_ATTRIBUTES, programMethod.referencedClasses != null ? (Clazz[])programMethod.referencedClasses.clone() : null);
        programMethod3.setVisitorInfo(programMethod);
        programMethod.attributesAccept(programClass, new AttributeAdder(this.targetClass, programMethod3, false));
        this.classEditor.addMethod(programMethod3);
        if (this.extraMemberVisitor != null) {
            this.extraMemberVisitor.visitProgramMethod(this.targetClass, programMethod3);
        }
    }

    private String newUniqueMemberName(String string, String string2) {
        return string.equals("<init>") ? "<init>" : string + '$' + Long.toHexString(Math.abs(string2.hashCode()));
    }
}

