/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Color;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartSelectionModel;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.Timeline;
import org.netbeans.lib.profiler.charts.axis.TimeAxisUtils;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemPainter;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.modules.profiler.snaptracer.ProbeItemDescriptor;
import org.netbeans.modules.profiler.snaptracer.TracerProbe;
import org.netbeans.modules.profiler.snaptracer.TracerProbeDescriptor;
import org.netbeans.modules.profiler.snaptracer.impl.IdeSnapshot;
import org.netbeans.modules.profiler.snaptracer.impl.details.DetailsPanel;
import org.netbeans.modules.profiler.snaptracer.impl.details.DetailsTableModel;
import org.netbeans.modules.profiler.snaptracer.impl.export.DataExport;
import org.netbeans.modules.profiler.snaptracer.impl.options.TracerOptions;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.PointsComputer;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineChart;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineLegendOverlay;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineModel;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelinePaintersFactory;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSelectionManager;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineTooltipOverlay;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineTooltipPainter;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineUnitsOverlay;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineXYItem;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineXYPainter;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.items.ValueItemDescriptor;

public final class TimelineSupport {
    public static final int[] EMPTY_TIMESTAMPS = new int[0];
    private final TimelineChart chart;
    private final TimelineModel model;
    private final SynchronousXYItemsModel itemsModel;
    private final PointsComputer pointsComputer;
    private final TimelineTooltipOverlay tooltips;
    private final TimelineLegendOverlay legend;
    private final TimelineUnitsOverlay units;
    private final List<TracerProbe> probes = new ArrayList<TracerProbe>();
    private final List<TimelineChart.Row> rows = new ArrayList<TimelineChart.Row>();
    private final DescriptorResolver descriptorResolver;
    private final Set<ValuesListener> valuesListeners = new HashSet<ValuesListener>();
    private final Set<Integer> selectedTimestamps = new HashSet<Integer>();
    private final List<Integer> selectedIntervals = new ArrayList<Integer>();
    private final Set<SelectionListener> selectionListeners = new HashSet<SelectionListener>();
    private final IdeSnapshot snapshot;
    private ComponentListener chartResizeHandler;
    private DetailsTableModel detailsModel;
    private static final int SCROLL_MARGIN_LEFT = 10;
    private static final int SCROLL_MARGIN_RIGHT = 50;
    private boolean hovering;
    private boolean hoveredSelected;
    private int startIndex = -1;
    private int endIndex = -1;

    public TimelineSupport(DescriptorResolver descriptorResolver, IdeSnapshot ideSnapshot) {
        this.descriptorResolver = descriptorResolver;
        this.snapshot = ideSnapshot;
        this.model = new TimelineModel();
        this.itemsModel = new SynchronousXYItemsModel((Timeline)this.model);
        this.chart = new TimelineChart(this.itemsModel);
        TimelineSelectionManager timelineSelectionManager = new TimelineSelectionManager();
        this.chart.setSelectionModel(timelineSelectionManager);
        timelineSelectionManager.registerChart((ChartComponent)this.chart);
        this.tooltips = new TimelineTooltipOverlay(this);
        this.chart.addOverlayComponent(this.tooltips);
        this.pointsComputer = new PointsComputer();
        this.legend = new TimelineLegendOverlay(this.chart);
        this.legend.setVisible(TracerOptions.getInstance().isShowLegendEnabled());
        this.chart.addOverlayComponent(this.legend);
        this.units = new TimelineUnitsOverlay(this.chart);
        this.units.setVisible(TracerOptions.getInstance().isShowValuesEnabled());
        this.chart.addOverlayComponent(this.units);
    }

    TimelineChart getChart() {
        return this.chart;
    }

    PointsComputer getPointsComputer() {
        return this.pointsComputer;
    }

    public void dataLoadingStarted(final long l) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimelineSupport.this.cleanResizeHandler();
                TimelineSupport.this.chartResizeHandler = new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent componentEvent) {
                        TimelineSupport.this.chart.setScale((double)TimelineSupport.this.chart.getWidth() / (double)l, 1.0);
                    }
                };
                TimelineSupport.this.chart.addComponentListener(TimelineSupport.this.chartResizeHandler);
                TimelineSupport.this.chart.setFitsWidth(false);
                TimelineSupport.this.chartResizeHandler.componentResized(null);
            }
        });
    }

    public void dataLoadingFinished() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimelineSupport.this.cleanResizeHandler();
                TimelineSupport.this.chart.setFitsWidth(true);
                TimelineSupport.this.chart.invalidateRepaint();
            }
        });
    }

    private void cleanResizeHandler() {
        if (this.chartResizeHandler != null) {
            this.chart.removeComponentListener(this.chartResizeHandler);
            this.chartResizeHandler = null;
        }
    }

    public void setShowValuesEnabled(boolean bl) {
        this.units.setVisible(bl);
    }

    public boolean isShowValuesEnabled() {
        return this.units.isVisible();
    }

    public void setShowLegendEnabled(boolean bl) {
        this.legend.setVisible(bl);
    }

    public boolean isShowLegendEnabled() {
        return this.legend.isVisible();
    }

    public void addProbe(final TracerProbe tracerProbe) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimelineSupport.this.resetValues();
                TimelineChart.Row row = TimelineSupport.this.chart.addRow();
                TimelineSupport.this.probes.add(tracerProbe);
                TimelineSupport.this.rows.add(row);
                ProbeItemDescriptor[] probeItemDescriptorArray = tracerProbe.getItemDescriptors();
                SynchronousXYItem[] synchronousXYItemArray = TimelineSupport.this.model.createItems(probeItemDescriptorArray);
                XYItemPainter[] xYItemPainterArray = new XYItemPainter[synchronousXYItemArray.length];
                for (int i = 0; i < xYItemPainterArray.length; ++i) {
                    xYItemPainterArray[i] = TimelinePaintersFactory.createPainter(probeItemDescriptorArray[i], i, TimelineSupport.this.pointsComputer, TimelineSupport.this.snapshot);
                }
                row.addItems(synchronousXYItemArray, (ItemPainter[])xYItemPainterArray);
                TimelineSupport.this.setupOverlays();
            }
        });
    }

    public void removeProbe(final TracerProbe tracerProbe) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimelineSupport.this.resetValues();
                TimelineChart.Row row = TimelineSupport.this.getRow(tracerProbe);
                TimelineSupport.this.chart.removeRow(row);
                TimelineSupport.this.model.removeItems(row.getItems());
                TimelineSupport.this.rows.remove(row);
                TimelineSupport.this.probes.remove(tracerProbe);
                TimelineSupport.this.setupOverlays();
            }
        });
    }

    public List<TracerProbe> getProbes() {
        return this.probes;
    }

    public int getItemsCount() {
        return this.model.getItemsCount();
    }

    public boolean hasData() {
        return this.model.getTimestampsCount() > 0;
    }

    public long getTimestamp(int n) {
        return this.model.getTimestamp(n);
    }

    private void setupOverlays() {
        final int n = this.chart.getRowsCount();
        TimelineTooltipPainter.Model[] modelArray = new TimelineTooltipPainter.Model[n];
        for (int i = 0; i < modelArray.length; ++i) {
            TimelineChart.Row row = this.chart.getRow(i);
            TracerProbe tracerProbe = this.getProbe(row);
            final int n2 = row.getItemsCount();
            final String[] stringArray = new String[n2];
            final ValueItemDescriptor[] valueItemDescriptorArray = new ValueItemDescriptor[n2];
            final String[] stringArray2 = new String[n2];
            for (int j = 0; j < n2; ++j) {
                stringArray[j] = ((TimelineXYItem)row.getItem(j)).getName();
                valueItemDescriptorArray[j] = (ValueItemDescriptor)tracerProbe.getItemDescriptors()[j];
                stringArray2[j] = valueItemDescriptorArray[j].getUnitsString(0);
            }
            modelArray[i] = new TimelineTooltipPainter.Model(){

                @Override
                public int getRowsCount() {
                    return n2;
                }

                @Override
                public String getRowName(int n) {
                    return stringArray[n];
                }

                @Override
                public String getRowValue(int n, long l) {
                    return valueItemDescriptorArray[n].getValueString(l, 0);
                }

                @Override
                public String getRowUnits(int n) {
                    return stringArray2[n];
                }
            };
        }
        this.tooltips.setupModel(modelArray);
        this.units.setupModel(new TimelineUnitsOverlay.Model(){
            private final String LAST_UNITS_STRING = "lastUnitsString";
            private Color[][] rowColors = new Color[n][];
            private String[][] rowMinValues = new String[n][];
            private String[][] rowMaxValues = new String[n][];
            private List<Color> visibleRowItemColors;
            private List<String> visibleRowItemMinValues;
            private List<String> visibleRowItemMaxValues;

            @Override
            public void prefetch() {
                PaintersModel paintersModel = TimelineSupport.this.chart.getPaintersModel();
                for (int i = 0; i < n; ++i) {
                    TimelineChart.Row row = TimelineSupport.this.chart.getRow(i);
                    TracerProbe tracerProbe = TimelineSupport.this.getProbe(row);
                    int n2 = row.getItemsCount();
                    ChartContext chartContext = row.getContext();
                    long l = chartContext.getDataOffsetY();
                    long l2 = l + chartContext.getDataHeight();
                    if (this.visibleRowItemColors != null) {
                        this.visibleRowItemColors.clear();
                        this.visibleRowItemMinValues.clear();
                        this.visibleRowItemMaxValues.clear();
                    } else {
                        this.visibleRowItemColors = new ArrayList<Color>(n2);
                        this.visibleRowItemMinValues = new ArrayList<String>(n2);
                        this.visibleRowItemMaxValues = new ArrayList<String>(n2);
                    }
                    boolean bl = true;
                    double d = -1.0;
                    String string = "lastUnitsString";
                    for (int j = 0; j < n2; ++j) {
                        TimelineXYItem timelineXYItem = (TimelineXYItem)row.getItem(j);
                        TimelineXYPainter timelineXYPainter = (TimelineXYPainter)paintersModel.getPainter((ChartItem)timelineXYItem);
                        if (!timelineXYPainter.isPainting()) continue;
                        this.visibleRowItemColors.add(timelineXYPainter.getDefiningColor());
                        ValueItemDescriptor valueItemDescriptor = (ValueItemDescriptor)tracerProbe.getItemDescriptors()[j];
                        double d2 = valueItemDescriptor.getDataFactor();
                        String string2 = valueItemDescriptor.getUnitsString(1);
                        if (bl) {
                            if (d == -1.0) {
                                d = d2;
                            } else if (d != d2) {
                                bl = false;
                            }
                            d = d2;
                            if (string == "lastUnitsString") {
                                string = string2;
                            } else if (!this.equals(string, string2)) {
                                bl = false;
                            }
                            string = string2;
                        }
                        String string3 = valueItemDescriptor.getValueString((long)((double)l / timelineXYPainter.dataFactor), 1);
                        this.visibleRowItemMinValues.add(string2 == null ? string3 : string3 + " " + string2);
                        String string4 = valueItemDescriptor.getValueString((long)((double)l2 / timelineXYPainter.dataFactor), 1);
                        this.visibleRowItemMaxValues.add(string2 == null ? string4 : string4 + " " + string2);
                    }
                    if (bl) {
                        this.rowColors[i] = new Color[]{null};
                        this.rowMinValues[i] = new String[]{this.visibleRowItemMinValues.get(0)};
                        this.rowMaxValues[i] = new String[]{this.visibleRowItemMaxValues.get(0)};
                        continue;
                    }
                    this.rowColors[i] = this.visibleRowItemColors.toArray(new Color[0]);
                    this.rowMinValues[i] = this.visibleRowItemMinValues.toArray(new String[0]);
                    this.rowMaxValues[i] = this.visibleRowItemMaxValues.toArray(new String[0]);
                }
            }

            @Override
            public Color[] getColors(TimelineChart.Row row) {
                return this.rowColors[row.getIndex()];
            }

            @Override
            public String[] getMinUnits(TimelineChart.Row row) {
                return this.rowMinValues[row.getIndex()];
            }

            @Override
            public String[] getMaxUnits(TimelineChart.Row row) {
                return this.rowMaxValues[row.getIndex()];
            }

            private boolean equals(String string, String string2) {
                if (string == null) {
                    return string2 == null;
                }
                return string.equals(string2);
            }
        });
    }

    TimelineChart.Row getRow(TracerProbe tracerProbe) {
        return this.rows.get(this.probes.indexOf(tracerProbe));
    }

    TracerProbe getProbe(TimelineChart.Row row) {
        return this.probes.get(this.rows.indexOf(row));
    }

    TracerProbeDescriptor getDescriptor(TracerProbe tracerProbe) {
        return this.descriptorResolver.getDescriptor(tracerProbe);
    }

    public void addValues(long l, long[] lArray) {
        int n = this.detailsModel == null ? -1 : this.detailsModel.getRowCount();
        this.model.addValues(l, lArray);
        this.itemsModel.valuesAdded();
        if (n != -1) {
            this.detailsModel.fireTableRowsInserted(n, n);
        }
        this.fireValuesAdded();
    }

    public void resetValues() {
        this.model.reset();
        this.itemsModel.valuesReset();
        this.resetSelectedTimestamps();
        this.pointsComputer.reset();
        if (this.detailsModel != null) {
            this.detailsModel.fireTableStructureChanged();
        }
        this.fireValuesReset();
    }

    public void exportAllValues(String string) {
        final int n = this.model.getTimestampsCount();
        final int n2 = this.model.getItemsCount();
        final SimpleDateFormat simpleDateFormat = new SimpleDateFormat(MessageFormat.format("{0}, {1}", TimeAxisUtils.TIME_MSEC, TimeAxisUtils.DATE_YEAR));
        ArrayList<ProbeItemDescriptor> arrayList = new ArrayList<ProbeItemDescriptor>(n2);
        for (TracerProbe tracerProbe : this.probes) {
            arrayList.addAll(Arrays.asList(tracerProbe.getItemDescriptors()));
        }
        final ValueItemDescriptor[] valueItemDescriptorArray = new ValueItemDescriptor[n2];
        for (int i = 0; i < n2; ++i) {
            valueItemDescriptorArray[i] = (ValueItemDescriptor)arrayList.get(i);
        }
        AbstractTableModel abstractTableModel = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return n;
            }

            @Override
            public int getColumnCount() {
                return n2 + 1;
            }

            @Override
            public String getColumnName(int n3) {
                if (n3 == 0) {
                    return "Time [ms]";
                }
                String string = valueItemDescriptorArray[n3 - 1].getUnitsString(3);
                string = string == null ? "" : " [" + string + "]";
                return TimelineSupport.this.itemsModel.getItem(n3 - 1).getName() + string;
            }

            @Override
            public Object getValueAt(int n3, int n22) {
                if (n22 == 0) {
                    return simpleDateFormat.format(TimelineSupport.this.model.getTimestamp(n3));
                }
                long l = TimelineSupport.this.itemsModel.getItem(n22 - 1).getYValue(n3);
                return valueItemDescriptorArray[n22 - 1].getValueString(l, 3);
            }
        };
        DataExport.exportData(abstractTableModel, string);
    }

    public void exportDetailsValues(String string) {
        if (this.detailsModel == null) {
            return;
        }
        final int n = this.detailsModel.getRowCount();
        final int n2 = this.detailsModel.getColumnCount();
        final SimpleDateFormat simpleDateFormat = new SimpleDateFormat(MessageFormat.format("{0}, {1}", TimeAxisUtils.TIME_MSEC, TimeAxisUtils.DATE_YEAR));
        AbstractTableModel abstractTableModel = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return n;
            }

            @Override
            public int getColumnCount() {
                return n2 - 1;
            }

            @Override
            public String getColumnName(int n3) {
                return TimelineSupport.this.detailsModel.getColumnName(n3 + 1);
            }

            @Override
            public Object getValueAt(int n3, int n22) {
                Object object = TimelineSupport.this.detailsModel.getValueAt(n3, n22 + 1);
                if (n22 == 0) {
                    return simpleDateFormat.format(object);
                }
                return TimelineSupport.this.detailsModel.getDescriptor(n22 + 1).getValueString((Long)object, 3);
            }
        };
        DataExport.exportData(abstractTableModel, string);
    }

    public void addValuesListener(ValuesListener valuesListener) {
        this.valuesListeners.add(valuesListener);
    }

    public void removeValuesListener(ValuesListener valuesListener) {
        this.valuesListeners.remove(valuesListener);
    }

    private void fireValuesAdded() {
        for (ValuesListener valuesListener : this.valuesListeners) {
            valuesListener.valuesAdded();
        }
    }

    private void fireValuesReset() {
        for (ValuesListener valuesListener : this.valuesListeners) {
            valuesListener.valuesReset();
        }
    }

    public boolean isRowSelection() {
        return this.chart.isRowSelection();
    }

    public TableModel getDetailsModel() {
        this.detailsModel = !this.chart.isRowSelection() ? null : this.createSelectionModel();
        return this.detailsModel;
    }

    private DetailsTableModel createSelectionModel() {
        List<SynchronousXYItem> list = this.getSelectedItems();
        final List<ValueItemDescriptor> list2 = this.getSelectedDescriptors();
        int n = list.size();
        final int n2 = n + 2;
        final SynchronousXYItem[] synchronousXYItemArray = list.toArray(new SynchronousXYItem[0]);
        final String[] stringArray = new String[n2];
        stringArray[0] = "Mark";
        stringArray[1] = "Time [ms]";
        final String[] stringArray2 = new String[n2];
        stringArray2[0] = "Mark a timestamp in Timeline view";
        stringArray2[1] = "Timestamp of the data";
        for (int i = 2; i < n2; ++i) {
            String string = synchronousXYItemArray[i - 2].getName();
            String string2 = list2.get(i - 2).getUnitsString(2);
            string2 = string2 == null ? "" : " [" + string2 + "]";
            stringArray[i] = string + string2;
            stringArray2[i] = list2.get(i - 2).getDescription();
        }
        return new DetailsTableModel(){

            @Override
            public int getRowCount() {
                return TimelineSupport.this.model.getTimestampsCount();
            }

            @Override
            public int getColumnCount() {
                return n2;
            }

            @Override
            public String getColumnName(int n) {
                return stringArray[n];
            }

            @Override
            public String getColumnTooltip(int n) {
                return stringArray2[n];
            }

            public Class getColumnClass(int n) {
                if (n == 0) {
                    return Boolean.class;
                }
                if (n == 1) {
                    return DetailsPanel.class;
                }
                return Long.class;
            }

            @Override
            public ValueItemDescriptor getDescriptor(int n) {
                if (n == 0) {
                    return null;
                }
                if (n == 1) {
                    return null;
                }
                return (ValueItemDescriptor)list2.get(n - 2);
            }

            @Override
            public Object getValueAt(int n, int n22) {
                if (n22 == 0) {
                    return TimelineSupport.this.selectedTimestamps.contains(n);
                }
                if (n22 == 1) {
                    return TimelineSupport.this.model.getTimestamp(n);
                }
                return synchronousXYItemArray[n22 - 2].getYValue(n);
            }

            @Override
            public boolean isCellEditable(int n, int n22) {
                return n22 == 0;
            }

            @Override
            public void setValueAt(Object object, int n, int n22) {
                if (Boolean.TRUE.equals(object)) {
                    TimelineSupport.this.selectTimestamp(n, true, false);
                } else {
                    TimelineSupport.this.unselectTimestamp(n, false);
                }
            }
        };
    }

    void setTimestampHovering(boolean bl, boolean bl2) {
        this.hovering = bl;
        this.hoveredSelected = bl2;
        this.notifyTimeSelectionChanged();
    }

    public void selectTimestamp(int n, boolean bl) {
        this.selectTimestamp(n, bl, true);
    }

    private void selectTimestamp(int n, boolean bl, boolean bl2) {
        boolean bl3 = this.selectedTimestamps.add(n);
        if (bl2 && this.detailsModel != null) {
            this.detailsModel.fireTableCellUpdated(n, 0);
        }
        if (bl3) {
            this.updateSelectedItems();
            this.notifyTimeSelectionChanged();
            if (bl) {
                this.highlightTimestamp(n);
            }
        }
    }

    public void unselectTimestamp(int n) {
        this.unselectTimestamp(n, true);
    }

    public void toggleTimestampSelection(int n) {
        if (!this.selectedTimestamps.contains(n)) {
            this.selectTimestamp(n, false);
        } else {
            this.unselectTimestamp(n);
        }
    }

    public boolean isTimestampSelected(int n) {
        return this.selectedTimestamps.contains(n);
    }

    public boolean isTimestampSelection(boolean bl) {
        int n = this.selectedTimestamps.size();
        if (n == 0) {
            return false;
        }
        if (n > 1) {
            return true;
        }
        return bl || !this.hovering || this.hoveredSelected;
    }

    private void unselectTimestamp(int n, boolean bl) {
        boolean bl2 = this.selectedTimestamps.remove(n);
        if (bl && this.detailsModel != null) {
            this.detailsModel.fireTableCellUpdated(n, 0);
        }
        if (bl2) {
            this.updateSelectedItems();
            this.notifyTimeSelectionChanged();
        }
    }

    public void resetSelectedTimestamps() {
        if (this.selectedTimestamps.isEmpty()) {
            return;
        }
        this.selectedTimestamps.clear();
        if (this.detailsModel != null) {
            this.detailsModel.fireTableDataChanged();
        }
        this.updateSelectedItems();
        this.notifyTimeSelectionChanged();
    }

    private void updateSelectedItems() {
        List<SynchronousXYItem> list = this.getSelectedItems();
        ArrayList<XYItemSelection.Default> arrayList = new ArrayList<XYItemSelection.Default>(list.size() * this.selectedTimestamps.size());
        for (int n : this.selectedTimestamps) {
            for (SynchronousXYItem synchronousXYItem : list) {
                arrayList.add(new XYItemSelection.Default((XYItem)synchronousXYItem, n, Integer.MAX_VALUE));
            }
        }
        this.chart.getSelectionModel().setSelectedItems(arrayList);
    }

    public Set<Integer> getSelectedTimestamps() {
        return this.selectedTimestamps;
    }

    public void selectInterval(int n, int n2) {
        this.selectedIntervals.add(n);
        this.selectedIntervals.add(n2);
    }

    public List<Integer> getSelectedIntervals() {
        return this.selectedIntervals;
    }

    public void resetSelectedIntervals() {
        this.selectedIntervals.clear();
    }

    public void selectedIntervalsChanged() {
        this.notifyIntervalsSelectionChanged();
    }

    private void highlightTimestamp(int n) {
        ChartSelectionModel chartSelectionModel = this.chart.getSelectionModel();
        List list = chartSelectionModel.getHighlightedItems();
        int n2 = -1;
        if (!list.isEmpty()) {
            XYItemSelection xYItemSelection = (XYItemSelection)list.get(0);
            n2 = xYItemSelection.getValueIndex();
        }
        if (n != -1) {
            this.scrollChartToSelection(n2, n);
        }
    }

    public void scrollChartToIndex(int n) {
        this.scrollChartToSelection(-1, n);
    }

    private void scrollChartToSelection(int n, int n2) {
        long l;
        Timeline timeline = this.itemsModel.getTimeline();
        ChartContext chartContext = this.chart.getChartContext();
        long l2 = chartContext.getDataOffsetX();
        long l3 = timeline.getTimestamp(n2);
        long l4 = (long)chartContext.getViewWidth((double)(l3 - l2));
        long l5 = this.chart.getOffsetX();
        long l6 = chartContext.getViewportWidth();
        if (l4 >= l5 + 10L && l4 <= l5 + l6 - 50L) {
            return;
        }
        long l7 = n == -1 ? -1L : timeline.getTimestamp(n);
        long l8 = l = n == -1 ? -1L : (long)chartContext.getViewWidth((double)(l7 - l2));
        if (n == -1) {
            this.chart.setOffset(l4 - (long)(chartContext.getViewportWidth() / 2), this.chart.getOffsetY());
        } else if (l > l4) {
            this.chart.setOffset(l4 - 10L, this.chart.getOffsetY());
        } else {
            this.chart.setOffset(l4 - (long)chartContext.getViewportWidth() + 50L, this.chart.getOffsetY());
        }
        this.chart.repaintDirty();
    }

    private List<SynchronousXYItem> getSelectedItems() {
        List<TimelineChart.Row> list = this.chart.getSelectedRows();
        ArrayList<SynchronousXYItem> arrayList = new ArrayList<SynchronousXYItem>();
        for (TimelineChart.Row row : list) {
            arrayList.addAll(Arrays.asList(row.getItems()));
        }
        return arrayList;
    }

    private List<ValueItemDescriptor> getSelectedDescriptors() {
        List<TimelineChart.Row> list = this.chart.getSelectedRows();
        ArrayList<ValueItemDescriptor> arrayList = new ArrayList<ValueItemDescriptor>();
        for (TimelineChart.Row row : list) {
            arrayList.addAll(Arrays.asList(this.getProbe(row).getItemDescriptors()));
        }
        return arrayList;
    }

    public void selectAll() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimelineSelectionManager timelineSelectionManager = (TimelineSelectionManager)TimelineSupport.this.chart.getSelectionModel();
                timelineSelectionManager.selectAll();
                TimelineSupport.this.startIndex = timelineSelectionManager.getStartIndex();
                TimelineSupport.this.endIndex = timelineSelectionManager.getEndIndex();
                TimelineSupport.this.notifyIndexSelectionChanged();
            }
        });
    }

    public boolean isSelectAll() {
        return this.endIndex - this.startIndex == this.model.getTimestampsCount() - 1;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    void indexSelectionChanged(int n, int n2) {
        this.startIndex = n;
        this.endIndex = n2;
        this.notifyIndexSelectionChanged();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.remove(selectionListener);
    }

    private void notifyIntervalsSelectionChanged() {
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.intervalsSelectionChanged();
        }
    }

    private void notifyIndexSelectionChanged() {
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.indexSelectionChanged();
        }
    }

    private void notifyTimeSelectionChanged() {
        boolean bl = this.isTimestampSelection(true);
        boolean bl2 = bl && !this.isTimestampSelection(false);
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.timeSelectionChanged(bl, bl2);
        }
    }

    public static interface DescriptorResolver {
        public TracerProbeDescriptor getDescriptor(TracerProbe var1);
    }

    public static interface SelectionListener {
        public void intervalsSelectionChanged();

        public void indexSelectionChanged();

        public void timeSelectionChanged(boolean var1, boolean var2);
    }

    public static interface ValuesListener {
        public void valuesAdded();

        public void valuesReset();
    }
}

