/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.report;

import com.sun.star.beans.PropertyState;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertyState;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.table.XTableColumns;
import com.sun.star.table.XTableRows;
import com.sun.star.text.XDependentTextField;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.NumberFormatter;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.db.BlindtextCreator;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.db.RecordParser;
import com.sun.star.wizards.report.RecordTable;
import com.sun.star.wizards.text.TextDocument;
import com.sun.star.wizards.text.TextFieldHandler;
import com.sun.star.wizards.text.TextTableHandler;

public class DBColumn {
    private XCell xValCell;
    private XTextRange xValTextCell;
    private XTextCursor xValCellCursor;
    public XCell xNameCell;
    private XTextRange xNameTextCell;
    private boolean bAlignLeft;
    private String CharFontName;
    private PropertyState PropertyState;
    public int ValColumn = 1;
    private int ValRow = 0;
    public FieldColumn CurDBField;
    private XTextTable xTextTable;
    private XTableColumns xTableColumns;
    private XCellRange xCellRange;
    public XNamed xTableName;
    private boolean bIsGroupColumn;
    private RecordParser CurDBMetaData;
    private RecordTable CurRecordTable;
    private TextTableHandler oTextTableHandler;

    public DBColumn(RecordTable _CurRecordTable, TextTableHandler _oTextTableHandler, RecordParser _CurDBMetaData, int i, boolean _bforce) {
        this.initializeRecordTableMembers(_CurRecordTable, _oTextTableHandler, _CurDBMetaData, i, _bforce);
    }

    public DBColumn(RecordTable _CurRecordTable, TextTableHandler _oTextTableHandler, RecordParser _CurDBMetaData, int i) {
        this.initializeRecordTableMembers(_CurRecordTable, _oTextTableHandler, _CurDBMetaData, i, false);
    }

    private void initializeRecordTableMembers(RecordTable _CurRecordTable, TextTableHandler _oTextTableHandler, RecordParser _CurDBMetaData, int i, boolean _bForce) {
        this.oTextTableHandler = _oTextTableHandler;
        this.CurDBMetaData = _CurDBMetaData;
        this.CurRecordTable = _CurRecordTable;
        this.bIsGroupColumn = false;
        this.CurDBField = this.CurDBMetaData.RecordFieldColumns != null ? this.CurDBMetaData.getFieldColumnByFieldName(this.CurDBMetaData.RecordFieldColumns[i].getFieldName()) : this.CurDBMetaData.getFieldColumnByFieldName(this.CurDBMetaData.getRecordFieldName(i));
        if (_bForce) {
            this.assignCells(i, true);
        } else {
            for (int n = 0; n < this.CurRecordTable.xTableColumns.getCount(); ++n) {
                this.assignCells(n, false);
            }
        }
    }

    private boolean assignCells(int _nColumn, boolean _bforce) {
        try {
            XCell xCell = this.CurRecordTable.xCellRange.getCellByPosition(_nColumn, 0);
            XTextRange xTextCell = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)xCell);
            String CompString = "Column";
            XTextCursor xLocCellCursor = TextDocument.createTextCursor(xCell);
            if (this.isNameCell(xLocCellCursor, this.CurDBField.getFieldName(), CompString) || _bforce) {
                this.xNameCell = xCell;
                this.xNameTextCell = xTextCell;
                this.xValCell = this.CurRecordTable.xCellRange.getCellByPosition(_nColumn, 1);
                this.xValTextCell = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)this.xValCell);
                this.xValCellCursor = TextDocument.createTextCursor(this.xValCell);
                this.ValColumn = _nColumn;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return false;
    }

    public DBColumn(TextTableHandler _oTextTableHandler, RecordParser _CurDBMetaData, String _FieldName, String TableName, DBColumn OldDBColumn) {
        this.oTextTableHandler = _oTextTableHandler;
        this.CurDBMetaData = _CurDBMetaData;
        this.CurDBField = this.CurDBMetaData.getFieldColumnByDisplayName(_FieldName);
        this.bIsGroupColumn = true;
        this.getTableColumns(TableName);
        this.xNameCell = OldDBColumn.xNameCell;
        this.xNameTextCell = OldDBColumn.xNameTextCell;
        this.xValCell = OldDBColumn.xValCell;
        this.xValTextCell = OldDBColumn.xValTextCell;
        this.xValCellCursor = TextDocument.createTextCursor(this.xValCell);
        this.ValColumn = OldDBColumn.ValColumn;
        this.ValRow = OldDBColumn.ValRow;
        this.initializeNumberFormat();
    }

    public DBColumn(TextTableHandler _oTextTableHandler, RecordParser _CurDBMetaData, String _FieldName, String TableName) throws Exception {
        this.oTextTableHandler = _oTextTableHandler;
        this.CurDBMetaData = _CurDBMetaData;
        this.CurDBField = this.CurDBMetaData.getFieldColumnByFieldName(_FieldName);
        this.bIsGroupColumn = true;
        this.getTableColumns(TableName);
        XTableRows xRows = null;
        try {
            xRows = this.xTextTable.getRows();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        for (int n = 0; n < this.xTableColumns.getCount(); ++n) {
            for (int m = 0; m < xRows.getCount(); ++m) {
                XCell xCell = this.xCellRange.getCellByPosition(n, m);
                XTextRange xTextCell = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)xCell);
                String CompString = TableName.substring(4);
                XTextCursor xLocCellCursor = TextDocument.createTextCursor(xCell);
                if (this.isNameCell(xLocCellCursor, this.CurDBField.getFieldName(), CompString)) {
                    this.xNameCell = xCell;
                    this.xNameTextCell = xTextCell;
                    continue;
                }
                this.xValCell = xCell;
                this.xValTextCell = xTextCell;
                this.xValCellCursor = xLocCellCursor;
                this.ValColumn = n;
                this.ValRow = m;
                this.checkforLeftAlignment();
            }
        }
    }

    private void getTableColumns(String TableName) {
        try {
            XNameAccess xAllTextTables = this.oTextTableHandler.xTextTablesSupplier.getTextTables();
            if (xAllTextTables.hasByName(TableName)) {
                Object oTextTable = xAllTextTables.getByName(TableName);
                this.xCellRange = (XCellRange)UnoRuntime.queryInterface(XCellRange.class, (Object)oTextTable);
                this.xTextTable = (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)oTextTable);
                this.xTableName = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)oTextTable);
                this.xTableColumns = this.xTextTable.getColumns();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initializeNumberFormat() {
        if (this.CurDBField.isBoolean()) {
            NumberFormatter oNumberFormatter = this.oTextTableHandler.getNumberFormatter();
            int iLogicalFormatKey = oNumberFormatter.setBooleanReportDisplayNumberFormat();
            oNumberFormatter.setNumberFormat((XInterface)this.xValCell, iLogicalFormatKey, oNumberFormatter);
        } else {
            this.oTextTableHandler.getNumberFormatter().setNumberFormat((XInterface)this.xValCell, this.CurDBField.getDBFormatKey(), this.CurDBMetaData.getNumberFormatter());
        }
        this.setCellFont();
    }

    public void insertColumnData(TextFieldHandler oTextFieldHandler, boolean _bIsLandscape) {
        this.insertUserFieldToTableCell(oTextFieldHandler);
        this.replaceValueCellofTable(_bIsLandscape);
    }

    private void insertUserFieldToTableCell(TextFieldHandler oTextFieldHandler) {
        XTextCursor xTextCursor = TextDocument.createTextCursor(this.xNameCell);
        xTextCursor.gotoStart(false);
        xTextCursor.gotoEnd(true);
        xTextCursor.setString(PropertyNames.EMPTY_STRING);
        oTextFieldHandler.insertUserField(xTextCursor, this.CurDBField.getFieldName(), this.CurDBField.getFieldTitle());
    }

    public void formatValueCell() {
        this.initializeNumberFormat();
        if (this.checkforLeftAlignment()) {
            this.bAlignLeft = true;
        }
    }

    private boolean checkforLeftAlignment() {
        this.bAlignLeft = this.CurDBField.isNumberFormat() && this.ValColumn == this.xTableColumns.getCount() - 1;
        return this.bAlignLeft;
    }

    public void modifyCellContent(XCellRange xCellRange, Object CurGroupValue) {
        try {
            this.xValCell = xCellRange.getCellByPosition(this.ValColumn, this.ValRow);
            this.xValTextCell = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)this.xValCell);
            this.modifyCellContent(CurGroupValue);
            if (this.bAlignLeft) {
                this.xValCellCursor = TextDocument.createTextCursor(this.xValCell);
                Helper.setUnoPropertyValue(this.xValCellCursor, "ParaAdjust", 0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private void modifyCellContent(Object CurGroupValue) {
        double dblValue = 0.0;
        try {
            if (this.xValCell != null) {
                if (AnyConverter.isString((Object)CurGroupValue)) {
                    String sValue = AnyConverter.toString((Object)CurGroupValue);
                    this.xValTextCell.setString(sValue);
                } else {
                    if (AnyConverter.isBoolean((Object)CurGroupValue)) {
                        dblValue = AnyConverter.toInt((Object)CurGroupValue);
                    }
                    if (AnyConverter.isByte((Object)CurGroupValue)) {
                        dblValue = AnyConverter.toByte((Object)CurGroupValue);
                    } else if (AnyConverter.isDouble((Object)CurGroupValue)) {
                        dblValue = AnyConverter.toDouble((Object)CurGroupValue);
                    } else if (AnyConverter.isFloat((Object)CurGroupValue)) {
                        dblValue = AnyConverter.toFloat((Object)CurGroupValue);
                    } else if (AnyConverter.isInt((Object)CurGroupValue)) {
                        dblValue = AnyConverter.toInt((Object)CurGroupValue);
                    } else if (AnyConverter.isLong((Object)CurGroupValue)) {
                        dblValue = AnyConverter.toLong((Object)CurGroupValue);
                    } else if (AnyConverter.isShort((Object)CurGroupValue)) {
                        dblValue = AnyConverter.toShort((Object)CurGroupValue);
                    }
                    this.xValCell.setValue(dblValue);
                }
            }
        }
        catch (IllegalArgumentException exception) {
            System.err.println(exception);
        }
    }

    private void replaceValueCellofTable(boolean _bIsLandscape) {
        try {
            int nFieldType;
            Object CurGroupValue = !this.bIsGroupColumn && !this.CurDBField.isNumberFormat() ? BlindtextCreator.adjustBlindTextlength(this.CurDBField.getFieldTitle(), this.CurDBField.getFieldWidth(), _bIsLandscape, this.bIsGroupColumn, this.CurDBMetaData.getRecordFieldNames()) : this.CurDBField.getDefaultValue();
            this.modifyCellContent(CurGroupValue);
            if (this.bAlignLeft) {
                Helper.setUnoPropertyValue(this.xValCellCursor, "ParaAdjust", 0);
            }
            if ((nFieldType = this.CurDBField.getFieldType()) == -7 || nFieldType == 16) {
                this.CharFontName = "StarSymbol";
                Helper.setUnoPropertyValue(this.xValCellCursor, "CharFontName", this.CharFontName);
                if (!this.bIsGroupColumn) {
                    Helper.setUnoPropertyValue(this.xValCellCursor, "ParaAdjust", 3);
                }
            } else if (this.PropertyState == com.sun.star.beans.PropertyState.DEFAULT_VALUE) {
                XPropertyState xPropState = (XPropertyState)UnoRuntime.queryInterface(XPropertyState.class, (Object)this.xValCellCursor);
                xPropState.setPropertyToDefault("CharFontName");
            } else if (this.PropertyState == com.sun.star.beans.PropertyState.DIRECT_VALUE) {
                Helper.setUnoPropertyValue(this.xValCellCursor, "CharFontName", this.CharFontName);
            }
        }
        catch (UnknownPropertyException exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void setCellFont() {
        try {
            int nFieldType = this.CurDBField.getFieldType();
            if (nFieldType == -7 || nFieldType == 16) {
                this.CharFontName = "StarSymbol";
                this.PropertyState = com.sun.star.beans.PropertyState.DIRECT_VALUE;
                this.xValCellCursor.gotoStart(false);
                this.xValCellCursor.gotoEnd(true);
                Helper.setUnoPropertyValue(this.xValCellCursor, "CharFontName", this.CharFontName);
            } else {
                XPropertyState xPropertyState = (XPropertyState)UnoRuntime.queryInterface(XPropertyState.class, (Object)this.xValCellCursor);
                this.PropertyState = xPropertyState.getPropertyState("CharFontName");
                this.CharFontName = AnyConverter.toString((Object)Helper.getUnoPropertyValue(this.xValCellCursor, "CharFontName"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private boolean isNameCell(XTextCursor xCellCursor, String CurFieldName, String CompString) {
        try {
            xCellCursor.gotoStart(false);
            XTextRange xTextRange = xCellCursor.getEnd();
            Object oTextField = Helper.getUnoPropertyValue(xTextRange, "TextField");
            if (AnyConverter.isVoid((Object)oTextField)) {
                return false;
            }
            XDependentTextField xDependent = (XDependentTextField)UnoRuntime.queryInterface(XDependentTextField.class, (Object)oTextField);
            XPropertySet xMaster = xDependent.getTextFieldMaster();
            String UserFieldName = (String)xMaster.getPropertyValue(PropertyNames.PROPERTY_NAME);
            boolean bIsNameCell = false;
            if (UserFieldName.startsWith(CompString) || UserFieldName.equals(CurFieldName)) {
                bIsNameCell = true;
            } else {
                String sLocalCurFieldName = CurFieldName + "_renamed_";
                if (UserFieldName.startsWith(sLocalCurFieldName)) {
                    bIsNameCell = true;
                }
            }
            return bIsNameCell;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return true;
        }
    }
}

