# @generated from torch/__init__.pyi.in

from typing import List, Tuple, Optional, Union, Any, ContextManager, Callable, overload
from torch._six import inf

import builtins

# These identifiers are reexported from other modules.  These modules
# are not mypy-clean yet, so in order to use this stub file usefully
# from mypy you will need to specify --follow-imports=silent.
# Not all is lost: these imports still enable IDEs like PyCharm to offer
# autocomplete.
#
# Note: Why does the syntax here look so strange?  Import visibility
# rules in stubs are different from normal Python files!  You must use
# 'from ... import ... as ...' syntax to cause an identifier to be
# exposed (or use a wildcard); regular syntax is not exposed.
from .random import set_rng_state as set_rng_state, get_rng_state as get_rng_state, \
    manual_seed as manual_seed, initial_seed as initial_seed
from ._tensor_str import set_printoptions as set_printoptions
from .functional import *
from .serialization import save as save, load as load
from .autograd import no_grad as no_grad, enable_grad as enable_grad, \
    set_grad_enabled as set_grad_enabled
from . import cuda as cuda
from . import optim as optim

class dtype: ...

class layout: ...

strided : layout = ...

# See https://github.com/python/mypy/issues/4146 for why these workarounds
# is necessary
_int = builtins.int
_float = builtins.float

class device:
    type: str
    index: _int

    @overload
    def __init__(self, device: Union[_int, str]) -> None: ...

    @overload
    def __init__(self, type: str, index: _int) -> None: ...

class Generator: ...

class Size(tuple): ...

class Storage: ...

# See https://github.com/python/mypy/issues/4146 for why these workarounds
# is necessary
_dtype = dtype
_device = device
_size = Union[Size, List[_int], Tuple[_int, ...]]

# Meta-type for "numeric" things; matches our docs
Number = Union[builtins.int, builtins.float]

# TODO: One downside of doing it this way, is direct use of
# torch.tensor.Tensor doesn't get type annotations.  Nobody
# should really do that, so maybe this is not so bad.
class Tensor:
    dtype: _dtype = ...
    shape: Size = ...
    device: _device = ...
    requires_grad: bool = ...
    grad: Optional[Tensor] = ...

    def __abs__(self) -> Tensor: ...
    def __add__(self, other: Any) -> Tensor: ...
    @overload
    def __and__(self, other: Number) -> Tensor: ...
    @overload
    def __and__(self, other: Tensor) -> Tensor: ...
    @overload
    def __and__(self, other: Any) -> Tensor: ...
    def __bool__(self) -> bool: ...
    def __div__(self, other: Any) -> Tensor: ...
    def __eq__(self, other: Any) -> Tensor: ...  # type: ignore
    def __float__(self) -> builtins.float: ...
    def __ge__(self, other: Any) -> Tensor: ...  # type: ignore
    def __getitem__(self, indices: Union[None, _int, slice, Tensor, List, Tuple]) -> Tensor: ...
    def __gt__(self, other: Any) -> Tensor: ...  # type: ignore
    def __iadd__(self, other: Any) -> Tensor: ...
    @overload
    def __iand__(self, other: Number) -> Tensor: ...
    @overload
    def __iand__(self, other: Tensor) -> Tensor: ...
    @overload
    def __iand__(self, other: Any) -> Tensor: ...
    def __idiv__(self, other: Any) -> Tensor: ...
    @overload
    def __ilshift__(self, other: Number) -> Tensor: ...
    @overload
    def __ilshift__(self, other: Tensor) -> Tensor: ...
    @overload
    def __ilshift__(self, other: Any) -> Tensor: ...
    def __imul__(self, other: Any) -> Tensor: ...
    def __index__(self) -> builtins.int: ...
    def __int__(self) -> builtins.int: ...
    def __invert__(self) -> Tensor: ...
    @overload
    def __ior__(self, other: Number) -> Tensor: ...
    @overload
    def __ior__(self, other: Tensor) -> Tensor: ...
    @overload
    def __ior__(self, other: Any) -> Tensor: ...
    @overload
    def __irshift__(self, other: Number) -> Tensor: ...
    @overload
    def __irshift__(self, other: Tensor) -> Tensor: ...
    @overload
    def __irshift__(self, other: Any) -> Tensor: ...
    def __isub__(self, other: Any) -> Tensor: ...
    def __itruediv__(self, other: Any) -> Tensor: ...
    @overload
    def __ixor__(self, other: Number) -> Tensor: ...
    @overload
    def __ixor__(self, other: Tensor) -> Tensor: ...
    @overload
    def __ixor__(self, other: Any) -> Tensor: ...
    def __le__(self, other: Any) -> Tensor: ...  # type: ignore
    def __long__(self) -> builtins.int: ...
    @overload
    def __lshift__(self, other: Number) -> Tensor: ...
    @overload
    def __lshift__(self, other: Tensor) -> Tensor: ...
    @overload
    def __lshift__(self, other: Any) -> Tensor: ...
    def __lt__(self, other: Any) -> Tensor: ...  # type: ignore
    def __matmul__(self, other: Any) -> Tensor: ...
    def __mod__(self, other: Any) -> Tensor: ...
    def __mul__(self, other: Any) -> Tensor: ...
    def __ne__(self, other: Any) -> Tensor: ...  # type: ignore
    def __neg__(self) -> Tensor: ...
    def __nonzero__(self) -> bool: ...
    @overload
    def __or__(self, other: Number) -> Tensor: ...
    @overload
    def __or__(self, other: Tensor) -> Tensor: ...
    @overload
    def __or__(self, other: Any) -> Tensor: ...
    def __pow__(self, other: Any) -> Tensor: ...
    def __radd__(self, other: Any) -> Tensor: ...
    def __rmul__(self, other: Any) -> Tensor: ...
    @overload
    def __rshift__(self, other: Number) -> Tensor: ...
    @overload
    def __rshift__(self, other: Tensor) -> Tensor: ...
    @overload
    def __rshift__(self, other: Any) -> Tensor: ...
    def __setitem__(self, indices: Union[None, _int, slice, Tensor, List, Tuple], val: Union[Tensor, Number]) -> None: ...
    def __sub__(self, other: Any) -> Tensor: ...
    def __truediv__(self, other: Any) -> Tensor: ...
    @overload
    def __xor__(self, other: Number) -> Tensor: ...
    @overload
    def __xor__(self, other: Tensor) -> Tensor: ...
    @overload
    def __xor__(self, other: Any) -> Tensor: ...
    def _coalesced_(self, coalesced: bool) -> Tensor: ...
    def _dimI(self) -> _int: ...
    def _dimV(self) -> _int: ...
    def _indices(self) -> Tensor: ...
    def _nnz(self) -> _int: ...
    def _values(self) -> Tensor: ...
    def abs(self) -> Tensor: ...
    def abs_(self) -> Tensor: ...
    def acos(self) -> Tensor: ...
    def acos_(self) -> Tensor: ...
    def addbmm(self, batch1: Tensor, batch2: Tensor, *, beta: Number=1, alpha: Number=1) -> Tensor: ...
    def addbmm_(self, batch1: Tensor, batch2: Tensor, *, beta: Number=1, alpha: Number=1) -> Tensor: ...
    def addcdiv(self, tensor1: Tensor, tensor2: Tensor, *, value: Number=1) -> Tensor: ...
    def addcdiv_(self, tensor1: Tensor, tensor2: Tensor, *, value: Number=1) -> Tensor: ...
    def addcmul(self, tensor1: Tensor, tensor2: Tensor, *, value: Number=1) -> Tensor: ...
    def addcmul_(self, tensor1: Tensor, tensor2: Tensor, *, value: Number=1) -> Tensor: ...
    def addmm(self, mat1: Tensor, mat2: Tensor, *, beta: Number=1, alpha: Number=1) -> Tensor: ...
    def addmm_(self, mat1: Tensor, mat2: Tensor, *, beta: Number=1, alpha: Number=1) -> Tensor: ...
    def addmv(self, mat: Tensor, vec: Tensor, *, beta: Number=1, alpha: Number=1) -> Tensor: ...
    def addmv_(self, mat: Tensor, vec: Tensor, *, beta: Number=1, alpha: Number=1) -> Tensor: ...
    def addr(self, vec1: Tensor, vec2: Tensor, *, beta: Number=1, alpha: Number=1) -> Tensor: ...
    def addr_(self, vec1: Tensor, vec2: Tensor, *, beta: Number=1, alpha: Number=1) -> Tensor: ...
    @overload
    def all(self, dim: _int, keepdim: bool=False) -> Tensor: ...
    @overload
    def all(self) -> Tensor: ...
    def allclose(self, other: Tensor, rtol: _float=1e-05, atol: _float=1e-08, equal_nan: bool=False) -> bool: ...
    @overload
    def any(self, dim: _int, keepdim: bool=False) -> Tensor: ...
    @overload
    def any(self) -> Tensor: ...
    def apply_(self, callable: Callable) -> Tensor: ...
    def argmax(self, dim: Optional[_int]=None, keepdim: bool=False) -> Tensor: ...
    def argmin(self, dim: Optional[_int]=None, keepdim: bool=False) -> Tensor: ...
    def argsort(self, dim: _int=-1, descending: bool=False) -> Tensor: ...
    def as_strided(self, size: _size, stride: _size, storage_offset: Optional[_int]=None) -> Tensor: ...
    def as_strided_(self, size: _size, stride: _size, storage_offset: Optional[_int]=None) -> Tensor: ...
    def asin(self) -> Tensor: ...
    def asin_(self) -> Tensor: ...
    def atan(self) -> Tensor: ...
    def atan2(self, other: Tensor) -> Tensor: ...
    def atan2_(self, other: Tensor) -> Tensor: ...
    def atan_(self) -> Tensor: ...
    def baddbmm(self, batch1: Tensor, batch2: Tensor, *, beta: Number=1, alpha: Number=1) -> Tensor: ...
    def baddbmm_(self, batch1: Tensor, batch2: Tensor, *, beta: Number=1, alpha: Number=1) -> Tensor: ...
    @overload
    def bernoulli(self, *, generator: Generator=None) -> Tensor: ...
    @overload
    def bernoulli(self, p: _float, *, generator: Generator=None) -> Tensor: ...
    @overload
    def bernoulli_(self, p: Tensor, *, generator: Generator=None) -> Tensor: ...
    @overload
    def bernoulli_(self, p: _float=0.5, *, generator: Generator=None) -> Tensor: ...
    def bincount(self, weights: Optional[Tensor]=None, minlength: _int=0) -> Tensor: ...
    def bmm(self, mat2: Tensor) -> Tensor: ...
    def byte(self) -> Tensor: ...
    def cauchy_(self, median: _float=0, sigma: _float=1, *, generator: Generator=None) -> Tensor: ...
    def ceil(self) -> Tensor: ...
    def ceil_(self) -> Tensor: ...
    def char(self) -> Tensor: ...
    def cholesky(self, upper: bool=False) -> Tensor: ...
    def cholesky_inverse(self, upper: bool=False) -> Tensor: ...
    def cholesky_solve(self, input2: Tensor, upper: bool=False) -> Tensor: ...
    def chunk(self, chunks: _int, dim: _int=0) -> Union[Tuple[Tensor, ...], List[Tensor]]: ...
    def clamp(self, min: _float=-inf, max: _float=inf, *, out: Optional[Tensor]=None) -> Tensor: ...
    def clamp_(self, min: _float=-inf, max: _float=inf) -> Tensor: ...
    def clamp_max(self, max: Number) -> Tensor: ...
    def clamp_max_(self, max: Number) -> Tensor: ...
    def clamp_min(self, min: Number) -> Tensor: ...
    def clamp_min_(self, min: Number) -> Tensor: ...
    def clone(self) -> Tensor: ...
    def coalesce(self) -> Tensor: ...
    def cos(self) -> Tensor: ...
    def cos_(self) -> Tensor: ...
    def cosh(self) -> Tensor: ...
    def cosh_(self) -> Tensor: ...
    def cpu(self) -> Tensor: ...
    def cross(self, other: Tensor, dim: Optional[_int]=None) -> Tensor: ...
    def cuda(self, device: Optional[_device]=None, non_blocking: bool=False) -> Tensor: ...
    @overload
    def cumprod(self, dim: _int, *, dtype: _dtype) -> Tensor: ...
    @overload
    def cumprod(self, dim: _int) -> Tensor: ...
    @overload
    def cumsum(self, dim: _int, *, dtype: _dtype) -> Tensor: ...
    @overload
    def cumsum(self, dim: _int) -> Tensor: ...
    def data_ptr(self) -> _int: ...
    def dense_dim(self) -> _int: ...
    def dequantize(self) -> Tensor: ...
    def det(self) -> Tensor: ...
    def detach(self) -> Tensor: ...
    def detach_(self) -> Tensor: ...
    def diag(self, diagonal: _int=0) -> Tensor: ...
    def diag_embed(self, offset: _int=0, dim1: _int=-2, dim2: _int=-1) -> Tensor: ...
    def diagflat(self, offset: _int=0) -> Tensor: ...
    def diagonal(self, offset: _int=0, dim1: _int=0, dim2: _int=1) -> Tensor: ...
    def digamma(self) -> Tensor: ...
    def digamma_(self) -> Tensor: ...
    def dim(self) -> _int: ...
    def dist(self, other: Tensor, p: Number=2) -> Tensor: ...
    def dot(self, tensor: Tensor) -> Tensor: ...
    def double(self) -> Tensor: ...
    def eig(self, eigenvectors: bool=False) -> Tuple[Tensor, Tensor]: ...
    def element_size(self) -> _int: ...
    @overload
    def eq(self, other: Number) -> Tensor: ...
    @overload
    def eq(self, other: Tensor) -> Tensor: ...
    @overload
    def eq_(self, other: Number) -> Tensor: ...
    @overload
    def eq_(self, other: Tensor) -> Tensor: ...
    def equal(self, other: Tensor) -> bool: ...
    def erf(self) -> Tensor: ...
    def erf_(self) -> Tensor: ...
    def erfc(self) -> Tensor: ...
    def erfc_(self) -> Tensor: ...
    def erfinv(self) -> Tensor: ...
    def erfinv_(self) -> Tensor: ...
    def exp(self) -> Tensor: ...
    def exp_(self) -> Tensor: ...
    @overload
    def expand(self, size: _size, *, implicit: bool=False) -> Tensor: ...
    @overload
    def expand(self, *size: _int, implicit: bool=False) -> Tensor: ...
    def expand_as(self, other: Tensor) -> Tensor: ...
    def expm1(self) -> Tensor: ...
    def expm1_(self) -> Tensor: ...
    def exponential_(self, lambd: _float=1, *, generator: Generator=None) -> Tensor: ...
    def fft(self, signal_ndim: _int, normalized: bool=False) -> Tensor: ...
    @overload
    def fill_(self, value: Number) -> Tensor: ...
    @overload
    def fill_(self, value: Tensor) -> Tensor: ...
    def flatten(self, start_dim: _int=0, end_dim: _int=-1) -> Tensor: ...
    @overload
    def flip(self, dims: _size) -> Tensor: ...
    @overload
    def flip(self, *dims: _int) -> Tensor: ...
    def float(self) -> Tensor: ...
    def floor(self) -> Tensor: ...
    def floor_(self) -> Tensor: ...
    @overload
    def fmod(self, other: Number) -> Tensor: ...
    @overload
    def fmod(self, other: Tensor) -> Tensor: ...
    @overload
    def fmod_(self, other: Number) -> Tensor: ...
    @overload
    def fmod_(self, other: Tensor) -> Tensor: ...
    def frac(self) -> Tensor: ...
    def frac_(self) -> Tensor: ...
    def gather(self, dim: _int, index: Tensor, *, sparse_grad: bool=False) -> Tensor: ...
    @overload
    def ge(self, other: Number) -> Tensor: ...
    @overload
    def ge(self, other: Tensor) -> Tensor: ...
    @overload
    def ge_(self, other: Number) -> Tensor: ...
    @overload
    def ge_(self, other: Tensor) -> Tensor: ...
    def gels(self, A: Tensor) -> Tuple[Tensor, Tensor]: ...
    def geometric_(self, p: _float, *, generator: Generator=None) -> Tensor: ...
    def geqrf(self) -> Tuple[Tensor, Tensor]: ...
    def ger(self, vec2: Tensor) -> Tensor: ...
    def get_device(self) -> _int: ...
    @overload
    def gt(self, other: Number) -> Tensor: ...
    @overload
    def gt(self, other: Tensor) -> Tensor: ...
    @overload
    def gt_(self, other: Number) -> Tensor: ...
    @overload
    def gt_(self, other: Tensor) -> Tensor: ...
    def half(self) -> Tensor: ...
    def hardshrink(self, lambd: Number=0.5) -> Tensor: ...
    def histc(self, bins: _int=100, min: Number=0, max: Number=0) -> Tensor: ...
    def ifft(self, signal_ndim: _int, normalized: bool=False) -> Tensor: ...
    def index_add(self, dim: _int, index: Tensor, source: Tensor) -> Tensor: ...
    def index_add_(self, dim: _int, index: Tensor, source: Tensor) -> Tensor: ...
    def index_copy(self, dim: _int, index: Tensor, source: Tensor) -> Tensor: ...
    def index_copy_(self, dim: _int, index: Tensor, source: Tensor) -> Tensor: ...
    @overload
    def index_fill(self, dim: _int, index: Tensor, value: Number) -> Tensor: ...
    @overload
    def index_fill(self, dim: _int, index: Tensor, value: Tensor) -> Tensor: ...
    @overload
    def index_fill_(self, dim: _int, index: Tensor, value: Number) -> Tensor: ...
    @overload
    def index_fill_(self, dim: _int, index: Tensor, value: Tensor) -> Tensor: ...
    def index_put(self, indices: Optional[Union[Tuple[Tensor, ...], List[Tensor]]], values: Tensor, accumulate: bool=False) -> Tensor: ...
    def index_put_(self, indices: Optional[Union[Tuple[Tensor, ...], List[Tensor]]], values: Tensor, accumulate: bool=False) -> Tensor: ...
    def index_select(self, dim: _int, index: Tensor) -> Tensor: ...
    def indices(self) -> Tensor: ...
    def int(self) -> Tensor: ...
    def int_repr(self) -> Tensor: ...
    def inverse(self) -> Tensor: ...
    def irfft(self, signal_ndim: _int, normalized: bool=False, onesided: bool=True, signal_sizes: _size=()) -> Tensor: ...
    def is_coalesced(self) -> bool: ...
    def is_complex(self) -> bool: ...
    def is_contiguous(self) -> bool: ...
    def is_cuda(self) -> bool: ...
    def is_distributed(self) -> bool: ...
    def is_floating_point(self) -> bool: ...
    def is_leaf(self) -> bool: ...
    def is_nonzero(self) -> bool: ...
    def is_same_size(self, other: Tensor) -> bool: ...
    def is_set_to(self, tensor: Tensor) -> bool: ...
    def is_signed(self) -> bool: ...
    def isclose(self, other: Tensor, rtol: _float=1e-05, atol: _float=1e-08, equal_nan: bool=False) -> Tensor: ...
    def item(self) -> Number: ...
    def kthvalue(self, k: _int, dim: _int=-1, keepdim: bool=False) -> Tuple[Tensor, Tensor]: ...
    @overload
    def le(self, other: Number) -> Tensor: ...
    @overload
    def le(self, other: Tensor) -> Tensor: ...
    @overload
    def le_(self, other: Number) -> Tensor: ...
    @overload
    def le_(self, other: Tensor) -> Tensor: ...
    @overload
    def lerp(self, end: Tensor, weight: Number) -> Tensor: ...
    @overload
    def lerp(self, end: Tensor, weight: Tensor) -> Tensor: ...
    @overload
    def lerp_(self, end: Tensor, weight: Number) -> Tensor: ...
    @overload
    def lerp_(self, end: Tensor, weight: Tensor) -> Tensor: ...
    def lgamma(self) -> Tensor: ...
    def lgamma_(self) -> Tensor: ...
    def log(self) -> Tensor: ...
    def log10(self) -> Tensor: ...
    def log10_(self) -> Tensor: ...
    def log1p(self) -> Tensor: ...
    def log1p_(self) -> Tensor: ...
    def log2(self) -> Tensor: ...
    def log2_(self) -> Tensor: ...
    def log_(self) -> Tensor: ...
    def log_normal_(self, mean: _float=1, std: _float=2, *, generator: Generator=None) -> Tensor: ...
    @overload
    def log_softmax(self, dim: _int, dtype: _dtype) -> Tensor: ...
    @overload
    def log_softmax(self, dim: _int) -> Tensor: ...
    def logdet(self) -> Tensor: ...
    def logsumexp(self, dim: Union[_int, _size], keepdim: bool=False) -> Tensor: ...
    def long(self) -> Tensor: ...
    @overload
    def lt(self, other: Number) -> Tensor: ...
    @overload
    def lt(self, other: Tensor) -> Tensor: ...
    @overload
    def lt_(self, other: Number) -> Tensor: ...
    @overload
    def lt_(self, other: Tensor) -> Tensor: ...
    def lu_solve(self, LU_data: Tensor, LU_pivots: Tensor) -> Tensor: ...
    def map_(tensor: Tensor, callable: Callable) -> Tensor: ...
    @overload
    def masked_fill(self, mask: Tensor, value: Number) -> Tensor: ...
    @overload
    def masked_fill(self, mask: Tensor, value: Tensor) -> Tensor: ...
    @overload
    def masked_fill_(self, mask: Tensor, value: Number) -> Tensor: ...
    @overload
    def masked_fill_(self, mask: Tensor, value: Tensor) -> Tensor: ...
    def masked_scatter(self, mask: Tensor, source: Tensor) -> Tensor: ...
    def masked_scatter_(self, mask: Tensor, source: Tensor) -> Tensor: ...
    def masked_select(self, mask: Tensor) -> Tensor: ...
    def matmul(self, other: Tensor) -> Tensor: ...
    def matrix_power(self, n: _int) -> Tensor: ...
    @overload
    def max(self, dim: _int, keepdim: bool=False) -> Tuple[Tensor, Tensor]: ...
    @overload
    def max(self, other: Tensor) -> Tensor: ...
    @overload
    def max(self) -> Tensor: ...
    @overload
    def mean(self, *, dtype: _dtype) -> Tensor: ...
    @overload
    def mean(self) -> Tensor: ...
    @overload
    def mean(self, dim: Union[_int, _size], keepdim: bool, *, dtype: _dtype) -> Tensor: ...
    @overload
    def mean(self, dim: Union[_int, _size], keepdim: bool=False) -> Tensor: ...
    @overload
    def mean(self, dim: Union[_int, _size], *, dtype: _dtype) -> Tensor: ...
    @overload
    def mean(self, *dim: _int, dtype: _dtype) -> Tensor: ...
    @overload
    def median(self, dim: _int, keepdim: bool=False) -> Tuple[Tensor, Tensor]: ...
    @overload
    def median(self) -> Tensor: ...
    @overload
    def min(self, dim: _int, keepdim: bool=False) -> Tuple[Tensor, Tensor]: ...
    @overload
    def min(self, other: Tensor) -> Tensor: ...
    @overload
    def min(self) -> Tensor: ...
    def mm(self, mat2: Tensor) -> Tensor: ...
    def mode(self, dim: _int=-1, keepdim: bool=False) -> Tuple[Tensor, Tensor]: ...
    def multinomial(self, num_samples: _int, replacement: bool=False, *, generator: Generator=None) -> Tensor: ...
    def mv(self, vec: Tensor) -> Tensor: ...
    def mvlgamma(self, p: _int) -> Tensor: ...
    def mvlgamma_(self, p: _int) -> Tensor: ...
    def narrow(self, dim: _int, start: _int, length: _int) -> Tensor: ...
    def narrow_copy(self, dim: _int, start: _int, length: _int) -> Tensor: ...
    def ndimension(self) -> _int: ...
    @overload
    def ne(self, other: Number) -> Tensor: ...
    @overload
    def ne(self, other: Tensor) -> Tensor: ...
    @overload
    def ne_(self, other: Number) -> Tensor: ...
    @overload
    def ne_(self, other: Tensor) -> Tensor: ...
    def neg(self) -> Tensor: ...
    def neg_(self) -> Tensor: ...
    def nelement(self) -> _int: ...
    def new_empty(self, size: _size, dtype: Optional[_dtype]=None, device: Union[_device, str, None]=None, requires_grad: bool=False) -> Tensor: ...
    def new_full(self, size: _size, value: Number, dtype: Optional[_dtype]=None, device: Union[_device, str, None]=None, requires_grad: bool=False) -> Tensor: ...
    def new_ones(self, size: _size, dtype: Optional[_dtype]=None, device: Union[_device, str, None]=None, requires_grad: bool=False) -> Tensor: ...
    def new_tensor(self, data: Any, dtype: Optional[_dtype]=None, device: Union[_device, str, None]=None, requires_grad: bool=False) -> Tensor: ...
    def new_zeros(self, size: _size, dtype: Optional[_dtype]=None, device: Union[_device, str, None]=None, requires_grad: bool=False) -> Tensor: ...
    def nonzero(self) -> Tensor: ...
    def normal_(self, mean: _float=0, std: _float=1, *, generator: Generator=None) -> Tensor: ...
    def numel(self) -> _int: ...
    def numpy(self) -> Any: ...
    def orgqr(self, input2: Tensor) -> Tensor: ...
    def ormqr(self, input2: Tensor, input3: Tensor, left: bool=True, transpose: bool=False) -> Tensor: ...
    @overload
    def permute(self, dims: _size) -> Tensor: ...
    @overload
    def permute(self, *dims: _int) -> Tensor: ...
    def pin_memory(self) -> Tensor: ...
    def pinverse(self, rcond: _float=1e-15) -> Tensor: ...
    def polygamma(self, n: _int) -> Tensor: ...
    def polygamma_(self, n: _int) -> Tensor: ...
    @overload
    def pow(self, exponent: Number) -> Tensor: ...
    @overload
    def pow(self, exponent: Tensor) -> Tensor: ...
    @overload
    def pow_(self, exponent: Number) -> Tensor: ...
    @overload
    def pow_(self, exponent: Tensor) -> Tensor: ...
    def prelu(self, weight: Tensor) -> Tensor: ...
    @overload
    def prod(self, *, dtype: _dtype) -> Tensor: ...
    @overload
    def prod(self) -> Tensor: ...
    @overload
    def prod(self, dim: _int, keepdim: bool, *, dtype: _dtype) -> Tensor: ...
    @overload
    def prod(self, dim: _int, keepdim: bool=False) -> Tensor: ...
    @overload
    def prod(self, dim: _int, *, dtype: _dtype) -> Tensor: ...
    def pstrf(self, upper: bool=True, tol: Number=-1) -> Tuple[Tensor, Tensor]: ...
    def put_(self, index: Tensor, source: Tensor, accumulate: bool=False) -> Tensor: ...
    def q_scale(self) -> Number: ...
    def q_zero_point(self) -> Number: ...
    def qr(self) -> Tuple[Tensor, Tensor]: ...
    def quantize_linear(self, scale: _float, zero_point: _int) -> Tensor: ...
    @overload
    def random_(self, from_: _int, to: _int, *, generator: Generator=None) -> Tensor: ...
    @overload
    def random_(self, to: _int, *, generator: Generator=None) -> Tensor: ...
    @overload
    def random_(self, *, generator: Generator=None) -> Tensor: ...
    def reciprocal(self) -> Tensor: ...
    def reciprocal_(self) -> Tensor: ...
    def relu(self) -> Tensor: ...
    def relu_(self) -> Tensor: ...
    @overload
    def remainder(self, other: Number) -> Tensor: ...
    @overload
    def remainder(self, other: Tensor) -> Tensor: ...
    @overload
    def remainder_(self, other: Number) -> Tensor: ...
    @overload
    def remainder_(self, other: Tensor) -> Tensor: ...
    def renorm(self, p: Number, dim: _int, maxnorm: Number) -> Tensor: ...
    def renorm_(self, p: Number, dim: _int, maxnorm: Number) -> Tensor: ...
    @overload
    def repeat(self, repeats: _size) -> Tensor: ...
    @overload
    def repeat(self, *repeats: _int) -> Tensor: ...
    @overload
    def repeat_interleave(self, repeats: Tensor, dim: Optional[_int]=None) -> Tensor: ...
    @overload
    def repeat_interleave(self, repeats: _int, dim: Optional[_int]=None) -> Tensor: ...
    def requires_grad_(self, mode: bool=True) -> Tensor: ...
    @overload
    def reshape(self, shape: _size) -> Tensor: ...
    @overload
    def reshape(self, *shape: _int) -> Tensor: ...
    def reshape_as(self, other: Tensor) -> Tensor: ...
    @overload
    def resize_(self, size: _size) -> Tensor: ...
    @overload
    def resize_(self, *size: _int) -> Tensor: ...
    def resize_as_(self, the_template: Tensor) -> Tensor: ...
    def rfft(self, signal_ndim: _int, normalized: bool=False, onesided: bool=True) -> Tensor: ...
    def roll(self, shifts: Union[_int, _size], dims: Union[_int, _size]=()) -> Tensor: ...
    def rot90(self, k: _int=1, dims: _size=(0,1)) -> Tensor: ...
    def round(self) -> Tensor: ...
    def round_(self) -> Tensor: ...
    def rsqrt(self) -> Tensor: ...
    def rsqrt_(self) -> Tensor: ...
    @overload
    def scatter(self, dim: _int, index: Tensor, src: Tensor) -> Tensor: ...
    @overload
    def scatter(self, dim: _int, index: Tensor, value: Number) -> Tensor: ...
    @overload
    def scatter_(self, dim: _int, index: Tensor, src: Tensor) -> Tensor: ...
    @overload
    def scatter_(self, dim: _int, index: Tensor, value: Number) -> Tensor: ...
    def scatter_add(self, dim: _int, index: Tensor, src: Tensor) -> Tensor: ...
    def scatter_add_(self, dim: _int, index: Tensor, src: Tensor) -> Tensor: ...
    def select(self, dim: _int, index: _int) -> Tensor: ...
    @overload
    def set_(self, source: Storage) -> Tensor: ...
    @overload
    def set_(self, source: Storage, storage_offset: _int, size: _size, stride: _size=()) -> Tensor: ...
    @overload
    def set_(self, source: Tensor) -> Tensor: ...
    @overload
    def set_(self) -> Tensor: ...
    def short(self) -> Tensor: ...
    def sigmoid(self) -> Tensor: ...
    def sigmoid_(self) -> Tensor: ...
    def sign(self) -> Tensor: ...
    def sign_(self) -> Tensor: ...
    def sin(self) -> Tensor: ...
    def sin_(self) -> Tensor: ...
    def sinh(self) -> Tensor: ...
    def sinh_(self) -> Tensor: ...
    @overload
    def size(self) -> Size: ...
    @overload
    def size(self, _int) -> _int: ...
    def slogdet(self) -> Tuple[Tensor, Tensor]: ...
    def smm(self, mat2: Tensor) -> Tensor: ...
    @overload
    def softmax(self, dim: _int, dtype: _dtype) -> Tensor: ...
    @overload
    def softmax(self, dim: _int) -> Tensor: ...
    def solve(self, A: Tensor) -> Tuple[Tensor, Tensor]: ...
    def sort(self, dim: _int=-1, descending: bool=False) -> Tuple[Tensor, Tensor]: ...
    def sparse_dim(self) -> _int: ...
    def sparse_mask(self, mask: Tensor) -> Tensor: ...
    def sparse_resize_(self, size: _size, sparse_dim: _int, dense_dim: _int) -> Tensor: ...
    def sparse_resize_and_clear_(self, size: _size, sparse_dim: _int, dense_dim: _int) -> Tensor: ...
    def split_with_sizes(self, split_sizes: _size, dim: _int=0) -> Union[Tuple[Tensor, ...], List[Tensor]]: ...
    def sqrt(self) -> Tensor: ...
    def sqrt_(self) -> Tensor: ...
    @overload
    def squeeze(self) -> Tensor: ...
    @overload
    def squeeze(self, dim: _int) -> Tensor: ...
    @overload
    def squeeze_(self) -> Tensor: ...
    @overload
    def squeeze_(self, dim: _int) -> Tensor: ...
    def sspaddmm(self, mat1: Tensor, mat2: Tensor, *, beta: Number=1, alpha: Number=1) -> Tensor: ...
    @overload
    def std(self, unbiased: bool=True) -> Tensor: ...
    @overload
    def std(self, dim: Union[_int, _size], unbiased: bool=True, keepdim: bool=False) -> Tensor: ...
    def storage(self) -> Storage: ...
    def storage_offset(self) -> _int: ...
    @overload
    def stride(self) -> Tuple[_int]: ...
    @overload
    def stride(self, _int) -> _int: ...
    @overload
    def sum(self, *, dtype: _dtype) -> Tensor: ...
    @overload
    def sum(self) -> Tensor: ...
    @overload
    def sum(self, dim: Union[_int, _size], keepdim: bool, *, dtype: _dtype) -> Tensor: ...
    @overload
    def sum(self, dim: Union[_int, _size], keepdim: bool=False) -> Tensor: ...
    @overload
    def sum(self, dim: Union[_int, _size], *, dtype: _dtype) -> Tensor: ...
    @overload
    def sum(self, *dim: _int, dtype: _dtype) -> Tensor: ...
    @overload
    def sum_to_size(self, size: _size) -> Tensor: ...
    @overload
    def sum_to_size(self, *size: _int) -> Tensor: ...
    def svd(self, some: bool=True, compute_uv: bool=True) -> Tuple[Tensor, Tensor, Tensor]: ...
    def symeig(self, eigenvectors: bool=False, upper: bool=True) -> Tuple[Tensor, Tensor]: ...
    def t(self) -> Tensor: ...
    def t_(self) -> Tensor: ...
    def take(self, index: Tensor) -> Tensor: ...
    def tan(self) -> Tensor: ...
    def tan_(self) -> Tensor: ...
    def tanh(self) -> Tensor: ...
    def tanh_(self) -> Tensor: ...
    @overload
    def to(self, dtype: _dtype, non_blocking: bool=False, copy: bool=False) -> Tensor: ...
    @overload
    def to(self, device: Optional[Union[_device, str]]=None, dtype: Optional[_dtype]=None, non_blocking: bool=False, copy: bool=False) -> Tensor: ...
    @overload
    def to(self, other: Tensor, non_blocking: bool=False, copy: bool=False) -> Tensor: ...
    def to_dense(self) -> Tensor: ...
    def to_mkldnn(self) -> Tensor: ...
    @overload
    def to_sparse(self, sparse_dim: _int) -> Tensor: ...
    @overload
    def to_sparse(self) -> Tensor: ...
    def tolist(self) -> List: ...
    def topk(self, k: _int, dim: _int=-1, largest: bool=True, sorted: bool=True) -> Tuple[Tensor, Tensor]: ...
    def trace(self) -> Tensor: ...
    def transpose(self, dim0: _int, dim1: _int) -> Tensor: ...
    def transpose_(self, dim0: _int, dim1: _int) -> Tensor: ...
    def triangular_solve(self, A: Tensor, upper: bool=True, transpose: bool=False, unitriangular: bool=False) -> Tuple[Tensor, Tensor]: ...
    def tril(self, diagonal: _int=0) -> Tensor: ...
    def tril_(self, diagonal: _int=0) -> Tensor: ...
    def triu(self, diagonal: _int=0) -> Tensor: ...
    def triu_(self, diagonal: _int=0) -> Tensor: ...
    def trunc(self) -> Tensor: ...
    def trunc_(self) -> Tensor: ...
    def type(self, dtype: Union[None, str, _dtype]=None, non_blocking: bool=False) -> Union[str, Tensor]: ...
    def type_as(self, other: Tensor) -> Tensor: ...
    def unbind(self, dim: _int=0) -> Union[Tuple[Tensor, ...], List[Tensor]]: ...
    def unfold(self, dimension: _int, size: _int, step: _int) -> Tensor: ...
    def uniform_(self, from_: _float=0, to: _float=1, *, generator: Generator=None) -> Tensor: ...
    def unsqueeze(self, dim: _int) -> Tensor: ...
    def unsqueeze_(self, dim: _int) -> Tensor: ...
    def values(self) -> Tensor: ...
    @overload
    def var(self, unbiased: bool=True) -> Tensor: ...
    @overload
    def var(self, dim: Union[_int, _size], unbiased: bool=True, keepdim: bool=False) -> Tensor: ...
    @overload
    def view(self, size: _size) -> Tensor: ...
    @overload
    def view(self, *size: _int) -> Tensor: ...
    def view_as(self, other: Tensor) -> Tensor: ...
    def where(self, condition: Tensor, other: Tensor) -> Tensor: ...
    def zero_(self) -> Tensor: ...
    @overload
    def zeros_like_(self, other: Union[Tensor, Number]) -> Tensor: ...
    @overload
    def zeros_like_(self, value: Number, other: Union[Tensor, Number]) -> Tensor: ...
    @overload
    def zeros_like_(self, other: Union[Tensor, Number], *, out: Optional[Tensor]=None) -> Tensor: ...
    @overload
    def zeros_like_(self, value: Number, other: Union[Tensor, Number], *, out: Optional[Tensor]=None) -> Tensor: ...
    @overload
    def zeros_like__(self, other: Union[Tensor, Number]) -> Tensor: ...
    @overload
    def zeros_like__(self, value: Number, other: Union[Tensor, Number]) -> Tensor: ...
    @overload
    def zeros_like__(self, other: Union[Tensor, Number], *, out: Optional[Tensor]=None) -> Tensor: ...
    @overload
    def zeros_like__(self, value: Number, other: Union[Tensor, Number], *, out: Optional[Tensor]=None) -> Tensor: ...
    @overload
    def zeros_like___(self, other: Union[Tensor, Number]) -> Tensor: ...
    @overload
    def zeros_like___(self, value: Number, other: Union[Tensor, Number]) -> Tensor: ...
    @overload
    def zeros_like___(self, other: Union[Tensor, Number], *, out: Optional[Tensor]=None) -> Tensor: ...
    @overload
    def zeros_like___(self, value: Number, other: Union[Tensor, Number], *, out: Optional[Tensor]=None) -> Tensor: ...
    @overload
    def zeros_like____(self, other: Union[Tensor, Number]) -> Tensor: ...
    @overload
    def zeros_like____(self, value: Number, other: Union[Tensor, Number]) -> Tensor: ...
    @overload
    def zeros_like____(self, other: Union[Tensor, Number], *, out: Optional[Tensor]=None) -> Tensor: ...
    @overload
    def zeros_like____(self, value: Number, other: Union[Tensor, Number], *, out: Optional[Tensor]=None) -> Tensor: ...

    # Manually defined methods from torch/tensor.py
    def backward(self, gradient: Optional[Tensor]=None, retain_graph: Optional[bool]=None, create_graph: bool=False) -> None: ...
    def register_hook(self, hook: Callable) -> Any: ...
    def retain_grad(self) -> None: ...
    def is_pinned(self) -> bool: ...
    def is_shared(self) -> bool: ...
    def share_memory_(self) -> None: ...
    # TODO: fill in the types for these, or otherwise figure out some
    # way to not have to write these out again...
    def norm(self, p="fro", dim=None, keepdim=False): ...
    def stft(self, n_fft, hop_length=None, win_length=None, window=None,
             center=True, pad_mode='reflect', normalized=False, onesided=True): ...
    def split(self, split_size, dim=0): ...
    def unique(self, sorted=True, return_inverse=False, dim=None): ...
    def unique_consecutive(self, sorted=True, return_inverse=False, return_counts=False, dim=None): ...
    def lu(self, pivot=True, get_infos=False): ...

@overload
def __and__(self: Tensor, other: Number) -> Tensor: ...
@overload
def __and__(self: Tensor, other: Tensor) -> Tensor: ...
@overload
def __lshift__(self: Tensor, other: Number) -> Tensor: ...
@overload
def __lshift__(self: Tensor, other: Tensor) -> Tensor: ...
@overload
def __or__(self: Tensor, other: Number) -> Tensor: ...
@overload
def __or__(self: Tensor, other: Tensor) -> Tensor: ...
@overload
def __rshift__(self: Tensor, other: Number) -> Tensor: ...
@overload
def __rshift__(self: Tensor, other: Tensor) -> Tensor: ...
@overload
def __xor__(self: Tensor, other: Number) -> Tensor: ...
@overload
def __xor__(self: Tensor, other: Tensor) -> Tensor: ...
def _adaptive_avg_pool2d(self: Tensor, output_size: Union[_int, _size]) -> Tensor: ...
def _baddbmm_mkl_(self: Tensor, batch1: Tensor, batch2: Tensor, *, beta: Number=1, alpha: Number=1) -> Tensor: ...
def _batch_norm_impl_index(input: Tensor, weight: Optional[Tensor], bias: Optional[Tensor], running_mean: Optional[Tensor], running_var: Optional[Tensor], training: bool, momentum: _float, eps: _float, cudnn_enabled: bool) -> Tuple[Tensor, Tensor, Tensor, _int]: ...
def _cast_Byte(self: Tensor, non_blocking: bool=False) -> Tensor: ...
def _cast_Char(self: Tensor, non_blocking: bool=False) -> Tensor: ...
def _cast_Double(self: Tensor, non_blocking: bool=False) -> Tensor: ...
def _cast_Float(self: Tensor, non_blocking: bool=False) -> Tensor: ...
def _cast_Half(self: Tensor, non_blocking: bool=False) -> Tensor: ...
def _cast_Int(self: Tensor, non_blocking: bool=False) -> Tensor: ...
def _cast_Long(self: Tensor, non_blocking: bool=False) -> Tensor: ...
def _cast_Short(self: Tensor, non_blocking: bool=False) -> Tensor: ...
def _convolution(input: Tensor, weight: Tensor, bias: Optional[Tensor], stride: _size, padding: _size, dilation: _size, transposed: bool, output_padding: _size, groups: _int, benchmark: bool, deterministic: bool, cudnn_enabled: bool) -> Tensor: ...
def _convolution_nogroup(input: Tensor, weight: Tensor, bias: Optional[Tensor], stride: _size, padding: _size, dilation: _size, transposed: bool, output_padding: _size) -> Tensor: ...
def _copy_same_type_(self: Tensor, src: Tensor) -> None: ...
def _ctc_loss(log_probs: Tensor, targets: Tensor, input_lengths: _size, target_lengths: _size, blank: _int=0, zero_infinity: bool=False) -> Tuple[Tensor, Tensor]: ...
def _cudnn_ctc_loss(log_probs: Tensor, targets: Tensor, input_lengths: _size, target_lengths: _size, blank: _int, deterministic: bool, zero_infinity: bool) -> Tuple[Tensor, Tensor]: ...
def _cudnn_init_dropout_state(dropout: _float, train: bool, dropout_seed: _int, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
def _cudnn_rnn(input: Tensor, weight: Union[Tuple[Tensor, ...], List[Tensor]], weight_stride0: _int, weight_buf: Optional[Tensor], hx: Tensor, cx: Optional[Tensor], mode: _int, hidden_size: _int, num_layers: _int, batch_first: bool, dropout: _float, train: bool, bidirectional: bool, batch_sizes: _size, dropout_state: Optional[Tensor]) -> Tuple[Tensor, Tensor, Tensor, Tensor, Tensor]: ...
def _cudnn_rnn_flatten_weight(weight_arr: Union[Tuple[Tensor, ...], List[Tensor]], weight_stride0: _int, input_size: _int, mode: _int, hidden_size: _int, num_layers: _int, batch_first: bool, bidirectional: bool) -> Tensor: ...
def _cufft_clear_plan_cache(device_index: _int) -> None: ...
def _cufft_get_plan_cache_max_size(device_index: _int) -> _int: ...
def _cufft_get_plan_cache_size(device_index: _int) -> _int: ...
def _cufft_set_plan_cache_max_size(device_index: _int, max_size: _int) -> None: ...
def _debug_has_internal_overlap(self: Tensor) -> _int: ...
def _dim_arange(like: Tensor, dim: _int) -> Tensor: ...
def _dirichlet_grad(x: Tensor, alpha: Tensor, total: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def _embedding_bag(weight: Tensor, indices: Tensor, offsets: Tensor, scale_grad_by_freq: bool=False, mode: _int=0, sparse: bool=False, per_sample_weights: Optional[Tensor]=None) -> Tuple[Tensor, Tensor, Tensor, Tensor]: ...
@overload
def _empty_affine_quantized(size: _size, *, scale: _float=1, zero_point: _int=0, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def _empty_affine_quantized(*size: _int, scale: _float=1, zero_point: _int=0, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
def _fft_with_size(self: Tensor, signal_ndim: _int, complex_input: bool, complex_output: bool, inverse: bool, checked_signal_sizes: _size, normalized: bool, onesided: bool, output_sizes: _size) -> Tensor: ...
def _fused_dropout(self: Tensor, p: _float, generator: Generator=None) -> Tuple[Tensor, Tensor]: ...
def _log_softmax(self: Tensor, dim: _int, half_to_float: bool) -> Tensor: ...
def _log_softmax_backward_data(grad_output: Tensor, output: Tensor, dim: _int, self: Tensor) -> Tensor: ...
def _lu_with_info(self: Tensor, pivot: bool=True, check_errors: bool=True) -> Tuple[Tensor, Tensor, Tensor]: ...
def _masked_scale(self: Tensor, mask: Tensor, scale: _float) -> Tensor: ...
def _multinomial_alias_draw(J: Tensor, q: Tensor, num_samples: _int, *, generator: Generator=None) -> Tensor: ...
def _multinomial_alias_setup(probs: Tensor) -> Tuple[Tensor, Tensor]: ...
def _nnpack_available() -> bool: ...
def _nnpack_spatial_convolution(input: Tensor, weight: Tensor, bias: Optional[Tensor], padding: Union[_int, _size]) -> Tensor: ...
def _pack_padded_sequence(input: Tensor, lengths: Tensor, batch_first: bool) -> Tuple[Tensor, Tensor]: ...
def _pad_packed_sequence(data: Tensor, batch_sizes: Tensor, batch_first: bool, padding_value: Number, total_length: _int) -> Tuple[Tensor, Tensor]: ...
def _reshape_from_tensor(self: Tensor, shape: Tensor) -> Tensor: ...
def _s_copy_from(self: Tensor, dst: Tensor, non_blocking: bool=False) -> Tensor: ...
def _s_where(condition: Tensor, self: Tensor, other: Tensor) -> Tensor: ...
def _sample_dirichlet(self: Tensor, generator: Generator=None) -> Tensor: ...
def _shape_as_tensor(self: Tensor) -> Tensor: ...
def _sobol_engine_draw(quasi: Tensor, n: _int, sobolstate: Tensor, dimension: _int, num_generated: _int, dtype: Optional[_dtype]) -> Tuple[Tensor, Tensor]: ...
def _sobol_engine_ff_(self: Tensor, n: _int, sobolstate: Tensor, dimension: _int, num_generated: _int) -> Tensor: ...
def _sobol_engine_initialize_state_(self: Tensor, dimension: _int) -> Tensor: ...
def _sobol_engine_scramble_(self: Tensor, ltm: Tensor, dimension: _int) -> Tensor: ...
def _softmax(self: Tensor, dim: _int, half_to_float: bool) -> Tensor: ...
def _softmax_backward_data(grad_output: Tensor, output: Tensor, dim: _int, self: Tensor) -> Tensor: ...
def _sparse_addmm(self: Tensor, sparse: Tensor, dense: Tensor, *, beta: Number=1, alpha: Number=1) -> Tensor: ...
def _sparse_mm(sparse: Tensor, dense: Tensor) -> Tensor: ...
@overload
def _sparse_sum(self: Tensor) -> Tensor: ...
@overload
def _sparse_sum(self: Tensor, *, dtype: _dtype) -> Tensor: ...
@overload
def _sparse_sum(self: Tensor, dim: Union[_int, _size]) -> Tensor: ...
@overload
def _sparse_sum(self: Tensor, dim: Union[_int, _size], *, dtype: _dtype) -> Tensor: ...
def _standard_gamma(self: Tensor, generator: Generator=None) -> Tensor: ...
def _standard_gamma_grad(self: Tensor, output: Tensor) -> Tensor: ...
def _trilinear(i1: Tensor, i2: Tensor, i3: Tensor, expand1: _size, expand2: _size, expand3: _size, sumdim: _size, unroll_dim: _int=1) -> Tensor: ...
def _unique(self: Tensor, sorted: bool=True, return_inverse: bool=False) -> Tuple[Tensor, Tensor]: ...
def _unique2(self: Tensor, sorted: bool=True, return_inverse: bool=False, return_counts: bool=False) -> Tuple[Tensor, Tensor, Tensor]: ...
def _weight_norm(v: Tensor, g: Tensor, dim: _int=0) -> Tensor: ...
def _weight_norm_cuda_interface(v: Tensor, g: Tensor, dim: _int=0) -> Tuple[Tensor, Tensor]: ...
def abs(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def abs_(self: Tensor) -> Tensor: ...
def acos(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def acos_(self: Tensor) -> Tensor: ...
def adaptive_avg_pool1d(self: Tensor, output_size: Union[_int, _size]) -> Tensor: ...
def adaptive_max_pool1d(self: Tensor, output_size: Union[_int, _size]) -> Tuple[Tensor, Tensor]: ...
@overload
def add(input: Union[Tensor, Number], other: Union[Tensor, Number], *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def add(input: Union[Tensor, Number], value: Number, other: Union[Tensor, Number], *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def add(self: Tensor, alpha: Number, other: Tensor) -> Tensor: ...
@overload
def add(self: Tensor, alpha: Number, other: Tensor, *, out: Tensor) -> Tensor: ...
@overload
def addbmm(self: Tensor, batch1: Tensor, batch2: Tensor, *, beta: Number=1, alpha: Number=1, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def addbmm(beta: Number, self: Tensor, alpha: Number, batch1: Tensor, batch2: Tensor) -> Tensor: ...
@overload
def addbmm(beta: Number, self: Tensor, alpha: Number, batch1: Tensor, batch2: Tensor, *, out: Tensor) -> Tensor: ...
@overload
def addbmm(beta: Number, self: Tensor, batch1: Tensor, batch2: Tensor) -> Tensor: ...
@overload
def addbmm(beta: Number, self: Tensor, batch1: Tensor, batch2: Tensor, *, out: Tensor) -> Tensor: ...
@overload
def addcdiv(self: Tensor, tensor1: Tensor, tensor2: Tensor, *, value: Number=1, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def addcdiv(self: Tensor, value: Number, tensor1: Tensor, tensor2: Tensor) -> Tensor: ...
@overload
def addcdiv(self: Tensor, value: Number, tensor1: Tensor, tensor2: Tensor, *, out: Tensor) -> Tensor: ...
@overload
def addcmul(self: Tensor, tensor1: Tensor, tensor2: Tensor, *, value: Number=1, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def addcmul(self: Tensor, value: Number, tensor1: Tensor, tensor2: Tensor) -> Tensor: ...
@overload
def addcmul(self: Tensor, value: Number, tensor1: Tensor, tensor2: Tensor, *, out: Tensor) -> Tensor: ...
@overload
def addmm(self: Tensor, mat1: Tensor, mat2: Tensor, *, beta: Number=1, alpha: Number=1, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def addmm(beta: Number, self: Tensor, alpha: Number, mat1: Tensor, mat2: Tensor) -> Tensor: ...
@overload
def addmm(beta: Number, self: Tensor, alpha: Number, mat1: Tensor, mat2: Tensor, *, out: Tensor) -> Tensor: ...
@overload
def addmm(beta: Number, self: Tensor, mat1: Tensor, mat2: Tensor) -> Tensor: ...
@overload
def addmm(beta: Number, self: Tensor, mat1: Tensor, mat2: Tensor, *, out: Tensor) -> Tensor: ...
@overload
def addmv(self: Tensor, mat: Tensor, vec: Tensor, *, beta: Number=1, alpha: Number=1, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def addmv(beta: Number, self: Tensor, alpha: Number, mat: Tensor, vec: Tensor) -> Tensor: ...
@overload
def addmv(beta: Number, self: Tensor, alpha: Number, mat: Tensor, vec: Tensor, *, out: Tensor) -> Tensor: ...
@overload
def addmv(beta: Number, self: Tensor, mat: Tensor, vec: Tensor) -> Tensor: ...
@overload
def addmv(beta: Number, self: Tensor, mat: Tensor, vec: Tensor, *, out: Tensor) -> Tensor: ...
def addmv_(self: Tensor, mat: Tensor, vec: Tensor, *, beta: Number=1, alpha: Number=1) -> Tensor: ...
@overload
def addr(self: Tensor, vec1: Tensor, vec2: Tensor, *, beta: Number=1, alpha: Number=1, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def addr(beta: Number, self: Tensor, alpha: Number, vec1: Tensor, vec2: Tensor) -> Tensor: ...
@overload
def addr(beta: Number, self: Tensor, alpha: Number, vec1: Tensor, vec2: Tensor, *, out: Tensor) -> Tensor: ...
@overload
def addr(beta: Number, self: Tensor, vec1: Tensor, vec2: Tensor) -> Tensor: ...
@overload
def addr(beta: Number, self: Tensor, vec1: Tensor, vec2: Tensor, *, out: Tensor) -> Tensor: ...
def affine_grid_generator(theta: Tensor, size: _size) -> Tensor: ...
@overload
def all(self: Tensor, dim: _int, keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def all(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def allclose(self: Tensor, other: Tensor, rtol: _float=1e-05, atol: _float=1e-08, equal_nan: bool=False) -> bool: ...
def alpha_dropout(input: Tensor, p: _float, train: bool) -> Tensor: ...
def alpha_dropout_(self: Tensor, p: _float, train: bool) -> Tensor: ...
@overload
def any(self: Tensor, dim: _int, keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def any(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def arange(start: Number, end: Number, step: Number, *, out: Optional[Tensor]=None, dtype: Optional[_dtype]=None, device: Union[_device, str, None]=None, requires_grad: bool=False) -> Tensor: ...
@overload
def arange(start: Number, end: Number, *, out: Optional[Tensor]=None, dtype: Optional[_dtype]=None, device: Union[_device, str, None]=None, requires_grad: bool=False) -> Tensor: ...
@overload
def arange(end: Number, *, out: Optional[Tensor]=None, dtype: Optional[_dtype]=None, device: Union[_device, str, None]=None, requires_grad: bool=False) -> Tensor: ...
def argmax(self: Tensor, dim: Optional[_int]=None, keepdim: bool=False) -> Tensor: ...
def argmin(self: Tensor, dim: Optional[_int]=None, keepdim: bool=False) -> Tensor: ...
def argsort(self: Tensor, dim: _int=-1, descending: bool=False) -> Tensor: ...
def as_strided(self: Tensor, size: _size, stride: _size, storage_offset: Optional[_int]=None) -> Tensor: ...
def as_strided_(self: Tensor, size: _size, stride: _size, storage_offset: Optional[_int]=None) -> Tensor: ...
def as_tensor(data: Any, dtype: _dtype=None, device: Optional[_device]=None) -> Tensor: ...
def asin(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def asin_(self: Tensor) -> Tensor: ...
def atan(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def atan2(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def atan_(self: Tensor) -> Tensor: ...
def avg_pool1d(self: Tensor, kernel_size: Union[_int, _size], stride: Union[_int, _size]=(), padding: Union[_int, _size]=0, ceil_mode: bool=False, count_include_pad: bool=True) -> Tensor: ...
@overload
def baddbmm(self: Tensor, batch1: Tensor, batch2: Tensor, *, beta: Number=1, alpha: Number=1, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def baddbmm(beta: Number, self: Tensor, alpha: Number, batch1: Tensor, batch2: Tensor) -> Tensor: ...
@overload
def baddbmm(beta: Number, self: Tensor, alpha: Number, batch1: Tensor, batch2: Tensor, *, out: Tensor) -> Tensor: ...
@overload
def baddbmm(beta: Number, self: Tensor, batch1: Tensor, batch2: Tensor) -> Tensor: ...
@overload
def baddbmm(beta: Number, self: Tensor, batch1: Tensor, batch2: Tensor, *, out: Tensor) -> Tensor: ...
@overload
def bartlett_window(window_length: _int, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def bartlett_window(window_length: _int, periodic: bool, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
def batch_norm(input: Tensor, weight: Optional[Tensor], bias: Optional[Tensor], running_mean: Optional[Tensor], running_var: Optional[Tensor], training: bool, momentum: _float, eps: _float, cudnn_enabled: bool) -> Tensor: ...
def batch_norm_backward_elemt(grad_out: Tensor, input: Tensor, mean: Tensor, invstd: Tensor, weight: Optional[Tensor], mean_dy: Tensor, mean_dy_xmu: Tensor) -> Tensor: ...
def batch_norm_backward_reduce(grad_out: Tensor, input: Tensor, mean: Tensor, invstd: Tensor, input_g: bool, weight_g: bool, bias_g: bool) -> Tuple[Tensor, Tensor, Tensor, Tensor]: ...
def batch_norm_elemt(input: Tensor, weight: Optional[Tensor], bias: Optional[Tensor], mean: Tensor, invstd: Tensor, eps: _float) -> Tensor: ...
def batch_norm_gather_stats(input: Tensor, mean: Tensor, invstd: Tensor, running_mean: Optional[Tensor], running_var: Optional[Tensor], momentum: _float, eps: _float, count: _int) -> Tuple[Tensor, Tensor]: ...
def batch_norm_stats(input: Tensor, eps: _float) -> Tuple[Tensor, Tensor]: ...
def batch_norm_update_stats(input: Tensor, running_mean: Optional[Tensor], running_var: Optional[Tensor], momentum: _float) -> Tuple[Tensor, Tensor]: ...
@overload
def bernoulli(self: Tensor, *, generator: Generator=None, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def bernoulli(self: Tensor, p: _float, *, generator: Generator=None, out: Optional[Tensor]=None) -> Tensor: ...
def bilinear(input1: Tensor, input2: Tensor, weight: Tensor, bias: Optional[Tensor]) -> Tensor: ...
def binary_cross_entropy_with_logits(self: Tensor, target: Tensor, weight: Optional[Tensor], pos_weight: Optional[Tensor], reduction: _int) -> Tensor: ...
def bincount(self: Tensor, weights: Optional[Tensor]=None, minlength: _int=0) -> Tensor: ...
@overload
def blackman_window(window_length: _int, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def blackman_window(window_length: _int, periodic: bool, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
def bmm(self: Tensor, mat2: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def cat(tensors: Union[Tuple[Tensor, ...], List[Tensor]], dim: _int=0, *, out: Optional[Tensor]=None) -> Tensor: ...
def cdist(x1: Tensor, x2: Tensor, p: _float=2) -> Tensor: ...
def ceil(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def ceil_(self: Tensor) -> Tensor: ...
def celu(self: Tensor, alpha: Number=1.0) -> Tensor: ...
def celu_(self: Tensor, alpha: Number=1.0) -> Tensor: ...
def cholesky(self: Tensor, upper: bool=False, *, out: Optional[Tensor]=None) -> Tensor: ...
def cholesky_inverse(self: Tensor, upper: bool=False, *, out: Optional[Tensor]=None) -> Tensor: ...
def cholesky_solve(self: Tensor, input2: Tensor, upper: bool=False, *, out: Optional[Tensor]=None) -> Tensor: ...
def chunk(self: Tensor, chunks: _int, dim: _int=0) -> Union[Tuple[Tensor, ...], List[Tensor]]: ...
def clamp(self, min: _float=-inf, max: _float=inf, *, out: Optional[Tensor]=None) -> Tensor: ...
def clamp_max(self: Tensor, max: Number, *, out: Optional[Tensor]=None) -> Tensor: ...
def clamp_max_(self: Tensor, max: Number) -> Tensor: ...
def clamp_min(self: Tensor, min: Number, *, out: Optional[Tensor]=None) -> Tensor: ...
def clamp_min_(self: Tensor, min: Number) -> Tensor: ...
def clone(self: Tensor) -> Tensor: ...
def combinations(self: Tensor, r: _int=2, with_replacement: bool=False) -> Tensor: ...
def constant_pad_nd(self: Tensor, pad: _size, value: Number=0) -> Tensor: ...
def conv1d(input: Tensor, weight: Tensor, bias: Optional[Tensor]=None, stride: Union[_int, _size]=1, padding: Union[_int, _size]=0, dilation: Union[_int, _size]=1, groups: _int=1) -> Tensor: ...
def conv2d(input: Tensor, weight: Tensor, bias: Optional[Tensor]=None, stride: Union[_int, _size]=1, padding: Union[_int, _size]=0, dilation: Union[_int, _size]=1, groups: _int=1) -> Tensor: ...
def conv3d(input: Tensor, weight: Tensor, bias: Optional[Tensor]=None, stride: Union[_int, _size]=1, padding: Union[_int, _size]=0, dilation: Union[_int, _size]=1, groups: _int=1) -> Tensor: ...
def conv_tbc(self: Tensor, weight: Tensor, bias: Tensor, pad: _int=0) -> Tensor: ...
def conv_transpose1d(input: Tensor, weight: Tensor, bias: Optional[Tensor]=None, stride: Union[_int, _size]=1, padding: Union[_int, _size]=0, output_padding: Union[_int, _size]=0, groups: _int=1, dilation: Union[_int, _size]=1) -> Tensor: ...
def conv_transpose2d(input: Tensor, weight: Tensor, bias: Optional[Tensor]=None, stride: Union[_int, _size]=1, padding: Union[_int, _size]=0, output_padding: Union[_int, _size]=0, groups: _int=1, dilation: Union[_int, _size]=1) -> Tensor: ...
def conv_transpose3d(input: Tensor, weight: Tensor, bias: Optional[Tensor]=None, stride: Union[_int, _size]=1, padding: Union[_int, _size]=0, output_padding: Union[_int, _size]=0, groups: _int=1, dilation: Union[_int, _size]=1) -> Tensor: ...
def convolution(input: Tensor, weight: Tensor, bias: Optional[Tensor], stride: _size, padding: _size, dilation: _size, transposed: bool, output_padding: _size, groups: _int) -> Tensor: ...
def cos(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def cos_(self: Tensor) -> Tensor: ...
def cosh(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def cosh_(self: Tensor) -> Tensor: ...
def cosine_similarity(x1: Tensor, x2: Tensor, dim: _int=1, eps: _float=1e-08) -> Tensor: ...
def cross(self: Tensor, other: Tensor, dim: Optional[_int]=None, *, out: Optional[Tensor]=None) -> Tensor: ...
def cudnn_affine_grid_generator(theta: Tensor, N: _int, C: _int, H: _int, W: _int) -> Tensor: ...
def cudnn_batch_norm(input: Tensor, weight: Tensor, bias: Optional[Tensor], running_mean: Optional[Tensor], running_var: Optional[Tensor], training: bool, exponential_average_factor: _float, epsilon: _float) -> Tuple[Tensor, Tensor, Tensor]: ...
def cudnn_convolution(self: Tensor, weight: Tensor, bias: Optional[Tensor], padding: _size, stride: _size, dilation: _size, groups: _int, benchmark: bool, deterministic: bool) -> Tensor: ...
def cudnn_convolution_transpose(self: Tensor, weight: Tensor, bias: Optional[Tensor], padding: _size, output_padding: _size, stride: _size, dilation: _size, groups: _int, benchmark: bool, deterministic: bool) -> Tensor: ...
def cudnn_grid_sampler(self: Tensor, grid: Tensor) -> Tensor: ...
def cudnn_is_acceptable(self: Tensor) -> bool: ...
@overload
def cumprod(self: Tensor, dim: _int, *, dtype: _dtype, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def cumprod(self: Tensor, dim: _int, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def cumsum(self: Tensor, dim: _int, *, dtype: _dtype, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def cumsum(self: Tensor, dim: _int, *, out: Optional[Tensor]=None) -> Tensor: ...
def dequantize(self: Tensor) -> Tensor: ...
def det(self: Tensor) -> Tensor: ...
def detach(self: Tensor) -> Tensor: ...
def detach_(self: Tensor) -> Tensor: ...
def diag(self: Tensor, diagonal: _int=0, *, out: Optional[Tensor]=None) -> Tensor: ...
def diag_embed(self: Tensor, offset: _int=0, dim1: _int=-2, dim2: _int=-1) -> Tensor: ...
def diagflat(self: Tensor, offset: _int=0) -> Tensor: ...
def diagonal(self: Tensor, offset: _int=0, dim1: _int=0, dim2: _int=1) -> Tensor: ...
def digamma(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def dist(self: Tensor, other: Tensor, p: Number=2) -> Tensor: ...
@overload
def div(input: Union[Tensor, Number], other: Union[Tensor, Number], *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def div(input: Union[Tensor, Number], value: Number, other: Union[Tensor, Number], *, out: Optional[Tensor]=None) -> Tensor: ...
def dot(self: Tensor, tensor: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def dropout(input: Tensor, p: _float, train: bool) -> Tensor: ...
def dropout_(self: Tensor, p: _float, train: bool) -> Tensor: ...
def eig(self: Tensor, eigenvectors: bool=False, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...
def embedding(weight: Tensor, indices: Tensor, padding_idx: _int=-1, scale_grad_by_freq: bool=False, sparse: bool=False) -> Tensor: ...
def embedding_bag(weight: Tensor, indices: Tensor, offsets: Tensor, scale_grad_by_freq: bool=False, mode: _int=0, sparse: bool=False, per_sample_weights: Optional[Tensor]=None) -> Tuple[Tensor, Tensor, Tensor, Tensor]: ...
def embedding_renorm_(self: Tensor, indices: Tensor, max_norm: _float, norm_type: _float) -> Tensor: ...
@overload
def empty(size: _size, *, out: Optional[Tensor]=None, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def empty(*size: _int, out: Optional[Tensor]=None, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def empty_like(self: Tensor) -> Tensor: ...
@overload
def empty_like(self: Tensor, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
def empty_strided(size: _size, stride: _size, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def eq(self: Tensor, other: Number, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def eq(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def equal(self: Tensor, other: Tensor) -> bool: ...
def erf(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def erf_(self: Tensor) -> Tensor: ...
def erfc(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def erfc_(self: Tensor) -> Tensor: ...
def erfinv(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def exp(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def exp_(self: Tensor) -> Tensor: ...
def expm1(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def expm1_(self: Tensor) -> Tensor: ...
@overload
def eye(n: _int, *, out: Optional[Tensor]=None, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def eye(n: _int, m: _int, *, out: Optional[Tensor]=None, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
def fbgemm_is_cpu_supported() -> bool: ...
def fbgemm_linear_int8_weight(input: Tensor, weight: Tensor, packed: Tensor, col_offsets: Tensor, weight_scale: Number, weight_zero_point: Number, bias: Tensor) -> Tensor: ...
def fbgemm_linear_quantize_weight(input: Tensor) -> Tuple[Tensor, Tensor, _float, _int]: ...
def fbgemm_pack_quantized_matrix(input: Tensor, K: _int, N: _int) -> Tensor: ...
def feature_alpha_dropout(input: Tensor, p: _float, train: bool) -> Tensor: ...
def feature_alpha_dropout_(self: Tensor, p: _float, train: bool) -> Tensor: ...
def feature_dropout(input: Tensor, p: _float, train: bool) -> Tensor: ...
def feature_dropout_(self: Tensor, p: _float, train: bool) -> Tensor: ...
def fft(self: Tensor, signal_ndim: _int, normalized: bool=False) -> Tensor: ...
@overload
def fill_(self: Tensor, value: Number) -> Tensor: ...
@overload
def fill_(self: Tensor, value: Tensor) -> Tensor: ...
def flatten(self: Tensor, start_dim: _int=0, end_dim: _int=-1) -> Tensor: ...
def flip(self: Tensor, dims: _size) -> Tensor: ...
def floor(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def floor_(self: Tensor) -> Tensor: ...
@overload
def fmod(self: Tensor, other: Number, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def fmod(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def frac(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def frac_(self: Tensor) -> Tensor: ...
@overload
def frobenius_norm(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def frobenius_norm(self: Tensor, dim: Union[_int, _size], keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tensor: ...
def from_file(filename: str, shared: Optional[bool]=None, size: Optional[_int]=0, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
def from_numpy(ndarray) -> Tensor: ...
def full(size: _size, fill_value: Number, *, out: Optional[Tensor]=None, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def full_like(self: Tensor, fill_value: Number) -> Tensor: ...
@overload
def full_like(self: Tensor, fill_value: Number, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
def gather(self: Tensor, dim: _int, index: Tensor, *, sparse_grad: bool=False, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def ge(self: Tensor, other: Number, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def ge(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def gels(self: Tensor, A: Tensor, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...
def geqrf(self: Tensor, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...
def ger(self: Tensor, vec2: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def get_default_dtype() -> _dtype: ...
def get_num_threads() -> _int: ...
def grid_sampler(input: Tensor, grid: Tensor, interpolation_mode: _int, padding_mode: _int) -> Tensor: ...
def grid_sampler_2d(input: Tensor, grid: Tensor, interpolation_mode: _int, padding_mode: _int) -> Tensor: ...
def grid_sampler_3d(input: Tensor, grid: Tensor, interpolation_mode: _int, padding_mode: _int) -> Tensor: ...
def group_norm(input: Tensor, num_groups: _int, weight: Optional[Tensor]=None, bias: Optional[Tensor]=None, eps: _float=1e-05, cudnn_enabled: bool=True) -> Tensor: ...
@overload
def gru(input: Tensor, hx: Tensor, params: Union[Tuple[Tensor, ...], List[Tensor]], has_biases: bool, num_layers: _int, dropout: _float, train: bool, bidirectional: bool, batch_first: bool) -> Tuple[Tensor, Tensor]: ...
@overload
def gru(data: Tensor, batch_sizes: Tensor, hx: Tensor, params: Union[Tuple[Tensor, ...], List[Tensor]], has_biases: bool, num_layers: _int, dropout: _float, train: bool, bidirectional: bool) -> Tuple[Tensor, Tensor]: ...
def gru_cell(input: Tensor, hx: Tensor, w_ih: Tensor, w_hh: Tensor, b_ih: Optional[Tensor]=None, b_hh: Optional[Tensor]=None) -> Tensor: ...
@overload
def gt(self: Tensor, other: Number, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def gt(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def hamming_window(window_length: _int, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def hamming_window(window_length: _int, periodic: bool, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def hamming_window(window_length: _int, periodic: bool, alpha: _float, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def hamming_window(window_length: _int, periodic: bool, alpha: _float, beta: _float, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def hann_window(window_length: _int, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def hann_window(window_length: _int, periodic: bool, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
def hardshrink(self: Tensor, lambd: Number=0.5) -> Tensor: ...
def histc(self: Tensor, bins: _int=100, min: Number=0, max: Number=0, *, out: Optional[Tensor]=None) -> Tensor: ...
def hspmm(mat1: Tensor, mat2: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def ifft(self: Tensor, signal_ndim: _int, normalized: bool=False) -> Tensor: ...
def index_add(self: Tensor, dim: _int, index: Tensor, source: Tensor) -> Tensor: ...
def index_copy(self: Tensor, dim: _int, index: Tensor, source: Tensor) -> Tensor: ...
@overload
def index_fill(self: Tensor, dim: _int, index: Tensor, value: Number) -> Tensor: ...
@overload
def index_fill(self: Tensor, dim: _int, index: Tensor, value: Tensor) -> Tensor: ...
def index_put(self: Tensor, indices: Optional[Union[Tuple[Tensor, ...], List[Tensor]]], values: Tensor, accumulate: bool=False) -> Tensor: ...
def index_put_(self: Tensor, indices: Optional[Union[Tuple[Tensor, ...], List[Tensor]]], values: Tensor, accumulate: bool=False) -> Tensor: ...
def index_select(self: Tensor, dim: _int, index: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def instance_norm(input: Tensor, weight: Optional[Tensor], bias: Optional[Tensor], running_mean: Optional[Tensor], running_var: Optional[Tensor], use_input_stats: bool, momentum: _float, eps: _float, cudnn_enabled: bool) -> Tensor: ...
def int_repr(self: Tensor) -> Tensor: ...
def inverse(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def irfft(self: Tensor, signal_ndim: _int, normalized: bool=False, onesided: bool=True, signal_sizes: _size=()) -> Tensor: ...
def is_complex(self: Tensor) -> bool: ...
def is_distributed(self: Tensor) -> bool: ...
def is_floating_point(self: Tensor) -> bool: ...
def is_nonzero(self: Tensor) -> bool: ...
def is_same_size(self: Tensor, other: Tensor) -> bool: ...
def is_signed(self: Tensor) -> bool: ...
def isclose(self: Tensor, other: Tensor, rtol: _float=1e-05, atol: _float=1e-08, equal_nan: bool=False) -> Tensor: ...
def isnan(self: Tensor) -> Tensor: ...
def kthvalue(self: Tensor, k: _int, dim: _int=-1, keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...
def layer_norm(input: Tensor, normalized_shape: _size, weight: Optional[Tensor]=None, bias: Optional[Tensor]=None, eps: _float=1e-05, cudnn_enable: bool=True) -> Tensor: ...
@overload
def le(self: Tensor, other: Number, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def le(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def lerp(self: Tensor, end: Tensor, weight: Number, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def lerp(self: Tensor, end: Tensor, weight: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def lgamma(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def linspace(start: Number, end: Number, steps: _int=100, *, out: Optional[Tensor]=None, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
def log(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def log10(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def log10_(self: Tensor) -> Tensor: ...
def log1p(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def log1p_(self: Tensor) -> Tensor: ...
def log2(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def log2_(self: Tensor) -> Tensor: ...
def log_(self: Tensor) -> Tensor: ...
@overload
def log_softmax(self: Tensor, dim: _int, dtype: _dtype) -> Tensor: ...
@overload
def log_softmax(self: Tensor, dim: _int) -> Tensor: ...
def logdet(self: Tensor) -> Tensor: ...
def logspace(start: Number, end: Number, steps: _int=100, base: _float=10.0, *, out: Optional[Tensor]=None, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
def logsumexp(self: Tensor, dim: Union[_int, _size], keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def lstm(input: Tensor, hx: Union[Tuple[Tensor, ...], List[Tensor]], params: Union[Tuple[Tensor, ...], List[Tensor]], has_biases: bool, num_layers: _int, dropout: _float, train: bool, bidirectional: bool, batch_first: bool) -> Tuple[Tensor, Tensor, Tensor]: ...
@overload
def lstm(data: Tensor, batch_sizes: Tensor, hx: Union[Tuple[Tensor, ...], List[Tensor]], params: Union[Tuple[Tensor, ...], List[Tensor]], has_biases: bool, num_layers: _int, dropout: _float, train: bool, bidirectional: bool) -> Tuple[Tensor, Tensor, Tensor]: ...
def lstm_cell(input: Tensor, hx: Union[Tuple[Tensor, ...], List[Tensor]], w_ih: Tensor, w_hh: Tensor, b_ih: Optional[Tensor]=None, b_hh: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...
@overload
def lt(self: Tensor, other: Number, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def lt(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def lu_solve(self: Tensor, LU_data: Tensor, LU_pivots: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def masked_fill(self: Tensor, mask: Tensor, value: Number) -> Tensor: ...
@overload
def masked_fill(self: Tensor, mask: Tensor, value: Tensor) -> Tensor: ...
def masked_scatter(self: Tensor, mask: Tensor, source: Tensor) -> Tensor: ...
def masked_select(self: Tensor, mask: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def matmul(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def matrix_power(self: Tensor, n: _int) -> Tensor: ...
@overload
def matrix_rank(self: Tensor, tol: _float, symmetric: bool=False) -> Tensor: ...
@overload
def matrix_rank(self: Tensor, symmetric: bool=False) -> Tensor: ...
@overload
def max(self: Tensor, dim: _int, keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...
@overload
def max(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def max(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def max_pool1d(self: Tensor, kernel_size: Union[_int, _size], stride: Union[_int, _size]=(), padding: Union[_int, _size]=0, dilation: Union[_int, _size]=1, ceil_mode: bool=False) -> Tensor: ...
def max_pool1d_with_indices(self: Tensor, kernel_size: Union[_int, _size], stride: Union[_int, _size]=(), padding: Union[_int, _size]=0, dilation: Union[_int, _size]=1, ceil_mode: bool=False) -> Tuple[Tensor, Tensor]: ...
def max_pool2d(self: Tensor, kernel_size: Union[_int, _size], stride: Union[_int, _size]=(), padding: Union[_int, _size]=0, dilation: Union[_int, _size]=1, ceil_mode: bool=False) -> Tensor: ...
def max_pool3d(self: Tensor, kernel_size: Union[_int, _size], stride: Union[_int, _size]=(), padding: Union[_int, _size]=0, dilation: Union[_int, _size]=1, ceil_mode: bool=False) -> Tensor: ...
@overload
def mean(self: Tensor, *, dtype: _dtype, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def mean(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def mean(self: Tensor, dim: Union[_int, _size], keepdim: bool, *, dtype: _dtype, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def mean(self: Tensor, dim: Union[_int, _size], keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def mean(self: Tensor, dim: Union[_int, _size], *, dtype: _dtype, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def median(self: Tensor, dim: _int, keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...
@overload
def median(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def min(self: Tensor, dim: _int, keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...
@overload
def min(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def min(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def miopen_batch_norm(input: Tensor, weight: Tensor, bias: Optional[Tensor], running_mean: Optional[Tensor], running_var: Optional[Tensor], training: bool, exponential_average_factor: _float, epsilon: _float) -> Tuple[Tensor, Tensor, Tensor]: ...
def miopen_convolution(self: Tensor, weight: Tensor, bias: Optional[Tensor], padding: _size, stride: _size, dilation: _size, groups: _int, benchmark: bool, deterministic: bool) -> Tensor: ...
def miopen_convolution_transpose(self: Tensor, weight: Tensor, bias: Optional[Tensor], padding: _size, output_padding: _size, stride: _size, dilation: _size, groups: _int, benchmark: bool, deterministic: bool) -> Tensor: ...
def miopen_depthwise_convolution(self: Tensor, weight: Tensor, bias: Optional[Tensor], padding: _size, stride: _size, dilation: _size, groups: _int, benchmark: bool, deterministic: bool) -> Tensor: ...
def mkldnn_convolution(self: Tensor, weight: Tensor, bias: Optional[Tensor], padding: _size, stride: _size, dilation: _size, groups: _int) -> Tensor: ...
def mkldnn_convolution_backward_weights(weight_size: _size, grad_output: Tensor, self: Tensor, padding: _size, stride: _size, dilation: _size, groups: _int, bias_defined: bool) -> Tuple[Tensor, Tensor]: ...
def mkldnn_max_pool2d(self: Tensor, kernel_size: Union[_int, _size], stride: Union[_int, _size]=(), padding: Union[_int, _size]=0, dilation: Union[_int, _size]=1, ceil_mode: bool=False) -> Tensor: ...
def mkldnn_reshape(self: Tensor, shape: _size) -> Tensor: ...
def mm(self: Tensor, mat2: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def mode(self: Tensor, dim: _int=-1, keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...
@overload
def mul(input: Union[Tensor, Number], other: Union[Tensor, Number], *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def mul(input: Union[Tensor, Number], value: Number, other: Union[Tensor, Number], *, out: Optional[Tensor]=None) -> Tensor: ...
def multinomial(self: Tensor, num_samples: _int, replacement: bool=False, *, generator: Generator=None, out: Optional[Tensor]=None) -> Tensor: ...
def mv(self: Tensor, vec: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def mvlgamma(self: Tensor, p: _int) -> Tensor: ...
def narrow(self: Tensor, dim: _int, start: _int, length: _int) -> Tensor: ...
def native_batch_norm(input: Tensor, weight: Optional[Tensor], bias: Optional[Tensor], running_mean: Optional[Tensor], running_var: Optional[Tensor], training: bool, momentum: _float, eps: _float) -> Tuple[Tensor, Tensor, Tensor]: ...
def native_norm(self: Tensor, p: Number=2) -> Tensor: ...
@overload
def ne(self: Tensor, other: Number, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def ne(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def neg(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def neg_(self: Tensor) -> Tensor: ...
def nonzero(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def norm_except_dim(v: Tensor, pow: _int=2, dim: _int=0) -> Tensor: ...
@overload
def normal(mean: Tensor, std: _float=1, *, generator: Generator=None, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def normal(mean: _float, std: Tensor, *, generator: Generator=None, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def normal(mean: Tensor, std: Tensor, *, generator: Generator=None, out: Optional[Tensor]=None) -> Tensor: ...
def nuclear_norm(self: Tensor, keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tensor: ...
def numel(self: Tensor) -> _int: ...
@overload
def ones(size: _size, *, out: Optional[Tensor]=None, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def ones(*size: _int, out: Optional[Tensor]=None, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def ones_like(self: Tensor) -> Tensor: ...
@overload
def ones_like(self: Tensor, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
def orgqr(self: Tensor, input2: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def ormqr(self: Tensor, input2: Tensor, input3: Tensor, left: bool=True, transpose: bool=False, *, out: Optional[Tensor]=None) -> Tensor: ...
def pairwise_distance(x1: Tensor, x2: Tensor, p: _float=2, eps: _float=1e-06, keepdim: bool=False) -> Tensor: ...
def pdist(self: Tensor, p: _float=2) -> Tensor: ...
def pin_memory(self: Tensor) -> Tensor: ...
def pinverse(self: Tensor, rcond: _float=1e-15) -> Tensor: ...
def pixel_shuffle(self: Tensor, upscale_factor: _int) -> Tensor: ...
def poisson(self: Tensor, generator: Generator=None) -> Tensor: ...
def polygamma(n: _int, self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def pow(self: Tensor, exponent: Number, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def pow(self: Tensor, exponent: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def pow(self: Number, exponent: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def prelu(self: Tensor, weight: Tensor) -> Tensor: ...
@overload
def prod(self: Tensor, *, dtype: _dtype, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def prod(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def prod(self: Tensor, dim: _int, keepdim: bool, *, dtype: _dtype, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def prod(self: Tensor, dim: _int, keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def prod(self: Tensor, dim: _int, *, dtype: _dtype, out: Optional[Tensor]=None) -> Tensor: ...
def pstrf(self: Tensor, upper: bool=True, tol: Number=-1, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...
def q_scale(self: Tensor) -> Number: ...
def q_zero_point(self: Tensor) -> Number: ...
def qr(self: Tensor, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...
def quantize_linear(self: Tensor, scale: _float, zero_point: _int) -> Tensor: ...
def quantized_gru_cell(input: Tensor, hx: Tensor, w_ih: Tensor, w_hh: Tensor, b_ih: Tensor, b_hh: Tensor, packed_ih: Tensor, packed_hh: Tensor, col_offsets_ih: Tensor, col_offsets_hh: Tensor, scale_ih: Number, scale_hh: Number, zero_point_ih: Number, zero_point_hh: Number) -> Tensor: ...
def quantized_lstm(input: Tensor, hx: Union[Tuple[Tensor, ...], List[Tensor]], params: Union[Tuple[Tensor, ...], List[Tensor]], has_biases: bool, num_layers: _int, dropout: _float, train: bool, bidirectional: bool, batch_first: bool) -> Tuple[Tensor, Tensor, Tensor]: ...
def quantized_lstm_cell(input: Tensor, hx: Union[Tuple[Tensor, ...], List[Tensor]], w_ih: Tensor, w_hh: Tensor, b_ih: Tensor, b_hh: Tensor, packed_ih: Tensor, packed_hh: Tensor, col_offsets_ih: Tensor, col_offsets_hh: Tensor, scale_ih: Number, scale_hh: Number, zero_point_ih: Number, zero_point_hh: Number) -> Tuple[Tensor, Tensor]: ...
def quantized_rnn_relu_cell(input: Tensor, hx: Tensor, w_ih: Tensor, w_hh: Tensor, b_ih: Tensor, b_hh: Tensor, packed_ih: Tensor, packed_hh: Tensor, col_offsets_ih: Tensor, col_offsets_hh: Tensor, scale_ih: Number, scale_hh: Number, zero_point_ih: Number, zero_point_hh: Number) -> Tensor: ...
def quantized_rnn_tanh_cell(input: Tensor, hx: Tensor, w_ih: Tensor, w_hh: Tensor, b_ih: Tensor, b_hh: Tensor, packed_ih: Tensor, packed_hh: Tensor, col_offsets_ih: Tensor, col_offsets_hh: Tensor, scale_ih: Number, scale_hh: Number, zero_point_ih: Number, zero_point_hh: Number) -> Tensor: ...
@overload
def rand(size: _size, *, out: Optional[Tensor]=None, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def rand(*size: _int, out: Optional[Tensor]=None, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def rand(size: _size, *, generator: Generator, out: Optional[Tensor]=None, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def rand(*size: _int, generator: Generator, out: Optional[Tensor]=None, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def rand_like(self: Tensor) -> Tensor: ...
@overload
def rand_like(self: Tensor, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def randint(low: _int, high: _int, size: _size, *, dtype: Optional[_dtype]=None, device: Union[_device, str, None]=None, requires_grad: bool=False) -> Tensor: ...
@overload
def randint(high: _int, size: _size, *, dtype: Optional[_dtype]=None, device: Union[_device, str, None]=None, requires_grad: bool=False) -> Tensor: ...
@overload
def randint_like(self: Tensor, high: _int) -> Tensor: ...
@overload
def randint_like(self: Tensor, low: _int, high: _int) -> Tensor: ...
@overload
def randint_like(self: Tensor, high: _int, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def randint_like(self: Tensor, low: _int, high: _int, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def randn(size: _size, *, out: Optional[Tensor]=None, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def randn(*size: _int, out: Optional[Tensor]=None, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def randn(size: _size, *, generator: Generator, out: Optional[Tensor]=None, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def randn(*size: _int, generator: Generator, out: Optional[Tensor]=None, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def randn_like(self: Tensor) -> Tensor: ...
@overload
def randn_like(self: Tensor, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def randperm(n: _int, *, out: Optional[Tensor]=None, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def randperm(n: _int, *, generator: Generator, out: Optional[Tensor]=None, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
def range(start: Number, end: Number, step: Number=1, *, out: Optional[Tensor]=None, dtype: Optional[_dtype]=None, device: Union[_device, str, None]=None, requires_grad: bool=False) -> Tensor: ...
def reciprocal(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def reciprocal_(self: Tensor) -> Tensor: ...
def relu(self: Tensor) -> Tensor: ...
def relu_(self: Tensor) -> Tensor: ...
@overload
def remainder(self: Tensor, other: Number, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def remainder(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def renorm(self: Tensor, p: Number, dim: _int, maxnorm: Number, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def repeat_interleave(repeats: Tensor) -> Tensor: ...
@overload
def repeat_interleave(self: Tensor, repeats: Tensor, dim: Optional[_int]=None) -> Tensor: ...
@overload
def repeat_interleave(self: Tensor, repeats: _int, dim: Optional[_int]=None) -> Tensor: ...
def reshape(self: Tensor, shape: _size) -> Tensor: ...
def resize_as_(self: Tensor, the_template: Tensor) -> Tensor: ...
def rfft(self: Tensor, signal_ndim: _int, normalized: bool=False, onesided: bool=True) -> Tensor: ...
@overload
def rnn_relu(input: Tensor, hx: Tensor, params: Union[Tuple[Tensor, ...], List[Tensor]], has_biases: bool, num_layers: _int, dropout: _float, train: bool, bidirectional: bool, batch_first: bool) -> Tuple[Tensor, Tensor]: ...
@overload
def rnn_relu(data: Tensor, batch_sizes: Tensor, hx: Tensor, params: Union[Tuple[Tensor, ...], List[Tensor]], has_biases: bool, num_layers: _int, dropout: _float, train: bool, bidirectional: bool) -> Tuple[Tensor, Tensor]: ...
def rnn_relu_cell(input: Tensor, hx: Tensor, w_ih: Tensor, w_hh: Tensor, b_ih: Optional[Tensor]=None, b_hh: Optional[Tensor]=None) -> Tensor: ...
@overload
def rnn_tanh(input: Tensor, hx: Tensor, params: Union[Tuple[Tensor, ...], List[Tensor]], has_biases: bool, num_layers: _int, dropout: _float, train: bool, bidirectional: bool, batch_first: bool) -> Tuple[Tensor, Tensor]: ...
@overload
def rnn_tanh(data: Tensor, batch_sizes: Tensor, hx: Tensor, params: Union[Tuple[Tensor, ...], List[Tensor]], has_biases: bool, num_layers: _int, dropout: _float, train: bool, bidirectional: bool) -> Tuple[Tensor, Tensor]: ...
def rnn_tanh_cell(input: Tensor, hx: Tensor, w_ih: Tensor, w_hh: Tensor, b_ih: Optional[Tensor]=None, b_hh: Optional[Tensor]=None) -> Tensor: ...
def roll(self: Tensor, shifts: Union[_int, _size], dims: Union[_int, _size]=()) -> Tensor: ...
def rot90(self: Tensor, k: _int=1, dims: _size=(0,1)) -> Tensor: ...
def round(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def round_(self: Tensor) -> Tensor: ...
def rrelu(self: Tensor, lower: Number=0.125, upper: Number=0.3333333333333333, training: bool=False, generator: Generator=None) -> Tensor: ...
def rrelu_(self: Tensor, lower: Number=0.125, upper: Number=0.3333333333333333, training: bool=False, generator: Generator=None) -> Tensor: ...
def rsqrt(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def rsqrt_(self: Tensor) -> Tensor: ...
@overload
def rsub(self: Tensor, other: Tensor, *, alpha: Number=1) -> Tensor: ...
@overload
def rsub(self: Tensor, other: Number, alpha: Number=1) -> Tensor: ...
def s_copy_(self: Tensor, src: Tensor, non_blocking: bool=False) -> Tensor: ...
def s_native_addmm(self: Tensor, mat1: Tensor, mat2: Tensor, *, beta: Number=1, alpha: Number=1, out: Optional[Tensor]=None) -> Tensor: ...
def s_native_addmm_(self: Tensor, mat1: Tensor, mat2: Tensor, *, beta: Number=1, alpha: Number=1) -> Tensor: ...
def scalar_tensor(s: Number, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def scatter(self: Tensor, dim: _int, index: Tensor, src: Tensor) -> Tensor: ...
@overload
def scatter(self: Tensor, dim: _int, index: Tensor, value: Number) -> Tensor: ...
def scatter_add(self: Tensor, dim: _int, index: Tensor, src: Tensor) -> Tensor: ...
def select(self: Tensor, dim: _int, index: _int) -> Tensor: ...
def selu(self: Tensor) -> Tensor: ...
def selu_(self: Tensor) -> Tensor: ...
def set_flush_denormal(mode: bool) -> bool: ...
def set_num_threads(num: _int) -> None: ...
def sigmoid(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def sigmoid_(self: Tensor) -> Tensor: ...
def sign(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def sin(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def sin_(self: Tensor) -> Tensor: ...
def sinh(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def sinh_(self: Tensor) -> Tensor: ...
def slogdet(self: Tensor) -> Tuple[Tensor, Tensor]: ...
def smm(self: Tensor, mat2: Tensor) -> Tensor: ...
@overload
def softmax(self: Tensor, dim: _int, dtype: _dtype) -> Tensor: ...
@overload
def softmax(self: Tensor, dim: _int) -> Tensor: ...
def solve(self: Tensor, A: Tensor, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...
def sort(self: Tensor, dim: _int=-1, descending: bool=False, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...
def sparse_coo_tensor(indices: Tensor, values: Union[Tensor,List], size: Optional[_size]=None, *, dtype: Optional[_dtype]=None, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
def split_with_sizes(self: Tensor, split_sizes: _size, dim: _int=0) -> Union[Tuple[Tensor, ...], List[Tensor]]: ...
def sqrt(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def sqrt_(self: Tensor) -> Tensor: ...
@overload
def squeeze(self: Tensor) -> Tensor: ...
@overload
def squeeze(self: Tensor, dim: _int) -> Tensor: ...
@overload
def sspaddmm(self: Tensor, mat1: Tensor, mat2: Tensor, *, beta: Number=1, alpha: Number=1, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def sspaddmm(beta: Number, self: Tensor, alpha: Number, mat1: Tensor, mat2: Tensor) -> Tensor: ...
@overload
def sspaddmm(beta: Number, self: Tensor, mat1: Tensor, mat2: Tensor) -> Tensor: ...
def stack(tensors: Union[Tuple[Tensor, ...], List[Tensor]], dim: _int=0, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def std(self: Tensor, unbiased: bool=True, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def std(self: Tensor, dim: Union[_int, _size], unbiased: bool=True, keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def sub(input: Union[Tensor, Number], other: Union[Tensor, Number], *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def sub(input: Union[Tensor, Number], value: Number, other: Union[Tensor, Number], *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def sub(self: Tensor, alpha: Number, other: Tensor) -> Tensor: ...
@overload
def sub(self: Tensor, alpha: Number, other: Tensor, *, out: Tensor) -> Tensor: ...
@overload
def sum(self: Tensor, *, dtype: _dtype, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def sum(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def sum(self: Tensor, dim: Union[_int, _size], keepdim: bool, *, dtype: _dtype, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def sum(self: Tensor, dim: Union[_int, _size], keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def sum(self: Tensor, dim: Union[_int, _size], *, dtype: _dtype, out: Optional[Tensor]=None) -> Tensor: ...
def svd(self: Tensor, some: bool=True, compute_uv: bool=True, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor, Tensor]: ...
def symeig(self: Tensor, eigenvectors: bool=False, upper: bool=True, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...
def t(self: Tensor) -> Tensor: ...
def take(self: Tensor, index: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def tan(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def tan_(self: Tensor) -> Tensor: ...
def tanh(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def tanh_(self: Tensor) -> Tensor: ...
def tensor(data: Any, dtype: Optional[_dtype]=None, device: Union[_device, str, None]=None, requires_grad: bool=False) -> Tensor: ...
def threshold(self: Tensor, threshold: Number, value: Number, *, out: Optional[Tensor]=None) -> Tensor: ...
def threshold_(self: Tensor, threshold: Number, value: Number) -> Tensor: ...
def topk(self: Tensor, k: _int, dim: _int=-1, largest: bool=True, sorted: bool=True, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...
def trace(self: Tensor) -> Tensor: ...
def transpose(self: Tensor, dim0: _int, dim1: _int) -> Tensor: ...
def triangular_solve(self: Tensor, A: Tensor, upper: bool=True, transpose: bool=False, unitriangular: bool=False, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...
def tril(self: Tensor, diagonal: _int=0, *, out: Optional[Tensor]=None) -> Tensor: ...
def tril_indices(row: _int, col: _int, offset: _int=0, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
def triu(self: Tensor, diagonal: _int=0, *, out: Optional[Tensor]=None) -> Tensor: ...
def triu_indices(row: _int, col: _int, offset: _int=0, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
def trunc(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...
def trunc_(self: Tensor) -> Tensor: ...
def unbind(self: Tensor, dim: _int=0) -> Union[Tuple[Tensor, ...], List[Tensor]]: ...
def unique_dim(self: Tensor, dim: _int, sorted: bool=True, return_inverse: bool=False, return_counts: bool=False) -> Tuple[Tensor, Tensor, Tensor]: ...
def unsqueeze(self: Tensor, dim: _int) -> Tensor: ...
@overload
def var(self: Tensor, unbiased: bool=True, *, out: Optional[Tensor]=None) -> Tensor: ...
@overload
def var(self: Tensor, dim: Union[_int, _size], unbiased: bool=True, keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tensor: ...
def where(condition: Tensor, self: Tensor, other: Tensor) -> Tensor: ...
def zero_(self: Tensor) -> Tensor: ...
@overload
def zeros(size: _size, *, out: Optional[Tensor]=None, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def zeros(*size: _int, out: Optional[Tensor]=None, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...
@overload
def zeros_like(self: Tensor) -> Tensor: ...
@overload
def zeros_like(self: Tensor, *, dtype: _dtype=None, layout: layout=strided, device: Union[_device, str, None]=None, requires_grad:bool=False) -> Tensor: ...

class DoubleStorage(Storage): ...
class FloatStorage(Storage): ...
class LongStorage(Storage): ...
class IntStorage(Storage): ...
class ShortStorage(Storage): ...
class CharStorage(Storage): ...
class ByteStorage(Storage): ...
class DoubleTensor(Tensor): ...
class FloatTensor(Tensor): ...
class LongTensor(Tensor): ...
class IntTensor(Tensor): ...
class ShortTensor(Tensor): ...
class CharTensor(Tensor): ...
class ByteTensor(Tensor): ...

float32: dtype = ...
float: dtype = ...
float64: dtype = ...
double: dtype = ...
float16: dtype = ...
half: dtype = ...
uint8: dtype = ...
int8: dtype = ...
int16: dtype = ...
short: dtype = ...
int32: dtype = ...
int: dtype = ...
int64: dtype = ...
long: dtype = ...
complex32: dtype = ...
complex64: dtype = ...
complex128: dtype = ...

# Pure Python functions defined in torch/__init__.py

def typename(obj) -> str: ...
def is_tensor(obj) -> bool: ...
def is_storage(obj) -> bool: ...
def set_default_tensor_type(type) -> None: ...  # ick, what a bad legacy API
def set_default_dtype(d : _dtype) -> None: ...
def manager_path() -> str: ...
def compiled_with_cxx11_abi() -> bool: ...
