/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.impl.AbstractProjectTask;
import com.intellij.task.impl.ModuleBuildTaskImpl;
import com.intellij.task.impl.ModuleFilesBuildTaskImpl;
import com.intellij.task.impl.ProjectModelBuildTaskImpl;
import com.intellij.task.impl.ProjectTaskList;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectTaskManagerImpl
extends ProjectTaskManager {
    private final ProjectTaskRunner myDummyTaskRunner;

    public ProjectTaskManagerImpl(@NotNull Project project) {
        if (project == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(0);
        }
        super(project);
        this.myDummyTaskRunner = new DummyTaskRunner();
    }

    public void build(@NotNull Module[] modules, @Nullable ProjectTaskNotification callback2) {
        if (modules == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(1);
        }
        this.run(this.createModulesBuildTask(modules, true, true, false), callback2);
    }

    public void rebuild(@NotNull Module[] modules, @Nullable ProjectTaskNotification callback2) {
        if (modules == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(2);
        }
        this.run(this.createModulesBuildTask(modules, false, false, false), callback2);
    }

    public void compile(@NotNull VirtualFile[] files2, @Nullable ProjectTaskNotification callback2) {
        if (files2 == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(3);
        }
        List buildTasks = Arrays.stream(files2).collect(Collectors.groupingBy(file2 -> ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).getModuleForFile(file2, false))).entrySet().stream().map(entry -> new ModuleFilesBuildTaskImpl((Module)entry.getKey(), false, (Collection)entry.getValue())).collect(Collectors.toList());
        this.run(new ProjectTaskList(buildTasks), callback2);
    }

    public void build(@NotNull ProjectModelBuildableElement[] buildableElements, @Nullable ProjectTaskNotification callback2) {
        if (buildableElements == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(4);
        }
        this.doBuild(buildableElements, callback2, true);
    }

    public void rebuild(@NotNull ProjectModelBuildableElement[] buildableElements, @Nullable ProjectTaskNotification callback2) {
        if (buildableElements == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(5);
        }
        this.doBuild(buildableElements, callback2, false);
    }

    public void buildAllModules(@Nullable ProjectTaskNotification callback2) {
        this.run(this.createAllModulesBuildTask(true, this.myProject), callback2);
    }

    public void rebuildAllModules(@Nullable ProjectTaskNotification callback2) {
        this.run(this.createAllModulesBuildTask(false, this.myProject), callback2);
    }

    public ProjectTask createAllModulesBuildTask(boolean isIncrementalBuild, Project project) {
        return this.createModulesBuildTask(ModuleManager.getInstance((Project)project).getModules(), isIncrementalBuild, false, false);
    }

    public ProjectTask createModulesBuildTask(Module module, boolean isIncrementalBuild, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        return this.createModulesBuildTask((Module[])ContainerUtil.ar((Object[])new Module[]{module}), isIncrementalBuild, includeDependentModules, includeRuntimeDependencies);
    }

    public ProjectTask createModulesBuildTask(Module[] modules, boolean isIncrementalBuild, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        return modules.length == 1 ? new ModuleBuildTaskImpl(modules[0], isIncrementalBuild, includeDependentModules, includeRuntimeDependencies) : new ProjectTaskList(ContainerUtil.map((Collection)ContainerUtil.list((Object[])modules), module -> new ModuleBuildTaskImpl((Module)module, isIncrementalBuild, includeDependentModules, includeRuntimeDependencies)));
    }

    public ProjectTask createBuildTask(boolean isIncrementalBuild, ProjectModelBuildableElement ... buildableElements) {
        return buildableElements.length == 1 ? new ProjectModelBuildTaskImpl<ProjectModelBuildableElement>(buildableElements[0], isIncrementalBuild) : new ProjectTaskList(ContainerUtil.map((Collection)ContainerUtil.list((Object[])buildableElements), buildableElement -> new ProjectModelBuildTaskImpl<ProjectModelBuildableElement>((ProjectModelBuildableElement)buildableElement, isIncrementalBuild)));
    }

    public void run(@NotNull ProjectTask projectTask, @Nullable ProjectTaskNotification callback2) {
        if (projectTask == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(6);
        }
        this.run(new ProjectTaskContext(), projectTask, callback2);
    }

    public void run(@NotNull ProjectTaskContext context, @NotNull ProjectTask projectTask, final @Nullable ProjectTaskNotification callback2) {
        if (context == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(7);
        }
        if (projectTask == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(8);
        }
        SmartList toRun = new SmartList();
        Consumer taskClassifier = arg_0 -> this.lambda$run$6((List)toRun, arg_0);
        ProjectTaskManagerImpl.visitTasks((Collection<? extends ProjectTask>)(projectTask instanceof ProjectTaskList ? (ProjectTaskList)projectTask : Collections.singleton(projectTask)), (Consumer<? super Collection<? extends ProjectTask>>)taskClassifier);
        if (toRun.isEmpty()) {
            ProjectTaskManagerImpl.sendSuccessNotify(callback2);
            return;
        }
        final AtomicInteger inProgressCounter = new AtomicInteger(toRun.size());
        final AtomicInteger errorsCounter = new AtomicInteger();
        final AtomicInteger warningsCounter = new AtomicInteger();
        final AtomicBoolean abortedFlag = new AtomicBoolean(false);
        ProjectTaskNotification chunkStatusNotification = callback2 == null ? null : new ProjectTaskNotification(){

            public void finished(@NotNull ProjectTaskResult executionResult) {
                if (executionResult == null) {
                    1.$$$reportNull$$$0(0);
                }
                int inProgress = inProgressCounter.decrementAndGet();
                int allErrors = errorsCounter.addAndGet(executionResult.getErrors());
                int allWarnings = warningsCounter.addAndGet(executionResult.getWarnings());
                if (executionResult.isAborted()) {
                    abortedFlag.set(true);
                }
                if (inProgress == 0) {
                    callback2.finished(new ProjectTaskResult(abortedFlag.get(), allErrors, allWarnings));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionResult", "com/intellij/task/impl/ProjectTaskManagerImpl$1", "finished"));
            }
        };
        toRun.forEach(pair -> {
            if (((Collection)pair.second).isEmpty()) {
                ProjectTaskManagerImpl.sendSuccessNotify(chunkStatusNotification);
            } else {
                ((ProjectTaskRunner)pair.first).run(this.myProject, context, chunkStatusNotification, (Collection)pair.second);
            }
        });
    }

    private static void sendSuccessNotify(@Nullable ProjectTaskNotification notification) {
        if (notification != null) {
            notification.finished(new ProjectTaskResult(false, 0, 0));
        }
    }

    private static void visitTasks(@NotNull Collection<? extends ProjectTask> tasks, @NotNull Consumer<? super Collection<? extends ProjectTask>> consumer) {
        if (tasks == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(9);
        }
        if (consumer == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(10);
        }
        for (ProjectTask projectTask : tasks) {
            Collection<ProjectTask> taskDependencies = projectTask instanceof AbstractProjectTask ? ((AbstractProjectTask)projectTask).getDependsOn() : (projectTask instanceof ProjectTaskList ? (ProjectTaskList)projectTask : Collections.singleton(projectTask));
            ProjectTaskManagerImpl.visitTasks(taskDependencies, consumer);
        }
        consumer.consume(tasks);
    }

    @NotNull
    private static ProjectTaskRunner[] getTaskRunners() {
        ProjectTaskRunner[] projectTaskRunnerArray = (ProjectTaskRunner[])ProjectTaskRunner.EP_NAME.getExtensions();
        if (projectTaskRunnerArray == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(11);
        }
        return projectTaskRunnerArray;
    }

    private void doBuild(@NotNull ProjectModelBuildableElement[] buildableElements, @Nullable ProjectTaskNotification callback2, boolean isIncrementalBuild) {
        if (buildableElements == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(12);
        }
        this.run(this.createBuildTask(isIncrementalBuild, buildableElements), callback2);
    }

    private /* synthetic */ void lambda$run$6(List toRun, Collection tasks) {
        Map<ProjectTaskRunner, List<ProjectTask>> toBuild = tasks.stream().collect(Collectors.groupingBy(aTask -> Arrays.stream(ProjectTaskManagerImpl.getTaskRunners()).filter(runner -> runner.canRun(this.myProject, aTask)).findFirst().orElse(this.myDummyTaskRunner)));
        for (Map.Entry<ProjectTaskRunner, List<ProjectTask>> entry : toBuild.entrySet()) {
            toRun.add(Pair.create((Object)entry.getKey(), entry.getValue()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildableElements";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTask";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/task/impl/ProjectTaskManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/task/impl/ProjectTaskManagerImpl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskRunners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "rebuild";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitTasks";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doBuild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DummyTaskRunner
    extends ProjectTaskRunner {
        private DummyTaskRunner() {
        }

        public void run(@NotNull Project project, @NotNull ProjectTaskContext context, @Nullable ProjectTaskNotification callback2, @NotNull Collection<? extends ProjectTask> tasks) {
            if (project == null) {
                DummyTaskRunner.$$$reportNull$$$0(0);
            }
            if (context == null) {
                DummyTaskRunner.$$$reportNull$$$0(1);
            }
            if (tasks == null) {
                DummyTaskRunner.$$$reportNull$$$0(2);
            }
        }

        public boolean canRun(@NotNull ProjectTask projectTask) {
            if (projectTask == null) {
                DummyTaskRunner.$$$reportNull$$$0(3);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tasks";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectTask";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/task/impl/ProjectTaskManagerImpl$DummyTaskRunner";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canRun";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

