/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.BlockInlayImpl;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlayModelImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.RangeMarkerWithGetterImpl;
import com.intellij.openapi.util.Key;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class InlayImpl<R extends EditorCustomElementRenderer, T extends InlayImpl>
extends RangeMarkerWithGetterImpl
implements Inlay<R> {
    static final Key<Integer> OFFSET_BEFORE_DISPOSAL = Key.create((String)"inlay.offset.before.disposal");
    private static final Key<Integer> ORDER_BEFORE_DISPOSAL = Key.create((String)"inlay.order.before.disposal");
    @NotNull
    final EditorImpl myEditor;
    @NotNull
    final R myRenderer;
    private final boolean myRelatedToPrecedingText;
    int myWidthInPixels;

    InlayImpl(@NotNull EditorImpl editor, int offset, boolean relatesToPrecedingText, @NotNull R renderer) {
        if (editor == null) {
            InlayImpl.$$$reportNull$$$0(0);
        }
        if (renderer == null) {
            InlayImpl.$$$reportNull$$$0(1);
        }
        super(editor.getDocument(), offset, offset, false);
        this.myEditor = editor;
        this.myRelatedToPrecedingText = relatesToPrecedingText;
        this.myRenderer = renderer;
        this.doUpdateSize();
        this.getTree().addInterval(this, offset, offset, false, false, relatesToPrecedingText, 0);
    }

    abstract RangeMarkerTree<T> getTree();

    @NotNull
    public Editor getEditor() {
        EditorImpl editorImpl = this.myEditor;
        if (editorImpl == null) {
            InlayImpl.$$$reportNull$$$0(2);
        }
        return editorImpl;
    }

    public void updateSize() {
        int oldWidth = this.getWidthInPixels();
        int oldHeight = this.getHeightInPixels();
        this.doUpdateSize();
        if (oldWidth != this.getWidthInPixels() || oldHeight != this.getHeightInPixels()) {
            this.myEditor.getInlayModel().notifyChanged(this);
        } else {
            this.repaint();
        }
    }

    public void repaint() {
        Rectangle bounds2;
        EditorComponentImpl contentComponent;
        if (this.isValid() && !this.myEditor.isDisposed() && !this.myEditor.getDocument().isInBulkUpdate() && (contentComponent = this.myEditor.getContentComponent()).isShowing() && (bounds2 = this.getBounds()) != null) {
            if (this instanceof BlockInlayImpl) {
                bounds2.width = contentComponent.getWidth();
            }
            contentComponent.repaint(bounds2);
        }
    }

    abstract void doUpdateSize();

    @Override
    public void dispose() {
        if (this.isValid()) {
            int offset = this.getOffset();
            InlayModelImpl inlayModel = this.myEditor.getInlayModel();
            List<Inlay> inlays = inlayModel.getInlineElementsInRange(offset, offset);
            this.putUserData(ORDER_BEFORE_DISPOSAL, inlays.indexOf(this));
            this.putUserData(OFFSET_BEFORE_DISPOSAL, offset);
            this.getTree().removeInterval(this);
            inlayModel.notifyRemoved(this);
        }
    }

    public int getOffset() {
        Integer offsetBeforeDisposal = (Integer)this.getUserData(OFFSET_BEFORE_DISPOSAL);
        return offsetBeforeDisposal == null ? this.getStartOffset() : offsetBeforeDisposal.intValue();
    }

    public boolean isRelatedToPrecedingText() {
        return this.myRelatedToPrecedingText;
    }

    abstract Point getPosition();

    @Nullable
    public Rectangle getBounds() {
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(this.getOffset())) {
            return null;
        }
        Point pos = this.getPosition();
        return new Rectangle(pos.x, pos.y, this.getWidthInPixels(), this.getHeightInPixels());
    }

    @NotNull
    public R getRenderer() {
        R r = this.myRenderer;
        if (r == null) {
            InlayImpl.$$$reportNull$$$0(3);
        }
        return r;
    }

    public int getWidthInPixels() {
        return this.myWidthInPixels;
    }

    int getOrder() {
        Integer value = (Integer)this.getUserData(ORDER_BEFORE_DISPOSAL);
        return value == null ? -1 : value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/InlayImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/InlayImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

