/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SelectionBasedPsiElementInternalAction<T extends PsiElement>
extends AnAction {
    @NotNull
    protected final Class<T> myClass;
    @NotNull
    protected final Class<? extends PsiFile> myFileClass;

    protected SelectionBasedPsiElementInternalAction(@NotNull Class<T> aClass, @NotNull Class<? extends PsiFile> fileClass) {
        if (aClass == null) {
            SelectionBasedPsiElementInternalAction.$$$reportNull$$$0(0);
        }
        if (fileClass == null) {
            SelectionBasedPsiElementInternalAction.$$$reportNull$$$0(1);
        }
        this.myClass = aClass;
        this.myFileClass = fileClass;
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SelectionBasedPsiElementInternalAction.$$$reportNull$$$0(2);
        }
        final Editor editor = SelectionBasedPsiElementInternalAction.getEditor(e);
        PsiFile file2 = SelectionBasedPsiElementInternalAction.getPsiFile(e);
        if (editor == null || file2 == null) {
            return;
        }
        List<T> expressions = this.getElement(editor, file2);
        PsiElement first = (PsiElement)ContainerUtil.getFirstItem(expressions);
        if (expressions.size() > 1) {
            IntroduceTargetChooser.showChooser(editor, expressions, new Pass<T>(){

                public void pass(@NotNull T expression) {
                    if (expression == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    SelectionBasedPsiElementInternalAction.this.performOnElement(editor, expression);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/internal/SelectionBasedPsiElementInternalAction$1", "pass"));
                }
            }, expression -> expression.getText());
        } else if (expressions.size() == 1 && first != null) {
            this.performOnElement(editor, first);
        } else if (expressions.isEmpty()) {
            this.showError(editor);
        }
    }

    protected void showError(@NotNull Editor editor) {
        if (editor == null) {
            SelectionBasedPsiElementInternalAction.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            String errorHint = "Cannot find element of class " + this.myClass.getSimpleName() + " at selection/offset";
            HintManager.getInstance().showErrorHint(editor, errorHint);
        });
    }

    private void performOnElement(@NotNull Editor editor, @NotNull T first) {
        if (editor == null) {
            SelectionBasedPsiElementInternalAction.$$$reportNull$$$0(4);
        }
        if (first == null) {
            SelectionBasedPsiElementInternalAction.$$$reportNull$$$0(5);
        }
        TextRange textRange = first.getTextRange();
        editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
        String informationHint = this.getInformationHint(first);
        if (informationHint != null) {
            ApplicationManager.getApplication().invokeLater(() -> HintManager.getInstance().showInformationHint(editor, informationHint));
        } else {
            ApplicationManager.getApplication().invokeLater(() -> HintManager.getInstance().showErrorHint(editor, this.getErrorHint()));
        }
    }

    @Nullable
    protected abstract String getInformationHint(@NotNull T var1);

    @NotNull
    protected abstract String getErrorHint();

    @NotNull
    protected List<T> getElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        SelectionModel selectionModel;
        if (editor == null) {
            SelectionBasedPsiElementInternalAction.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            SelectionBasedPsiElementInternalAction.$$$reportNull$$$0(7);
        }
        if ((selectionModel = editor.getSelectionModel()).hasSelection()) {
            List list2 = ContainerUtil.list((Object[])new PsiElement[]{this.getElementFromSelection(file2, selectionModel)});
            if (list2 == null) {
                SelectionBasedPsiElementInternalAction.$$$reportNull$$$0(8);
            }
            return list2;
        }
        List<T> list3 = this.getElementAtOffset(editor, file2);
        if (list3 == null) {
            SelectionBasedPsiElementInternalAction.$$$reportNull$$$0(9);
        }
        return list3;
    }

    @NotNull
    protected List<T> getElementAtOffset(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            SelectionBasedPsiElementInternalAction.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            SelectionBasedPsiElementInternalAction.$$$reportNull$$$0(11);
        }
        List list2 = ContainerUtil.list((Object[])new PsiElement[]{PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)editor.getCaretModel().getOffset(), this.myClass, (boolean)false)});
        if (list2 == null) {
            SelectionBasedPsiElementInternalAction.$$$reportNull$$$0(12);
        }
        return list2;
    }

    @Nullable
    protected T getElementFromSelection(@NotNull PsiFile file2, @NotNull SelectionModel selectionModel) {
        if (file2 == null) {
            SelectionBasedPsiElementInternalAction.$$$reportNull$$$0(13);
        }
        if (selectionModel == null) {
            SelectionBasedPsiElementInternalAction.$$$reportNull$$$0(14);
        }
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        return (T)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file2, (int)selectionStart, (int)selectionEnd, this.myClass);
    }

    public final void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SelectionBasedPsiElementInternalAction.$$$reportNull$$$0(15);
        }
        Presentation presentation = e.getPresentation();
        boolean enabled = ApplicationManagerEx.getApplicationEx().isInternal() && SelectionBasedPsiElementInternalAction.getEditor(e) != null && this.myFileClass.isInstance(SelectionBasedPsiElementInternalAction.getPsiFile(e));
        presentation.setVisible(enabled);
        presentation.setEnabled(enabled);
    }

    @Nullable
    private static Editor getEditor(@NotNull AnActionEvent e) {
        if (e == null) {
            SelectionBasedPsiElementInternalAction.$$$reportNull$$$0(16);
        }
        return (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
    }

    @Nullable
    private static PsiFile getPsiFile(@NotNull AnActionEvent e) {
        if (e == null) {
            SelectionBasedPsiElementInternalAction.$$$reportNull$$$0(17);
        }
        return (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileClass";
                break;
            }
            case 2: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/SelectionBasedPsiElementInternalAction";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/SelectionBasedPsiElementInternalAction";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementAtOffset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performOnElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getElementAtOffset";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getElementFromSelection";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

