/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.impl.EmptyLookupItem;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.util.ExceptionUtil;
import java.util.Collection;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupOffsets
implements DocumentListener {
    @NotNull
    private String myAdditionalPrefix = "";
    private String myInitialPrefix;
    private boolean myStableStart;
    @Nullable
    private Supplier<String> myStartMarkerDisposeInfo = null;
    @NotNull
    private RangeMarker myLookupStartMarker;
    private int myRemovedPrefix;
    private final RangeMarker myLookupOriginalStartMarker;
    private final Editor myEditor;

    public LookupOffsets(Editor editor) {
        this.myEditor = editor;
        int caret = this.getPivotOffset();
        this.myLookupOriginalStartMarker = this.createLeftGreedyMarker(caret);
        this.myLookupStartMarker = this.createLeftGreedyMarker(caret);
        this.myEditor.getDocument().addDocumentListener((DocumentListener)this);
    }

    public void documentChanged(@NotNull DocumentEvent e) {
        if (e == null) {
            LookupOffsets.$$$reportNull$$$0(0);
        }
        if (this.myStartMarkerDisposeInfo == null && !this.myLookupStartMarker.isValid()) {
            Throwable throwable = new Throwable();
            String eString = e.toString();
            this.myStartMarkerDisposeInfo = () -> eString + "\n" + ExceptionUtil.getThrowableText((Throwable)throwable);
        }
    }

    private RangeMarker createLeftGreedyMarker(int start2) {
        RangeMarker marker = this.myEditor.getDocument().createRangeMarker(start2, start2);
        marker.setGreedyToLeft(true);
        return marker;
    }

    private int getPivotOffset() {
        return this.myEditor.getSelectionModel().hasSelection() ? this.myEditor.getSelectionModel().getSelectionStart() : this.myEditor.getCaretModel().getOffset();
    }

    @NotNull
    public String getAdditionalPrefix() {
        String string = this.myAdditionalPrefix;
        if (string == null) {
            LookupOffsets.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void appendPrefix(char c) {
        this.myAdditionalPrefix = this.myAdditionalPrefix + c;
        this.myInitialPrefix = null;
    }

    public boolean truncatePrefix() {
        int len = this.myAdditionalPrefix.length();
        if (len == 0) {
            ++this.myRemovedPrefix;
            return false;
        }
        this.myAdditionalPrefix = this.myAdditionalPrefix.substring(0, len - 1);
        this.myInitialPrefix = null;
        return true;
    }

    void destabilizeLookupStart() {
        this.myStableStart = false;
    }

    void checkMinPrefixLengthChanges(Collection<LookupElement> items, LookupImpl lookup) {
        if (this.myStableStart) {
            return;
        }
        if (!lookup.isCalculating() && !items.isEmpty()) {
            this.myStableStart = true;
        }
        int minPrefixLength = items.isEmpty() ? 0 : Integer.MAX_VALUE;
        for (LookupElement item : items) {
            if (item instanceof EmptyLookupItem) continue;
            minPrefixLength = Math.min(lookup.itemMatcher(item).getPrefix().length(), minPrefixLength);
        }
        int start2 = this.getPivotOffset() - minPrefixLength - this.myAdditionalPrefix.length() + this.myRemovedPrefix;
        start2 = Math.max(Math.min(start2, this.myEditor.getDocument().getTextLength()), 0);
        if (this.myLookupStartMarker.isValid() && this.myLookupStartMarker.getStartOffset() == start2 && this.myLookupStartMarker.getEndOffset() == start2) {
            return;
        }
        this.myLookupStartMarker.dispose();
        this.myLookupStartMarker = this.createLeftGreedyMarker(start2);
        this.myStartMarkerDisposeInfo = null;
    }

    int getLookupStart(@Nullable Throwable disposeTrace) {
        if (!this.myLookupStartMarker.isValid()) {
            throw new AssertionError((Object)("Invalid lookup start: " + this.myLookupStartMarker + ", " + this.myEditor + ", disposeTrace=" + (disposeTrace == null ? null : ExceptionUtil.getThrowableText((Throwable)disposeTrace)) + "\n================\n start dispose trace=" + (this.myStartMarkerDisposeInfo == null ? null : this.myStartMarkerDisposeInfo.get())));
        }
        return this.myLookupStartMarker.getStartOffset();
    }

    int getLookupOriginalStart() {
        return this.myLookupOriginalStartMarker.isValid() ? this.myLookupOriginalStartMarker.getStartOffset() : -1;
    }

    boolean performGuardedChange(Runnable change) {
        if (!this.myLookupStartMarker.isValid()) {
            throw new AssertionError((Object)("Invalid start: " + this.myEditor + ", trace=" + (this.myStartMarkerDisposeInfo == null ? null : this.myStartMarkerDisposeInfo.get())));
        }
        change.run();
        return this.myLookupStartMarker.isValid();
    }

    void clearAdditionalPrefix() {
        this.myAdditionalPrefix = "";
        this.myRemovedPrefix = 0;
    }

    void restorePrefix() {
        if (this.myInitialPrefix == null || !this.myLookupStartMarker.isValid()) {
            return;
        }
        this.myEditor.getDocument().replaceString(this.myLookupStartMarker.getStartOffset(), this.myEditor.getCaretModel().getOffset(), (CharSequence)this.myInitialPrefix);
    }

    void disposeMarkers() {
        this.myEditor.getDocument().removeDocumentListener((DocumentListener)this);
        this.myLookupStartMarker.dispose();
        this.myLookupOriginalStartMarker.dispose();
    }

    public int getPrefixLength(LookupElement item, LookupImpl lookup) {
        return lookup.itemPattern(item).length() - this.myRemovedPrefix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/impl/LookupOffsets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/impl/LookupOffsets";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

