/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.dvcs.branch.DvcsTaskHandler;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsTaskHandler;
import com.intellij.util.containers.ContainerUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitBranchesCollection;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.validators.GitRefNameValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitTaskHandler
extends DvcsTaskHandler<GitRepository> {
    @NotNull
    private final GitBrancher myBrancher;
    @NotNull
    private final GitRefNameValidator myNameValidator;

    public GitTaskHandler(@NotNull GitBrancher brancher, @NotNull GitRepositoryManager repositoryManager, @NotNull Project project) {
        if (brancher == null) {
            GitTaskHandler.$$$reportNull$$$0(0);
        }
        if (repositoryManager == null) {
            GitTaskHandler.$$$reportNull$$$0(1);
        }
        if (project == null) {
            GitTaskHandler.$$$reportNull$$$0(2);
        }
        super((AbstractRepositoryManager)repositoryManager, project, "branch");
        this.myBrancher = brancher;
        this.myNameValidator = GitRefNameValidator.getInstance();
    }

    protected void checkout(@NotNull String taskName, @NotNull List<GitRepository> repos, @Nullable Runnable callInAwtLater) {
        if (taskName == null) {
            GitTaskHandler.$$$reportNull$$$0(3);
        }
        if (repos == null) {
            GitTaskHandler.$$$reportNull$$$0(4);
        }
        this.myBrancher.checkout(taskName, false, repos, callInAwtLater);
    }

    protected void checkoutAsNewBranch(@NotNull String name, @NotNull List<GitRepository> repositories) {
        if (name == null) {
            GitTaskHandler.$$$reportNull$$$0(5);
        }
        if (repositories == null) {
            GitTaskHandler.$$$reportNull$$$0(6);
        }
        this.myBrancher.checkoutNewBranch(name, repositories);
    }

    protected String getActiveBranch(GitRepository repository) {
        return repository.getCurrentBranchName();
    }

    protected void mergeAndClose(@NotNull String branch, @NotNull List<GitRepository> repositories) {
        if (branch == null) {
            GitTaskHandler.$$$reportNull$$$0(7);
        }
        if (repositories == null) {
            GitTaskHandler.$$$reportNull$$$0(8);
        }
        this.myBrancher.merge(branch, GitBrancher.DeleteOnMergeOption.DELETE, repositories);
    }

    protected boolean hasBranch(@NotNull GitRepository repository, @NotNull VcsTaskHandler.TaskInfo info) {
        if (repository == null) {
            GitTaskHandler.$$$reportNull$$$0(9);
        }
        if (info == null) {
            GitTaskHandler.$$$reportNull$$$0(10);
        }
        GitBranchesCollection branches2 = repository.getBranches();
        return info.isRemote() ? branches2.getRemoteBranches().stream().anyMatch(branch -> info.getName().equals(branch.getName())) : branches2.findLocalBranch(info.getName()) != null;
    }

    @NotNull
    protected Iterable<VcsTaskHandler.TaskInfo> getAllBranches(@NotNull GitRepository repository) {
        if (repository == null) {
            GitTaskHandler.$$$reportNull$$$0(11);
        }
        GitBranchesCollection branches2 = repository.getBranches();
        ArrayList<VcsTaskHandler.TaskInfo> list = new ArrayList<VcsTaskHandler.TaskInfo>(ContainerUtil.map(GitBranchUtil.sortBranchesByName(branches2.getLocalBranches()), branch -> new VcsTaskHandler.TaskInfo(branch.getName(), Collections.singleton(repository.getPresentableUrl()))));
        list.addAll(ContainerUtil.map(GitBranchUtil.sortBranchesByName(branches2.getRemoteBranches()), branch -> new VcsTaskHandler.TaskInfo(branch.getName(), Collections.singleton(repository.getPresentableUrl())){

            public boolean isRemote() {
                return true;
            }
        }));
        ArrayList<VcsTaskHandler.TaskInfo> arrayList = list;
        if (arrayList == null) {
            GitTaskHandler.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    public boolean isBranchNameValid(@NotNull String branchName) {
        if (branchName == null) {
            GitTaskHandler.$$$reportNull$$$0(13);
        }
        return this.myNameValidator.checkInput(branchName);
    }

    @NotNull
    public String cleanUpBranchName(@NotNull String suggestedName) {
        if (suggestedName == null) {
            GitTaskHandler.$$$reportNull$$$0(14);
        }
        String string = this.myNameValidator.cleanUpBranchName(suggestedName);
        if (string == null) {
            GitTaskHandler.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "brancher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repos";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/GitTaskHandler";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/GitTaskHandler";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBranches";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanUpBranchName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkout";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkoutAsNewBranch";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mergeAndClose";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasBranch";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAllBranches";
                break;
            }
            case 12: 
            case 15: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isBranchNameValid";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "cleanUpBranchName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

