/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.injection.Injectable;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FileContentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.TemporaryPlacesRegistry;
import org.intellij.plugins.intelliLang.references.InjectedReferencesContributor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectLanguageAction
implements IntentionAction,
LowPriorityAction {
    @NonNls
    private static final String INJECT_LANGUAGE_FAMILY = "Inject language or reference";
    public static final String LAST_INJECTED_LANGUAGE = "LAST_INJECTED_LANGUAGE";
    public static final Key<Processor<? super PsiLanguageInjectionHost>> FIX_KEY = Key.create((String)"inject fix key");
    private static final FixPresenter DEFAULT_FIX_PRESENTER = (editor, range, pointer, text, handler) -> {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        HintManager.getInstance().showQuestionHint(editor, text, range.getStartOffset(), range.getEndOffset(), new QuestionAction(){

            public boolean execute() {
                return handler.process((Object)pointer.getElement());
            }
        });
    };

    @NotNull
    public static List<Injectable> getAllInjectables() {
        Language[] languages = InjectedLanguage.getAvailableLanguages();
        ArrayList<Injectable> list = new ArrayList<Injectable>();
        for (Language language : languages) {
            list.add(Injectable.fromLanguage((Language)language));
        }
        list.addAll(Arrays.asList(ReferenceInjector.EXTENSION_POINT_NAME.getExtensions()));
        Collections.sort(list);
        ArrayList<Injectable> arrayList = list;
        if (arrayList == null) {
            InjectLanguageAction.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    public String getText() {
        if (INJECT_LANGUAGE_FAMILY == null) {
            InjectLanguageAction.$$$reportNull$$$0(1);
        }
        return INJECT_LANGUAGE_FAMILY;
    }

    @NotNull
    public String getFamilyName() {
        if (INJECT_LANGUAGE_FAMILY == null) {
            InjectLanguageAction.$$$reportNull$$$0(2);
        }
        return INJECT_LANGUAGE_FAMILY;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        PsiLanguageInjectionHost host;
        if (project == null) {
            InjectLanguageAction.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            InjectLanguageAction.$$$reportNull$$$0(4);
        }
        if (file == null) {
            InjectLanguageAction.$$$reportNull$$$0(5);
        }
        if ((host = InjectLanguageAction.findInjectionHost(editor, file)) == null) {
            return false;
        }
        List injectedPsi = InjectedLanguageManager.getInstance((Project)project).getInjectedPsiFiles((PsiElement)host);
        if (injectedPsi == null || injectedPsi.isEmpty()) {
            return !InjectedReferencesContributor.isInjected(file.findReferenceAt(editor.getCaretModel().getOffset()));
        }
        return false;
    }

    @Nullable
    protected static PsiLanguageInjectionHost findInjectionHost(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            InjectLanguageAction.$$$reportNull$$$0(6);
        }
        if (file == null) {
            InjectLanguageAction.$$$reportNull$$$0(7);
        }
        if (editor instanceof EditorWindow) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        FileViewProvider vp = file.getViewProvider();
        for (Language language : vp.getLanguages()) {
            PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)vp.findElementAt(offset, language), PsiLanguageInjectionHost.class, (boolean)false);
            if (host == null || !host.isValidHost()) continue;
            return host;
        }
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            InjectLanguageAction.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            InjectLanguageAction.$$$reportNull$$$0(9);
        }
        if (file == null) {
            InjectLanguageAction.$$$reportNull$$$0(10);
        }
        SmartPsiElementPointer filePointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)file);
        InjectLanguageAction.doChooseLanguageToInject(editor, (Processor<? super Injectable>)((Processor)injectable -> {
            ReadAction.run(() -> {
                if (project.isDisposed()) {
                    return;
                }
                PsiFile psiFile = (PsiFile)filePointer.getElement();
                if (psiFile == null || editor.isDisposed()) {
                    return;
                }
                InjectLanguageAction.invokeImpl(project, editor, psiFile, injectable);
            });
            return false;
        }));
    }

    public static void invokeImpl(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull Injectable injectable) {
        if (project == null) {
            InjectLanguageAction.$$$reportNull$$$0(11);
        }
        if (editor == null) {
            InjectLanguageAction.$$$reportNull$$$0(12);
        }
        if (file == null) {
            InjectLanguageAction.$$$reportNull$$$0(13);
        }
        if (injectable == null) {
            InjectLanguageAction.$$$reportNull$$$0(14);
        }
        InjectLanguageAction.invokeImpl(project, editor, file, injectable, DEFAULT_FIX_PRESENTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeImpl(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull Injectable injectable, @NotNull FixPresenter fixPresenter) {
        PsiLanguageInjectionHost host;
        if (project == null) {
            InjectLanguageAction.$$$reportNull$$$0(15);
        }
        if (editor == null) {
            InjectLanguageAction.$$$reportNull$$$0(16);
        }
        if (file == null) {
            InjectLanguageAction.$$$reportNull$$$0(17);
        }
        if (injectable == null) {
            InjectLanguageAction.$$$reportNull$$$0(18);
        }
        if (fixPresenter == null) {
            InjectLanguageAction.$$$reportNull$$$0(19);
        }
        if ((host = InjectLanguageAction.findInjectionHost(editor, file)) == null) {
            return;
        }
        if (InjectLanguageAction.defaultFunctionalityWorked(host, injectable.getId())) {
            return;
        }
        try {
            host.putUserData(FIX_KEY, null);
            Language language = injectable.toLanguage();
            for (LanguageInjectionSupport support : InjectorUtils.getActiveInjectionSupports()) {
                if (!support.isApplicableTo(host) || !support.addInjectionInPlace(language, host)) continue;
                return;
            }
            if (TemporaryPlacesRegistry.getInstance(project).getLanguageInjectionSupport().addInjectionInPlace(language, host)) {
                Processor fixer = (Processor)host.getUserData(FIX_KEY);
                String text = StringUtil.escapeXml((String)language.getDisplayName()) + " was temporarily injected.";
                if (fixer != null) {
                    SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)host);
                    String fixText = text + "<br>Do you want to insert annotation? " + KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
                    fixPresenter.showFix(editor, host.getTextRange(), (SmartPsiElementPointer<PsiLanguageInjectionHost>)pointer, fixText, (Processor<PsiLanguageInjectionHost>)((Processor)host1 -> {
                        List files = InjectedLanguageManager.getInstance((Project)project).getInjectedPsiFiles((PsiElement)host1);
                        if (files != null) {
                            for (Pair pair : files) {
                                PsiFile psiFile = (PsiFile)pair.first;
                                LanguageInjectionSupport languageInjectionSupport = (LanguageInjectionSupport)psiFile.getUserData(LanguageInjectionSupport.INJECTOR_SUPPORT);
                                if (languageInjectionSupport == null) continue;
                                languageInjectionSupport.removeInjectionInPlace((PsiLanguageInjectionHost)host1);
                            }
                        } else {
                            LanguageInjectionSupport support = (LanguageInjectionSupport)host1.getUserData(LanguageInjectionSupport.INJECTOR_SUPPORT);
                            if (support != null && support.removeInjection((PsiElement)host)) {
                                host1.getManager().dropPsiCaches();
                            }
                        }
                        return fixer.process(host1);
                    }));
                } else {
                    HintManager.getInstance().showInformationHint(editor, text);
                }
            }
        }
        finally {
            if (injectable.getLanguage() != null) {
                FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
            } else {
                PsiManager.getInstance((Project)project).dropPsiCaches();
            }
        }
    }

    private static boolean defaultFunctionalityWorked(PsiLanguageInjectionHost host, String id) {
        return Configuration.getProjectInstance(host.getProject()).setHostInjectionEnabled(host, Collections.singleton(id), true);
    }

    public static boolean doChooseLanguageToInject(Editor editor, Processor<? super Injectable> onChosen) {
        ColoredListCellRenderer<Injectable> renderer = new ColoredListCellRenderer<Injectable>(){

            protected void customizeCellRenderer(@NotNull JList<? extends Injectable> list, Injectable language, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.setIcon(language.getIcon());
                this.append(language.getDisplayName());
                String description = language.getAdditionalDescription();
                if (description != null) {
                    this.append(description, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction$2", "customizeCellRenderer"));
            }
        };
        List<Injectable> injectables = InjectLanguageAction.getAllInjectables();
        String lastInjectedId = PropertiesComponent.getInstance().getValue(LAST_INJECTED_LANGUAGE);
        Injectable lastInjected = lastInjectedId != null ? (Injectable)ContainerUtil.find(injectables, injectable -> lastInjectedId.equals(injectable.getId())) : null;
        Dimension minSize = new JLabel(PlainTextLanguage.INSTANCE.getDisplayName(), EmptyIcon.ICON_16, 2).getMinimumSize();
        minSize.height *= 4;
        IPopupChooserBuilder builder = JBPopupFactory.getInstance().createPopupChooserBuilder(injectables).setRenderer((ListCellRenderer)renderer).setItemChosenCallback(injectable -> {
            onChosen.process(injectable);
            PropertiesComponent.getInstance().setValue(LAST_INJECTED_LANGUAGE, injectable.getId());
        }).setMinSize(minSize).setNamerForFiltering(language -> language.getDisplayName());
        if (lastInjected != null) {
            builder = builder.setSelectedValue((Object)lastInjected, true);
        }
        builder.createPopup().showInBestPositionFor(editor);
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/inject/InjectLanguageAction";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectable";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixPresenter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInjectables";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/InjectLanguageAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findInjectionHost";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "invokeImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface FixPresenter {
        public void showFix(@NotNull Editor var1, @NotNull TextRange var2, @NotNull SmartPsiElementPointer<PsiLanguageInjectionHost> var3, @NotNull String var4, @NotNull Processor<PsiLanguageInjectionHost> var5);
    }
}

