/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import processing.app.Base;
import processing.app.Language;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.contrib.AvailableContribution;
import processing.app.contrib.ContribProgressBar;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionManager;
import processing.app.contrib.ContributionType;
import processing.app.contrib.ListPanel;
import processing.app.contrib.LocalContribution;
import processing.app.contrib.ManagerFrame;
import processing.app.contrib.ModeContribution;
import processing.app.contrib.StatusPanel;
import processing.app.ui.Editor;
import processing.app.ui.Toolkit;

class DetailPanel
extends JPanel {
    public static final String REMOVE_RESTART_MESSAGE = String.format("<i>%s</i>", Language.text("contrib.messages.remove_restart"));
    public static final String INSTALL_RESTART_MESSAGE = String.format("<i>%s</i>", Language.text("contrib.messages.install_restart"));
    public static final String UPDATE_RESTART_MESSAGE = String.format("<i>%s</i>", Language.text("contrib.messages.update_restart"));
    public static final String PROGRESS_BAR_CONSTRAINT = "Install/Remove Progress Bar Panel";
    public static final String BUTTON_CONSTRAINT = "Install/Remove Button Panel";
    public static final String INCOMPATIBILITY_BLUR = "This contribution is not compatible with the current revision of Processing";
    private final ListPanel listPanel;
    private final ContributionListing contribListing = ContributionListing.getInstance();
    static final int BUTTON_WIDTH = Toolkit.zoom(100);
    static Icon foundationIcon;
    private Contribution contrib;
    private boolean alreadySelected;
    private boolean enableHyperlinks;
    private JTextPane descriptionPane;
    private JLabel notificationLabel;
    private JButton updateButton;
    JProgressBar installProgressBar;
    private JButton installRemoveButton;
    private JPopupMenu contextMenu;
    private JMenuItem openFolder;
    private JPanel barButtonCardPane;
    private CardLayout barButtonCardLayout;
    private static final String installText;
    private static final String removeText;
    private static final String undoText;
    boolean updateInProgress;
    boolean installInProgress;
    boolean removeInProgress;
    String description;

    static {
        installText = Language.text("contrib.install");
        removeText = Language.text("contrib.remove");
        undoText = Language.text("contrib.undo");
    }

    public Contribution getContrib() {
        return this.contrib;
    }

    private LocalContribution getLocalContrib() {
        return (LocalContribution)this.contrib;
    }

    DetailPanel(ListPanel contributionListPanel) {
        if (foundationIcon == null) {
            foundationIcon = Toolkit.getLibIconX("icons/foundation", 32);
        }
        this.listPanel = contributionListPanel;
        this.barButtonCardPane = new JPanel();
        this.contextMenu = new JPopupMenu();
        this.openFolder = new JMenuItem("Open Folder");
        this.openFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DetailPanel.this.contrib instanceof LocalContribution) {
                    File folder = ((LocalContribution)DetailPanel.this.contrib).getFolder();
                    Platform.openFolder(folder);
                }
            }
        });
        this.setLayout(new BoxLayout(this, 1));
        this.addPaneComponents();
        this.setBackground(this.listPanel.getBackground());
        this.setOpaque(true);
        this.setSelected(false);
        this.setExpandListener(this, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (DetailPanel.this.contrib.isCompatible(Base.getRevision())) {
                    DetailPanel.this.listPanel.setSelectedPanel(DetailPanel.this);
                } else {
                    DetailPanel.this.setErrorMessage(String.valueOf(DetailPanel.this.contrib.getName()) + " cannot be used with this version of Processing");
                }
            }
        });
    }

    private void addPaneComponents() {
        this.setLayout(new BorderLayout());
        this.descriptionPane = new JTextPane();
        this.descriptionPane.setInheritsPopupMenu(true);
        this.descriptionPane.setEditable(false);
        Insets margin = this.descriptionPane.getMargin();
        margin.bottom = 0;
        this.descriptionPane.setMargin(margin);
        this.descriptionPane.setContentType("text/html");
        DetailPanel.setTextStyle(this.descriptionPane, "0.95em");
        this.descriptionPane.setOpaque(false);
        if (UIManager.getLookAndFeel().getID().equals("Nimbus")) {
            this.descriptionPane.setBackground(new Color(0, 0, 0, 0));
        }
        this.descriptionPane.setBorder(new EmptyBorder(4, 7, 7, 7));
        this.descriptionPane.setHighlighter(null);
        this.descriptionPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && DetailPanel.this.isSelected() && DetailPanel.this.enableHyperlinks && e.getURL() != null) {
                    Platform.openURL(e.getURL().toString());
                }
            }
        });
        this.add((Component)this.descriptionPane, "Center");
        JPanel updateBox = new JPanel();
        updateBox.setLayout(new BorderLayout());
        this.notificationLabel = new JLabel();
        this.notificationLabel.setInheritsPopupMenu(true);
        this.notificationLabel.setVisible(false);
        this.notificationLabel.setOpaque(false);
        this.notificationLabel.setFont(ManagerFrame.SMALL_PLAIN);
        this.updateButton = new JButton("Update");
        this.updateButton.setInheritsPopupMenu(true);
        Dimension dim = new Dimension(BUTTON_WIDTH, this.updateButton.getPreferredSize().height);
        this.updateButton.setMinimumSize(dim);
        this.updateButton.setPreferredSize(dim);
        this.updateButton.setOpaque(false);
        this.updateButton.setVisible(false);
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailPanel.this.update();
            }
        });
        updateBox.add((Component)this.updateButton, "East");
        updateBox.add((Component)this.notificationLabel, "West");
        updateBox.setBorder(new EmptyBorder(4, 7, 7, 7));
        updateBox.setOpaque(false);
        this.add((Component)updateBox, "South");
        JPanel rightPane = new JPanel();
        rightPane.setInheritsPopupMenu(true);
        rightPane.setOpaque(false);
        rightPane.setLayout(new BoxLayout(rightPane, 1));
        rightPane.setMinimumSize(new Dimension(BUTTON_WIDTH, 1));
        this.add((Component)rightPane, "East");
        this.barButtonCardLayout = new CardLayout();
        this.barButtonCardPane.setLayout(this.barButtonCardLayout);
        this.barButtonCardPane.setInheritsPopupMenu(true);
        this.barButtonCardPane.setOpaque(false);
        this.barButtonCardPane.setMinimumSize(new Dimension(BUTTON_WIDTH, 1));
        this.installProgressBar = new JProgressBar();
        this.installProgressBar.setInheritsPopupMenu(true);
        this.installProgressBar.setStringPainted(true);
        this.resetInstallProgressBarState();
        Dimension dim2 = new Dimension(BUTTON_WIDTH, this.installProgressBar.getPreferredSize().height);
        this.installProgressBar.setPreferredSize(dim2);
        this.installProgressBar.setMaximumSize(dim2);
        this.installProgressBar.setMinimumSize(dim2);
        this.installProgressBar.setOpaque(false);
        this.installProgressBar.setAlignmentX(0.5f);
        this.installRemoveButton = new JButton(" ");
        this.installRemoveButton.setInheritsPopupMenu(true);
        this.installRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String mode = DetailPanel.this.installRemoveButton.getText();
                if (mode.equals(installText)) {
                    DetailPanel.this.install();
                } else if (mode.equals(removeText)) {
                    DetailPanel.this.remove();
                } else if (mode.equals(undoText)) {
                    DetailPanel.this.undo();
                }
            }
        });
        Dimension installButtonDimensions = this.installRemoveButton.getPreferredSize();
        installButtonDimensions.width = BUTTON_WIDTH;
        this.installRemoveButton.setPreferredSize(installButtonDimensions);
        this.installRemoveButton.setMaximumSize(installButtonDimensions);
        this.installRemoveButton.setMinimumSize(installButtonDimensions);
        this.installRemoveButton.setOpaque(false);
        this.installRemoveButton.setAlignmentX(0.5f);
        JPanel barPane = new JPanel();
        barPane.setOpaque(false);
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        buttonPane.add(this.installRemoveButton);
        this.barButtonCardPane.add((Component)buttonPane, BUTTON_CONSTRAINT);
        this.barButtonCardPane.add((Component)barPane, PROGRESS_BAR_CONSTRAINT);
        this.barButtonCardLayout.show(this.barButtonCardPane, BUTTON_CONSTRAINT);
        rightPane.add(this.barButtonCardPane);
        Dimension dim3 = new Dimension(BUTTON_WIDTH, this.installRemoveButton.getPreferredSize().height);
        rightPane.setMinimumSize(dim3);
        rightPane.setPreferredSize(dim3);
    }

    private void reorganizePaneComponents() {
        BorderLayout layout = (BorderLayout)this.getLayout();
        this.remove(layout.getLayoutComponent("South"));
        this.remove(layout.getLayoutComponent("East"));
        JPanel updateBox = new JPanel();
        updateBox.setLayout(new BorderLayout());
        updateBox.setInheritsPopupMenu(true);
        updateBox.add((Component)this.notificationLabel, "West");
        updateBox.setBorder(new EmptyBorder(4, 7, 7, 7));
        updateBox.setOpaque(false);
        this.add((Component)updateBox, "South");
        JPanel rightPane = new JPanel();
        rightPane.setInheritsPopupMenu(true);
        rightPane.setOpaque(false);
        rightPane.setLayout(new BoxLayout(rightPane, 1));
        rightPane.setMinimumSize(new Dimension(BUTTON_WIDTH, 1));
        this.add((Component)rightPane, "East");
        if (this.updateButton.isVisible() && !this.removeInProgress && !this.contrib.isDeletionFlagged()) {
            JPanel updateRemovePanel = new JPanel();
            updateRemovePanel.setLayout(new FlowLayout());
            updateRemovePanel.setOpaque(false);
            updateRemovePanel.add(this.updateButton);
            updateRemovePanel.setInheritsPopupMenu(true);
            updateRemovePanel.add(this.installRemoveButton);
            updateBox.add((Component)updateRemovePanel, "East");
            JPanel barPane = new JPanel();
            barPane.setOpaque(false);
            barPane.setInheritsPopupMenu(true);
            rightPane.add(barPane);
            if (this.updateInProgress) {
                this.barButtonCardLayout.show(this.barButtonCardPane, PROGRESS_BAR_CONSTRAINT);
            }
        } else {
            updateBox.add((Component)this.updateButton, "East");
            this.barButtonCardPane.removeAll();
            JPanel barPane = new JPanel();
            barPane.setOpaque(false);
            barPane.setInheritsPopupMenu(true);
            JPanel buttonPane = new JPanel();
            buttonPane.setOpaque(false);
            buttonPane.setInheritsPopupMenu(true);
            buttonPane.add(this.installRemoveButton);
            this.barButtonCardPane.add((Component)buttonPane, BUTTON_CONSTRAINT);
            this.barButtonCardPane.add((Component)barPane, PROGRESS_BAR_CONSTRAINT);
            if (this.installInProgress || this.removeInProgress || this.updateInProgress) {
                this.barButtonCardLayout.show(this.barButtonCardPane, PROGRESS_BAR_CONSTRAINT);
            } else {
                this.barButtonCardLayout.show(this.barButtonCardPane, BUTTON_CONSTRAINT);
            }
            rightPane.add(this.barButtonCardPane);
        }
        Dimension progressDim = this.installProgressBar.getPreferredSize();
        Dimension installDim = this.installRemoveButton.getPreferredSize();
        progressDim.width = BUTTON_WIDTH;
        progressDim.height = Math.max(progressDim.height, installDim.height);
        rightPane.setMinimumSize(progressDim);
        rightPane.setPreferredSize(progressDim);
    }

    private void setExpandListener(Component component, MouseListener expandListener) {
        if (!(component instanceof JButton)) {
            component.addMouseListener(expandListener);
            if (component instanceof Container) {
                Component[] componentArray = ((Container)component).getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component child = componentArray[n2];
                    this.setExpandListener(child, expandListener);
                    ++n2;
                }
            }
        }
    }

    private void blurContributionPanel(Component component) {
        component.setFocusable(false);
        component.setEnabled(false);
        if (component instanceof JComponent) {
            ((JComponent)component).setToolTipText(INCOMPATIBILITY_BLUR);
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component child = componentArray[n2];
                this.blurContributionPanel(child);
                ++n2;
            }
        }
    }

    public void setContribution(Contribution contrib) {
        this.contrib = contrib;
        if (contrib.isSpecial()) {
            JLabel iconLabel = new JLabel(foundationIcon);
            iconLabel.setBorder(new EmptyBorder(4, 7, 7, 7));
            iconLabel.setVerticalAlignment(1);
            this.add((Component)iconLabel, "West");
        }
        Font boldFont = ManagerFrame.SMALL_BOLD;
        String fontFace = "<font face=\"" + boldFont.getName() + "\">";
        StringBuilder desc = new StringBuilder();
        desc.append("<html><body>" + fontFace);
        if (contrib.getUrl() == null) {
            desc.append(contrib.getName());
        } else {
            desc.append("<a href=\"" + contrib.getUrl() + "\">" + contrib.getName() + "</a>");
        }
        desc.append("</font> ");
        String prettyVersion = contrib.getPrettyVersion();
        if (prettyVersion != null) {
            desc.append(prettyVersion);
        }
        desc.append(" <br/>");
        String authorList = contrib.getAuthorList();
        if (authorList != null && !authorList.isEmpty()) {
            desc.append(DetailPanel.toHtmlLinks(contrib.getAuthorList()));
        }
        desc.append("<br/><br/>");
        if (contrib.isDeletionFlagged()) {
            desc.append(REMOVE_RESTART_MESSAGE);
        } else if (contrib.isRestartFlagged()) {
            desc.append(INSTALL_RESTART_MESSAGE);
        } else if (contrib.isUpdateFlagged()) {
            desc.append(UPDATE_RESTART_MESSAGE);
        } else {
            String sentence = contrib.getSentence();
            if (sentence == null || sentence.isEmpty()) {
                sentence = String.format("<i>%s</i>", Language.text("contrib.errors.description_unavailable"));
            } else {
                sentence = DetailPanel.sanitizeHtmlTags(sentence);
                sentence = DetailPanel.toHtmlLinks(sentence);
            }
            desc.append(sentence);
        }
        long lastUpdatedUTC = contrib.getLastUpdated();
        if (lastUpdatedUTC != 0L) {
            DateFormat dateFormatter = DateFormat.getDateInstance(2);
            Date lastUpdatedDate = new Date(lastUpdatedUTC);
            if (prettyVersion != null) {
                desc.append(", ");
            }
            desc.append("Last Updated on " + dateFormatter.format(lastUpdatedDate));
        }
        desc.append("</body></html>");
        this.description = desc.toString();
        this.descriptionPane.setText(this.description);
        if (this.contribListing.hasUpdates(contrib) && contrib.isCompatible(Base.getRevision())) {
            StringBuilder versionText = new StringBuilder();
            versionText.append("<html><body><i>");
            if (!contrib.isUpdateFlagged() && !contrib.isDeletionFlagged()) {
                String latestVersion = this.contribListing.getLatestPrettyVersion(contrib);
                if (latestVersion != null) {
                    versionText.append("New version (" + latestVersion + ") available.");
                } else {
                    versionText.append("New version available.");
                }
            }
            versionText.append("</i></body></html>");
            this.notificationLabel.setText(versionText.toString());
            this.notificationLabel.setVisible(true);
        } else {
            this.notificationLabel.setText("");
            this.notificationLabel.setVisible(false);
        }
        this.updateButton.setEnabled(true);
        if (contrib != null) {
            this.updateButton.setVisible(this.contribListing.hasUpdates(contrib) && !contrib.isUpdateFlagged() && !contrib.isDeletionFlagged() || this.updateInProgress);
        }
        if (contrib.isDeletionFlagged()) {
            this.installRemoveButton.setText(undoText);
        } else if (contrib.isInstalled()) {
            this.installRemoveButton.setText(removeText);
            this.installRemoveButton.setVisible(true);
            this.installRemoveButton.setEnabled(!contrib.isUpdateFlagged());
            this.reorganizePaneComponents();
        } else {
            this.installRemoveButton.setText(installText);
        }
        this.contextMenu.removeAll();
        if (contrib.isInstalled()) {
            this.contextMenu.add(this.openFolder);
            this.setComponentPopupMenu(this.contextMenu);
        } else {
            this.setComponentPopupMenu(null);
        }
        if (!contrib.isCompatible(Base.getRevision())) {
            this.blurContributionPanel(this);
        }
    }

    private void installContribution(AvailableContribution info) {
        if (info.link == null) {
            this.setErrorMessage(Language.interpolate("contrib.unsupported_operating_system", new Object[]{info.getType()}));
        } else {
            this.installContribution(info, info.link);
        }
    }

    private void finishInstall(boolean error) {
        this.resetInstallProgressBarState();
        this.installRemoveButton.setEnabled(!this.contrib.isUpdateFlagged());
        if (error) {
            this.setErrorMessage(Language.text("contrib.download_error"));
        }
        this.barButtonCardLayout.show(this.barButtonCardPane, BUTTON_CONSTRAINT);
        this.installInProgress = false;
        if (this.updateInProgress) {
            this.updateInProgress = false;
        }
        this.updateButton.setVisible(this.contribListing.hasUpdates(this.contrib) && !this.contrib.isUpdateFlagged());
        this.setSelected(true);
    }

    private void installContribution(AvailableContribution ad, String url) {
        this.installRemoveButton.setEnabled(false);
        try {
            URL downloadUrl = new URL(url);
            this.installProgressBar.setVisible(true);
            ContribProgressBar downloadProgress = new ContribProgressBar(this.installProgressBar){

                @Override
                public void finishedAction() {
                }

                @Override
                public void cancelAction() {
                    DetailPanel.this.finishInstall(false);
                }
            };
            ContribProgressBar installProgress = new ContribProgressBar(this.installProgressBar){

                @Override
                public void finishedAction() {
                    DetailPanel.this.finishInstall(this.isError());
                }

                @Override
                public void cancelAction() {
                    this.finishedAction();
                }
            };
            ContributionManager.downloadAndInstall(this.getBase(), downloadUrl, ad, downloadProgress, installProgress, this.getStatusPanel());
        }
        catch (MalformedURLException e) {
            Messages.showWarning(Language.text("contrib.errors.install_failed"), Language.text("contrib.errors.malformed_url"), e);
        }
    }

    protected void resetInstallProgressBarState() {
        this.installProgressBar.setString(Language.text("contrib.progress.starting"));
        this.installProgressBar.setIndeterminate(false);
        this.installProgressBar.setValue(0);
        this.installProgressBar.setVisible(false);
    }

    public void setSelected(boolean isSelected) {
        this.enableHyperlinks = this.alreadySelected;
        if (this.contrib != null) {
            this.updateButton.setVisible(this.contribListing.hasUpdates(this.contrib) && !this.contrib.isUpdateFlagged() && !this.contrib.isDeletionFlagged() || this.updateInProgress);
            this.updateButton.setEnabled(!this.contribListing.hasListDownloadFailed());
        }
        this.installRemoveButton.setVisible(this.isSelected() || this.installRemoveButton.getText().equals(Language.text("contrib.remove")) || this.updateInProgress);
        this.installRemoveButton.setEnabled(this.installRemoveButton.getText().equals(Language.text("contrib.remove")) || !this.contribListing.hasListDownloadFailed());
        this.reorganizePaneComponents();
        DetailPanel.setSelectionStyle(this.descriptionPane, this.isSelected());
        this.alreadySelected = this.isSelected();
    }

    public boolean isSelected() {
        return this.listPanel.getSelectedPanel() == this;
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.contrib != null) {
            boolean installed = this.contrib.isInstalled();
            DetailPanel.setForegroundStyle(this.descriptionPane, installed, this.isSelected());
        }
    }

    static String sanitizeHtmlTags(String stringIn) {
        stringIn = stringIn.replaceAll("<", "&lt;");
        stringIn = stringIn.replaceAll(">", "&gt;");
        return stringIn;
    }

    static String toHtmlLinks(String stringIn) {
        Pattern p = Pattern.compile("\\[(.*?)\\]\\((.*?)\\)");
        Matcher m = p.matcher(stringIn);
        StringBuilder sb = new StringBuilder();
        int start = 0;
        while (m.find(start)) {
            sb.append(stringIn.substring(start, m.start()));
            String text = m.group(1);
            String url = m.group(2);
            sb.append("<a href=\"");
            sb.append(url);
            sb.append("\">");
            sb.append(text);
            sb.append("</a>");
            start = m.end();
        }
        sb.append(stringIn.substring(start));
        return sb.toString();
    }

    static void setForegroundStyle(JTextPane textPane, boolean installed, boolean selected) {
        Document doc = textPane.getDocument();
        if (doc instanceof HTMLDocument) {
            HTMLDocument html = (HTMLDocument)doc;
            StyleSheet stylesheet = html.getStyleSheet();
            String c = installed && !selected ? "#555555" : "#000000";
            stylesheet.addRule("body { color:" + c + "; }");
            stylesheet.addRule("a { color:" + c + "; }");
        }
    }

    static void setTextStyle(JTextPane textPane, String fontSize) {
        Document doc = textPane.getDocument();
        if (doc instanceof HTMLDocument) {
            HTMLDocument html = (HTMLDocument)doc;
            StyleSheet stylesheet = html.getStyleSheet();
            stylesheet.addRule("body {   margin: 0; padding: 0;  font-family: " + Toolkit.getSansFontName() + ", Arial, Helvetica, sans-serif;" + "  font-size: 100%;" + "font-size: " + fontSize + "; " + "}");
        }
    }

    static void setSelectionStyle(JTextPane textPane, boolean selected) {
        Document doc = textPane.getDocument();
        if (doc instanceof HTMLDocument) {
            HTMLDocument html = (HTMLDocument)doc;
            StyleSheet styleSheet = html.getStyleSheet();
            if (selected) {
                styleSheet.addRule("a { text-decoration:underline } ");
            } else {
                styleSheet.addRule("a { text-decoration:none }");
            }
        }
    }

    public void install() {
        this.clearStatusMessage();
        this.installInProgress = true;
        this.barButtonCardLayout.show(this.barButtonCardPane, PROGRESS_BAR_CONSTRAINT);
        if (this.contrib instanceof AvailableContribution) {
            this.installContribution((AvailableContribution)this.contrib);
            this.contribListing.replaceContribution(this.contrib, this.contrib);
        }
    }

    public void update() {
        this.clearStatusMessage();
        this.updateInProgress = true;
        if (this.contrib.getType().requiresRestart()) {
            this.installRemoveButton.setEnabled(false);
            this.installProgressBar.setVisible(true);
            this.installProgressBar.setIndeterminate(true);
            UpdateProgressBar progress = new UpdateProgressBar(this.installProgressBar);
            this.getLocalContrib().removeContribution(this.getBase(), progress, this.getStatusPanel());
        } else {
            this.updateButton.setEnabled(false);
            this.installRemoveButton.setEnabled(false);
            AvailableContribution ad = this.contribListing.getAvailableContribution(this.contrib);
            this.installContribution(ad, ad.link);
        }
    }

    public void remove() {
        this.clearStatusMessage();
        if (this.contrib.isInstalled() && this.contrib instanceof LocalContribution) {
            this.removeInProgress = true;
            this.barButtonCardLayout.show(this.barButtonCardPane, PROGRESS_BAR_CONSTRAINT);
            this.updateButton.setEnabled(false);
            this.installRemoveButton.setEnabled(false);
            this.installProgressBar.setVisible(true);
            this.installProgressBar.setIndeterminate(true);
            RemoveProgressBar monitor = new RemoveProgressBar(this.installProgressBar);
            this.getLocalContrib().removeContribution(this.getBase(), monitor, this.getStatusPanel());
        }
    }

    private void undo() {
        this.clearStatusMessage();
        if (this.contrib instanceof LocalContribution) {
            LocalContribution installed = this.getLocalContrib();
            installed.setDeletionFlag(false);
            this.contribListing.replaceContribution(this.contrib, this.contrib);
            Iterator<Contribution> contribsListIter = this.contribListing.allContributions.iterator();
            boolean toBeRestarted = false;
            while (contribsListIter.hasNext()) {
                Contribution contribElement = contribsListIter.next();
                if (!this.contrib.getType().equals((Object)contribElement.getType()) || !contribElement.isDeletionFlagged() && !contribElement.isUpdateFlagged()) continue;
                toBeRestarted = !toBeRestarted;
                break;
            }
        }
    }

    private Base getBase() {
        return this.listPanel.contributionTab.editor.getBase();
    }

    private boolean isModeActive(Contribution contrib) {
        if (contrib.getType() == ContributionType.MODE) {
            ModeContribution m = (ModeContribution)contrib;
            for (Editor e : this.getBase().getEditors()) {
                if (!e.getMode().equals(m.getMode())) continue;
                return true;
            }
        }
        return false;
    }

    private StatusPanel getStatusPanel() {
        return this.listPanel.contributionTab.statusPanel;
    }

    private void clearStatusMessage() {
        this.getStatusPanel().clearMessage();
    }

    private void setErrorMessage(String message) {
        this.getStatusPanel().setErrorMessage(message);
    }

    class RemoveProgressBar
    extends ContribProgressBar {
        public RemoveProgressBar(JProgressBar progressBar) {
            super(progressBar);
        }

        private void preAction() {
            DetailPanel.this.resetInstallProgressBarState();
            DetailPanel.this.removeInProgress = false;
            DetailPanel.this.installRemoveButton.setEnabled(true);
            DetailPanel.this.reorganizePaneComponents();
            DetailPanel.this.setSelected(true);
        }

        @Override
        public void finishedAction() {
            this.preAction();
        }

        @Override
        public void cancelAction() {
            this.preAction();
            if (DetailPanel.this.isModeActive(DetailPanel.this.contrib)) {
                DetailPanel.this.updateButton.setEnabled(true);
            }
        }
    }

    class UpdateProgressBar
    extends ContribProgressBar {
        public UpdateProgressBar(JProgressBar progressBar) {
            super(progressBar);
        }

        @Override
        public void finishedAction() {
            DetailPanel.this.resetInstallProgressBarState();
            DetailPanel.this.updateButton.setEnabled(false);
            AvailableContribution ad = DetailPanel.this.contribListing.getAvailableContribution(DetailPanel.this.contrib);
            String url = ad.link;
            DetailPanel.this.installContribution(ad, url);
        }

        @Override
        public void cancelAction() {
            DetailPanel.this.resetInstallProgressBarState();
            DetailPanel.this.clearStatusMessage();
            DetailPanel.this.updateInProgress = false;
            DetailPanel.this.installRemoveButton.setEnabled(true);
            if (DetailPanel.this.contrib.isDeletionFlagged()) {
                DetailPanel.this.getLocalContrib().setUpdateFlag(true);
                DetailPanel.this.getLocalContrib().setDeletionFlag(false);
                DetailPanel.this.contribListing.replaceContribution(DetailPanel.this.contrib, DetailPanel.this.contrib);
            }
            if (DetailPanel.this.isModeActive(DetailPanel.this.contrib)) {
                DetailPanel.this.updateButton.setEnabled(true);
            }
        }
    }
}

