'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _crossSpawn = require('cross-spawn');

var _crossSpawn2 = _interopRequireDefault(_crossSpawn);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var closeArgsToError = function closeArgsToError(code, signal) {
  if (signal !== null) {
    var err = new Error(`Exited with signal ${ signal }`);
    err.exitSignal = signal;
    return err;
  }
  if (code !== 0) {
    var _err = new Error(`Exited with status ${ code }`);
    _err.exitStatus = code;
    return _err;
  }
  return null;
};

var concatBuffer = function concatBuffer(buffer) {
  if (buffer == null || buffer.length === 0) {
    return null;
  } else if (typeof buffer[0] === 'string') {
    return buffer.join('');
  } else if (Buffer.isBuffer(buffer[0])) {
    return Buffer.concat(buffer);
  } else {
    throw new Error('Unexpected buffer type');
  }
};

var setEncoding = function setEncoding(stream, encoding) {
  if (stream != null && encoding != null && typeof stream.setEncoding === 'function') {
    stream.setEncoding(encoding);
  }
};

var prepareStream = function prepareStream(stream, encoding) {
  if (stream == null) {
    return null;
  }
  setEncoding(stream, encoding);
  var buffers = [];
  stream.on('data', function (data) {
    buffers.push(data);
  });
  return buffers;
};

exports.default = function (cmd, args) {
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

  var childProcess = void 0;
  var promise = new Promise(function (resolve, reject) {
    var encoding = void 0;
    if (options.encoding != null) {
      encoding = options.encoding;
      options = Object.assign({}, options);
      delete options.encoding;
    }

    childProcess = (0, _crossSpawn2.default)(cmd, args, options);

    setEncoding(childProcess.stdin, encoding);
    var stdout = prepareStream(childProcess.stdout, encoding);
    var stderr = prepareStream(childProcess.stderr, encoding);

    childProcess.once('exit', function (code, signal) {
      var error = closeArgsToError(code, signal);
      if (error != null) {
        error.stdout = concatBuffer(stdout);
        error.stderr = concatBuffer(stderr);
        reject(error);
      } else {
        resolve(concatBuffer(stdout));
      }
    });

    childProcess.once('error', reject);
  });
  promise.childProcess = childProcess;
  return promise;
};
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
