import { io } from './IO';
import { phantom } from './function';
export const URI = 'IxIO';
/**
 * @since 1.0.0
 */
export class IxIO {
    constructor(value) {
        this.value = value;
    }
    run() {
        return this.value.run();
    }
    ichain(f) {
        return new IxIO(this.value.chain(a => f(a).value));
    }
    map(f) {
        return new IxIO(this.value.map(f));
    }
    ap(fab) {
        return new IxIO(this.value.ap(fab.value));
    }
    chain(f) {
        return new IxIO(this.value.chain(a => f(a).value));
    }
}
/**
 * @since 1.0.0
 */
export const iof = (a) => {
    return new IxIO(io.of(a));
};
const ichain = (fa, f) => {
    return fa.ichain(f);
};
const map = (fa, f) => {
    return fa.map(f);
};
const of = iof;
const ap = (fab, fa) => {
    return fa.ap(fab);
};
const chain = (fa, f) => {
    return fa.chain(f);
};
/**
 * @since 1.0.0
 */
export const getMonad = () => {
    return {
        URI,
        _L: phantom,
        _U: phantom,
        map,
        of,
        ap,
        chain
    };
};
/**
 * @since 1.0.0
 */
export const ixIO = {
    URI,
    iof,
    ichain
};
