/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.persistence;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jruby.EvalType;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubySymbol;
import org.jruby.ir.IRClassBody;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRFor;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMetaClassBody;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.ClosureLocalVariable;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.persistence.IRPersistenceValues;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.parser.StaticScope;
import org.jruby.parser.StaticScopeFactory;
import org.jruby.runtime.Signature;
import org.jruby.util.ByteList;
import org.jruby.util.KeyValuePair;

public class IRReader
implements IRPersistenceValues {
    public static IRScope load(IRManager manager, final IRReaderDecoder file2) throws IOException {
        IRScope scope;
        int version = file2.decodeIntRaw();
        if (version != 1) {
            throw new IOException("Trying to read incompatible persistence format (version found: " + version + ", version expected: " + 1);
        }
        int headersOffset = file2.decodeIntRaw();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("header_offset = " + headersOffset);
        }
        int poolOffset = file2.decodeIntRaw();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("pool_offset = " + headersOffset);
        }
        file2.seek(headersOffset);
        int scopesToRead = file2.decodeInt();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("scopes to read = " + scopesToRead);
        }
        KeyValuePair[] scopes = new KeyValuePair[scopesToRead];
        for (int i2 = 0; i2 < scopesToRead; ++i2) {
            scopes[i2] = IRReader.decodeScopeHeader(manager, file2);
        }
        for (KeyValuePair pair : scopes) {
            scope = (IRScope)pair.getKey();
            final int instructionsOffset = (Integer)pair.getValue();
            scope.allocateInterpreterContext(new Callable<List<Instr>>(){

                @Override
                public List<Instr> call() {
                    return file2.decodeInstructionsAt(scope, instructionsOffset);
                }
            });
        }
        for (KeyValuePair pair : scopes) {
            scope = (IRScope)pair.getKey();
            scope.computeScopeFlags();
        }
        return (IRScope)scopes[0].getKey();
    }

    private static KeyValuePair<IRScope, Integer> decodeScopeHeader(IRManager manager, IRReaderDecoder decoder) {
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("DECODING SCOPE HEADER");
        }
        IRScopeType type2 = decoder.decodeIRScopeType();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("IRScopeType = " + (Object)((Object)type2));
        }
        ByteList name2 = decoder.decodeByteList();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("NAME = " + name2);
        }
        int line = decoder.decodeInt();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("LINE = " + line);
        }
        int tempVarsCount = decoder.decodeInt();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("# of Temp Vars = " + tempVarsCount);
        }
        boolean isEND = false;
        if (type2 == IRScopeType.CLOSURE) {
            isEND = decoder.decodeBoolean();
        }
        Map<String, Integer> indices = IRReader.decodeScopeLabelIndices(decoder);
        IRScope parent = type2 != IRScopeType.SCRIPT_BODY ? decoder.decodeScope() : null;
        Signature signature = type2 == IRScopeType.CLOSURE || type2 == IRScopeType.FOR ? Signature.decode(decoder.decodeLong()) : Signature.OPTIONAL;
        StaticScope parentScope = parent == null ? null : parent.getStaticScope();
        StaticScope staticScope = IRReader.decodeStaticScope(decoder, parentScope);
        IRScope scope = IRReader.createScope(manager, type2, manager.runtime.newSymbol(name2), line, parent, signature, staticScope);
        if (scope instanceof IRClosure && isEND) {
            ((IRClosure)scope).setIsEND();
        }
        scope.setTemporaryVariableCount(tempVarsCount);
        scope.setLabelIndices(indices);
        scope.setLocalVariables(IRReader.decodeScopeLocalVariables(decoder, scope));
        decoder.addScope(scope);
        int instructionsOffset = decoder.decodeInt();
        return new KeyValuePair<IRScope, Integer>(scope, instructionsOffset);
    }

    private static Map<RubySymbol, LocalVariable> decodeScopeLocalVariables(IRReaderDecoder decoder, IRScope scope) {
        int size2 = decoder.decodeInt();
        HashMap<RubySymbol, LocalVariable> localVariables = new HashMap<RubySymbol, LocalVariable>(size2);
        for (int i2 = 0; i2 < size2; ++i2) {
            RubySymbol name2 = scope.getManager().getRuntime().newSymbol(decoder.decodeByteList());
            int offset2 = decoder.decodeInt();
            localVariables.put(name2, scope instanceof IRClosure ? new ClosureLocalVariable(name2, 0, offset2) : new LocalVariable(name2, 0, offset2));
        }
        return localVariables;
    }

    private static Map<String, Integer> decodeScopeLabelIndices(IRReaderDecoder decoder) {
        int labelIndicesSize = decoder.decodeInt();
        HashMap<String, Integer> indices = new HashMap<String, Integer>(labelIndicesSize);
        for (int i2 = 0; i2 < labelIndicesSize; ++i2) {
            indices.put(decoder.decodeString(), decoder.decodeInt());
        }
        return indices;
    }

    private static StaticScope decodeStaticScope(IRReaderDecoder decoder, StaticScope parentScope) {
        StaticScope scope = StaticScopeFactory.newStaticScope(parentScope, decoder.decodeStaticScopeType(), decoder.decodeStringArray(), decoder.decodeInt());
        scope.setSignature(decoder.decodeSignature());
        return scope;
    }

    public static IRScope createScope(IRManager manager, IRScopeType type2, RubySymbol name2, int line, IRScope lexicalParent, Signature signature, StaticScope staticScope) {
        switch (type2) {
            case CLASS_BODY: {
                return new IRClassBody(manager, lexicalParent, name2, line, staticScope);
            }
            case METACLASS_BODY: {
                return new IRMetaClassBody(manager, lexicalParent, manager.getMetaClassName(), line, staticScope);
            }
            case INSTANCE_METHOD: {
                return new IRMethod(manager, lexicalParent, null, name2, true, line, staticScope, false);
            }
            case CLASS_METHOD: {
                return new IRMethod(manager, lexicalParent, null, name2, false, line, staticScope, false);
            }
            case MODULE_BODY: {
                return new IRModuleBody(manager, lexicalParent, name2, line, staticScope);
            }
            case SCRIPT_BODY: {
                return new IRScriptBody(manager, name2, staticScope);
            }
            case FOR: {
                return new IRFor(manager, lexicalParent, line, staticScope, signature);
            }
            case CLOSURE: {
                return new IRClosure(manager, lexicalParent, line, staticScope, signature);
            }
            case EVAL_SCRIPT: {
                return new IREvalScript(manager, lexicalParent, lexicalParent.getFileName(), line, staticScope, EvalType.NONE);
            }
        }
        throw new RuntimeException("No such scope type: " + (Object)((Object)type2));
    }
}

