/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.modelset.Atom;
import org.jmol.viewer.Viewer;

public class NBOParser {
    private Viewer vwr;
    private boolean haveBeta;

    public NBOParser set(Viewer vwr) {
        this.vwr = vwr;
        return this;
    }

    public Lst<Object> getAllStructures(String output, Lst<Object> list) {
        if (output == null) {
            return null;
        }
        if (list == null) {
            list = new Lst();
        }
        output = PT.rep(output, "the $CHOOSE", "");
        this.getStructures(this.getBlock(output, "$CHOOSE"), "CHOOSE", list);
        this.getStructures(this.getBlock(output, "$NRTSTR"), "NRTSTR", list);
        this.getStructures(this.getBlock(output, "$NRTSTRA"), "NRTSTRA", list);
        this.getStructures(this.getBlock(output, "$NRTSTRB"), "NRTSTRB", list);
        this.getStructuresTOPO(this.getData(output, "TOPO matrix", "* Total *", 1), "RSA", list);
        this.getStructuresTOPO(this.getData(output, "TOPO matrix", "* Total *", 2), "RSB", list);
        return list;
    }

    private String getBlock(String output, String key) {
        int pt = output.indexOf(key);
        int pt1 = output.indexOf("$END", pt + 1);
        return pt < 0 || pt1 < 0 ? null : output.substring(pt + key.length(), pt1);
    }

    public static void getStructures46(String[] tokens, String type, Lst<Object> structures, int nAtoms) {
        if (tokens == null) {
            return;
        }
        Hashtable<String, Object> htData = new Hashtable<String, Object>();
        structures.addLast(htData);
        int[][] matrix = new int[nAtoms][nAtoms];
        htData.put("matrix", matrix);
        htData.put("type", type);
        htData.put("spin", type);
        htData.put("index", 0);
        for (String org : tokens) {
            if (org.contains("(ry)")) break;
            if (org.contains("*") || org.contains("(cr)")) continue;
            boolean isLP = org.endsWith("(lp)");
            if (isLP || org.endsWith("(lv)")) {
                int ia = NBOParser.getAtomIndex(org.substring(0, org.length() - 4));
                int[] nArray = matrix[ia];
                int n = ia;
                nArray[n] = nArray[n] + (isLP ? 1 : 10);
                continue;
            }
            String[] names = PT.split(org, "-");
            if (names.length == 3) {
                System.out.println("NBOParser 3-center bonnd " + org + " ignored for Kekule structure");
                continue;
            }
            int ia = NBOParser.getAtomIndex(names[0]);
            int ib = NBOParser.getAtomIndex(names[1]);
            int[] nArray = matrix[ia];
            int n = ib;
            nArray[n] = nArray[n] + 1;
        }
        NBOParser.dumpMatrix(type, 0, matrix);
    }

    private static int getAtomIndex(String xx99) {
        int n;
        int i = n = xx99.length();
        int val = 0;
        int pow = 1;
        char ch = '\u0000';
        while (--i >= 0) {
            ch = xx99.charAt(i);
            if (ch < '0' || ch > '9') {
                return val - 1;
            }
            val += (ch - 48) * pow;
            pow *= 10;
        }
        return 0;
    }

    private void getStructuresTOPO(String data, String nrtType, Lst<Object> list) {
        if (data == null || data.length() == 0) {
            return;
        }
        String[] parts = PT.split(data, "Resonance");
        if (parts.length < 2) {
            return;
        }
        int pt = parts[0].lastIndexOf(".");
        int nAtoms = PT.parseInt(parts[0].substring(pt - 3, pt));
        if (nAtoms < 0) {
            return;
        }
        String[] tokens = PT.getTokens(PT.rep(PT.rep(parts[0], ".", ".1"), "Atom", "-1"));
        float[] raw = new float[tokens.length];
        int n = PT.parseFloatArrayInfested(tokens, raw);
        int[][] table = new int[nAtoms][nAtoms];
        int atom1 = -1;
        int atom2 = 0;
        int atom0 = 0;
        for (int i = 0; i < n; ++i) {
            float f = raw[i];
            if (f < 0.0f) {
                atom1 = -1;
                continue;
            }
            if (f % 1.0f == 0.0f) {
                if (atom1 == -1) {
                    atom0 = (int)f;
                    atom1 = -2;
                }
                if (atom1 < 0) continue;
                table[atom1][atom2++] = (int)f;
                continue;
            }
            atom1 = (int)(f - 1.0f);
            atom2 = atom0 - 1;
        }
        int[][] matrix = null;
        tokens = parts[1].split("\n");
        String s = "";
        for (int i = 3; i < tokens.length; ++i) {
            if (tokens[i].indexOf("--") >= 0) continue;
            s = s + tokens[i].substring(10) + "\n";
        }
        s = s.replace('-', ' ');
        s = PT.rep(s, ".", ".1");
        s = PT.rep(s, "(", " -1 ");
        s = PT.rep(s, ")", " -2 ");
        s = PT.rep(s, ",", " -3 ");
        tokens = PT.getTokens(s);
        raw = new float[tokens.length];
        n = PT.parseFloatArrayInfested(tokens, raw);
        Hashtable<String, Object> htData = null;
        int dir = 1;
        atom2 = -1;
        atom1 = -1;
        int index = 0;
        block7: for (int i = 0; i < n; ++i) {
            float f = raw[i];
            float remain = f % 1.0f;
            if (remain == 0.0f) {
                int v = (int)f;
                switch (v) {
                    case -1: {
                        dir = -1;
                        atom2 = -1;
                        atom1 = -1;
                        continue block7;
                    }
                    case -2: {
                        break;
                    }
                    case -3: {
                        if (atom1 >= 0) break;
                        continue block7;
                    }
                    default: {
                        if (atom1 < 0) {
                            atom1 = atom2 = v - 1;
                            continue block7;
                        }
                        atom2 = v - 1;
                        continue block7;
                    }
                }
                int[] nArray = matrix[atom1];
                int n2 = atom2;
                nArray[n2] = nArray[n2] + dir;
                atom2 = -1;
                atom1 = -1;
                dir = 1;
                continue;
            }
            if (htData == null) {
                matrix = table;
            }
            NBOParser.dumpMatrix(nrtType, index, matrix);
            if (raw[i + 2] == 0.0f) break;
            htData = new Hashtable<String, Object>();
            list.addLast(htData);
            s = "" + ((int)f * 100 + (int)(((double)remain - 0.0999999) * 1000.0));
            int len = s.length();
            s = (len == 2 ? "0" : "") + s.substring(0, len - 2) + "." + s.substring(len - 2);
            htData.put("weight", s);
            htData.put("index", index++);
            htData.put("type", nrtType.toLowerCase());
            htData.put("spin", nrtType.indexOf("B") >= 0 ? "beta" : "alpha");
            matrix = new int[nAtoms][nAtoms];
            htData.put("matrix", matrix);
            for (int j = 0; j < nAtoms; ++j) {
                for (int k = 0; k < nAtoms; ++k) {
                    matrix[j][k] = table[j][k];
                }
            }
        }
    }

    private static void dumpMatrix(String nrtType, int index, int[][] matrix) {
        System.out.println("NBOParser matrix " + nrtType + " " + index);
        int nAtoms = matrix.length;
        for (int j = 0; j < nAtoms; ++j) {
            System.out.println(PT.toJSON(null, matrix[j]));
        }
        System.out.println("-------------------");
    }

    private String getData(String output, String start, String end, int n) {
        int pt = 0;
        int pt1 = 0;
        for (int i = 0; i < n; ++i) {
            pt = output.indexOf(start, pt1 + 1);
            pt1 = output.indexOf(end, pt + 1);
        }
        return pt < 0 || pt1 < 0 ? null : output.substring(pt, pt1);
    }

    public int getStructures(String data, String nrtType, Lst<Object> list) {
        if (data == null || data.length() == 0) {
            return 0;
        }
        int n = 0;
        try {
            String spin;
            boolean ignoreSTR;
            boolean bl = ignoreSTR = data.indexOf("ALPHA") >= 0;
            if (!ignoreSTR && !data.contains("STR")) {
                data = "STR " + data + " END";
            }
            String string = spin = (nrtType = nrtType.toLowerCase()).equals("nrtstrb") ? "beta" : "alpha";
            if (nrtType.equals("choose")) {
                nrtType = null;
            }
            Hashtable<String, Object> htData = null;
            String[] tokens = PT.getTokens(data.replace('\r', ' ').replace('\n', ' ').replace('\t', ' '));
            String lastType = "";
            int index = 0;
            int nt = tokens.length;
            block10: for (int i = 0; i < nt; ++i) {
                String tok = tokens[i];
                switch ("STR  =    ALPHABETA LONE BOND 3C".indexOf(tok)) {
                    case 0: {
                        if (ignoreSTR) continue block10;
                        tok = spin;
                    }
                    case 10: 
                    case 15: {
                        htData = new Hashtable<String, Object>();
                        list.addLast(htData);
                        if (!lastType.equals(tok)) {
                            lastType = tok;
                            index = 0;
                        }
                        htData.put("index", index++);
                        spin = tok.toLowerCase();
                        htData.put("spin", spin);
                        if (spin.equals("beta")) {
                            this.haveBeta = true;
                        }
                        htData.put("type", nrtType == null ? "choose" + spin.substring(0, 1) : nrtType);
                        ++n;
                        continue block10;
                    }
                    case 5: {
                        htData.put("weight", tokens[++i]);
                        continue block10;
                    }
                    case 20: {
                        Lst<int[]> lone = new Lst<int[]>();
                        htData.put("lone", lone);
                        while (!(tok = tokens[++i]).equals("END")) {
                            int at1 = Integer.parseInt(tok);
                            int nlp = Integer.parseInt(tokens[++i]);
                            lone.addLast(new int[]{nlp, at1});
                        }
                        continue block10;
                    }
                    case 25: {
                        Lst<int[]> bonds = new Lst<int[]>();
                        htData.put("bond", bonds);
                        while (!(tok = tokens[++i]).equals("END")) {
                            int order = "DTQ".indexOf(tok.charAt(0)) + 2;
                            int at1 = Integer.parseInt(tokens[++i]);
                            int at2 = Integer.parseInt(tokens[++i]);
                            bonds.addLast(new int[]{order, at1, at2});
                        }
                        continue block10;
                    }
                    case 30: {
                        Lst<int[]> threeCenter = new Lst<int[]>();
                        htData.put("3c", threeCenter);
                        while (!(tok = tokens[++i]).equals("END")) {
                            int order = "DTQ".indexOf(tok.charAt(0)) + 2;
                            int at1 = Integer.parseInt(tokens[++i]);
                            int at2 = Integer.parseInt(tokens[++i]);
                            int at3 = Integer.parseInt(tokens[++i]);
                            threeCenter.addLast(new int[]{order, at1, at2, at3});
                        }
                        continue block10;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            list.clear();
            return -1;
        }
        return n;
    }

    public boolean isOpenShell() {
        return this.haveBeta;
    }

    public static Map<String, Object> getStructureMap(Lst<Object> structureList, String type, int index) {
        if (type == null || structureList == null) {
            return null;
        }
        String spin = (type = type.toLowerCase()).indexOf("b") < 0 ? "alpha" : "beta";
        for (int i = 0; i < structureList.size(); ++i) {
            Map map = (Map)structureList.get(i);
            if (!spin.equals(map.get("spin")) || !type.equals(map.get("type")) || index >= 0 && index != (Integer)map.get("index")) continue;
            return map;
        }
        return null;
    }

    public boolean connectNBO(int modelIndex, String type) {
        try {
            if (type == null) {
                type = "alpha";
            }
            if ((type = type.toLowerCase()).length() == 0 || type.equals("46")) {
                type = "alpha";
            }
            Map<String, Object> map = this.vwr.ms.getModelAuxiliaryInfo(modelIndex);
            this.haveBeta = map.containsKey("isOpenShell");
            Lst list = (Lst)map.get("nboStructures");
            if (list == null || list.size() == 0) {
                return false;
            }
            int index = (type = type.toLowerCase()).indexOf("_");
            if (index > 0) {
                String fname;
                if (list.size() <= 2 && (fname = (String)map.get("fileName")) != null && !fname.endsWith(".nbo")) {
                    fname = fname.substring(0, fname.lastIndexOf(".")) + ".nbo";
                    this.getAllStructures(this.vwr.getAsciiFileOrNull(fname), list);
                }
                String[] tokens = PT.split(type, "_");
                index = PT.parseInt(tokens[1]) - 1;
                type = tokens[0];
            } else {
                index = 0;
            }
            Map<String, Object> structureMap = NBOParser.getStructureMap(list, type, index);
            if (structureMap == null || !this.setJmolLewisStructure(structureMap, modelIndex, index + 1)) {
                return false;
            }
            map.put("nboStructure", structureMap);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean setJmolLewisStructure(Map<String, Object> structureMap, int modelIndex, int resNo) {
        int a1;
        if (structureMap == null || modelIndex < 0) {
            return false;
        }
        String type = (String)structureMap.get("type");
        System.out.println("creating structure " + modelIndex + " " + type);
        Lst bonds = (Lst)structureMap.get("bond");
        Lst lonePairs = (Lst)structureMap.get("lone");
        int[][] matrix = (int[][])structureMap.get("matrix");
        int[] lplv = (int[])structureMap.get("lplv");
        int[] bondCounts = (int[])structureMap.get("bondCounts");
        boolean needLP = lplv == null;
        BS bsAtoms = this.vwr.ms.getModelAtomBitSetIncludingDeleted(modelIndex, false);
        int atomCount = bsAtoms.cardinality();
        int iatom0 = bsAtoms.nextSetBit(0);
        if (matrix != null && atomCount != matrix.length) {
            return false;
        }
        if (matrix != null) {
            NBOParser.dumpMatrix(type, resNo, matrix);
        }
        if (needLP) {
            lplv = new int[atomCount];
            structureMap.put("lplv", lplv);
            bondCounts = new int[atomCount];
            structureMap.put("bondCounts", bondCounts);
        }
        if (needLP) {
            int i;
            if (lonePairs != null) {
                i = lonePairs.size();
                while (--i >= 0) {
                    int[] na = (int[])lonePairs.get(i);
                    int nlp = na[0];
                    a1 = na[1] - 1;
                    lplv[a1] = nlp;
                }
            } else if (matrix != null) {
                i = atomCount;
                while (--i >= 0) {
                    lplv[i] = matrix[i][i];
                }
            }
        }
        this.vwr.ms.deleteModelBonds(modelIndex);
        short mad = this.vwr.ms.getDefaultMadFromOrder(1);
        if (bonds != null) {
            int i = bonds.size();
            while (--i >= 0) {
                int[] oab = (int[])bonds.get(i);
                a1 = iatom0 + oab[1] - 1;
                int a2 = iatom0 + oab[2] - 1;
                int order = oab[0];
                if (needLP) {
                    int n = a1;
                    bondCounts[n] = bondCounts[n] + order;
                    int n2 = a2;
                    bondCounts[n2] = bondCounts[n2] + order;
                }
                this.vwr.ms.bondAtoms(this.vwr.ms.at[a1], this.vwr.ms.at[a2], order, mad, bsAtoms, 0.0f, true, true);
            }
        } else if (matrix != null) {
            for (int i = 0; i < atomCount - 1; ++i) {
                int[] m = matrix[i];
                for (int j = i + 1; j < atomCount; ++j) {
                    int order = m[j];
                    if (order == 0) continue;
                    System.out.println("adding bond " + this.vwr.ms.at[i + iatom0] + " " + this.vwr.ms.at[j + iatom0]);
                    this.vwr.ms.bondAtoms(this.vwr.ms.at[i + iatom0], this.vwr.ms.at[j + iatom0], order, mad, null, 0.0f, false, true);
                    if (!needLP) continue;
                    int n = i;
                    bondCounts[n] = bondCounts[n] + order;
                    int n3 = j;
                    bondCounts[n3] = bondCounts[n3] + order;
                }
            }
        }
        int i = 0;
        int ia = bsAtoms.nextSetBit(0);
        while (ia >= 0) {
            Atom a = this.vwr.ms.at[ia];
            a.setValence(bondCounts[i]);
            a.setFormalCharge(0);
            int nH = this.vwr.ms.getMissingHydrogenCount(a, true);
            if (a.getElementNumber() == 6 && nH == 1 && (bondCounts[i] == 3 && lplv[i] % 10 == 0 || bondCounts[i] == 2)) {
                nH -= 2;
            }
            a.setFormalCharge(-nH);
            ia = bsAtoms.nextSetBit(ia + 1);
            ++i;
        }
        return true;
    }

    public String getNBOAtomLabel(Atom a) {
        int charge;
        String name = a.getAtomName();
        int modelIndex = a.getModelIndex();
        Map structureMap = (Map)this.vwr.ms.getModelAuxiliaryInfo(modelIndex).get("nboStructure");
        if (this.vwr == null || structureMap == null) {
            return name;
        }
        int[] lplv = (int[])structureMap.get("lplv");
        int i = a.i - this.vwr.ms.am[modelIndex].firstAtomIndex;
        boolean addFormalCharge = this.vwr.getBoolean(603979891);
        int n = charge = addFormalCharge ? this.vwr.ms.at[i].getFormalCharge() : 0;
        if (lplv[i] == 0 && charge == 0) {
            return name;
        }
        if (lplv[i] % 10 > 0) {
            name = "<sup>(" + lplv[i] % 10 + ")</sup>" + name;
        }
        if (lplv[i] >= 10) {
            name = "*" + name;
        }
        if (addFormalCharge && charge != 0) {
            name = name + "<sup>" + Math.abs(charge) + (charge > 0 ? "+" : (charge < 0 ? "-" : "")) + "</sup>";
        }
        return name;
    }
}

