/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.AbstractTracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;

public class TracingStrategyImpl
extends AbstractTracingStrategy {
    private final KtReferenceExpression reference;

    private TracingStrategyImpl(@NotNull KtReferenceExpression reference, @NotNull Call call2) {
        if (reference == null) {
            TracingStrategyImpl.$$$reportNull$$$0(0);
        }
        if (call2 == null) {
            TracingStrategyImpl.$$$reportNull$$$0(1);
        }
        super(reference, call2);
        this.reference = reference;
    }

    @NotNull
    public static TracingStrategy create(@NotNull KtReferenceExpression reference, @NotNull Call call2) {
        if (reference == null) {
            TracingStrategyImpl.$$$reportNull$$$0(2);
        }
        if (call2 == null) {
            TracingStrategyImpl.$$$reportNull$$$0(3);
        }
        TracingStrategyImpl tracingStrategyImpl = new TracingStrategyImpl(reference, call2);
        if (tracingStrategyImpl == null) {
            TracingStrategyImpl.$$$reportNull$$$0(4);
        }
        return tracingStrategyImpl;
    }

    @Override
    public void bindCall(@NotNull BindingTrace trace, @NotNull Call call2) {
        if (trace == null) {
            TracingStrategyImpl.$$$reportNull$$$0(5);
        }
        if (call2 == null) {
            TracingStrategyImpl.$$$reportNull$$$0(6);
        }
        trace.record(BindingContext.CALL, call2.getCalleeExpression(), call2);
    }

    @Override
    public <D extends CallableDescriptor> void bindReference(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall2) {
        DeclarationDescriptor storedReference;
        if (trace == null) {
            TracingStrategyImpl.$$$reportNull$$$0(7);
        }
        if (resolvedCall2 == null) {
            TracingStrategyImpl.$$$reportNull$$$0(8);
        }
        Object descriptor2 = resolvedCall2.getCandidateDescriptor();
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            descriptor2 = ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getCandidateDescriptor();
        }
        if (descriptor2 instanceof FakeCallableDescriptorForObject) {
            FakeCallableDescriptorForObject fakeCallableDescriptorForObject = (FakeCallableDescriptorForObject)descriptor2;
            descriptor2 = fakeCallableDescriptorForObject.getReferencedDescriptor();
            if (fakeCallableDescriptorForObject.getClassDescriptor().getCompanionObjectDescriptor() != null) {
                trace.record(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, this.reference, fakeCallableDescriptorForObject.getClassDescriptor());
            }
        }
        if ((storedReference = trace.get(BindingContext.REFERENCE_TARGET, this.reference)) == null || !ErrorUtils.isError(descriptor2)) {
            trace.record(BindingContext.REFERENCE_TARGET, this.reference, descriptor2);
        }
    }

    @Override
    public <D extends CallableDescriptor> void bindResolvedCall(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall2) {
        if (trace == null) {
            TracingStrategyImpl.$$$reportNull$$$0(9);
        }
        if (resolvedCall2 == null) {
            TracingStrategyImpl.$$$reportNull$$$0(10);
        }
        trace.record(BindingContext.RESOLVED_CALL, this.call, resolvedCall2);
    }

    @Override
    public void unresolvedReference(@NotNull BindingTrace trace) {
        if (trace == null) {
            TracingStrategyImpl.$$$reportNull$$$0(11);
        }
        trace.report(Errors.UNRESOLVED_REFERENCE.on(this.reference, this.reference));
    }

    @Override
    public <D extends CallableDescriptor> void unresolvedReferenceWrongReceiver(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> candidates2) {
        VariableDescriptor variableDescriptor;
        if (trace == null) {
            TracingStrategyImpl.$$$reportNull$$$0(12);
        }
        if (candidates2 == null) {
            TracingStrategyImpl.$$$reportNull$$$0(13);
        }
        if ((variableDescriptor = TracingStrategyImpl.isFunctionExpectedError(candidates2)) != null) {
            trace.report(Errors.FUNCTION_EXPECTED.on(this.reference, this.reference, variableDescriptor.getType()));
        } else {
            trace.report(Errors.UNRESOLVED_REFERENCE_WRONG_RECEIVER.on(this.reference, candidates2));
        }
    }

    @Nullable
    private static <D extends CallableDescriptor> VariableDescriptor isFunctionExpectedError(@NotNull Collection<? extends ResolvedCall<D>> candidates2) {
        if (candidates2 == null) {
            TracingStrategyImpl.$$$reportNull$$$0(14);
        }
        List variables = CollectionsKt.map(candidates2, TracingStrategyImpl::variableIfFunctionExpectedError);
        List distinctVariables = CollectionsKt.distinct((Iterable)variables);
        return (VariableDescriptor)CollectionsKt.singleOrNull((List)distinctVariables);
    }

    @Nullable
    private static <D extends CallableDescriptor> VariableDescriptor variableIfFunctionExpectedError(@NotNull ResolvedCall<D> candidate2) {
        if (candidate2 == null) {
            TracingStrategyImpl.$$$reportNull$$$0(15);
        }
        if (!(candidate2 instanceof VariableAsFunctionResolvedCall)) {
            return null;
        }
        ResolvedCall<VariableDescriptor> variableCall = ((VariableAsFunctionResolvedCall)((Object)candidate2)).getVariableCall();
        ResolvedCall<FunctionDescriptor> functionCall = ((VariableAsFunctionResolvedCall)((Object)candidate2)).getFunctionCall();
        KotlinType type2 = variableCall.getCandidateDescriptor().getType();
        boolean nonFunctionalVar = variableCall.getStatus().isSuccess() && !FunctionTypesKt.isFunctionType(type2);
        Call functionPsiCall = functionCall.getCall();
        if (nonFunctionalVar && CallResolverUtilKt.isInvokeCallOnVariable(functionPsiCall) && functionPsiCall.getValueArguments().isEmpty()) {
            return variableCall.getCandidateDescriptor();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyImpl";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "bindCall";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "bindReference";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "bindResolvedCall";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unresolvedReference";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "unresolvedReferenceWrongReceiver";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isFunctionExpectedError";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "variableIfFunctionExpectedError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

