/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CheckIrElementVisitor$WhenMappings;
import org.jetbrains.kotlin.backend.common.IrValidatorConfig;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012:\u0010\u0004\u001a6\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005j\u0002`\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020(H\u0016J\u001c\u0010)\u001a\u00020\f\"\u0004\b\u0000\u0010*2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H*0+H\u0016J\u0010\u0010,\u001a\u00020\f2\u0006\u0010$\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\f2\u0006\u0010$\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u00101\u001a\u00020\f2\u0006\u0010$\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\f2\u0006\u0010$\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\f2\u0006\u0010'\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020\f2\u0006\u0010$\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\f2\u0006\u0010$\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\f2\u0006\u0010$\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\f2\u0006\u0010$\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\f2\u0006\u0010$\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020\f2\u0006\u0010$\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020\f2\u0006\u0010$\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020\f2\u0006\u0010F\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020\f2\u0006\u0010$\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020\f2\u0006\u0010$\u001a\u00020KH\u0016J\u0010\u0010L\u001a\u00020\f2\u0006\u0010$\u001a\u00020MH\u0016J\u0010\u0010N\u001a\u00020\f2\u0006\u0010$\u001a\u00020OH\u0016J\u0010\u0010P\u001a\u00020\f2\u0006\u0010$\u001a\u00020QH\u0016J\u0010\u0010R\u001a\u00020\f2\u0006\u0010$\u001a\u00020SH\u0016J\u0010\u0010T\u001a\u00020\f2\u0006\u0010$\u001a\u00020UH\u0016J\u0014\u0010V\u001a\u00020\f*\u00020W2\u0006\u0010$\u001a\u000204H\u0002J\u0014\u0010X\u001a\u00020\f*\u0002042\u0006\u0010Y\u001a\u00020ZH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019RE\u0010\u0004\u001a6\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005j\u0002`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017\u00a8\u0006["}, d2={"Lorg/jetbrains/kotlin/backend/common/CheckIrElementVisitor;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "reportError", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lkotlin/ParameterName;", "name", "element", "", "message", "", "Lorg/jetbrains/kotlin/backend/common/ReportError;", "config", "Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lkotlin/jvm/functions/Function2;Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;)V", "getBuiltIns", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "checkedTypes", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getCheckedTypes", "()Ljava/util/Set;", "getConfig", "()Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;", "getReportError", "()Lkotlin/jvm/functions/Function2;", "set", "getSet", "checkType", "type", "visitBreakContinue", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreakContinue;", "visitCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitClass", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitConst", "T", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "visitDeclarationReference", "Lorg/jetbrains/kotlin/ir/expressions/IrDeclarationReference;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitElement", "visitEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "visitExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitInstanceInitializerCall", "Lorg/jetbrains/kotlin/ir/expressions/IrInstanceInitializerCall;", "visitLocalDelegatedPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrLocalDelegatedPropertyReference;", "visitLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "visitPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitSetVariable", "Lorg/jetbrains/kotlin/ir/expressions/IrSetVariable;", "visitStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "visitThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "ensureBound", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "ensureTypeIs", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "ir.backend.common"})
public final class CheckIrElementVisitor
implements IrElementVisitorVoid {
    @NotNull
    private final Set<IrElement> set;
    @NotNull
    private final Set<IrType> checkedTypes;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final Function2<IrElement, String, Unit> reportError;
    @NotNull
    private final IrValidatorConfig config;

    @NotNull
    public final Set<IrElement> getSet() {
        return this.set;
    }

    @NotNull
    public final Set<IrType> getCheckedTypes() {
        return this.checkedTypes;
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (this.config.getEnsureAllNodesAreDifferent()) {
            if (this.set.contains(element)) {
                this.reportError.invoke((Object)element, (Object)"Duplicate IR node");
            }
            this.set.add(element);
        }
    }

    private final void ensureTypeIs(@NotNull IrExpression $this$ensureTypeIs, KotlinType expectedType) {
        if (!this.config.getCheckTypes()) {
            return;
        }
        if (Intrinsics.areEqual((Object)expectedType, (Object)IrTypesKt.toKotlinType($this$ensureTypeIs.getType())) ^ true) {
            this.reportError.invoke((Object)$this$ensureTypeIs, (Object)("unexpected expression.type: expected " + expectedType + ", got " + IrTypesKt.toKotlinType($this$ensureTypeIs.getType())));
        }
    }

    private final void ensureBound(@NotNull IrSymbol $this$ensureBound, IrExpression expression2) {
        if (!$this$ensureBound.isBound() && !(expression2.getType() instanceof IrDynamicType)) {
            this.reportError.invoke((Object)expression2, (Object)("Unbound symbol " + $this$ensureBound));
        }
    }

    @Override
    public <T> void visitConst(@NotNull IrConst<T> expression2) {
        SimpleType simpleType2;
        Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
        IrConstKind<T> irConstKind = expression2.getKind();
        if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Null.INSTANCE)) {
            simpleType2 = this.builtIns.getNullableNothingType();
        } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Boolean.INSTANCE)) {
            simpleType2 = this.builtIns.getBooleanType();
        } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Char.INSTANCE)) {
            simpleType2 = this.builtIns.getCharType();
        } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Byte.INSTANCE)) {
            simpleType2 = this.builtIns.getByteType();
        } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Short.INSTANCE)) {
            simpleType2 = this.builtIns.getShortType();
        } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Int.INSTANCE)) {
            simpleType2 = this.builtIns.getIntType();
        } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Long.INSTANCE)) {
            simpleType2 = this.builtIns.getLongType();
        } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.String.INSTANCE)) {
            simpleType2 = this.builtIns.getStringType();
        } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Float.INSTANCE)) {
            simpleType2 = this.builtIns.getFloatType();
        } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Double.INSTANCE)) {
            simpleType2 = this.builtIns.getDoubleType();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"when (expression.kind) {\u2026tIns.doubleType\n        }");
        SimpleType naturalType = simpleType2;
        this.ensureTypeIs(expression2, naturalType);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
        IrExpression irExpression = expression2;
        SimpleType simpleType2 = this.builtIns.getStringType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"builtIns.stringType");
        this.ensureTypeIs(irExpression, simpleType2);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
        IrExpression irExpression = expression2;
        SimpleType simpleType2 = expression2.getDescriptor().getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"expression.descriptor.defaultType");
        this.ensureTypeIs(irExpression, simpleType2);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
        IrExpression irExpression = expression2;
        KotlinType kotlinType2 = expression2.getDescriptor().getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"expression.descriptor.type");
        this.ensureTypeIs(irExpression, kotlinType2);
    }

    @Override
    public void visitSetVariable(@NotNull IrSetVariable expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2);
        IrExpression irExpression = expression2;
        SimpleType simpleType2 = this.builtIns.getUnitType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"builtIns.unitType");
        this.ensureTypeIs(irExpression, simpleType2);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
        IrExpression irExpression = expression2;
        KotlinType kotlinType2 = expression2.getDescriptor().getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"expression.descriptor.type");
        this.ensureTypeIs(irExpression, kotlinType2);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
        IrExpression irExpression = expression2;
        SimpleType simpleType2 = this.builtIns.getUnitType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"builtIns.unitType");
        this.ensureTypeIs(irExpression, simpleType2);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
            KotlinType returnType2 = expression2.getDescriptor().getReturnType();
            if (returnType2 == null) {
                this.reportError.invoke((Object)expression2, (Object)(expression2.getDescriptor() + " return type is null"));
            } else {
                this.ensureTypeIs(expression2, returnType2);
            }
            IrClassSymbol irClassSymbol = expression2.getSuperQualifierSymbol();
            if (irClassSymbol == null) break block2;
            this.ensureBound(irClassSymbol, expression2);
        }
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
        IrExpression irExpression = expression2;
        SimpleType simpleType2 = this.builtIns.getUnitType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"builtIns.unitType");
        this.ensureTypeIs(irExpression, simpleType2);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
        IrExpression irExpression = expression2;
        SimpleType simpleType2 = this.builtIns.getUnitType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"builtIns.unitType");
        this.ensureTypeIs(irExpression, simpleType2);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
        IrExpression irExpression = expression2;
        SimpleType simpleType2 = this.builtIns.getUnitType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"builtIns.unitType");
        this.ensureTypeIs(irExpression, simpleType2);
        this.ensureBound(expression2.getClassSymbol(), expression2);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        KotlinType kotlinType2;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
        IrTypeOperator operator = expression2.getOperator();
        IrType typeOperand = expression2.getTypeOperand();
        switch (CheckIrElementVisitor$WhenMappings.$EnumSwitchMapping$0[operator.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                kotlinType2 = IrTypesKt.toKotlinType(typeOperand);
                break;
            }
            case 7: {
                kotlinType2 = IrTypesKt.toKotlinType(IrTypesKt.makeNullable$default(typeOperand, false, 1, null));
                break;
            }
            case 8: 
            case 9: {
                SimpleType simpleType2 = this.builtIns.getBooleanType();
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"builtIns.booleanType");
                kotlinType2 = simpleType2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        KotlinType naturalType = kotlinType2;
        if (operator == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT && !IrTypePredicatesKt.isUnit(typeOperand)) {
            this.reportError.invoke((Object)expression2, (Object)("typeOperand is " + RenderIrElementKt.render(typeOperand)));
        }
        this.ensureTypeIs(expression2, naturalType);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2) {
        Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
        IrExpression irExpression = loop2;
        SimpleType simpleType2 = this.builtIns.getUnitType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"builtIns.unitType");
        this.ensureTypeIs(irExpression, simpleType2);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
        Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
        IrExpression irExpression = jump;
        SimpleType simpleType2 = this.builtIns.getNothingType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"builtIns.nothingType");
        this.ensureTypeIs(irExpression, simpleType2);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
        IrExpression irExpression = expression2;
        SimpleType simpleType2 = this.builtIns.getNothingType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"builtIns.nothingType");
        this.ensureTypeIs(irExpression, simpleType2);
        this.ensureBound(expression2.getReturnTargetSymbol(), expression2);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
        IrExpression irExpression = expression2;
        SimpleType simpleType2 = this.builtIns.getNothingType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"builtIns.nothingType");
        this.ensureTypeIs(irExpression, simpleType2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitClass(@NotNull IrClass declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration);
        if (this.config.getCheckDescriptors() && !IrUtilsKt.isAnnotationClass(declaration)) {
            void $this$mapTo$iv$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = ResolutionScope.DefaultImpls.getContributedDescriptors$default(declaration.getDescriptor().getUnsubstitutedMemberScope(), null, null, 3, null);
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof CallableMemberDescriptor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List allDescriptors2 = (List)destination$iv$iv;
            Iterable $this$map$iv = declaration.getDeclarations();
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrDeclaration irDeclaration = (IrDeclaration)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                DeclarationDescriptor declarationDescriptor = it.getDescriptor();
                collection.add(declarationDescriptor);
            }
            List presentDescriptors = (List)destination$iv$iv2;
            List missingDescriptors = CollectionsKt.minus((Iterable)allDescriptors2, (Iterable)presentDescriptors);
            Collection collection = missingDescriptors;
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.reportError.invoke((Object)declaration, (Object)("Missing declarations for descriptors:\n" + CollectionsKt.joinToString$default((Iterable)missingDescriptors, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)));
            }
        }
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration) {
        int i;
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
        boolean bl = false;
        for (IrDeclarationWithName p : (Iterable)declaration.getValueParameters()) {
            if (p.getIndex() != i) {
                this.reportError.invoke((Object)declaration, (Object)("Inconsistent index of value parameter " + p.getIndex() + " != " + i));
            }
            ++i;
        }
        i = 0;
        for (IrDeclarationWithName p : (Iterable)declaration.getTypeParameters()) {
            if (p.getIndex() != i) {
                this.reportError.invoke((Object)declaration, (Object)("Inconsistent index of type parameter " + p.getIndex() + " != " + i));
            }
            ++i;
        }
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
        if (DescriptorUtilsKt.isEffectivelyExternal(expression2.getDescriptor())) {
            return;
        }
        if (expression2 instanceof IrFieldAccessExpression) {
            IrType receiverType;
            IrExpression irExpression = ((IrFieldAccessExpression)expression2).getReceiver();
            IrType irType = receiverType = irExpression != null ? irExpression.getType() : null;
            if (receiverType instanceof IrDynamicType) {
                return;
            }
        }
        this.ensureBound(expression2.getSymbol(), expression2);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
        this.ensureBound(expression2.getSymbol(), expression2);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
        this.ensureBound(expression2.getSymbol(), expression2);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
            IrFieldSymbol irFieldSymbol = expression2.getField();
            if (irFieldSymbol != null) {
                this.ensureBound(irFieldSymbol, expression2);
            }
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getGetter();
            if (irSimpleFunctionSymbol != null) {
                this.ensureBound(irSimpleFunctionSymbol, expression2);
            }
            IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = expression2.getSetter();
            if (irSimpleFunctionSymbol2 == null) break block2;
            this.ensureBound(irSimpleFunctionSymbol2, expression2);
        }
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
            this.ensureBound(expression2.getDelegate(), expression2);
            this.ensureBound(expression2.getGetter(), expression2);
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getSetter();
            if (irSimpleFunctionSymbol == null) break block0;
            this.ensureBound(irSimpleFunctionSymbol, expression2);
        }
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        this.checkType(expression2.getType(), expression2);
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
    }

    private final void checkType(IrType type2, IrElement element) {
        if (this.checkedTypes.contains(type2)) {
            return;
        }
        IrType irType = type2;
        if (irType instanceof IrSimpleType && !((IrSimpleType)type2).getClassifier().isBound()) {
            this.reportError.invoke((Object)element, (Object)("Type: " + RenderIrElementKt.render(type2) + " has unbound classifier"));
        }
        this.checkedTypes.add(type2);
    }

    @NotNull
    public final KotlinBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    @NotNull
    public final Function2<IrElement, String, Unit> getReportError() {
        return this.reportError;
    }

    @NotNull
    public final IrValidatorConfig getConfig() {
        return this.config;
    }

    public CheckIrElementVisitor(@NotNull KotlinBuiltIns builtIns2, @NotNull Function2<? super IrElement, ? super String, Unit> reportError2, @NotNull IrValidatorConfig config) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)builtIns2, (String)"builtIns");
        Intrinsics.checkParameterIsNotNull(reportError2, (String)"reportError");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.builtIns = builtIns2;
        this.reportError = reportError2;
        this.config = config;
        CheckIrElementVisitor checkIrElementVisitor = this;
        boolean bl = false;
        checkIrElementVisitor.set = set = (Set)new LinkedHashSet();
        checkIrElementVisitor = this;
        bl = false;
        checkIrElementVisitor.checkedTypes = set = (Set)new LinkedHashSet();
    }

    @Override
    public void visitElement(@NotNull IrElement element, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
    }

    @Override
    public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
    }

    @Override
    public void visitSetVariable(@NotNull IrSetVariable expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2, data);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body, data);
    }

    @Override
    public void visitBody(@NotNull IrBody body) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body);
    }

    @Override
    public void visitBody(@NotNull IrBody body, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body, data);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch) {
        Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump) {
        Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch) {
        Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump) {
        Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclaration declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclaration declaration, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
        Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch) {
        Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body, data);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
    }

    @Override
    public void visitField(@NotNull IrField declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
    }

    @Override
    public void visitField(@NotNull IrField declaration, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread) {
        Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body, data);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry) {
        Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data);
    }

    @Override
    public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
        Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
    }
}

