/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.filter;

import freemind.controller.Controller;
import freemind.controller.FreeMindToolBar;
import freemind.controller.filter.DefaultFilter;
import freemind.controller.filter.Filter;
import freemind.controller.filter.FilterComposerDialog;
import freemind.controller.filter.FilterController;
import freemind.controller.filter.condition.Condition;
import freemind.controller.filter.condition.NoFilteringCondition;
import freemind.controller.filter.condition.SelectedViewCondition;
import freemind.main.Resources;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

class FilterToolbar
extends FreeMindToolBar {
    private FilterController fc;
    private FilterComposerDialog filterDialog = null;
    private JComboBox activeFilterConditionComboBox;
    private JCheckBox showAncestors;
    private JCheckBox showDescendants;
    private Filter activeFilter;
    private JButton btnEdit;
    private JButton btnUnfoldAncestors;
    private Controller c;
    private static Color filterInactiveColor = null;
    private String pathToFilterFile;
    private FilterChangeListener filterChangeListener;

    FilterToolbar(Controller c) {
        this.fc = c.getFilterController();
        this.c = c;
        this.setVisible(false);
        this.setFocusable(false);
        this.setRollover(true);
        this.filterChangeListener = new FilterChangeListener();
        this.add(new JLabel(Resources.getInstance().getResourceString("filter_toolbar") + " "));
        this.activeFilter = null;
        this.activeFilterConditionComboBox = new JComboBox(){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.activeFilterConditionComboBox.setFocusable(false);
        this.pathToFilterFile = c.getFrame().getFreemindDirectory() + File.separator + "auto." + "mmfilter";
        this.btnEdit = this.add(new EditFilterAction());
        this.add(this.btnEdit);
        this.btnUnfoldAncestors = this.add(new UnfoldAncestorsAction());
        this.btnUnfoldAncestors.setToolTipText(Resources.getInstance().getResourceString("filter_unfold_ancestors"));
        this.add(this.btnUnfoldAncestors);
        this.showAncestors = new JCheckBox(Resources.getInstance().getResourceString("filter_show_ancestors"), true);
        this.add(this.showAncestors);
        this.showAncestors.getModel().addActionListener(this.filterChangeListener);
        this.showDescendants = new JCheckBox(Resources.getInstance().getResourceString("filter_show_descendants"), false);
        this.add(this.showDescendants);
        this.showDescendants.getModel().addActionListener(this.filterChangeListener);
    }

    void addStandardConditions() {
        DefaultComboBoxModel filterConditionModel = this.fc.getFilterConditionModel();
        Condition noFiltering = NoFilteringCondition.createCondition();
        filterConditionModel.insertElementAt(noFiltering, 0);
        filterConditionModel.insertElementAt(SelectedViewCondition.CreateCondition(), 1);
        if (filterConditionModel.getSelectedItem() == null) {
            filterConditionModel.setSelectedItem(noFiltering);
        }
    }

    void initConditions() {
        try {
            this.fc.loadConditions(this.fc.getFilterConditionModel(), this.pathToFilterFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addStandardConditions();
        this.activeFilterConditionComboBox.setSelectedIndex(0);
        this.activeFilterConditionComboBox.setRenderer(this.fc.getConditionRenderer());
        this.add(this.activeFilterConditionComboBox);
        this.add(Box.createHorizontalGlue());
        this.activeFilterConditionComboBox.addItemListener(this.filterChangeListener);
        this.activeFilterConditionComboBox.addPropertyChangeListener(this.filterChangeListener);
    }

    public void resetFilter() {
        this.activeFilter = null;
    }

    private Condition getSelectedCondition() {
        return (Condition)this.activeFilterConditionComboBox.getSelectedItem();
    }

    void setMapFilter() {
        MindMap map;
        if (this.activeFilter == null) {
            this.activeFilter = new DefaultFilter(this.getSelectedCondition(), this.showAncestors.getModel().isSelected(), this.showDescendants.getModel().isSelected());
        }
        if ((map = this.fc.getMap()) != null) {
            map.setFilter(this.activeFilter);
        }
    }

    FilterComposerDialog getFilterDialog() {
        return this.filterDialog;
    }

    void mapChanged(MindMap newMap) {
        if (!this.isVisible()) {
            return;
        }
        if (newMap != null) {
            Filter filter = newMap.getFilter();
            if (filter != this.activeFilter) {
                this.activeFilter = filter;
                this.activeFilterConditionComboBox.setSelectedItem(filter.getCondition());
                this.showAncestors.setSelected(filter.areAncestorsShown());
                this.showDescendants.setSelected(filter.areDescendantsShown());
            }
        } else {
            Object filter = null;
            this.activeFilterConditionComboBox.setSelectedIndex(0);
        }
    }

    private void refreshMap() {
        this.fc.refreshMap();
    }

    void saveConditions() {
        try {
            this.fc.saveConditions(this.fc.getFilterConditionModel(), this.pathToFilterFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    ComboBoxModel getFilterConditionModel() {
        return this.activeFilterConditionComboBox.getModel();
    }

    void setFilterConditionModel(ComboBoxModel filterConditionModel) {
        this.activeFilterConditionComboBox.setModel(filterConditionModel);
    }

    private class UnfoldAncestorsAction
    extends AbstractAction {
        UnfoldAncestorsAction() {
            super("", new ImageIcon(Resources.getInstance().getResource("images/unfold.png")));
        }

        private void unfoldAncestors(MindMapNode parent) {
            ListIterator i = parent.childrenUnfolded();
            while (i.hasNext()) {
                MindMapNode node = (MindMapNode)i.next();
                if (!FilterToolbar.this.showDescendants.isSelected() && !node.getFilterInfo().isAncestor()) continue;
                this.setFolded(node, false);
                this.unfoldAncestors(node);
            }
        }

        private void setFolded(MindMapNode node, boolean state) {
            if (node.hasChildren() && node.isFolded() != state) {
                FilterToolbar.this.c.getModeController().setFolded(node, state);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FilterToolbar.this.getSelectedCondition() != null) {
                this.unfoldAncestors(FilterToolbar.this.c.getModel().getRootNode());
            }
        }
    }

    private class EditFilterAction
    extends AbstractAction {
        EditFilterAction() {
            super("", new ImageIcon(Resources.getInstance().getResource("images/Btn_edit.gif")));
            this.putValue("ShortDescription", Resources.getInstance().getResourceString("filter_edit_description"));
        }

        private FilterComposerDialog getFilterDialog() {
            if (FilterToolbar.this.filterDialog == null) {
                FilterToolbar.this.filterDialog = new FilterComposerDialog(FilterToolbar.this.c, FilterToolbar.this);
                this.getFilterDialog().setLocationRelativeTo(FilterToolbar.this);
            }
            return FilterToolbar.this.filterDialog;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Object selectedItem = FilterToolbar.this.getFilterConditionModel().getSelectedItem();
            if (selectedItem != null) {
                this.getFilterDialog().setSelectedItem(selectedItem);
            }
            this.getFilterDialog().show();
        }
    }

    private class FilterChangeListener
    extends AbstractAction
    implements ItemListener,
    PropertyChangeListener {
        @Override
        public void actionPerformed(ActionEvent arg0) {
            FilterToolbar.this.resetFilter();
            FilterToolbar.this.setMapFilter();
            FilterToolbar.this.refreshMap();
            DefaultFilter.selectVisibleNode(FilterToolbar.this.c.getView());
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                this.filterChanged();
            }
        }

        private void filterChanged() {
            FilterToolbar.this.resetFilter();
            FilterToolbar.this.setMapFilter();
            MindMap map = FilterToolbar.this.fc.getMap();
            if (map != null) {
                FilterToolbar.this.activeFilter.applyFilter(FilterToolbar.this.c);
                FilterToolbar.this.refreshMap();
                DefaultFilter.selectVisibleNode(FilterToolbar.this.c.getView());
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("model")) {
                FilterToolbar.this.addStandardConditions();
                this.filterChanged();
            }
        }
    }
}

