/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.seqno.RetentionLeases;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.transport.TransportRequest;

public class RecoveryTranslogOperationsRequest
extends TransportRequest {
    private final long recoveryId;
    private final ShardId shardId;
    private final List<Translog.Operation> operations;
    private final int totalTranslogOps;
    private final long maxSeenAutoIdTimestampOnPrimary;
    private final long maxSeqNoOfUpdatesOrDeletesOnPrimary;
    private final RetentionLeases retentionLeases;
    private final long mappingVersionOnPrimary;

    RecoveryTranslogOperationsRequest(long recoveryId, ShardId shardId, List<Translog.Operation> operations, int totalTranslogOps, long maxSeenAutoIdTimestampOnPrimary, long maxSeqNoOfUpdatesOrDeletesOnPrimary, RetentionLeases retentionLeases, long mappingVersionOnPrimary) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.operations = operations;
        this.totalTranslogOps = totalTranslogOps;
        this.maxSeenAutoIdTimestampOnPrimary = maxSeenAutoIdTimestampOnPrimary;
        this.maxSeqNoOfUpdatesOrDeletesOnPrimary = maxSeqNoOfUpdatesOrDeletesOnPrimary;
        this.retentionLeases = retentionLeases;
        this.mappingVersionOnPrimary = mappingVersionOnPrimary;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public List<Translog.Operation> operations() {
        return this.operations;
    }

    public int totalTranslogOps() {
        return this.totalTranslogOps;
    }

    public long maxSeenAutoIdTimestampOnPrimary() {
        return this.maxSeenAutoIdTimestampOnPrimary;
    }

    public long maxSeqNoOfUpdatesOrDeletesOnPrimary() {
        return this.maxSeqNoOfUpdatesOrDeletesOnPrimary;
    }

    public RetentionLeases retentionLeases() {
        return this.retentionLeases;
    }

    long mappingVersionOnPrimary() {
        return this.mappingVersionOnPrimary;
    }

    RecoveryTranslogOperationsRequest(StreamInput in) throws IOException {
        super.readFrom(in);
        this.recoveryId = in.readLong();
        this.shardId = new ShardId(in);
        this.operations = Translog.readOperations(in, "recovery");
        this.totalTranslogOps = in.readVInt();
        this.maxSeenAutoIdTimestampOnPrimary = in.getVersion().onOrAfter(Version.V_6_5_0) ? in.readZLong() : -1L;
        this.maxSeqNoOfUpdatesOrDeletesOnPrimary = in.getVersion().onOrAfter(Version.V_6_5_0) ? in.readZLong() : -2L;
        this.retentionLeases = in.getVersion().onOrAfter(Version.V_6_7_0) ? new RetentionLeases(in) : RetentionLeases.EMPTY;
        this.mappingVersionOnPrimary = in.getVersion().onOrAfter(Version.V_7_2_0) ? in.readVLong() : Long.MAX_VALUE;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        Translog.writeOperations(out, this.operations);
        out.writeVInt(this.totalTranslogOps);
        if (out.getVersion().onOrAfter(Version.V_6_5_0)) {
            out.writeZLong(this.maxSeenAutoIdTimestampOnPrimary);
        }
        if (out.getVersion().onOrAfter(Version.V_6_5_0)) {
            out.writeZLong(this.maxSeqNoOfUpdatesOrDeletesOnPrimary);
        }
        if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
            this.retentionLeases.writeTo(out);
        }
        if (out.getVersion().onOrAfter(Version.V_7_2_0)) {
            out.writeVLong(this.mappingVersionOnPrimary);
        }
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
    }
}

