/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.segmentstore;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.AbstractSegmentStoreAnalysisModule;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class AbstractSegmentStoreAnalysisEventBasedModule
extends AbstractSegmentStoreAnalysisModule {
    private @Nullable ITmfEventRequest fOngoingRequest = null;

    protected abstract AbstractSegmentStoreAnalysisRequest createAnalysisRequest(ISegmentStore<ISegment> var1, IProgressMonitor var2);

    protected void canceling() {
        ITmfEventRequest req = this.fOngoingRequest;
        if (req != null && !req.isCompleted()) {
            req.cancel();
        }
    }

    @Override
    protected boolean buildAnalysisSegments(ISegmentStore<ISegment> segmentStore, IProgressMonitor monitor) throws TmfAnalysisException {
        ITmfTrace trace = (ITmfTrace)NonNullUtils.checkNotNull((Object)this.getTrace());
        Object req = this.fOngoingRequest;
        if (req != null && !req.isCompleted()) {
            req.cancel();
        }
        this.fOngoingRequest = req = this.createAnalysisRequest(segmentStore, monitor);
        trace.sendRequest(req);
        try {
            req.waitForCompletion();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !req.isCancelled() && !req.isFailed();
    }

    protected abstract class AbstractSegmentStoreAnalysisRequest
    extends TmfEventRequest {
        private final ISegmentStore<ISegment> fSegmentStore;

        public AbstractSegmentStoreAnalysisRequest(ISegmentStore<ISegment> segmentStore) {
            super(ITmfEvent.class, TmfTimeRange.ETERNITY, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND, AbstractSegmentStoreAnalysisEventBasedModule.this.getDependencyLevel());
            this.fSegmentStore = segmentStore;
        }

        public ISegmentStore<ISegment> getSegmentStore() {
            return this.fSegmentStore;
        }

        public void handleSuccess() {
            super.handleSuccess();
            this.closeSegmentStore(false);
        }

        public void handleFailure() {
            super.handleFailure();
            this.closeSegmentStore(true);
        }

        public void handleCancel() {
            super.handleCancel();
            this.closeSegmentStore(true);
        }

        private void closeSegmentStore(boolean deleteFiles) {
            this.fSegmentStore.close(deleteFiles);
        }
    }
}

