/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.ui.view;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelRoot;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiMessages;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiPlugin;
import org.eclipse.linuxtools.internal.oprofile.ui.view.OprofileViewContentProvider;
import org.eclipse.linuxtools.internal.oprofile.ui.view.OprofileViewDeleteSessionAction;
import org.eclipse.linuxtools.internal.oprofile.ui.view.OprofileViewDoubleClickListener;
import org.eclipse.linuxtools.internal.oprofile.ui.view.OprofileViewLabelProvider;
import org.eclipse.linuxtools.internal.oprofile.ui.view.OprofileViewLogReaderAction;
import org.eclipse.linuxtools.internal.oprofile.ui.view.OprofileViewRefreshAction;
import org.eclipse.linuxtools.internal.oprofile.ui.view.OprofileViewSaveDefaultSessionAction;
import org.eclipse.linuxtools.internal.oprofile.ui.view.OprofileViewSortAction;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelRoot;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelSession;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class OprofileView
extends ViewPart
implements ISelectionChangedListener {
    private TreeViewer viewer;
    private IAction deleteSessionAction;
    private IAction saveDefaultSessionAction;

    public void createPartControl(Composite parent) {
        this.createTreeViewer(parent);
        this.createActionMenu();
        OprofileUiPlugin.getDefault().setOprofileView(this);
    }

    private void createTreeViewer(Composite parent) {
        this.viewer = new TreeViewer(parent, 4);
        this.viewer.setContentProvider((IContentProvider)new OprofileViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new OprofileViewLabelProvider());
        this.viewer.addDoubleClickListener((IDoubleClickListener)new OprofileViewDoubleClickListener());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void createActionMenu() {
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add((IAction)new OprofileViewLogReaderAction());
        manager.add((IAction)new OprofileViewRefreshAction());
        this.saveDefaultSessionAction = new OprofileViewSaveDefaultSessionAction();
        manager.add(this.saveDefaultSessionAction);
        this.deleteSessionAction = new OprofileViewDeleteSessionAction(this.getTreeViewer());
        manager.add(this.deleteSessionAction);
        MenuManager sortMenu = new MenuManager(OprofileUiMessages.getString("view.menu.sortby.label"));
        UiModelRoot.SortType[] sortTypeArray = UiModelRoot.SortType.values();
        int n = sortTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            UiModelRoot.SortType s = sortTypeArray[n2];
            sortMenu.add((IAction)new OprofileViewSortAction(s, OprofileViewSortAction.sortTypeMap.get((Object)s)));
            ++n2;
        }
        manager.add((IContributionItem)sortMenu);
    }

    private TreeViewer getTreeViewer() {
        return this.viewer;
    }

    public void refreshView() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.oprofile.ui.OProfileView");
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        IRunnableWithProgress refreshRunner = monitor -> {
            monitor.beginTask(OprofileUiMessages.getString("view.dialog.parsing.text"), 2);
            OpModelRoot dataModelRoot = OpModelRoot.getDefault();
            dataModelRoot.refreshModel();
            monitor.worked(1);
            UiModelRoot UiRoot = UiModelRoot.getDefault();
            UiRoot.refreshModel();
            Display.getDefault().asyncExec(() -> OprofileUiPlugin.getDefault().getOprofileView().getTreeViewer().setInput((Object)UiRoot));
            monitor.worked(1);
            monitor.done();
        };
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(null);
        try {
            dialog.run(true, false, refreshRunner);
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ITreeSelection tsl = this.viewer.getStructuredSelection();
        if (tsl.getFirstElement() instanceof UiModelSession) {
            if (!this.deleteSessionAction.isEnabled()) {
                this.deleteSessionAction.setEnabled(true);
            }
            if (((UiModelSession)tsl.getFirstElement()).isDefaultSession() && !this.saveDefaultSessionAction.isEnabled()) {
                this.saveDefaultSessionAction.setEnabled(true);
            }
        } else {
            this.deleteSessionAction.setEnabled(false);
            this.saveDefaultSessionAction.setEnabled(false);
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
    }
}

