/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IBaseEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ILoggerInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IUstProviderInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.UstProviderInfo;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.BaseEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.BaseLoggerComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.UstProviderPropertySource;
import org.eclipse.ui.views.properties.IPropertySource;

public class UstProviderComponent
extends TraceControlComponent {
    private static final String USTL_PROVIDER_ICON_FILE = "icons/obj16/targets.gif";
    private static final String LTTNG_JUL_USER_EVENT = "lttng_jul:user_event";
    private static final String LTTNG_JUL_SYS_EVENT = "lttng_jul:sys_event";
    private static final String LTTNG_LOG4J_USER_EVENT = "lttng_log4j:user_event";
    private static final String LTTNG_LOG4J_SYS_EVENT = "lttng_log4j:sys_event";
    private static final String LTTNG_JUL_EVENT = "lttng_jul:event";
    private static final String LTTNG_LOG4J_EVENT = "lttng_log4j:event";
    private static final String LTTNG_PYTHON_EVENT = "lttng_python:event";
    private IUstProviderInfo fProviderInfo = null;

    public UstProviderComponent(String name, ITraceControlComponent parent) {
        super(name, parent);
        this.setImage(USTL_PROVIDER_ICON_FILE);
        this.setToolTip(Messages.TraceControl_ProviderDisplayName);
        this.fProviderInfo = new UstProviderInfo(name);
    }

    public void setUstProvider(IUstProviderInfo providerInfo) {
        this.fProviderInfo = providerInfo;
        IBaseEventInfo[] events = providerInfo.getEvents();
        ArrayList<ITraceControlComponent> eventComponents = new ArrayList<ITraceControlComponent>();
        int i = 0;
        while (i < events.length) {
            BaseEventComponent component = new BaseEventComponent(events[i].getName(), this);
            component.setEventInfo(events[i]);
            if (!(events[i].getName().equals(LTTNG_JUL_USER_EVENT) || events[i].getName().equals(LTTNG_JUL_SYS_EVENT) || events[i].getName().equals(LTTNG_LOG4J_USER_EVENT) || events[i].getName().equals(LTTNG_LOG4J_SYS_EVENT) || events[i].getName().equals(LTTNG_JUL_EVENT) || events[i].getName().equals(LTTNG_LOG4J_EVENT) || events[i].getName().equals(LTTNG_PYTHON_EVENT))) {
                eventComponents.add(component);
            }
            ++i;
        }
        this.setChildren(eventComponents);
        List loggers = providerInfo.getLoggers();
        ArrayList<ITraceControlComponent> loggerComponents = new ArrayList<ITraceControlComponent>();
        for (ILoggerInfo logger : loggers) {
            BaseLoggerComponent component = new BaseLoggerComponent(logger.getName(), this);
            component.setLoggerInfo(logger);
            if (logger.getName().equals("global")) continue;
            loggerComponents.add(component);
        }
        this.setChildren(loggerComponents);
        StringBuilder providerName = new StringBuilder();
        providerName.append(String.valueOf(this.getName()) + " [PID=" + this.fProviderInfo.getPid() + "]");
        if (!loggerComponents.isEmpty()) {
            providerName.append(" (With logger)");
        }
        this.setName(providerName.toString());
    }

    public int getPid() {
        return this.fProviderInfo.getPid();
    }

    public void setPid(int pid) {
        this.fProviderInfo.setPid(pid);
    }

    public List<ITraceControlComponent> getLoggerComponents(TraceDomainType domain) {
        return this.getChildren(BaseLoggerComponent.class).stream().filter(loggerComp -> domain.equals((Object)((BaseLoggerComponent)loggerComp).getDomain())).collect(Collectors.toList());
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySource.class) {
            return adapter.cast(new UstProviderPropertySource(this));
        }
        return null;
    }
}

