/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.edit;

import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.oracle.OracleMessages;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableConstraint;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableForeignKey;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableForeignKeyColumn;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLForeignKeyManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditForeignKeyPage;

public class OracleForeignKeyManager
extends SQLForeignKeyManager<OracleTableForeignKey, OracleTableBase> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleTableForeignKey> getObjectsCache(OracleTableForeignKey object) {
        return ((OracleTableBase)object.getParentObject()).getSchema().foreignKeyCache;
    }

    protected OracleTableForeignKey createDatabaseObject(final DBRProgressMonitor monitor, DBECommandContext context, Object container, Object from, Map<String, Object> options) {
        OracleTableBase table = (OracleTableBase)container;
        final OracleTableForeignKey foreignKey = new OracleTableForeignKey(table, null, null, null, DBSForeignKeyModifyRule.NO_ACTION);
        return (OracleTableForeignKey)((Object)new UITask<OracleTableForeignKey>(){

            protected OracleTableForeignKey runTask() {
                EditForeignKeyPage editPage = new EditForeignKeyPage(OracleMessages.edit_oracle_foreign_key_manager_dialog_title, (DBSEntityAssociation)foreignKey, new DBSForeignKeyModifyRule[]{DBSForeignKeyModifyRule.NO_ACTION, DBSForeignKeyModifyRule.CASCADE, DBSForeignKeyModifyRule.RESTRICT, DBSForeignKeyModifyRule.SET_NULL, DBSForeignKeyModifyRule.SET_DEFAULT});
                if (!editPage.edit()) {
                    return null;
                }
                foreignKey.setReferencedConstraint((OracleTableConstraint)editPage.getUniqueConstraint());
                foreignKey.setName(OracleForeignKeyManager.this.getNewConstraintName(monitor, foreignKey));
                foreignKey.setDeleteRule(editPage.getOnDeleteRule());
                int colIndex = 1;
                for (EditForeignKeyPage.FKColumnInfo tableColumn : editPage.getColumns()) {
                    foreignKey.addColumn(new OracleTableForeignKeyColumn(foreignKey, (OracleTableColumn)tableColumn.getOwnColumn(), colIndex++));
                }
                return foreignKey;
            }
        }.execute());
    }
}

