/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataType;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EntityEditPage;
import org.jkiss.utils.CommonUtils;

public class OracleDataTypeManager
extends SQLObjectEditor<OracleDataType, OracleSchema> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleDataType> getObjectsCache(OracleDataType object) {
        return object.getSchema().dataTypeCache;
    }

    protected OracleDataType createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        final OracleSchema schema = (OracleSchema)container;
        return (OracleDataType)new UITask<OracleDataType>(){

            protected OracleDataType runTask() {
                EntityEditPage editPage = new EntityEditPage((DBPDataSource)schema.getDataSource(), DBSEntityType.TYPE);
                if (!editPage.edit()) {
                    return null;
                }
                OracleDataType dataType = new OracleDataType(schema, editPage.getEntityName(), false);
                dataType.setObjectDefinitionText("TYPE " + dataType.getName() + " AS OBJECT\n" + "(\n" + ")");
                return dataType;
            }
        }.execute();
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand objectCreateCommand, Map<String, Object> options) {
        this.createOrReplaceProcedureQuery(actions, (OracleDataType)objectCreateCommand.getObject());
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand objectDeleteCommand, Map<String, Object> options) {
        OracleDataType object = (OracleDataType)objectDeleteCommand.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop type", "DROP TYPE " + object.getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand objectChangeCommand, Map<String, Object> options) {
        this.createOrReplaceProcedureQuery(actionList, (OracleDataType)objectChangeCommand.getObject());
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    private void createOrReplaceProcedureQuery(List<DBEPersistAction> actionList, OracleDataType dataType) {
        String body;
        String header = OracleUtils.normalizeSourceName(dataType, false);
        if (!CommonUtils.isEmpty((String)header)) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Create type header", "CREATE OR REPLACE " + header));
        }
        if (!CommonUtils.isEmpty((String)(body = OracleUtils.normalizeSourceName(dataType, true)))) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Create type body", "CREATE OR REPLACE " + body));
        }
        OracleUtils.addSchemaChangeActions(actionList, dataType);
    }
}

