/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.utils.CommonUtils;

public class GlobalProxySelector
extends ProxySelector {
    private static final Log log = Log.getLog(GlobalProxySelector.class);
    private static final String[] LOCAL_HOSTS = new String[]{"localhost", "127.0.0.1"};
    private final ProxySelector parent;

    public GlobalProxySelector(ProxySelector parent) {
        this.parent = parent;
    }

    @Override
    public List<Proxy> select(URI uri) {
        DBPDataSourceContainer activeContext;
        String scheme = uri.getScheme();
        if (CommonUtils.isEmpty((String)scheme)) {
            return this.parent.select(uri);
        }
        scheme.startsWith("http");
        String host = uri.getHost();
        if (CommonUtils.isEmpty((String)host)) {
            return this.parent.select(uri);
        }
        int port = uri.getPort();
        String path = uri.getPath();
        if ("socket".equals(scheme) && (activeContext = DBExecUtils.findConnectionContext(host, port, path)) != null) {
            ArrayList<Proxy> proxies = null;
            for (DBWHandlerConfiguration networkHandler : activeContext.getConnectionConfiguration().getHandlers()) {
                if (!networkHandler.isEnabled() || networkHandler.getType() != DBWHandlerType.PROXY) continue;
                Map<String, String> proxyProps = networkHandler.getProperties();
                String proxyHost = proxyProps.get("socks-host");
                String proxyPort = proxyProps.get("socks-port");
                if (CommonUtils.isEmpty((String)proxyHost)) continue;
                int portNumber = 1080;
                if (!CommonUtils.isEmpty((String)proxyPort)) {
                    try {
                        portNumber = Integer.parseInt(proxyPort);
                    }
                    catch (NumberFormatException e) {
                        log.warn("Bad proxy port number", e);
                    }
                }
                InetSocketAddress proxyAddr = new InetSocketAddress(proxyHost, portNumber);
                Proxy proxy = new Proxy(Proxy.Type.SOCKS, proxyAddr);
                if (proxies == null) {
                    proxies = new ArrayList<Proxy>();
                }
                proxies.add(proxy);
                log.debug("Use SOCKS proxy [" + proxyAddr + "]");
            }
            if (proxies != null) {
                return proxies;
            }
        }
        return this.parent.select(uri);
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        this.parent.connectFailed(uri, sa, ioe);
    }
}

