/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.io.File;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.MySQLConstants;
import org.jkiss.dbeaver.ext.mysql.MySQLDataSourceProvider;
import org.jkiss.dbeaver.ext.mysql.MySQLUtils;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCharset;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCollation;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSourceInfo;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDialect;
import org.jkiss.dbeaver.ext.mysql.model.MySQLEngine;
import org.jkiss.dbeaver.ext.mysql.model.MySQLHelpProvider;
import org.jkiss.dbeaver.ext.mysql.model.MySQLParameter;
import org.jkiss.dbeaver.ext.mysql.model.MySQLPrivilege;
import org.jkiss.dbeaver.ext.mysql.model.MySQLStructureAssistant;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLUser;
import org.jkiss.dbeaver.ext.mysql.model.QueryTransformerFetchAll;
import org.jkiss.dbeaver.ext.mysql.model.plan.MySQLPlanAnalyser;
import org.jkiss.dbeaver.ext.mysql.model.session.MySQLSessionManager;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.app.DBACertificateStorage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.gis.SpatialDataProvider;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCBasicDataTypeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCDataType;
import org.jkiss.dbeaver.model.impl.sql.QueryTransformerLimit;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLHelpProvider;
import org.jkiss.dbeaver.model.sql.SQLState;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class MySQLDataSource
extends JDBCDataSource
implements DBSObjectSelector {
    private static final Log log = Log.getLog(MySQLDataSource.class);
    private final JDBCBasicDataTypeCache<MySQLDataSource, JDBCDataType> dataTypeCache;
    private List<MySQLEngine> engines;
    private final CatalogCache catalogCache = new CatalogCache();
    private List<MySQLPrivilege> privileges;
    private List<MySQLUser> users;
    private List<MySQLCharset> charsets;
    private Map<String, MySQLCollation> collations;
    private String defaultCharset;
    private String defaultCollation;
    private String activeCatalogName;
    private SQLHelpProvider helpProvider;
    private Pattern ERROR_POSITION_PATTERN = Pattern.compile(" at line ([0-9]+)");

    public MySQLDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(monitor, container, (SQLDialect)new MySQLDialect());
        this.dataTypeCache = new JDBCBasicDataTypeCache((DBSObject)this);
    }

    public Object getDataSourceFeature(String featureId) {
        switch (featureId) {
            case "datasource.max-string-type-length": {
                if (this.isServerVersionAtLeast(5, 0)) {
                    return 65535;
                }
                return 255;
            }
        }
        return super.getDataSourceFeature(featureId);
    }

    protected Map<String, String> getInternalConnectionProperties(DBRProgressMonitor monitor, DBPDriver driver, String purpose, DBPConnectionConfiguration connectionInfo) throws DBCException {
        String zeroDateTimeBehavior;
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(MySQLDataSourceProvider.getConnectionsProps());
        DBWHandlerConfiguration sslConfig = this.getContainer().getActualConnectionConfiguration().getHandler("mysql_ssl");
        if (sslConfig != null && sslConfig.isEnabled()) {
            try {
                this.initSSL(monitor, props, sslConfig);
            }
            catch (Exception e) {
                throw new DBCException("Error configuring SSL certificates", (Throwable)e);
            }
        } else {
            props.put("useSSL", "false");
        }
        String serverTZ = connectionInfo.getProviderProperty("@dbeaver-serverTimezone@");
        if (!CommonUtils.isEmpty((String)serverTZ)) {
            props.put("serverTimezone", serverTZ);
        }
        if (!this.isMariaDB() && (zeroDateTimeBehavior = connectionInfo.getProperty("zeroDateTimeBehavior")) == null) {
            try {
                Driver driverInstance = (Driver)driver.getDriverInstance(monitor);
                if (driverInstance != null) {
                    if (driverInstance.getMajorVersion() >= 8) {
                        props.put("zeroDateTimeBehavior", "CONVERT_TO_NULL");
                    } else {
                        props.put("zeroDateTimeBehavior", "convertToNull");
                    }
                }
            }
            catch (Exception exception) {
                log.debug((Object)"Error setting MySQL zeroDateTimeBehavior property default");
            }
        }
        return props;
    }

    protected DBPDataSourceInfo createDataSourceInfo(@NotNull JDBCDatabaseMetaData metaData) {
        return new MySQLDataSourceInfo(metaData);
    }

    private void initSSL(DBRProgressMonitor monitor, Map<String, String> props, DBWHandlerConfiguration sslConfig) throws Exception {
        boolean retrievePublicKey;
        monitor.subTask("Install SSL certificates");
        DBACertificateStorage securityManager = this.getContainer().getPlatform().getCertificateStorage();
        props.put("useSSL", "true");
        props.put("verifyServerCertificate", String.valueOf(CommonUtils.toBoolean(sslConfig.getProperties().get("ssl.verify.server"))));
        props.put("requireSSL", String.valueOf(CommonUtils.toBoolean(sslConfig.getProperties().get("ssl.require"))));
        String caCertProp = (String)sslConfig.getProperties().get("ssl.ca.cert");
        String clientCertProp = (String)sslConfig.getProperties().get("ssl.client.cert");
        String clientCertKeyProp = (String)sslConfig.getProperties().get("ssl.client.key");
        if (!CommonUtils.isEmpty((String)caCertProp) || !CommonUtils.isEmpty((String)clientCertProp)) {
            byte[] caCertData = CommonUtils.isEmpty((String)caCertProp) ? null : IOUtils.readFileToBuffer((File)new File(caCertProp));
            byte[] clientCertData = CommonUtils.isEmpty((String)clientCertProp) ? null : IOUtils.readFileToBuffer((File)new File(clientCertProp));
            byte[] keyData = CommonUtils.isEmpty((String)clientCertKeyProp) ? null : IOUtils.readFileToBuffer((File)new File(clientCertKeyProp));
            securityManager.addCertificate(this.getContainer(), "ssl", caCertData, clientCertData, keyData);
        } else {
            securityManager.deleteCertificate(this.getContainer(), "ssl");
        }
        String ksPath = this.makeKeyStorePath(securityManager.getKeyStorePath(this.getContainer(), "ssl"));
        props.put("clientCertificateKeyStoreUrl", ksPath);
        props.put("trustCertificateKeyStoreUrl", ksPath);
        String cipherSuites = (String)sslConfig.getProperties().get("ssl.cipher.suites");
        if (!CommonUtils.isEmpty((String)cipherSuites)) {
            props.put("enabledSSLCipherSuites;", cipherSuites);
        }
        if (retrievePublicKey = CommonUtils.getBoolean((String)((String)sslConfig.getProperties().get("ssl.public.key.retrieve")), (boolean)false)) {
            props.put("allowPublicKeyRetrieval", "true");
        }
        if (CommonUtils.getBoolean((String)((String)sslConfig.getProperties().get("ssl.debug")), (boolean)false)) {
            System.setProperty("javax.net.debug", "all");
        }
    }

    private String makeKeyStorePath(File keyStorePath) throws MalformedURLException {
        if (this.isMariaDB()) {
            return keyStorePath.getAbsolutePath();
        }
        return keyStorePath.toURI().toURL().toString();
    }

    protected void initializeContextState(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext context, boolean setActiveObject) throws DBCException {
        MySQLCatalog object;
        if (setActiveObject && (object = this.getDefaultObject()) != null) {
            this.useDatabase(monitor, context, object);
        }
    }

    public String[] getTableTypes() {
        return MySQLConstants.TABLE_TYPES;
    }

    public CatalogCache getCatalogCache() {
        return this.catalogCache;
    }

    public Collection<MySQLCatalog> getCatalogs() {
        return this.catalogCache.getCachedObjects();
    }

    public MySQLCatalog getCatalog(String name) {
        return (MySQLCatalog)this.catalogCache.getCachedObject(name);
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        this.dataTypeCache.getAllObjects(monitor, (DBSObject)this);
        if (this.isServerVersionAtLeast(5, 7) && this.dataTypeCache.getCachedObject("json") == null) {
            this.dataTypeCache.cacheObject((DBSObject)new JDBCDataType((DBSObject)this, 1111, "json", "json", false, true, 0, 0, 0));
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load basic datasource metadata");){
            JDBCResultSet dbResult;
            Object var9_24;
            Throwable throwable2;
            JDBCPreparedStatement dbStat;
            Object var6_13;
            Throwable throwable3;
            this.engines = new ArrayList<MySQLEngine>();
            try {
                throwable3 = null;
                var6_13 = null;
                try {
                    dbStat = session.prepareStatement("SHOW ENGINES");
                    try {
                        throwable2 = null;
                        var9_24 = null;
                        try {
                            dbResult = dbStat.executeQuery();
                            try {
                                while (dbResult.next()) {
                                    MySQLEngine engine = new MySQLEngine(this, (ResultSet)dbResult);
                                    this.engines.add(engine);
                                }
                            }
                            finally {
                                if (dbResult != null) {
                                    dbResult.close();
                                }
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                    finally {
                        if (dbStat != null) {
                            dbStat.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable3 == null) {
                        throwable3 = throwable5;
                    } else if (throwable3 != throwable5) {
                        throwable3.addSuppressed(throwable5);
                    }
                    throw throwable3;
                }
            }
            catch (SQLException sQLException) {}
            this.charsets = new ArrayList<MySQLCharset>();
            try {
                throwable3 = null;
                var6_13 = null;
                try {
                    dbStat = session.prepareStatement("SHOW CHARSET");
                    try {
                        throwable2 = null;
                        var9_24 = null;
                        try {
                            dbResult = dbStat.executeQuery();
                            try {
                                while (dbResult.next()) {
                                    MySQLCharset charset = new MySQLCharset(this, (ResultSet)dbResult);
                                    this.charsets.add(charset);
                                }
                            }
                            finally {
                                if (dbResult != null) {
                                    dbResult.close();
                                }
                            }
                        }
                        catch (Throwable throwable6) {
                            if (throwable2 == null) {
                                throwable2 = throwable6;
                            } else if (throwable2 != throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            throw throwable2;
                        }
                    }
                    finally {
                        if (dbStat != null) {
                            dbStat.close();
                        }
                    }
                }
                catch (Throwable throwable7) {
                    if (throwable3 == null) {
                        throwable3 = throwable7;
                    } else if (throwable3 != throwable7) {
                        throwable3.addSuppressed(throwable7);
                    }
                    throw throwable3;
                }
            }
            catch (SQLException sQLException) {}
            this.charsets.sort(DBUtils.nameComparator());
            this.collations = new LinkedHashMap<String, MySQLCollation>();
            try {
                throwable3 = null;
                var6_13 = null;
                try {
                    dbStat = session.prepareStatement("SHOW COLLATION");
                    try {
                        throwable2 = null;
                        var9_24 = null;
                        try {
                            dbResult = dbStat.executeQuery();
                            try {
                                while (dbResult.next()) {
                                    String charsetName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CHARSET");
                                    MySQLCharset charset = this.getCharset(charsetName);
                                    if (charset == null) {
                                        log.warn((Object)("Charset '" + charsetName + "' not found."));
                                        continue;
                                    }
                                    MySQLCollation collation = new MySQLCollation(charset, (ResultSet)dbResult);
                                    this.collations.put(collation.getName(), collation);
                                    charset.addCollation(collation);
                                }
                            }
                            finally {
                                if (dbResult != null) {
                                    dbResult.close();
                                }
                            }
                        }
                        catch (Throwable throwable8) {
                            if (throwable2 == null) {
                                throwable2 = throwable8;
                            } else if (throwable2 != throwable8) {
                                throwable2.addSuppressed(throwable8);
                            }
                            throw throwable2;
                        }
                    }
                    finally {
                        if (dbStat != null) {
                            dbStat.close();
                        }
                    }
                }
                catch (Throwable throwable9) {
                    if (throwable3 == null) {
                        throwable3 = throwable9;
                    } else if (throwable3 != throwable9) {
                        throwable3.addSuppressed(throwable9);
                    }
                    throw throwable3;
                }
            }
            catch (SQLException sQLException) {}
            try {
                throwable3 = null;
                var6_13 = null;
                try {
                    dbStat = session.prepareStatement("SELECT @@GLOBAL.character_set_server,@@GLOBAL.collation_server");
                    try {
                        throwable2 = null;
                        var9_24 = null;
                        try {
                            dbResult = dbStat.executeQuery();
                            try {
                                if (dbResult.next()) {
                                    this.defaultCharset = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1);
                                    this.defaultCollation = JDBCUtils.safeGetString((ResultSet)dbResult, (int)2);
                                }
                            }
                            finally {
                                if (dbResult != null) {
                                    dbResult.close();
                                }
                            }
                        }
                        catch (Throwable throwable10) {
                            if (throwable2 == null) {
                                throwable2 = throwable10;
                            } else if (throwable2 != throwable10) {
                                throwable2.addSuppressed(throwable10);
                            }
                            throw throwable2;
                        }
                    }
                    finally {
                        if (dbStat != null) {
                            dbStat.close();
                        }
                    }
                }
                catch (Throwable throwable11) {
                    if (throwable3 == null) {
                        throwable3 = throwable11;
                    } else if (throwable3 != throwable11) {
                        throwable3.addSuppressed(throwable11);
                    }
                    throw throwable3;
                }
            }
            catch (Throwable ex) {
                log.debug((Object)"Error reading default server charset/collation", ex);
            }
            this.catalogCache.getAllObjects(monitor, (DBSObject)this);
            this.activeCatalogName = MySQLUtils.determineCurrentDatabase(session);
        }
        catch (Throwable throwable12) {
            if (throwable == null) {
                throwable = throwable12;
            } else if (throwable != throwable12) {
                throwable.addSuppressed(throwable12);
            }
            throw throwable;
        }
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.engines = null;
        this.catalogCache.clearCache();
        this.users = null;
        this.activeCatalogName = null;
        this.initialize(monitor);
        return this;
    }

    MySQLTable findTable(DBRProgressMonitor monitor, String catalogName, String tableName) throws DBException {
        if (CommonUtils.isEmpty((String)catalogName)) {
            return null;
        }
        MySQLCatalog catalog = this.getCatalog(catalogName);
        if (catalog == null) {
            log.error((Object)("Catalog " + catalogName + " not found"));
            return null;
        }
        return catalog.getTable(monitor, tableName);
    }

    public Collection<? extends MySQLCatalog> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getCatalogs();
    }

    public MySQLCatalog getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.getCatalog(childName);
    }

    public Class<? extends MySQLCatalog> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return MySQLCatalog.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    public boolean supportsDefaultChange() {
        return true;
    }

    public MySQLCatalog getDefaultObject() {
        return CommonUtils.isEmpty((String)this.activeCatalogName) ? null : this.getCatalog(this.activeCatalogName);
    }

    public void setDefaultObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object) throws DBException {
        MySQLCatalog oldSelectedEntity = this.getDefaultObject();
        if (!(object instanceof MySQLCatalog)) {
            throw new DBException("Invalid object type: " + object);
        }
        JDBCExecutionContext[] jDBCExecutionContextArray = this.getDefaultInstance().getAllContexts();
        int n = jDBCExecutionContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            JDBCExecutionContext context = jDBCExecutionContextArray[n2];
            this.useDatabase(monitor, context, (MySQLCatalog)object);
            ++n2;
        }
        this.activeCatalogName = object.getName();
        if (oldSelectedEntity != null) {
            DBUtils.fireObjectSelect((DBSObject)oldSelectedEntity, (boolean)false);
        }
        if (this.activeCatalogName != null) {
            DBUtils.fireObjectSelect((DBSObject)object, (boolean)true);
        }
    }

    public boolean refreshDefaultObject(@NotNull DBCSession session) throws DBException {
        MySQLCatalog newCatalog;
        String newCatalogName = MySQLUtils.determineCurrentDatabase((JDBCSession)session);
        if (!CommonUtils.equalObjects((Object)newCatalogName, (Object)this.activeCatalogName) && (newCatalog = this.getCatalog(newCatalogName)) != null) {
            this.setDefaultObject(session.getProgressMonitor(), (DBSObject)newCatalog);
            return true;
        }
        return false;
    }

    private void useDatabase(DBRProgressMonitor monitor, JDBCExecutionContext context, MySQLCatalog catalog) throws DBCException {
        if (catalog == null) {
            log.debug((Object)"Null current database");
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active catalog");){
                Throwable throwable2 = null;
                Object var8_12 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("use " + DBUtils.getQuotedIdentifier((DBSObject)catalog));){
                    dbStat.execute();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException(e, (DBPDataSource)this);
        }
    }

    protected Connection openConnection(@NotNull DBRProgressMonitor monitor, JDBCRemoteInstance remoteInstance, @NotNull String purpose) throws DBCException {
        Connection mysqlConnection = super.openConnection(monitor, remoteInstance, purpose);
        if (!this.getContainer().getPreferenceStore().getBoolean("database.meta.client.name.disable")) {
            try {
                mysqlConnection.setClientInfo("ApplicationName", DBUtils.getClientApplicationName((DBPDataSourceContainer)this.getContainer(), (String)purpose));
            }
            catch (Throwable e) {
                log.debug((Object)e);
            }
        }
        return mysqlConnection;
    }

    public List<MySQLUser> getUsers(DBRProgressMonitor monitor) throws DBException {
        if (this.users == null) {
            this.users = this.loadUsers(monitor);
        }
        return this.users;
    }

    public MySQLUser getUser(DBRProgressMonitor monitor, String name) throws DBException {
        return (MySQLUser)DBUtils.findObject(this.getUsers(monitor), (String)name);
    }

    /*
     * Exception decompiling
     */
    private List<MySQLUser> loadUsers(DBRProgressMonitor monitor) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<MySQLEngine> getEngines() {
        return this.engines;
    }

    public MySQLEngine getEngine(String name) {
        return (MySQLEngine)DBUtils.findObject(this.engines, (String)name);
    }

    public MySQLEngine getDefaultEngine() {
        for (MySQLEngine engine : this.engines) {
            if (engine.getSupport() != MySQLEngine.Support.DEFAULT) continue;
            return engine;
        }
        return null;
    }

    public Collection<MySQLCharset> getCharsets() {
        return this.charsets;
    }

    public MySQLCharset getCharset(String name) {
        for (MySQLCharset charset : this.charsets) {
            if (!charset.getName().equals(name)) continue;
            return charset;
        }
        return null;
    }

    public MySQLCollation getCollation(String name) {
        return this.collations.get(name);
    }

    public MySQLCharset getDefaultCharset() {
        return this.getCharset(this.defaultCharset);
    }

    public MySQLCollation getDefaultCollation() {
        return this.getCollation(this.defaultCollation);
    }

    public List<MySQLPrivilege> getPrivileges(DBRProgressMonitor monitor) throws DBException {
        if (this.privileges == null) {
            this.privileges = this.loadPrivileges(monitor);
        }
        return this.privileges;
    }

    public List<MySQLPrivilege> getPrivilegesByKind(DBRProgressMonitor monitor, MySQLPrivilege.Kind kind) throws DBException {
        ArrayList<MySQLPrivilege> privs = new ArrayList<MySQLPrivilege>();
        for (MySQLPrivilege priv : this.getPrivileges(monitor)) {
            if (priv.getKind() != kind) continue;
            privs.add(priv);
        }
        return privs;
    }

    public MySQLPrivilege getPrivilege(DBRProgressMonitor monitor, String name) throws DBException {
        return (MySQLPrivilege)DBUtils.findObject(this.getPrivileges(monitor), (String)name, (boolean)true);
    }

    /*
     * Exception decompiling
     */
    private List<MySQLPrivilege> loadPrivileges(DBRProgressMonitor monitor) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<MySQLParameter> getSessionStatus(DBRProgressMonitor monitor) throws DBException {
        return this.loadParameters(monitor, true, false);
    }

    public List<MySQLParameter> getGlobalStatus(DBRProgressMonitor monitor) throws DBException {
        return this.loadParameters(monitor, true, true);
    }

    public List<MySQLParameter> getSessionVariables(DBRProgressMonitor monitor) throws DBException {
        return this.loadParameters(monitor, false, false);
    }

    public List<MySQLParameter> getGlobalVariables(DBRProgressMonitor monitor) throws DBException {
        return this.loadParameters(monitor, false, true);
    }

    public List<MySQLDataSource> getInformation() {
        return Collections.singletonList(this);
    }

    /*
     * Exception decompiling
     */
    private List<MySQLParameter> loadParameters(DBRProgressMonitor monitor, boolean status, boolean global) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        if (type == DBCQueryTransformType.RESULT_SET_LIMIT) {
            return new QueryTransformerLimit();
        }
        if (type == DBCQueryTransformType.FETCH_ALL_TABLE) {
            return new QueryTransformerFetchAll();
        }
        return super.createQueryTransformer(type);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast((Object)new MySQLStructureAssistant(this));
        }
        if (adapter == SQLHelpProvider.class) {
            if (this.helpProvider == null) {
                this.helpProvider = new MySQLHelpProvider(this);
            }
            return adapter.cast(this.helpProvider);
        }
        if (adapter == DBAServerSessionManager.class) {
            return adapter.cast(new MySQLSessionManager(this));
        }
        if (adapter == SpatialDataProvider.class) {
            return adapter.cast(new SpatialDataProvider(){

                public boolean isFlipCoordinates() {
                    return false;
                }

                public int getDefaultSRID() {
                    return 4326;
                }
            });
        }
        if (adapter == DBCQueryPlanner.class) {
            return adapter.cast((Object)new MySQLPlanAnalyser(this));
        }
        return (T)super.getAdapter(adapter);
    }

    @NotNull
    public MySQLDataSource getDataSource() {
        return this;
    }

    public Collection<? extends DBSDataType> getLocalDataTypes() {
        return this.dataTypeCache.getCachedObjects();
    }

    public DBSDataType getLocalDataType(String typeName) {
        return (DBSDataType)this.dataTypeCache.getCachedObject(typeName);
    }

    public DBSDataType getLocalDataType(int typeID) {
        return this.dataTypeCache.getCachedObject(typeID);
    }

    public String getDefaultDataTypeName(DBPDataKind dataKind) {
        switch (dataKind) {
            case BOOLEAN: {
                return "TINYINT(1)";
            }
            case NUMERIC: {
                return "BIGINT";
            }
            case DATETIME: {
                return "TIMESTAMP";
            }
            case BINARY: {
                return "BINARY";
            }
            case CONTENT: {
                return "LONGBLOB";
            }
            case ROWID: {
                return "BINARY";
            }
        }
        return "VARCHAR";
    }

    public boolean isMariaDB() {
        return "org.mariadb.jdbc.Driver".equals(this.getContainer().getDriver().getDriverClassName());
    }

    public DBPErrorAssistant.ErrorType discoverErrorType(@NotNull Throwable error) {
        if (this.isMariaDB() && "08".equals(SQLState.getStateFromException((Throwable)error))) {
            return DBPErrorAssistant.ErrorType.CONNECTION_LOST;
        }
        return super.discoverErrorType(error);
    }

    @Nullable
    public DBPErrorAssistant.ErrorPosition[] getErrorPosition(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, @NotNull String query, @NotNull Throwable error) {
        Matcher matcher;
        String message = error.getMessage();
        if (!CommonUtils.isEmpty((String)message) && (matcher = this.ERROR_POSITION_PATTERN.matcher(message)).find()) {
            DBPErrorAssistant.ErrorPosition pos = new DBPErrorAssistant.ErrorPosition();
            pos.line = Integer.parseInt(matcher.group(1)) - 1;
            return new DBPErrorAssistant.ErrorPosition[]{pos};
        }
        return null;
    }

    static class CatalogCache
    extends JDBCObjectCache<MySQLDataSource, MySQLCatalog> {
        CatalogCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull MySQLDataSource owner) throws SQLException {
            StringBuilder catalogQuery = new StringBuilder("show databases");
            DBSObjectFilter catalogFilters = owner.getContainer().getObjectFilter(MySQLCatalog.class, null, false);
            if (catalogFilters != null) {
                JDBCUtils.appendFilterClause((StringBuilder)catalogQuery, (DBSObjectFilter)catalogFilters, (String)"`Database`", (boolean)true);
            }
            JDBCPreparedStatement dbStat = session.prepareStatement(catalogQuery.toString());
            if (catalogFilters != null) {
                JDBCUtils.setFilterParameters((PreparedStatement)dbStat, (int)1, (DBSObjectFilter)catalogFilters);
            }
            return dbStat;
        }

        protected MySQLCatalog fetchObject(@NotNull JDBCSession session, @NotNull MySQLDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new MySQLCatalog(owner, (ResultSet)resultSet);
        }
    }
}

