/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.LocalNativeClientLocation;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptorSerializer;
import org.jkiss.dbeaver.registry.driver.DriverLibraryAbstract;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.xml.sax.Attributes;

@Deprecated
public class DriverDescriptorSerializerLegacy
extends DriverDescriptorSerializer {
    private static final Log log = Log.getLog(DriverDescriptorSerializerLegacy.class);
    private DriverDescriptor driver;

    DriverDescriptorSerializerLegacy(DriverDescriptor driver) {
        this.driver = driver;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void serialize(XMLBuilder xml, boolean export) throws IOException {
        pathSubstitutions = this.getPathSubstitutions();
        var4_4 = null;
        var5_6 = null;
        try {
            e0 = xml.startElement("driver");
            try {
                if (export) {
                    xml.addAttribute("provider", this.driver.getProviderDescriptor().getId());
                }
                xml.addAttribute("id", this.driver.getId());
                if (this.driver.isDisabled()) {
                    xml.addAttribute("disabled", true);
                }
                if (!CommonUtils.isEmpty((String)this.driver.getCategory())) {
                    xml.addAttribute("category", this.driver.getCategory());
                }
                xml.addAttribute("categories", String.join((CharSequence)",", this.driver.getCategories()));
                xml.addAttribute("custom", this.driver.isCustom());
                xml.addAttribute("embedded", this.driver.isEmbedded());
                xml.addAttribute("name", this.driver.getName());
                xml.addAttribute("class", this.driver.getDriverClassName());
                if (!CommonUtils.isEmpty((String)this.driver.getSampleURL())) {
                    xml.addAttribute("url", this.driver.getSampleURL());
                }
                if (this.driver.getDefaultPort() != null) {
                    xml.addAttribute("port", this.driver.getDefaultPort());
                }
                xml.addAttribute("description", CommonUtils.notEmpty((String)this.driver.getDescription()));
                if (this.driver.isCustomDriverLoader()) {
                    xml.addAttribute("customDriverLoader", this.driver.isCustomDriverLoader());
                }
                for (DBPDriverLibrary lib : this.driver.getDriverLibraries()) {
                    if (export && !lib.isDisabled()) continue;
                    var9_11 = null;
                    var10_16 = null;
                    try {
                        e1 = xml.startElement("library");
                        try {
                            xml.addAttribute("type", lib.getType().name());
                            xml.addAttribute("path", DriverDescriptorSerializerLegacy.substitutePathVariables(pathSubstitutions, lib.getPath()));
                            xml.addAttribute("custom", lib.isCustom());
                            if (lib.isDisabled()) {
                                xml.addAttribute("disabled", true);
                            }
                            if (!CommonUtils.isEmpty((String)lib.getPreferredVersion())) {
                                xml.addAttribute("version", lib.getPreferredVersion());
                            }
                            if ((files = this.driver.getResolvedFiles().get(lib)) == null) continue;
                            for (DriverDescriptor.DriverFileInfo file : files) {
                                var15_25 = null;
                                var16_27 = null;
                                try {
                                    e2 = xml.startElement("file");
                                    try {
                                        if (file.getFile() != null) ** GOTO lbl75
                                        DriverDescriptorSerializerLegacy.log.warn((Object)("File missing in " + file.getId()));
                                        if (e2 == null) continue;
                                    }
                                    catch (Throwable var15_26) {
                                        if (e2 != null) {
                                            e2.close();
                                        }
                                        throw var15_26;
                                    }
                                    e2.close();
                                    continue;
lbl75:
                                    // 1 sources

                                    xml.addAttribute("id", file.getId());
                                    if (!CommonUtils.isEmpty((String)file.getVersion())) {
                                        xml.addAttribute("version", file.getVersion());
                                    }
                                    xml.addAttribute("path", DriverDescriptorSerializerLegacy.substitutePathVariables(pathSubstitutions, file.getFile().getAbsolutePath()));
                                    if (e2 == null) continue;
                                    e2.close();
                                }
                                catch (Throwable var16_28) {
                                    if (var15_25 == null) {
                                        var15_25 = var16_28;
                                    } else if (var15_25 != var16_28) {
                                        var15_25.addSuppressed(var16_28);
                                    }
                                    throw var15_25;
                                }
                            }
                        }
                        finally {
                            if (e1 != null) {
                                e1.close();
                            }
                        }
                    }
                    catch (Throwable var10_17) {
                        if (var9_11 == null) {
                            var9_11 = var10_17;
                        } else if (var9_11 != var10_17) {
                            var9_11.addSuppressed(var10_17);
                        }
                        throw var9_11;
                    }
                }
                for (DBPNativeClientLocation location : this.driver.getNativeClientHomes()) {
                    var9_11 = null;
                    var10_16 = null;
                    try {
                        e1 = xml.startElement("clientHome");
                        try {
                            xml.addAttribute("id", location.getName());
                            if (location.getPath() == null) continue;
                            xml.addAttribute("path", location.getPath().getAbsolutePath());
                        }
                        finally {
                            if (e1 != null) {
                                e1.close();
                            }
                        }
                    }
                    catch (Throwable var10_18) {
                        if (var9_11 == null) {
                            var9_11 = var10_18;
                        } else if (var9_11 != var10_18) {
                            var9_11.addSuppressed(var10_18);
                        }
                        throw var9_11;
                    }
                }
                for (Map.Entry paramEntry : this.driver.getCustomParameters().entrySet()) {
                    if (CommonUtils.equalObjects(paramEntry.getValue(), (Object)this.driver.getDefaultParameters().get(paramEntry.getKey()))) continue;
                    var9_11 = null;
                    var10_16 = null;
                    try {
                        e1 = xml.startElement("parameter");
                        try {
                            xml.addAttribute("name", CommonUtils.toString(paramEntry.getKey()));
                            xml.addAttribute("value", CommonUtils.toString(paramEntry.getValue()));
                        }
                        finally {
                            if (e1 != null) {
                                e1.close();
                            }
                        }
                    }
                    catch (Throwable var10_19) {
                        if (var9_11 == null) {
                            var9_11 = var10_19;
                        } else if (var9_11 != var10_19) {
                            var9_11.addSuppressed(var10_19);
                        }
                        throw var9_11;
                    }
                }
                for (Map.Entry propEntry : this.driver.getCustomConnectionProperties().entrySet()) {
                    if (CommonUtils.equalObjects(propEntry.getValue(), (Object)this.driver.getDefaultConnectionProperties().get(propEntry.getKey()))) continue;
                    var9_11 = null;
                    var10_16 = null;
                    try {
                        e1 = xml.startElement("property");
                        try {
                            xml.addAttribute("name", CommonUtils.toString(propEntry.getKey()));
                            xml.addAttribute("value", CommonUtils.toString(propEntry.getValue()));
                        }
                        finally {
                            if (e1 != null) {
                                e1.close();
                            }
                        }
                    }
                    catch (Throwable var10_20) {
                        if (var9_11 == null) {
                            var9_11 = var10_20;
                        } else if (var9_11 != var10_20) {
                            var9_11.addSuppressed(var10_20);
                        }
                        throw var9_11;
                    }
                }
            }
            finally {
                if (e0 != null) {
                    e0.close();
                }
            }
        }
        catch (Throwable var5_7) {
            if (var4_4 == null) {
                var4_4 = var5_7;
            } else if (var4_4 != var5_7) {
                var4_4.addSuppressed(var5_7);
            }
            throw var4_4;
        }
    }

    public static class DriversParser
    implements SAXListener {
        DataSourceProviderDescriptor curProvider;
        DriverDescriptor curDriver;
        DBPDriverLibrary curLibrary;
        private static final String PATH_VERSION_OBSOLETE_RELEASE = ":release";

        public void saxStartElement(SAXReader reader, String namespaceURI, String localName, Attributes atts) {
            switch (localName) {
                case "provider": {
                    this.curProvider = null;
                    this.curDriver = null;
                    String idAttr = atts.getValue("id");
                    if (CommonUtils.isEmpty((String)idAttr)) {
                        log.warn((Object)"No id for driver provider");
                        return;
                    }
                    this.curProvider = DataSourceProviderRegistry.getInstance().getDataSourceProvider(idAttr);
                    if (this.curProvider != null) break;
                    log.warn((Object)("Datasource provider '" + idAttr + "' not found. Bad provider description."));
                    break;
                }
                case "driver": {
                    this.curDriver = null;
                    if (this.curProvider == null) {
                        String providerId = atts.getValue("provider");
                        if (!CommonUtils.isEmpty((String)providerId)) {
                            this.curProvider = DataSourceProviderRegistry.getInstance().getDataSourceProvider(providerId);
                            if (this.curProvider == null) {
                                log.warn((Object)("Datasource provider '" + providerId + "' not found. Bad driver description."));
                            }
                        }
                        if (this.curProvider == null) {
                            log.warn((Object)"Driver outside of datasource provider");
                            return;
                        }
                    }
                    String idAttr = atts.getValue("id");
                    this.curDriver = this.curProvider.getDriver(idAttr);
                    if (this.curDriver == null) {
                        this.curDriver = new DriverDescriptor(this.curProvider, idAttr);
                        this.curProvider.addDriver(this.curDriver);
                    }
                    if (this.curProvider.isDriversManagable()) {
                        String category = atts.getValue("category");
                        if (!CommonUtils.isEmpty((String)category)) {
                            this.curDriver.setCategory(category);
                        }
                        if (this.curDriver.isCustom()) {
                            this.curDriver.setName(atts.getValue("name"));
                        }
                        this.curDriver.setDescription(atts.getValue("description"));
                        this.curDriver.setDriverClassName(atts.getValue("class"));
                        this.curDriver.setSampleURL(atts.getValue("url"));
                        this.curDriver.setDriverDefaultPort(atts.getValue("port"));
                        this.curDriver.setEmbedded(CommonUtils.getBoolean((String)atts.getValue("embedded"), (boolean)false));
                    }
                    if (atts.getValue("customDriverLoader") != null) {
                        this.curDriver.setCustomDriverLoader(CommonUtils.getBoolean((String)atts.getValue("customDriverLoader"), (boolean)false));
                    }
                    if (atts.getValue("useURL") != null) {
                        this.curDriver.setUseURL(CommonUtils.getBoolean((String)atts.getValue("useURL"), (boolean)true));
                    }
                    this.curDriver.setModified(true);
                    String disabledAttr = atts.getValue("disabled");
                    if (!CommonUtils.getBoolean((String)disabledAttr)) break;
                    this.curDriver.setDisabled(true);
                    break;
                }
                case "library": {
                    DBPDriverLibrary.FileType type;
                    if (this.curDriver == null) {
                        log.warn((Object)"Library outside of driver");
                        return;
                    }
                    String typeStr = atts.getValue("type");
                    if (CommonUtils.isEmpty((String)typeStr)) {
                        type = DBPDriverLibrary.FileType.jar;
                    } else {
                        try {
                            type = DBPDriverLibrary.FileType.valueOf((String)typeStr);
                        }
                        catch (IllegalArgumentException e) {
                            log.warn((Object)e);
                            type = DBPDriverLibrary.FileType.jar;
                        }
                    }
                    String path = DriversParser.normalizeLibraryPath(atts.getValue("path"));
                    if (!CommonUtils.isEmpty((String)path)) {
                        path = DriverDescriptorSerializerLegacy.replacePathVariables(path);
                    }
                    boolean custom = CommonUtils.getBoolean((String)atts.getValue("custom"), (boolean)true);
                    String version = atts.getValue("version");
                    DBPDriverLibrary lib = this.curDriver.getDriverLibrary(path);
                    if (!custom && lib == null) {
                        return;
                    }
                    String disabledAttr = atts.getValue("disabled");
                    if (lib != null && CommonUtils.getBoolean((String)disabledAttr)) {
                        lib.setDisabled(true);
                    } else if (lib == null) {
                        lib = DriverLibraryAbstract.createFromPath(this.curDriver, type, path, version);
                        this.curDriver.addDriverLibrary(lib);
                    } else if (!CommonUtils.isEmpty((String)version)) {
                        lib.setPreferredVersion(version);
                    }
                    this.curLibrary = lib;
                    break;
                }
                case "file": {
                    String path;
                    if (this.curDriver == null || this.curLibrary == null || (path = atts.getValue("path")) == null) break;
                    if (CommonUtils.isEmpty((String)(path = DriverDescriptorSerializerLegacy.replacePathVariables(path)))) {
                        log.warn((Object)"Empty path for library file");
                        break;
                    }
                    DriverDescriptor.DriverFileInfo info = new DriverDescriptor.DriverFileInfo(atts.getValue(CommonUtils.notEmpty((String)"id")), atts.getValue(CommonUtils.notEmpty((String)"version")), new File(path));
                    this.curDriver.addLibraryFile(this.curLibrary, info);
                    break;
                }
                case "clientHome": {
                    if (this.curDriver == null) break;
                    this.curDriver.addNativeClientLocation((DBPNativeClientLocation)new LocalNativeClientLocation(atts.getValue("id"), atts.getValue("path")));
                    break;
                }
                case "parameter": {
                    if (this.curDriver == null) break;
                    String paramName = atts.getValue("name");
                    String paramValue = atts.getValue("value");
                    if (CommonUtils.isEmpty((String)paramName) || CommonUtils.isEmpty((String)paramValue)) break;
                    this.curDriver.setDriverParameter(paramName, paramValue, false);
                    break;
                }
                case "property": {
                    if (this.curDriver == null) break;
                    String paramName = atts.getValue("name");
                    String paramValue = atts.getValue("value");
                    if (CommonUtils.isEmpty((String)paramName) || CommonUtils.isEmpty((String)paramValue)) break;
                    this.curDriver.setConnectionProperty(paramName, paramValue);
                }
            }
        }

        private static String normalizeLibraryPath(String value) {
            if (value.startsWith("maven:/") && value.endsWith(PATH_VERSION_OBSOLETE_RELEASE)) {
                value = String.valueOf(value.substring(0, value.length() - PATH_VERSION_OBSOLETE_RELEASE.length())) + ":" + "RELEASE";
            }
            return value;
        }

        public void saxText(SAXReader reader, String data) {
        }

        public void saxEndElement(SAXReader reader, String namespaceURI, String localName) {
            switch (localName) {
                case "library": {
                    this.curLibrary = null;
                }
            }
        }
    }
}

