/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.eclipse.core.internal.localstore.Bucket;
import org.eclipse.core.internal.localstore.BucketTree;
import org.eclipse.core.internal.properties.PropertyBucket;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class ProjectMetadata
implements DBPProject {
    private static final Log log = Log.getLog(ProjectMetadata.class);
    public static final String METADATA_STORAGE_FILE = "project-metadata.json";
    private static Gson METADATA_GSON = new GsonBuilder().setLenient().serializeNulls().create();
    private final DBPWorkspace workspace;
    private final IProject project;
    private ProjectFormat format = ProjectFormat.UNKNOWN;
    private volatile DataSourceRegistry dataSourceRegistry;
    private Map<String, Map<String, Object>> resourceProperties;
    private final Object metadataSync = new Object();

    public ProjectMetadata(DBPWorkspace workspace, IProject project) {
        this.workspace = workspace;
        this.project = project;
    }

    @NotNull
    public DBPWorkspace getWorkspace() {
        return this.workspace;
    }

    @NotNull
    public String getName() {
        return this.project.getName();
    }

    @NotNull
    public File getAbsolutePath() {
        return this.project.getLocation().toFile();
    }

    @NotNull
    public IProject getEclipseProject() {
        return this.project;
    }

    @NotNull
    public IFolder getMetadataFolder(boolean create) {
        IFolder metadataFolder = this.project.getFolder(".dbeaver");
        if (create && !metadataFolder.exists()) {
            try {
                metadataFolder.create(4097, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                log.error((Object)"Error creating project metadata folder", (Throwable)e);
            }
        }
        return metadataFolder;
    }

    @NotNull
    private File getMetadataPath() {
        return new File(this.getAbsolutePath(), ".dbeaver");
    }

    public boolean isOpen() {
        return this.project.isOpen();
    }

    public void ensureOpen() throws IllegalStateException {
        if (this.format != ProjectFormat.UNKNOWN) {
            return;
        }
        if (!this.project.isOpen()) {
            try {
                NullProgressMonitor monitor = new NullProgressMonitor();
                this.project.open((IProgressMonitor)monitor);
                this.project.refreshLocal(1, (IProgressMonitor)monitor);
            }
            catch (CoreException e) {
                log.error((Object)"Error opening project", (Throwable)e);
                return;
            }
        }
        IFolder mdFolder = this.getMetadataFolder(false);
        File dsConfig = new File(this.getAbsolutePath(), ".dbeaver-data-sources.xml");
        this.format = !mdFolder.exists() && dsConfig.exists() ? ProjectFormat.LEGACY : ProjectFormat.MODERN;
        this.getMetadataFolder(true);
        this.checkAndUpdateProjectStructure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBPDataSourceRegistry getDataSourceRegistry() {
        this.ensureOpen();
        if (this.dataSourceRegistry == null) {
            Object object = this.metadataSync;
            synchronized (object) {
                if (this.dataSourceRegistry == null) {
                    this.dataSourceRegistry = new DataSourceRegistry(this.workspace.getPlatform(), this);
                }
            }
        }
        return this.dataSourceRegistry;
    }

    @NotNull
    public ISecurePreferences getSecurePreferences() {
        return SecurePreferencesFactory.getDefault().node("dbeaver").node("projects").node(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResourceProperty(IResource resource, String propName) {
        this.loadMetadata();
        Object object = this.metadataSync;
        synchronized (object) {
            Map<String, Object> resProps = this.resourceProperties.get(resource.getProjectRelativePath().toString());
            if (resProps != null) {
                return resProps.get(propName);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceProperty(IResource resource, String propName, Object propValue) {
        this.loadMetadata();
        Object object = this.metadataSync;
        synchronized (object) {
            Map resProps = this.resourceProperties.computeIfAbsent(resource.getProjectRelativePath().toString(), s -> new LinkedHashMap());
            if (propValue == null) {
                if (resProps.remove(propName) == null) {
                    return;
                }
            } else {
                Object oldValue = resProps.put(propName, propValue);
                if (Objects.equals(oldValue, propValue)) {
                    return;
                }
            }
        }
        this.flushMetadata();
    }

    public void dispose() {
        this.dataSourceRegistry.dispose();
    }

    public ProjectFormat getFormat() {
        return this.format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMetadata() {
        this.ensureOpen();
        Object object = this.metadataSync;
        synchronized (object) {
            if (this.resourceProperties != null) {
                return;
            }
            File mdFile = new File(this.getMetadataPath(), METADATA_STORAGE_FILE);
            if (mdFile.exists()) {
                TreeMap<String, Map<String, Object>> mdCache = new TreeMap<String, Map<String, Object>>();
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (InputStreamReader mdReader = new InputStreamReader((InputStream)new FileInputStream(mdFile), StandardCharsets.UTF_8);){
                        Throwable throwable2 = null;
                        Object var8_12 = null;
                        try (JsonReader jsonReader = METADATA_GSON.newJsonReader((Reader)mdReader);){
                            jsonReader.beginObject();
                            while (jsonReader.hasNext()) {
                                String topName = jsonReader.nextName();
                                if (!"resources".equals(topName)) continue;
                                jsonReader.beginObject();
                                while (jsonReader.hasNext()) {
                                    String resourceName = jsonReader.nextName();
                                    HashMap<String, Object> resProperties = new HashMap<String, Object>();
                                    jsonReader.beginObject();
                                    while (jsonReader.hasNext()) {
                                        Object propValue;
                                        String propName = jsonReader.nextName();
                                        switch (jsonReader.peek()) {
                                            case NUMBER: {
                                                propValue = jsonReader.nextDouble();
                                                break;
                                            }
                                            case BOOLEAN: {
                                                propValue = jsonReader.nextBoolean();
                                                break;
                                            }
                                            case NULL: {
                                                propValue = null;
                                                break;
                                            }
                                            default: {
                                                propValue = jsonReader.nextString();
                                            }
                                        }
                                        resProperties.put(propName, propValue);
                                    }
                                    jsonReader.endObject();
                                    mdCache.put(resourceName, resProperties);
                                }
                                jsonReader.endObject();
                            }
                            jsonReader.endObject();
                            this.resourceProperties = mdCache;
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    log.error((Object)("Error reading project '" + this.getName() + "' metadata"), (Throwable)e);
                }
            } else {
                this.resourceProperties = new TreeMap<String, Map<String, Object>>();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndUpdateProjectStructure() {
        if (this.format == ProjectFormat.UNKNOWN || this.format == ProjectFormat.MODERN) {
            return;
        }
        File mdConfig = new File(this.getMetadataPath(), METADATA_STORAGE_FILE);
        if (!mdConfig.exists()) {
            log.debug((Object)("Migrate Eclipse resource properties to the project metadata (" + mdConfig.getAbsolutePath() + ")"));
            Map<String, Map<String, Object>> projectResourceProperties = this.extractProjectResourceProperties();
            Object object = this.metadataSync;
            synchronized (object) {
                this.resourceProperties = projectResourceProperties;
            }
            this.flushMetadata();
        }
        this.format = ProjectFormat.MODERN;
    }

    private Map<String, Map<String, Object>> extractProjectResourceProperties() {
        final LinkedHashMap<String, Map<String, Object>> result = new LinkedHashMap<String, Map<String, Object>>();
        try {
            BucketTree bucketTree = new BucketTree((Workspace)this.workspace.getEclipseWorkspace(), (Bucket)new PropertyBucket());
            try {
                final IPath projectPath = this.project.getFullPath();
                bucketTree.accept(new Bucket.Visitor(){

                    public int visit(Bucket.Entry entry) {
                        Object value = entry.getValue();
                        if (value instanceof String[][]) {
                            String[][] bucketProps;
                            String[][] stringArray = bucketProps = (String[][])value;
                            int n = bucketProps.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String[] resProps = stringArray[n2];
                                if (resProps.length == 3 && "org.jkiss.dbeaver".equals(resProps[0]) && !"sql-editor-project-id".equals(resProps[1])) {
                                    Map propsMap = result.computeIfAbsent(entry.getPath().makeRelativeTo(projectPath).toString(), s -> new LinkedHashMap());
                                    propsMap.put(resProps[1], resProps[2]);
                                }
                                ++n2;
                            }
                        }
                        return 0;
                    }
                }, projectPath, Integer.MAX_VALUE);
            }
            catch (CoreException e) {
                log.error((Object)e);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error extracting project metadata", e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushMetadata() {
        Object object = this.metadataSync;
        synchronized (object) {
            File mdFile = new File(this.getMetadataPath(), METADATA_STORAGE_FILE);
            if (CommonUtils.isEmpty(this.resourceProperties) && !mdFile.exists()) {
                return;
            }
            try {
                IOUtils.makeFileBackup((File)mdFile);
                Throwable throwable = null;
                Object var4_6 = null;
                try (OutputStreamWriter mdWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(mdFile), StandardCharsets.UTF_8);){
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (JsonWriter jsonWriter = METADATA_GSON.newJsonWriter((Writer)mdWriter);){
                        jsonWriter.beginObject();
                        jsonWriter.name("resources");
                        jsonWriter.beginObject();
                        for (Map.Entry<String, Map<String, Object>> resEntry : this.resourceProperties.entrySet()) {
                            jsonWriter.name(resEntry.getKey());
                            jsonWriter.beginObject();
                            Map<String, Object> resProps = resEntry.getValue();
                            for (Map.Entry<String, Object> propEntry : resProps.entrySet()) {
                                jsonWriter.name(propEntry.getKey());
                                Object value = propEntry.getValue();
                                if (value == null) {
                                    jsonWriter.nullValue();
                                    continue;
                                }
                                if (value instanceof Number) {
                                    jsonWriter.value((Number)value);
                                    continue;
                                }
                                if (value instanceof Boolean) {
                                    jsonWriter.value((Boolean)value);
                                    continue;
                                }
                                jsonWriter.value(CommonUtils.toString((Object)value));
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endObject();
                        jsonWriter.endObject();
                        jsonWriter.flush();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                log.error((Object)"Error flushing project metadata", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeResourceFromCache(IPath path) {
        Object object = this.metadataSync;
        synchronized (object) {
            this.resourceProperties.remove(path.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateResourceCache(IPath oldPath, IPath newPath) {
        Object object = this.metadataSync;
        synchronized (object) {
            Map<String, Object> props = this.resourceProperties.remove(oldPath.toString());
            if (props != null) {
                this.resourceProperties.put(newPath.toString(), props);
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    public static enum ProjectFormat {
        UNKNOWN,
        LEGACY,
        MODERN;

    }
}

