/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.object.struct;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNRoot;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSSequence;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.virtual.DBVContainer;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKey;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CSmartCombo;
import org.jkiss.dbeaver.ui.controls.ObjectContainerSelectorPanel;
import org.jkiss.dbeaver.ui.editors.internal.EditorsMessages;
import org.jkiss.dbeaver.ui.editors.object.struct.BaseObjectEditPage;
import org.jkiss.dbeaver.ui.editors.object.struct.EditConstraintPage;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class EditForeignKeyPage
extends BaseObjectEditPage {
    private static final Log log = Log.getLog(EditForeignKeyPage.class);
    private Button customUKButton;
    private DBSForeignKeyModifyRule[] supportedModifyRules;
    private DBSEntityAssociation foreignKey;
    private DBSEntity curRefTable;
    private List<DBSEntityConstraint> curConstraints;
    private DBNDatabaseNode ownerTableNode;
    private Table tableList;
    private Combo uniqueKeyCombo;
    private Text fkNameText;
    private Table columnsTable;
    private String fkName;
    private DBSEntityConstraint curConstraint;
    private List<? extends DBSEntityAttribute> ownColumns;
    private List<FKColumnInfo> fkColumns = new ArrayList<FKColumnInfo>();
    private DBSForeignKeyModifyRule onDeleteRule;
    private DBSForeignKeyModifyRule onUpdateRule;
    private boolean enableCustomKeys = false;

    public EditForeignKeyPage(String title, DBSEntityAssociation foreignKey, DBSForeignKeyModifyRule[] supportedModifyRules) {
        super(title);
        this.foreignKey = foreignKey;
        this.ownerTableNode = DBWorkbench.getPlatform().getNavigatorModel().findNode((DBSObject)foreignKey.getParentObject());
        this.supportedModifyRules = supportedModifyRules;
        if (this.ownerTableNode == null) {
            try {
                DBSEntity realEntity;
                if (foreignKey.getParentObject() instanceof DBVEntity && (realEntity = ((DBVEntity)foreignKey.getParentObject()).getRealEntity((DBRProgressMonitor)new VoidProgressMonitor())) != null) {
                    this.ownerTableNode = DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject((DBSObject)realEntity);
                }
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
        if (this.ownerTableNode != null) {
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)this.ownerTableNode.getNodeIcon()));
            this.setTitle(String.valueOf(title) + " | " + NLS.bind((String)EditorsMessages.dialog_struct_edit_fk_title, (Object)title, (Object)this.ownerTableNode.getNodeName()));
        }
    }

    public boolean isEnableCustomKeys() {
        return this.enableCustomKeys;
    }

    public void setEnableCustomKeys(boolean enableCustomKeys) {
        this.enableCustomKeys = enableCustomKeys;
    }

    protected Composite createPageContents(Composite parent) {
        Composite panel = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        panel.setLayoutData((Object)new GridData(1808));
        Composite tableGroup = UIUtils.createComposite((Composite)panel, (int)2);
        tableGroup.setLayoutData((Object)new GridData(768));
        UIUtils.createLabelText((Composite)tableGroup, (String)EditorsMessages.dialog_struct_edit_fk_label_table, (String)DBUtils.getObjectFullName((DBPNamedObject)this.foreignKey.getParentObject(), (DBPEvaluationContext)DBPEvaluationContext.UI), (int)2056);
        try {
            if (this.foreignKey instanceof DBVEntityForeignKey) {
                this.createContainerSelector(tableGroup);
            } else if (this.ownerTableNode != null) {
                this.createSchemaSelector(tableGroup);
            }
        }
        catch (Throwable e2) {
            log.debug((Object)"Can't create schema selector", e2);
        }
        DBNRoot rootNode = this.ownerTableNode == null ? DBWorkbench.getPlatform().getNavigatorModel().getRoot() : this.ownerTableNode.getParentNode();
        UIUtils.createControlLabel((Composite)panel, (String)EditorsMessages.dialog_struct_edit_fk_label_ref_table);
        this.tableList = new Table(panel, 67588);
        this.tableList.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.widthHint = 500;
        gd.heightHint = 150;
        this.tableList.setLayoutData((Object)gd);
        this.tableList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditForeignKeyPage.this.handleRefTableSelect((DBNDatabaseNode)e.item.getData());
            }
        });
        if (rootNode instanceof DBNDatabaseNode) {
            this.loadTableList((DBNDatabaseNode)rootNode);
        }
        Composite pkGroup = UIUtils.createComposite((Composite)panel, (int)(this.enableCustomKeys ? 3 : 2));
        pkGroup.setLayoutData((Object)new GridData(768));
        this.uniqueKeyCombo = UIUtils.createLabelCombo((Composite)pkGroup, (String)EditorsMessages.dialog_struct_edit_fk_combo_unik, (int)12);
        this.uniqueKeyCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditForeignKeyPage.this.handleUniqueKeySelect();
            }
        });
        if (this.enableCustomKeys) {
            this.customUKButton = UIUtils.createDialogButton((Composite)pkGroup, (String)"Create", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditForeignKeyPage.this.defineRefTableConstraint();
                }
            });
            this.customUKButton.setEnabled(false);
        }
        if (this.supportsCustomName()) {
            this.fkNameText = UIUtils.createLabelText((Composite)pkGroup, (String)EditorsMessages.dialog_struct_edit_fk_name, (String)"");
            this.fkNameText.addModifyListener(e -> {
                String string = this.fkName = this.fkNameText.getText();
            });
        }
        UIUtils.createControlLabel((Composite)panel, (String)EditorsMessages.dialog_struct_edit_fk_label_columns);
        this.columnsTable = new Table(panel, 67588);
        this.columnsTable.setHeaderVisible(true);
        this.columnsTable.setLinesVisible(true);
        gd = new GridData(1808);
        gd.widthHint = 500;
        gd.heightHint = 100;
        this.columnsTable.setLayoutData((Object)gd);
        UIUtils.createTableColumn((Table)this.columnsTable, (int)16384, (String)EditorsMessages.dialog_struct_edit_fk_column_column);
        UIUtils.createTableColumn((Table)this.columnsTable, (int)16384, (String)EditorsMessages.dialog_struct_edit_fk_column_col_type);
        UIUtils.createTableColumn((Table)this.columnsTable, (int)16384, (String)EditorsMessages.dialog_struct_edit_fk_column_ref_col);
        UIUtils.createTableColumn((Table)this.columnsTable, (int)16384, (String)EditorsMessages.dialog_struct_edit_fk_column_ref_col_type);
        UIUtils.packColumns((Table)this.columnsTable);
        TableEditor tableEditor = new TableEditor(this.columnsTable);
        tableEditor.horizontalAlignment = 0x1000000;
        tableEditor.verticalAlignment = 128;
        tableEditor.grabHorizontal = true;
        tableEditor.minimumWidth = 50;
        this.columnsTable.addMouseListener((MouseListener)new ColumnsMouseListener(tableEditor, this.columnsTable));
        if (!ArrayUtils.isEmpty((Object[])this.supportedModifyRules)) {
            Composite cascadeGroup = UIUtils.createPlaceholder((Composite)panel, (int)4, (int)5);
            cascadeGroup.setLayoutData((Object)new GridData(768));
            final Combo onDeleteCombo = UIUtils.createLabelCombo((Composite)cascadeGroup, (String)EditorsMessages.dialog_struct_edit_fk_combo_on_delete, (int)12);
            onDeleteCombo.setLayoutData((Object)new GridData(768));
            final Combo onUpdateCombo = UIUtils.createLabelCombo((Composite)cascadeGroup, (String)EditorsMessages.dialog_struct_edit_fk_combo_on_update, (int)12);
            onUpdateCombo.setLayoutData((Object)new GridData(768));
            DBSForeignKeyModifyRule[] dBSForeignKeyModifyRuleArray = this.supportedModifyRules;
            int n = this.supportedModifyRules.length;
            int n2 = 0;
            while (n2 < n) {
                DBSForeignKeyModifyRule modifyRule = dBSForeignKeyModifyRuleArray[n2];
                onDeleteCombo.add(modifyRule.getName());
                onUpdateCombo.add(modifyRule.getName());
                ++n2;
            }
            onDeleteCombo.select(0);
            onUpdateCombo.select(0);
            this.onDeleteRule = this.onUpdateRule = this.supportedModifyRules[0];
            onDeleteCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditForeignKeyPage.this.onDeleteRule = EditForeignKeyPage.this.supportedModifyRules[onDeleteCombo.getSelectionIndex()];
                }
            });
            onUpdateCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditForeignKeyPage.this.onUpdateRule = EditForeignKeyPage.this.supportedModifyRules[onUpdateCombo.getSelectionIndex()];
                }
            });
        }
        this.tableList.setFocus();
        return panel;
    }

    private void defineRefTableConstraint() {
        if (this.curRefTable == null) {
            log.error((Object)"No reference table");
            return;
        }
        DBVEntity vRefEntity = DBVUtils.getVirtualEntity((DBSEntity)this.curRefTable, (boolean)true);
        DBVEntityConstraint constraint = vRefEntity.getBestIdentifier();
        EditConstraintPage page = new EditConstraintPage("Define unique key", (DBSEntityReferrer)constraint);
        if (page.edit()) {
            constraint.setAttributes(page.getSelectedAttributes());
            this.handleRefTableSelect(DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject((DBSObject)this.curRefTable));
        }
    }

    private void createSchemaSelector(Composite tableGroup) throws DBException {
        DBNDatabaseNode schemaContainerNode = null;
        DBNNode node = this.ownerTableNode.getParentNode();
        while (node != null) {
            DBSObject nodeObject;
            if (node instanceof DBNDatabaseNode && ((nodeObject = ((DBNDatabaseNode)node).getObject()) instanceof DBSSchema || nodeObject instanceof DBSCatalog) && node.getParentNode() instanceof DBNDatabaseNode) {
                schemaContainerNode = (DBNDatabaseNode)node.getParentNode();
                break;
            }
            node = node.getParentNode();
        }
        if (schemaContainerNode != null) {
            LabelProvider labelProvider = new LabelProvider(){

                public Image getImage(Object element) {
                    return DBeaverIcons.getImage((DBPImage)((DBNDatabaseNode)element).getNodeIcon());
                }

                public String getText(Object element) {
                    return ((DBNDatabaseNode)element).getNodeName();
                }
            };
            boolean isSchema = this.foreignKey.getParentObject().getParentObject() instanceof DBSSchema;
            DBPDataSourceInfo dsInfo = this.foreignKey.getDataSource().getInfo();
            UIUtils.createControlLabel((Composite)tableGroup, (String)(isSchema ? dsInfo.getSchemaTerm() : dsInfo.getCatalogTerm()));
            final CSmartCombo schemaCombo = new CSmartCombo(tableGroup, 2048, (ILabelProvider)labelProvider);
            schemaCombo.setLayoutData((Object)new GridData(32));
            DBNDatabaseNode selectedNode = null;
            DBNDatabaseNode[] dBNDatabaseNodeArray = schemaContainerNode.getChildren((DBRProgressMonitor)new VoidProgressMonitor());
            int n = dBNDatabaseNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBNDatabaseNode node2 = dBNDatabaseNodeArray[n2];
                if (node2 instanceof DBNDatabaseNode && node2.getObject() instanceof DBSObjectContainer) {
                    schemaCombo.addItem((Object)node2);
                    if (node2.getObject() == this.foreignKey.getParentObject().getParentObject()) {
                        selectedNode = node2;
                    }
                }
                ++n2;
            }
            if (selectedNode != null) {
                schemaCombo.select(selectedNode);
            }
            schemaCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DBNDatabaseNode newContainerNode = null;
                    DBXTreeNode tableContainerMeta = ((DBNDatabaseNode)EditForeignKeyPage.this.ownerTableNode.getParentNode()).getMeta();
                    DBNDatabaseNode schemaNode = (DBNDatabaseNode)schemaCombo.getSelectedItem();
                    if (schemaNode.getMeta() == tableContainerMeta) {
                        newContainerNode = schemaNode;
                    } else {
                        try {
                            DBNDatabaseNode[] dBNDatabaseNodeArray = schemaNode.getChildren((DBRProgressMonitor)new VoidProgressMonitor());
                            int n = dBNDatabaseNodeArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                DBNDatabaseNode child = dBNDatabaseNodeArray[n2];
                                if (child instanceof DBNDatabaseNode && child.getMeta() == tableContainerMeta) {
                                    newContainerNode = child;
                                    break;
                                }
                                ++n2;
                            }
                        }
                        catch (DBException e1) {
                            log.debug((Object)e1);
                        }
                    }
                    if (newContainerNode != null) {
                        EditForeignKeyPage.this.loadTableList(newContainerNode);
                    }
                }
            });
        }
    }

    private void createContainerSelector(Composite tableGroup) throws DBException {
        ObjectContainerSelectorPanel containerPanel = new ObjectContainerSelectorPanel(tableGroup, "Reference table container", "Select reference table catalog/schema"){

            @Nullable
            protected DBNNode getSelectedNode() {
                Object containerObject = EditForeignKeyPage.this.ownerTableNode != null ? EditForeignKeyPage.this.ownerTableNode.getObject() : EditForeignKeyPage.this.foreignKey.getParentObject();
                if (containerObject != null && containerObject.getParentObject() instanceof DBSObjectContainer) {
                    containerObject = containerObject.getParentObject();
                }
                if (containerObject instanceof DBVContainer) {
                    try {
                        containerObject = ((DBVContainer)containerObject).getRealContainer((DBRProgressMonitor)new VoidProgressMonitor());
                    }
                    catch (DBException e) {
                        log.error((Object)"Error getting real object container", (Throwable)e);
                    }
                }
                return DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject(containerObject);
            }

            protected void setSelectedNode(DBNDatabaseNode node) {
                EditForeignKeyPage.this.ownerTableNode = node;
                if (node == null) {
                    this.setContainerInfo((DBPImage)DBIcon.TYPE_UNKNOWN, "");
                } else {
                    this.setContainerInfo(node.getNodeIconDefault(), node.getNodeFullName());
                    EditForeignKeyPage.this.loadTableList(EditForeignKeyPage.this.ownerTableNode);
                }
            }
        };
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        containerPanel.setLayoutData((Object)gd);
        if (this.ownerTableNode != null) {
            DBNNode containerNode = this.ownerTableNode.getParentNode();
            while (containerNode instanceof DBNDatabaseFolder) {
                containerNode = containerNode.getParentNode();
            }
            containerPanel.setContainerInfo(containerNode.getNodeIconDefault(), containerNode.getNodeFullName());
        }
    }

    private void loadTableList(DBNDatabaseNode newContainerNode) {
        this.tableList.removeAll();
        ArrayList entities = new ArrayList();
        try {
            UIUtils.runInProgressDialog(monitor -> {
                try {
                    this.loadEntities(monitor, entities, newContainerNode);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Error loading tables", "Error during table load", (Throwable)e);
        }
        for (DBNDatabaseNode entityNode : entities) {
            TableItem tableItem = new TableItem(this.tableList, 16384);
            tableItem.setText(entityNode.getNodeName());
            tableItem.setImage(DBeaverIcons.getImage((DBPImage)entityNode.getNodeIconDefault()));
            tableItem.setData((Object)entityNode);
        }
    }

    private void loadEntities(DBRProgressMonitor monitor, List<DBNDatabaseNode> entities, DBNDatabaseNode container) throws DBException {
        DBNDatabaseNode[] dBNDatabaseNodeArray = container.getChildren(monitor);
        int n = dBNDatabaseNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBSObject object;
            DBNDatabaseNode childNode = dBNDatabaseNodeArray[n2];
            if (monitor.isCanceled()) break;
            if (childNode instanceof DBNDatabaseFolder) {
                Class childrenClass = ((DBNDatabaseFolder)childNode).getChildrenClass(((DBNDatabaseFolder)childNode).getItemsMeta());
                if (DBSEntity.class.isAssignableFrom(childrenClass)) {
                    this.loadEntities(monitor, entities, (DBNDatabaseNode)((DBNDatabaseFolder)childNode));
                }
            } else if (childNode instanceof DBNDatabaseNode && (object = childNode.getObject()) instanceof DBSEntity && !(object instanceof DBSSequence) && !(object instanceof DBSDataType)) {
                entities.add(childNode);
            }
            ++n2;
        }
    }

    private void handleRefTableSelect(DBNDatabaseNode refTableNode) {
        if (refTableNode != null) {
            DBSObject object = refTableNode.getObject();
            if (object instanceof DBSEntity) {
                this.curRefTable = (DBSEntity)refTableNode.getObject();
            }
            if (this.fkNameText != null) {
                this.fkNameText.setText("FK_" + refTableNode.getObject().getName());
            }
        }
        this.uniqueKeyCombo.removeAll();
        try {
            this.curConstraints = new ArrayList<DBSEntityConstraint>();
            this.curConstraint = null;
            if (refTableNode != null) {
                DBSEntity refTable = (DBSEntity)refTableNode.getObject();
                UIUtils.runInProgressService(monitor -> {
                    try {
                        Collection indexes;
                        this.foreignKey.getParentObject().getAttributes(monitor);
                        refTable.getAttributes(monitor);
                        List constraints = DBVUtils.getAllConstraints((DBRProgressMonitor)monitor, (DBSEntity)refTable);
                        if (!CommonUtils.isEmpty((Collection)constraints)) {
                            for (DBSEntityConstraint constraint : constraints) {
                                if (!constraint.getConstraintType().isUnique()) continue;
                                this.curConstraints.add(constraint);
                            }
                        }
                        if (refTable instanceof DBSTable && !CommonUtils.isEmpty((Collection)(indexes = ((DBSTable)refTable).getIndexes(monitor)))) {
                            for (DBSTableIndex constraint : indexes) {
                                if (!constraint.getConstraintType().isUnique()) continue;
                                this.curConstraints.add((DBSEntityConstraint)constraint);
                            }
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            for (DBSEntityConstraint constraint : this.curConstraints) {
                this.uniqueKeyCombo.add(constraint.getName());
            }
            if (this.uniqueKeyCombo.getItemCount() == 0) {
                if (refTableNode == null) {
                    this.uniqueKeyCombo.add("<No reference table selected>");
                } else {
                    this.uniqueKeyCombo.add("<No unique keys in table '" + DBUtils.getObjectFullName((DBPNamedObject)refTableNode.getObject(), (DBPEvaluationContext)DBPEvaluationContext.UI) + "'>");
                }
                this.uniqueKeyCombo.select(0);
                this.curConstraint = null;
            } else {
                this.uniqueKeyCombo.select(0);
                this.curConstraint = this.curConstraints.get(0);
            }
            if (this.enableCustomKeys) {
                if (this.curConstraint == null) {
                    this.customUKButton.setEnabled(true);
                    this.customUKButton.setText("Create");
                } else if (this.curConstraint instanceof DBVEntityConstraint) {
                    this.customUKButton.setEnabled(true);
                    this.customUKButton.setText("Edit");
                } else {
                    this.customUKButton.setEnabled(false);
                }
            }
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError(EditorsMessages.dialog_struct_edit_fk_error_load_constraints_title, EditorsMessages.dialog_struct_edit_fk_error_load_constraints_message, e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        this.handleUniqueKeySelect();
        this.updatePageState();
    }

    private void handleUniqueKeySelect() {
        this.fkColumns.clear();
        this.ownColumns = null;
        this.columnsTable.removeAll();
        int ukSelectionIndex = this.uniqueKeyCombo.getSelectionIndex();
        if ((this.curConstraints.isEmpty() || ukSelectionIndex < 0) && !this.enableCustomKeys) {
            return;
        }
        DBSEntity curEntity = this.foreignKey.getParentObject();
        VoidProgressMonitor monitor = new VoidProgressMonitor();
        try {
            Collection tmpColumns = curEntity.getAttributes((DBRProgressMonitor)monitor);
            ArrayList<DBSEntityAttribute> arrayList = this.ownColumns = tmpColumns == null ? Collections.emptyList() : new ArrayList<DBSEntityAttribute>(EditForeignKeyPage.getValidAttributes(curEntity));
            if (this.curConstraint instanceof DBSEntityReferrer) {
                for (DBSEntityAttributeRef pkColumn : ((DBSEntityReferrer)this.curConstraint).getAttributeReferences((DBRProgressMonitor)monitor)) {
                    FKColumnInfo fkColumnInfo = new FKColumnInfo(pkColumn.getAttribute());
                    if (!CommonUtils.isEmpty(this.ownColumns)) {
                        for (DBSEntityAttribute dBSEntityAttribute : this.ownColumns) {
                            if (!dBSEntityAttribute.getName().equals(pkColumn.getAttribute().getName()) || curEntity == pkColumn.getAttribute().getParentObject()) continue;
                            fkColumnInfo.ownColumn = dBSEntityAttribute;
                            break;
                        }
                    }
                    this.fkColumns.add(fkColumnInfo);
                    TableItem tableItem = new TableItem(this.columnsTable, 0);
                    if (fkColumnInfo.ownColumn != null) {
                        tableItem.setText(0, fkColumnInfo.ownColumn.getName());
                        tableItem.setImage(0, this.getColumnIcon(fkColumnInfo.ownColumn));
                        tableItem.setText(1, fkColumnInfo.ownColumn.getFullTypeName());
                    }
                    tableItem.setText(2, pkColumn.getAttribute().getName());
                    tableItem.setImage(2, this.getColumnIcon(pkColumn.getAttribute()));
                    tableItem.setText(3, pkColumn.getAttribute().getFullTypeName());
                    tableItem.setData((Object)fkColumnInfo);
                }
            } else if (this.enableCustomKeys) {
                // empty if block
            }
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError(EditorsMessages.dialog_struct_edit_fk_error_load_constraint_columns_title, EditorsMessages.dialog_struct_edit_fk_error_load_constraint_columns_message, (Throwable)e);
        }
        UIUtils.packColumns((Table)this.columnsTable, (boolean)true);
    }

    private static List<DBSEntityAttribute> getValidAttributes(DBSEntity table) throws DBException {
        ArrayList<DBSEntityAttribute> result = new ArrayList<DBSEntityAttribute>();
        for (DBSEntityAttribute attr : table.getAttributes((DBRProgressMonitor)new VoidProgressMonitor())) {
            if (DBUtils.isHiddenObject((Object)attr) || DBUtils.isPseudoAttribute((DBSAttributeBase)attr)) continue;
            result.add(attr);
        }
        return result;
    }

    private Image getColumnIcon(DBSEntityAttribute column) {
        return DBeaverIcons.getImage((DBPImage)DBValueFormatting.getObjectImage((DBPObject)column));
    }

    @Override
    public boolean isPageComplete() {
        if (this.fkColumns.isEmpty()) {
            return false;
        }
        for (FKColumnInfo col : this.fkColumns) {
            if (col.ownColumn != null && col.refColumn != null) continue;
            return false;
        }
        return true;
    }

    public List<FKColumnInfo> getColumns() {
        return this.fkColumns;
    }

    public DBSForeignKeyModifyRule getOnDeleteRule() {
        return this.onDeleteRule;
    }

    public DBSForeignKeyModifyRule getOnUpdateRule() {
        return this.onUpdateRule;
    }

    public DBSEntityConstraint getUniqueConstraint() {
        return this.curConstraint;
    }

    private void assignForeignKeyRefConstraint(FKColumnInfo fkInfo, CCombo columnsCombo, TableItem item) {
        fkInfo.ownColumn = this.ownColumns.get(columnsCombo.getSelectionIndex());
        item.setText(0, fkInfo.ownColumn.getName());
        item.setImage(0, this.getColumnIcon(fkInfo.ownColumn));
        item.setText(1, fkInfo.ownColumn.getFullTypeName());
        this.updatePageState();
    }

    public boolean isEnabled() {
        return true;
    }

    public String getName() {
        return this.fkName;
    }

    protected boolean supportsCustomName() {
        return false;
    }

    private class ColumnsMouseListener
    extends MouseAdapter {
        private final TableEditor tableEditor;
        private final Table columnsTable;

        ColumnsMouseListener(TableEditor tableEditor, Table columnsTable) {
            this.tableEditor = tableEditor;
            this.columnsTable = columnsTable;
        }

        private void disposeOldEditor() {
            Control oldEditor = this.tableEditor.getEditor();
            if (oldEditor != null) {
                oldEditor.dispose();
            }
        }

        public void mouseUp(MouseEvent e) {
            this.handleColumnClick(e);
        }

        private void handleColumnClick(MouseEvent e) {
            this.disposeOldEditor();
            final TableItem item = this.columnsTable.getItem(new Point(e.x, e.y));
            if (item == null) {
                return;
            }
            final FKColumnInfo fkInfo = (FKColumnInfo)item.getData();
            int columnIndex = UIUtils.getColumnAtPos((TableItem)item, (int)e.x, (int)e.y);
            if (fkInfo.ownColumn == null && columnIndex != 0) {
                return;
            }
            if (fkInfo.refColumn == null && columnIndex != 2) {
                return;
            }
            final CCombo columnsCombo = new CCombo((Composite)this.columnsTable, 12);
            if (!CommonUtils.isEmpty((Collection)EditForeignKeyPage.this.ownColumns)) {
                for (DBSEntityAttribute ownColumn : EditForeignKeyPage.this.ownColumns) {
                    columnsCombo.add(ownColumn.getName());
                    if (fkInfo.ownColumn != ownColumn) continue;
                    columnsCombo.select(columnsCombo.getItemCount() - 1);
                }
                if (columnsCombo.getSelectionIndex() < 0) {
                    columnsCombo.select(0);
                }
            }
            columnsCombo.setFocus();
            columnsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (columnsCombo.getSelectionIndex() >= 0) {
                        EditForeignKeyPage.this.assignForeignKeyRefConstraint(fkInfo, columnsCombo, item);
                    }
                }
            });
            columnsCombo.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (columnsCombo.getSelectionIndex() >= 0) {
                        EditForeignKeyPage.this.assignForeignKeyRefConstraint(fkInfo, columnsCombo, item);
                    }
                    ColumnsMouseListener.this.disposeOldEditor();
                }
            });
            this.tableEditor.setEditor((Control)columnsCombo, item, 0);
        }
    }

    public static class FKColumnInfo {
        final DBSEntityAttribute refColumn;
        DBSEntityAttribute ownColumn;

        FKColumnInfo(DBSEntityAttribute refColumn) {
            this.refColumn = refColumn;
        }

        public DBSEntityAttribute getRefColumn() {
            return this.refColumn;
        }

        public DBSEntityAttribute getOwnColumn() {
            return this.ownColumn;
        }
    }
}

