/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.control;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.services.IServiceLocator;
import org.jfree.chart.JFreeChart;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.charts.BaseChartComposite;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardItem;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewType;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardRegistry;
import org.jkiss.dbeaver.ui.dashboard.view.DashboardItemConfigDialog;
import org.jkiss.dbeaver.ui.dashboard.view.DashboardItemViewDialog;

public class DashboardChartComposite
extends BaseChartComposite {
    private final DashboardViewContainer viewContainer;
    private final DashboardContainer dashboardContainer;

    public DashboardChartComposite(DashboardContainer dashboardContainer, DashboardViewContainer viewContainer, Composite parent, int style, Point preferredSize) {
        super(parent, style, preferredSize);
        this.dashboardContainer = dashboardContainer;
        this.viewContainer = viewContainer;
    }

    public DashboardViewContainer getViewContainer() {
        return this.viewContainer;
    }

    protected boolean isSingleChartMode() {
        return this.viewContainer.isSingleChartMode();
    }

    protected void fillContextMenu(IMenuManager manager) {
        if (!this.isSingleChartMode()) {
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)UIUtils.getActiveWorkbenchWindow(), (String)"org.jkiss.dbeaver.ui.dashboard.view"));
            manager.add((IContributionItem)new Separator());
        }
        super.fillContextMenu(manager);
        if (!UIUtils.isInDialog((Control)this)) {
            manager.add((IContributionItem)new Separator());
            MenuManager viewMenu = new MenuManager("View as");
            List<DashboardViewType> viewTypes = DashboardRegistry.getInstance().getSupportedViewTypes(this.dashboardContainer.getDashboardDataType());
            for (final DashboardViewType viewType : viewTypes) {
                Action changeViewAction = new Action(viewType.getTitle(), 8){

                    public boolean isChecked() {
                        return DashboardChartComposite.this.dashboardContainer.getDashboardViewType() == viewType;
                    }

                    public void runWithEvent(Event event) {
                        ((DashboardItem)DashboardChartComposite.this.dashboardContainer).getDashboardConfig().setViewType(viewType);
                        DashboardChartComposite.this.dashboardContainer.getGroup().getView().getViewConfiguration().saveSettings();
                        DashboardChartComposite.this.dashboardContainer.updateDashboardView();
                    }
                };
                if (viewType.getIcon() != null) {
                    changeViewAction.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)viewType.getIcon()));
                }
                viewMenu.add((IAction)changeViewAction);
            }
            manager.add((IContributionItem)viewMenu);
        }
        if (!this.isSingleChartMode()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)UIUtils.getActiveWorkbenchWindow(), (String)"org.jkiss.dbeaver.ui.dashboard.add"));
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)UIUtils.getActiveWorkbenchWindow(), (String)"org.jkiss.dbeaver.ui.dashboard.remove"));
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)UIUtils.getActiveWorkbenchWindow(), (String)"org.jkiss.dbeaver.ui.dashboard.reset"));
        }
    }

    public void setChart(JFreeChart chart) {
        super.setChart(chart);
        if (chart != null && !this.isSingleChartMode()) {
            this.setDomainZoomable(false);
            this.setRangeZoomable(false);
        }
    }

    protected boolean showChartConfigDialog() {
        boolean changed;
        DashboardItemConfigDialog dialog = new DashboardItemConfigDialog(this.getShell(), this.dashboardContainer, this.viewContainer.getViewConfiguration());
        boolean bl = changed = dialog.open() == 0;
        if (changed) {
            this.dashboardContainer.updateDashboardView();
        }
        return changed;
    }

    public void mouseDoubleClick(MouseEvent event) {
        if (this.viewContainer.isSingleChartMode()) {
            this.restoreAutoBounds();
        } else {
            DashboardItemViewDialog viewDialog = new DashboardItemViewDialog(this.viewContainer, (DashboardItem)this.dashboardContainer);
            viewDialog.open();
        }
    }
}

