/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.convert;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.StyledTextUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.convert.ISQLTextConverter;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.BaseSQLDialog;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLConverterRegistry;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLTargetConverterDescriptor;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class CopySourceCodeHandler
extends AbstractHandler
implements IElementUpdater {
    private static final Log log = Log.getLog(CopySourceCodeHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        TargetFormatDialog dialog;
        SQLScriptElement activeQuery;
        SQLEditor editor = (SQLEditor)((Object)RuntimeUtils.getObjectAdapter((Object)HandlerUtil.getActiveEditor((ExecutionEvent)event), SQLEditor.class));
        if (editor == null) {
            return null;
        }
        ISelection selection = editor.getSelectionProvider().getSelection();
        if (selection.isEmpty() || !(selection instanceof TextSelection)) {
            return null;
        }
        TextSelection textSelection = (TextSelection)selection;
        if (textSelection.getLength() < 2 && (activeQuery = editor.extractActiveQuery()) != null && activeQuery.getLength() > 1) {
            textSelection = new TextSelection(editor.getDocument(), activeQuery.getOffset(), activeQuery.getLength());
        }
        if ((dialog = new TargetFormatDialog(editor, textSelection)).open() != 0) {
            return null;
        }
        UIUtils.setClipboardContents((Display)Display.getCurrent(), (Transfer)TextTransfer.getInstance(), (Object)dialog.getConvertedText());
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        element.setText(SQLEditorMessages.editors_sql_actions_copy_as_source_code);
        element.setTooltip(SQLEditorMessages.editors_sql_actions_copy_as_source_code_tip);
    }

    private static class TargetFormatDialog
    extends BaseSQLDialog {
        private static final String DIALOG_ID = "DBeaver.SQLTargetFormatDialog";
        private final SQLEditor editor;
        private final TextSelection selection;
        private PropertyTreeViewer propsViewer;
        private StyledText targetText;
        private SQLTargetConverterDescriptor curFormat;
        private Map<String, Object> options = new HashMap<String, Object>();
        private String result;
        private PropertySourceCustom propertySource;

        TargetFormatDialog(SQLEditor editor, TextSelection selection) {
            super(editor.getSite(), SQLEditorMessages.sql_editor_menu_choose_format, null);
            this.editor = editor;
            this.selection = selection;
        }

        protected IDialogSettings getDialogBoundsSettings() {
            return UIUtils.getDialogSettings((String)DIALOG_ID);
        }

        protected Composite createDialogArea(Composite parent) {
            String formatId = this.getDialogBoundsSettings().get("format");
            if (formatId != null) {
                this.curFormat = SQLConverterRegistry.getInstance().getTargetConverter(formatId);
                if (this.curFormat == null) {
                    log.warn((Object)("Can't find SQL text converter '" + formatId + "'"));
                }
            }
            Composite composite = super.createDialogArea(parent);
            ((GridLayout)composite.getLayout()).numColumns = 2;
            SelectionAdapter formatChangeListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((Button)e.widget).getSelection()) {
                        if (curFormat == e.widget.getData()) {
                            return;
                        }
                        this.saveOptions();
                        curFormat = (SQLTargetConverterDescriptor)((Object)e.widget.getData());
                        this.loadOptions();
                        this.onFormatChange();
                    }
                }
            };
            Composite formatPanel = UIUtils.createPlaceholder((Composite)composite, (int)1);
            GridData gd = new GridData(1808);
            gd.minimumWidth = 200;
            formatPanel.setLayoutData((Object)gd);
            Group formatsGroup = UIUtils.createControlGroup((Composite)formatPanel, (String)SQLEditorMessages.sql_editor_panel_format, (int)1, (int)768, (int)0);
            for (SQLTargetConverterDescriptor converter : SQLConverterRegistry.getInstance().getTargetConverters()) {
                Button formatButton = new Button((Composite)formatsGroup, 16);
                formatButton.setText(converter.getLabel());
                formatButton.setToolTipText(converter.getDescription());
                formatButton.setData((Object)converter);
                if (this.curFormat == converter) {
                    formatButton.setSelection(true);
                }
                formatButton.addSelectionListener((SelectionListener)formatChangeListener);
            }
            Group settingsGroup = UIUtils.createControlGroup((Composite)formatPanel, (String)SQLEditorMessages.pref_page_sql_format_label_settings, (int)1, (int)768, (int)0);
            settingsGroup.setLayoutData((Object)new GridData(1808));
            this.propsViewer = new PropertyTreeViewer((Composite)settingsGroup, 2048);
            this.propsViewer.getTree().addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    this.saveOptions();
                    this.refreshResult();
                    targetText.setText(result);
                }
            });
            Composite previewPanel = new Composite(composite, 0);
            previewPanel.setLayoutData((Object)new GridData(1808));
            previewPanel.setLayout((Layout)new GridLayout(1, false));
            SashForm sash = new SashForm(previewPanel, 512);
            sash.setLayoutData((Object)new GridData(1808));
            this.createSQLPanel((Composite)sash);
            Composite targetGroup = UIUtils.createPlaceholder((Composite)sash, (int)1, (int)5);
            targetGroup.setLayoutData((Object)new GridData(1808));
            UIUtils.createControlLabel((Composite)targetGroup, (String)SQLEditorMessages.controls_querylog_column_result_name);
            this.targetText = new StyledText(targetGroup, 2632);
            this.targetText.setLayoutData((Object)new GridData(1808));
            this.targetText.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
            StyledTextUtils.fillDefaultStyledTextContextMenu((StyledText)this.targetText);
            this.loadOptions();
            this.onFormatChange();
            return composite;
        }

        private void loadOptions() {
            this.options.clear();
            if (this.curFormat != null) {
                IDialogSettings formatSettings = UIUtils.getSettingsSection((IDialogSettings)this.getDialogBoundsSettings(), (String)this.curFormat.getId());
                for (DBPPropertyDescriptor prop : this.curFormat.getProperties()) {
                    Object propValue = formatSettings.get(CommonUtils.toString((Object)prop.getId()));
                    if (propValue == null) {
                        propValue = prop.getDefaultValue();
                    }
                    if (propValue == null) continue;
                    this.options.put(CommonUtils.toString((Object)prop.getId()), propValue);
                }
            }
        }

        private void saveOptions() {
            if (this.propertySource != null && this.curFormat != null) {
                IDialogSettings formatSettings = UIUtils.getSettingsSection((IDialogSettings)this.getDialogBoundsSettings(), (String)this.curFormat.getId());
                for (Map.Entry entry : this.propertySource.getPropertiesWithDefaults().entrySet()) {
                    this.options.put(CommonUtils.toString(entry.getKey()), entry.getValue());
                    formatSettings.put(CommonUtils.toString(entry.getKey()), CommonUtils.toString(entry.getValue()));
                }
            }
        }

        private void onFormatChange() {
            if (this.curFormat != null) {
                this.propertySource = new PropertySourceCustom(this.curFormat.getProperties(), this.options);
                this.propsViewer.loadProperties((DBPPropertySource)this.propertySource);
                this.refreshResult();
            } else {
                this.result = "Choose format";
            }
            this.targetText.setText(this.result);
        }

        private void refreshResult() {
            try {
                ISQLTextConverter converter = this.curFormat.createInstance(ISQLTextConverter.class);
                this.result = converter.convertText(this.editor.getSQLDialect(), this.editor.getSyntaxManager(), this.editor.getRuleManager(), this.editor.getDocument(), this.selection.getOffset(), this.selection.getLength(), this.options);
            }
            catch (DBException e) {
                log.error((Object)e);
                this.result = CommonUtils.notEmpty((String)e.getMessage());
            }
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            Button okButton = this.getButton(0);
            if (okButton != null) {
                okButton.setText(SQLEditorMessages.dialog_view_sql_button_copy);
            }
        }

        String getConvertedText() {
            return this.result;
        }

        @Override
        protected DBCExecutionContext getExecutionContext() {
            return this.editor.getExecutionContext();
        }

        @Override
        protected String getSQLText() {
            return this.selection.getText();
        }

        protected void okPressed() {
            if (this.curFormat != null) {
                this.saveOptions();
                IDialogSettings dialogSettings = this.getDialogBoundsSettings();
                dialogSettings.put("format", this.curFormat.getId());
            }
            super.okPressed();
        }
    }
}

