/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataType;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabaseTrigger;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObjectClass;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.utils.LongKeyMap;

public class SQLServerDatabase
implements DBSCatalog,
DBPSaveableObject,
DBPRefreshableObject,
DBPSystemObject,
DBSObjectSelector {
    private static final Log log = Log.getLog(SQLServerDatabase.class);
    private final SQLServerDataSource dataSource;
    private boolean persisted;
    private String name;
    private String description;
    private DataTypeCache typesCache = new DataTypeCache();
    private SchemaCache schemaCache = new SchemaCache();
    private TriggerCache triggerCache = new TriggerCache();

    SQLServerDatabase(SQLServerDataSource dataSource, JDBCResultSet resultSet) {
        this.dataSource = dataSource;
        this.name = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"name");
        this.persisted = true;
    }

    public SQLServerDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, editable=true, order=1)
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, editable=true, updatable=true, multiline=true, order=100)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DBSObject getParentObject() {
        return this.dataSource;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public boolean isSystem() {
        return this.name.equals("msdb");
    }

    public DBSObject refreshObject(DBRProgressMonitor monitor) {
        this.typesCache.clearCache();
        this.schemaCache.clearCache();
        this.triggerCache.clearCache();
        return this;
    }

    @Association
    public Collection<SQLServerDataType> getDataTypes(DBRProgressMonitor monitor) throws DBException {
        return this.typesCache.getAllObjects(monitor, (DBSObject)this);
    }

    public SQLServerDataType getDataType(DBRProgressMonitor monitor, String typeName) throws DBException {
        return (SQLServerDataType)this.typesCache.getObject(monitor, (DBSObject)this, typeName);
    }

    public SQLServerDataType getDataTypeByUserTypeId(DBRProgressMonitor monitor, int typeID) throws DBException {
        this.typesCache.getAllObjects(monitor, (DBSObject)this);
        SQLServerDataType dataType = this.typesCache.getDataType(typeID);
        if (dataType != null) {
            return dataType;
        }
        dataType = this.dataSource.getSystemDataType(typeID);
        if (dataType != null) {
            return dataType;
        }
        log.debug((Object)("Data type '" + typeID + "' not found in database " + this.getName()));
        return null;
    }

    public boolean supportsDefaultChange() {
        return false;
    }

    public DBSObject getDefaultObject() {
        return this.schemaCache.getCachedObject("dbo");
    }

    public void setDefaultObject(DBRProgressMonitor monitor, DBSObject object) throws DBException {
        throw new DBException("SQL Server doesn't support default schema change");
    }

    public boolean refreshDefaultObject(DBCSession session) throws DBException {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    @Association
    public Collection<SQLServerSchema> getSchemas(DBRProgressMonitor monitor) throws DBException {
        return this.getChildren(monitor);
    }

    public SQLServerSchema getSchema(DBRProgressMonitor monitor, long schemaId) throws DBException {
        for (SQLServerSchema schema : this.getSchemas(monitor)) {
            if (schema.getObjectId() != schemaId) continue;
            return schema;
        }
        if (!monitor.isCanceled()) {
            log.debug((Object)("Schema '" + schemaId + "' not found"));
        }
        return null;
    }

    public SQLServerSchema getSchema(DBRProgressMonitor monitor, String name) throws DBException {
        return (SQLServerSchema)this.schemaCache.getObject(monitor, (DBSObject)this, name);
    }

    public Collection<SQLServerSchema> getChildren(DBRProgressMonitor monitor) throws DBException {
        return this.schemaCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DBSObject getChild(DBRProgressMonitor monitor, String childName) throws DBException {
        return this.schemaCache.getObject(monitor, (DBSObject)this, childName);
    }

    public Class<? extends DBSObject> getChildType(DBRProgressMonitor monitor) {
        return SQLServerSchema.class;
    }

    public void cacheStructure(DBRProgressMonitor monitor, int scope) throws DBException {
        this.schemaCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public Collection<SQLServerDatabaseTrigger> getTriggers(DBRProgressMonitor monitor) throws DBException {
        return this.triggerCache.getAllObjects(monitor, (DBSObject)this);
    }

    public TriggerCache getTriggerCache() {
        return this.triggerCache;
    }

    private class DataTypeCache
    extends JDBCObjectCache<SQLServerDatabase, SQLServerDataType> {
        private LongKeyMap<SQLServerDataType> dataTypeMap = new LongKeyMap();

        private DataTypeCache() {
        }

        protected JDBCStatement prepareObjectsStatement(JDBCSession session, SQLServerDatabase database) throws SQLException {
            return session.prepareStatement("SELECT * FROM " + SQLServerUtils.getSystemTableName(database, "types") + " WHERE is_user_defined = 1 order by name");
        }

        protected SQLServerDataType fetchObject(JDBCSession session, SQLServerDatabase database, JDBCResultSet resultSet) {
            return new SQLServerDataType((DBSObject)database, (ResultSet)resultSet);
        }

        public SQLServerDataType getDataType(long typeID) {
            return (SQLServerDataType)this.dataTypeMap.get(typeID);
        }

        public void clearCache() {
            super.clearCache();
            this.dataTypeMap.clear();
        }

        public void removeObject(@NotNull SQLServerDataType object, boolean resetFullCache) {
            super.removeObject((DBSObject)object, resetFullCache);
            this.dataTypeMap.remove(object.getObjectId());
        }

        public void cacheObject(@NotNull SQLServerDataType object) {
            super.cacheObject((DBSObject)object);
            this.dataTypeMap.put(object.getObjectId(), (Object)object);
        }

        public void setCache(List<SQLServerDataType> cache) {
            super.setCache(cache);
            for (SQLServerDataType dt : cache) {
                this.dataTypeMap.put(dt.getObjectId(), (Object)dt);
            }
        }
    }

    static class SchemaCache
    extends JDBCObjectCache<SQLServerDatabase, SQLServerSchema> {
        SchemaCache() {
            this.setListOrderComparator(DBUtils.nameComparatorIgnoreCase());
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull SQLServerDatabase owner) throws SQLException {
            DBSObjectFilter schemaFilters;
            SQLServerDataSource dataSource = owner.getDataSource();
            boolean showAllSchemas = SQLServerUtils.isShowAllSchemas((DBPDataSource)dataSource);
            String sysSchema = SQLServerUtils.getSystemSchemaFQN(dataSource, owner.getName(), "sys");
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT ");
            if (!showAllSchemas) {
                sql.append("DISTINCT ");
            }
            sql.append("s.*,ep.value as description FROM ").append(sysSchema).append(".schemas s");
            sql.append("\nLEFT OUTER JOIN ").append(SQLServerUtils.getExtendedPropsTableName(owner)).append(" ep ON ep.class=").append(SQLServerObjectClass.SCHEMA.getClassId()).append(" AND ep.major_id=s.schema_id AND ep.minor_id=0 AND ep.name='").append("MS_Description").append("'");
            if (!showAllSchemas) {
                sql.append("\nINNER JOIN ").append(sysSchema).append(".");
                if (dataSource.isServerVersionAtLeast(10, 0)) {
                    sql.append("all_objects o ").append("ON s.schema_id=o.schema_id");
                } else {
                    sql.append("sysobjects o ").append("ON s.schema_id=o.uid");
                }
            }
            if ((schemaFilters = dataSource.getContainer().getObjectFilter(SQLServerSchema.class, (DBSObject)owner, false)) != null && schemaFilters.isEnabled()) {
                sql.append("\n");
                JDBCUtils.appendFilterClause((StringBuilder)sql, (DBSObjectFilter)schemaFilters, (String)"s.name", (boolean)true);
            }
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            if (schemaFilters != null) {
                JDBCUtils.setFilterParameters((PreparedStatement)dbStat, (int)1, (DBSObjectFilter)schemaFilters);
            }
            return dbStat;
        }

        protected SQLServerSchema fetchObject(@NotNull JDBCSession session, @NotNull SQLServerDatabase owner, @NotNull JDBCResultSet resultSet) {
            return new SQLServerSchema(owner, resultSet);
        }
    }

    class TriggerCache
    extends JDBCObjectLookupCache<SQLServerDatabase, SQLServerDatabaseTrigger> {
        TriggerCache() {
        }

        public JDBCStatement prepareLookupStatement(JDBCSession session, SQLServerDatabase database, SQLServerDatabaseTrigger object, String objectName) throws SQLException {
            StringBuilder sql = new StringBuilder(500);
            sql.append("SELECT t.* FROM \n").append(SQLServerUtils.getSystemTableName(database, "triggers")).append(" t");
            sql.append("\nWHERE t.parent_id=0");
            if (object != null || objectName != null) {
                sql.append(" AND t.name=?");
            }
            sql.append("\nORDER BY t.name");
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            if (object != null || objectName != null) {
                dbStat.setString(1, object != null ? object.getName() : objectName);
            }
            return dbStat;
        }

        protected SQLServerDatabaseTrigger fetchObject(JDBCSession session, SQLServerDatabase database, JDBCResultSet resultSet) {
            return new SQLServerDatabaseTrigger(database, (ResultSet)resultSet);
        }
    }
}

