/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.internal.ui.refactoring.ChangePreviewViewerDescriptor;
import org.eclipse.ltk.internal.ui.refactoring.PreviewNode;
import org.eclipse.ltk.internal.ui.refactoring.TextEditChangePreviewViewer;
import org.eclipse.ltk.internal.ui.refactoring.TextEditGroupNode;
import org.eclipse.ltk.ui.refactoring.IChangePreviewViewer;
import org.eclipse.ltk.ui.refactoring.TextEditChangeNode;

public abstract class InternalLanguageElementNode
extends TextEditChangeNode.ChildNode {
    private List<TextEditChangeNode.ChildNode> fChildren;
    private GroupCategorySet fGroupCategories;

    protected InternalLanguageElementNode(PreviewNode parent) {
        super(parent);
    }

    @Override
    ChangePreviewViewerDescriptor getChangePreviewViewerDescriptor() throws CoreException {
        TextEditChangeNode element = this.getTextEditChangeNode();
        if (element == null) {
            return null;
        }
        return element.getChangePreviewViewerDescriptor();
    }

    @Override
    void feedInput(IChangePreviewViewer viewer, List<GroupCategory> categories) throws CoreException {
        TextEditChangeNode element = this.getTextEditChangeNode();
        if (element != null) {
            Change change = element.getChange();
            if (change instanceof TextEditBasedChange) {
                List<TextEditBasedChangeGroup> groups = this.collectTextEditBasedChangeGroups(categories);
                viewer.setInput(TextEditChangePreviewViewer.createInput(change, groups.toArray(new TextEditBasedChangeGroup[groups.size()]), this.getTextRange()));
            }
        } else {
            viewer.setInput(null);
        }
    }

    @Override
    void setEnabled(boolean enabled) {
        for (PreviewNode previewNode : this.fChildren) {
            previewNode.setEnabled(enabled);
        }
    }

    @Override
    void setEnabledShallow(boolean enabled) {
    }

    @Override
    int getActive() {
        Assert.isTrue((this.fChildren.size() > 0 ? 1 : 0) != 0);
        int result = ((PreviewNode)this.fChildren.get(0)).getActive();
        int i = 1;
        while (i < this.fChildren.size()) {
            PreviewNode element = this.fChildren.get(i);
            result = PreviewNode.ACTIVATION_TABLE[element.getActive()][result];
            if (result == 1) break;
            ++i;
        }
        return result;
    }

    @Override
    PreviewNode[] getChildren() {
        if (this.fChildren == null) {
            return PreviewNode.EMPTY_CHILDREN;
        }
        return this.fChildren.toArray(new PreviewNode[this.fChildren.size()]);
    }

    @Override
    boolean hasOneGroupCategory(List<GroupCategory> categories) {
        if (this.fChildren == null) {
            return false;
        }
        return this.getGroupCategorySet().containsOneCategory(categories);
    }

    @Override
    boolean hasDerived() {
        if (this.fChildren == null) {
            return false;
        }
        for (PreviewNode previewNode : this.fChildren) {
            if (!previewNode.hasDerived()) continue;
            return true;
        }
        return false;
    }

    private GroupCategorySet getGroupCategorySet() {
        if (this.fGroupCategories == null) {
            this.fGroupCategories = GroupCategorySet.NONE;
            for (PreviewNode previewNode : this.fChildren) {
                GroupCategorySet other = null;
                if (previewNode instanceof TextEditGroupNode) {
                    other = ((TextEditGroupNode)previewNode).getGroupCategorySet();
                } else if (previewNode instanceof InternalLanguageElementNode) {
                    other = ((InternalLanguageElementNode)previewNode).getGroupCategorySet();
                } else {
                    Assert.isTrue((boolean)false, (String)"Shouldn't happen");
                }
                this.fGroupCategories = GroupCategorySet.union((GroupCategorySet)this.fGroupCategories, (GroupCategorySet)other);
            }
        }
        return this.fGroupCategories;
    }

    protected void internalAddChild(TextEditChangeNode.ChildNode child) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList<TextEditChangeNode.ChildNode>(2);
        }
        this.fChildren.add(child);
    }

    private List<TextEditBasedChangeGroup> collectTextEditBasedChangeGroups(List<GroupCategory> categories) {
        ArrayList<TextEditBasedChangeGroup> result = new ArrayList<TextEditBasedChangeGroup>(10);
        PreviewNode[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            PreviewNode child = children[i];
            if (child instanceof TextEditGroupNode) {
                TextEditBasedChangeGroup changeGroup = ((TextEditGroupNode)child).getChangeGroup();
                if (categories == null || changeGroup.getGroupCategorySet().containsOneCategory(categories)) {
                    result.add(changeGroup);
                }
            } else if (child instanceof InternalLanguageElementNode) {
                result.addAll(((InternalLanguageElementNode)child).collectTextEditBasedChangeGroups(categories));
            }
            ++i;
        }
        return result;
    }

    public abstract IRegion getTextRange() throws CoreException;
}

