/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model.meta;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericDataTypeCache;
import org.jkiss.dbeaver.ext.generic.model.GenericFunctionResultType;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericPackage;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSynonym;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndex;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericUtils;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModelDescriptor;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCBasicDataTypeCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCDataType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.utils.CommonUtils;

public class GenericMetaModel {
    private static final Log log = Log.getLog(GenericMetaModel.class);
    GenericMetaModelDescriptor descriptor;

    public GenericMetaObject getMetaObject(String id) {
        return this.descriptor == null ? null : this.descriptor.getObject(id);
    }

    public GenericDataSource createDataSourceImpl(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        return new GenericDataSource(monitor, container, this, (SQLDialect)new GenericSQLDialect());
    }

    public JDBCBasicDataTypeCache<GenericStructContainer, ? extends JDBCDataType> createDataTypeCache(@NotNull GenericStructContainer container) {
        return new GenericDataTypeCache(container);
    }

    public DBCQueryPlanner getQueryPlanner(@NotNull GenericDataSource dataSource) {
        return null;
    }

    public DBPErrorAssistant.ErrorPosition getErrorPosition(@NotNull Throwable error) {
        return null;
    }

    public boolean supportsUpsertStatement() {
        return false;
    }

    public String getAutoIncrementClause(GenericTableColumn column) {
        return null;
    }

    public boolean useCatalogInObjectNames() {
        return true;
    }

    public List<GenericSchema> loadSchemas(JDBCSession session, GenericDataSource dataSource, GenericCatalog catalog) throws DBException {
        if (dataSource.isOmitSchema()) {
            return null;
        }
        try {
            GenericMetaObject schemaObject = this.getMetaObject("schema");
            DBSObjectFilter schemaFilters = dataSource.getContainer().getObjectFilter(GenericSchema.class, (DBSObject)catalog, false);
            ArrayList<GenericSchema> tmpSchemas = new ArrayList<GenericSchema>();
            JDBCResultSet dbResult = null;
            boolean catalogSchemas = false;
            boolean schemasFiltered = false;
            if (catalog != null) {
                try {
                    dbResult = session.getMetaData().getSchemas(catalog.getName(), schemaFilters != null && schemaFilters.hasSingleMask() ? schemaFilters.getSingleMask() : dataSource.getAllObjectsPattern());
                    catalogSchemas = true;
                }
                catch (Throwable e) {
                    log.debug((Object)("Error reading schemas in catalog '" + catalog.getName() + "' - " + e.getClass().getSimpleName() + " - " + e.getMessage()));
                }
            } else if (dataSource.isSchemaFiltersEnabled()) {
                try {
                    dbResult = session.getMetaData().getSchemas(null, schemaFilters != null && schemaFilters.hasSingleMask() ? schemaFilters.getSingleMask() : dataSource.getAllObjectsPattern());
                }
                catch (Throwable e) {
                    log.debug((Object)("Error reading global schemas  - " + e.getMessage()));
                }
            }
            if (dbResult == null) {
                dbResult = session.getMetaData().getSchemas();
            }
            try {
                while (dbResult.next()) {
                    if (session.getProgressMonitor().isCanceled()) {
                        break;
                    }
                    String schemaName = GenericUtils.safeGetString(schemaObject, (ResultSet)dbResult, "TABLE_SCHEM");
                    if (CommonUtils.isEmpty((String)schemaName)) {
                        schemaName = GenericUtils.safeGetString(schemaObject, (ResultSet)dbResult, "TABLE_OWNER");
                    }
                    if (CommonUtils.isEmpty((String)schemaName)) continue;
                    if (schemaFilters != null && !schemaFilters.matches(schemaName)) {
                        schemasFiltered = true;
                        continue;
                    }
                    String catalogName = GenericUtils.safeGetString(schemaObject, (ResultSet)dbResult, "TABLE_CATALOG");
                    if (!CommonUtils.isEmpty((String)catalogName)) {
                        if (catalog == null) {
                            if (!dataSource.isOmitCatalog()) {
                                log.debug((Object)("Catalog name (" + catalogName + ") found for schema '" + schemaName + "' while schema doesn't have parent catalog"));
                            }
                        } else if (!catalog.getName().equals(catalogName)) {
                            if (!catalogSchemas) continue;
                            log.debug((Object)("Catalog name '" + catalogName + "' differs from schema's catalog '" + catalog.getName() + "'"));
                        }
                    }
                    session.getProgressMonitor().subTask("Schema " + schemaName);
                    GenericSchema schema = this.createSchemaImpl(dataSource, catalog, schemaName);
                    tmpSchemas.add(schema);
                }
            }
            finally {
                dbResult.close();
            }
            if (tmpSchemas.isEmpty() && catalogSchemas && !schemasFiltered && dataSource.getCatalogs().size() == 1) {
                return this.loadSchemas(session, dataSource, null);
            }
            if (dataSource.isOmitSingleSchema() && catalog == null && tmpSchemas.size() == 1 && (schemaFilters == null || schemaFilters.isNotApplicable())) {
                tmpSchemas.clear();
            }
            return tmpSchemas;
        }
        catch (UnsupportedOperationException | SQLFeatureNotSupportedException e) {
            log.debug((Object)("Can't read schema list: " + e.getMessage()));
            return null;
        }
        catch (Throwable ex) {
            log.warn((Object)"Can't read schema list", ex);
            return null;
        }
    }

    public GenericSchema createSchemaImpl(@NotNull GenericDataSource dataSource, @Nullable GenericCatalog catalog, @NotNull String schemaName) throws DBException {
        return new GenericSchema(dataSource, catalog, schemaName);
    }

    public void loadProcedures(DBRProgressMonitor monitor, @NotNull GenericObjectContainer container) throws DBException {
        TreeMap<String, GenericObjectContainer> packageMap = null;
        GenericDataSource dataSource = container.getDataSource();
        GenericMetaObject procObject = dataSource.getMetaObject("procedure");
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Load procedures");){
                try (JDBCResultSet dbResult = session.getMetaData().getProcedures(container.getCatalog() == null ? null : container.getCatalog().getName(), container.getSchema() == null ? null : JDBCUtils.escapeWildCards((JDBCSession)session, (String)container.getSchema().getName()), dataSource.getAllObjectsPattern());){
                    while (dbResult.next()) {
                        DBSProcedureType procedureType;
                        if (monitor.isCanceled()) {
                            break;
                        }
                        String procedureCatalog = GenericUtils.safeGetStringTrimmed(procObject, (ResultSet)dbResult, "PROCEDURE_CAT");
                        String procedureName = GenericUtils.safeGetStringTrimmed(procObject, (ResultSet)dbResult, "PROCEDURE_NAME");
                        String specificName = GenericUtils.safeGetStringTrimmed(procObject, (ResultSet)dbResult, "SPECIFIC_NAME");
                        int procTypeNum = GenericUtils.safeGetInt(procObject, (ResultSet)dbResult, "PROCEDURE_TYPE");
                        String remarks = GenericUtils.safeGetString(procObject, (ResultSet)dbResult, "REMARKS");
                        switch (procTypeNum) {
                            case 1: {
                                procedureType = DBSProcedureType.PROCEDURE;
                                break;
                            }
                            case 2: {
                                procedureType = DBSProcedureType.FUNCTION;
                                break;
                            }
                            case 0: {
                                procedureType = DBSProcedureType.PROCEDURE;
                                break;
                            }
                            default: {
                                procedureType = DBSProcedureType.UNKNOWN;
                            }
                        }
                        if (CommonUtils.isEmpty((String)specificName)) {
                            specificName = procedureName;
                        }
                        procedureName = GenericUtils.normalizeProcedureName(procedureName);
                        String packageName = null;
                        GenericObjectContainer procedurePackage = null;
                        if (!CommonUtils.isEmpty((String)procedureCatalog) && CommonUtils.isEmpty(dataSource.getCatalogs())) {
                            packageName = procedureCatalog;
                        }
                        if (!CommonUtils.isEmpty(packageName)) {
                            if (packageMap == null) {
                                packageMap = new TreeMap<String, GenericObjectContainer>();
                            }
                            if ((procedurePackage = (GenericPackage)packageMap.get(packageName)) == null) {
                                procedurePackage = new GenericPackage(container, packageName, true);
                                packageMap.put(packageName, procedurePackage);
                                container.addPackage((GenericPackage)procedurePackage);
                            }
                        }
                        GenericProcedure procedure = this.createProcedureImpl(procedurePackage != null ? procedurePackage : container, procedureName, specificName, remarks, procedureType, null);
                        if (procedurePackage != null) {
                            ((GenericPackage)procedurePackage).addProcedure(procedure);
                            continue;
                        }
                        container.addProcedure(procedure);
                    }
                }
                try {
                    dbResult = session.getMetaData().getFunctions(container.getCatalog() == null ? null : container.getCatalog().getName(), container.getSchema() == null ? null : JDBCUtils.escapeWildCards((JDBCSession)session, (String)container.getSchema().getName()), dataSource.getAllObjectsPattern());
                    try {
                        while (dbResult.next()) {
                            GenericFunctionResultType functionResultType;
                            if (monitor.isCanceled()) {
                                break;
                            }
                            String functionName = GenericUtils.safeGetStringTrimmed(procObject, (ResultSet)dbResult, "FUNCTION_NAME");
                            if (functionName == null) continue;
                            String specificName = GenericUtils.safeGetStringTrimmed(procObject, (ResultSet)dbResult, "SPECIFIC_NAME");
                            if (specificName == null && functionName.indexOf(59) != -1) {
                                specificName = functionName;
                                functionName = functionName.substring(0, functionName.lastIndexOf(59));
                            }
                            if (container.hasProcedure(functionName)) continue;
                            int funcTypeNum = GenericUtils.safeGetInt(procObject, (ResultSet)dbResult, "FUNCTION_TYPE");
                            String remarks = GenericUtils.safeGetString(procObject, (ResultSet)dbResult, "REMARKS");
                            switch (funcTypeNum) {
                                case 1: {
                                    functionResultType = GenericFunctionResultType.NO_TABLE;
                                    break;
                                }
                                case 2: {
                                    functionResultType = GenericFunctionResultType.TABLE;
                                    break;
                                }
                                default: {
                                    functionResultType = GenericFunctionResultType.UNKNOWN;
                                }
                            }
                            GenericProcedure procedure = this.createProcedureImpl(container, functionName, specificName, remarks, DBSProcedureType.FUNCTION, functionResultType);
                            container.addProcedure(procedure);
                        }
                    }
                    finally {
                        dbResult.close();
                    }
                }
                catch (Throwable e) {
                    log.debug((Object)"Can't read generic functions", e);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, (DBPDataSource)dataSource);
        }
    }

    public GenericProcedure createProcedureImpl(GenericStructContainer container, String procedureName, String specificName, String remarks, DBSProcedureType procedureType, GenericFunctionResultType functionResultType) {
        return new GenericProcedure(container, procedureName, specificName, remarks, procedureType, functionResultType);
    }

    public String getProcedureDDL(DBRProgressMonitor monitor, GenericProcedure sourceObject) throws DBException {
        return "-- Source code not available";
    }

    public GenericCatalog createCatalogImpl(@NotNull GenericDataSource dataSource, @NotNull String catalogName) {
        return new GenericCatalog(dataSource, catalogName);
    }

    public JDBCStatement prepareTableLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase object, @Nullable String objectName) throws SQLException {
        DBSObjectFilter tableFilters;
        String tableNamePattern = object == null && objectName == null ? ((tableFilters = session.getDataSource().getContainer().getObjectFilter(GenericTable.class, (DBSObject)owner, false)) != null && tableFilters.hasSingleMask() ? tableFilters.getSingleMask() : owner.getDataSource().getAllObjectsPattern()) : JDBCUtils.escapeWildCards((JDBCSession)session, (String)(object != null ? object.getName() : objectName));
        return session.getMetaData().getTables(owner.getCatalog() == null ? null : owner.getCatalog().getName(), owner.getSchema() == null ? null : JDBCUtils.escapeWildCards((JDBCSession)session, (String)owner.getSchema().getName()), tableNamePattern, null).getSourceStatement();
    }

    public GenericTableBase createTableImpl(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        if (tableType != null && this.isView(tableType)) {
            return new GenericView(container, tableName, tableType, dbResult);
        }
        return new GenericTable(container, tableName, tableType, dbResult);
    }

    public String getViewDDL(DBRProgressMonitor monitor, GenericView sourceObject, Map<String, Object> options) throws DBException {
        return "-- View definition not available";
    }

    public String getTableDDL(DBRProgressMonitor monitor, GenericTableBase sourceObject, Map<String, Object> options) throws DBException {
        return DBStructUtils.generateTableDDL((DBRProgressMonitor)monitor, (DBSTable)sourceObject, options, (boolean)false);
    }

    public boolean isSystemTable(GenericTableBase table) {
        String tableType = table.getTableType().toUpperCase(Locale.ENGLISH);
        return tableType.contains("SYSTEM");
    }

    public boolean isView(String tableType) {
        return tableType.toUpperCase(Locale.ENGLISH).contains("VIEW");
    }

    public GenericTableColumn createTableColumnImpl(DBRProgressMonitor monitor, GenericTableBase table, String columnName, String typeName, int valueType, int sourceType, int ordinalPos, long columnSize, long charLength, Integer scale, Integer precision, int radix, boolean notNull, String remarks, String defaultValue, boolean autoIncrement, boolean autoGenerated) throws DBException {
        return new GenericTableColumn(table, columnName, typeName, valueType, sourceType, ordinalPos, columnSize, charLength, scale, precision, radix, notNull, remarks, defaultValue, autoIncrement, autoGenerated);
    }

    public GenericTableIndex createIndexImpl(GenericTableBase table, boolean nonUnique, String qualifier, long cardinality, String indexName, DBSIndexType indexType, boolean persisted) {
        return new GenericTableIndex(table, nonUnique, qualifier, cardinality, indexName, indexType, persisted);
    }

    public boolean supportsSequences(@NotNull GenericDataSource dataSource) {
        return false;
    }

    public List<GenericSequence> loadSequences(@NotNull DBRProgressMonitor monitor, @NotNull GenericStructContainer container) throws DBException {
        return new ArrayList<GenericSequence>();
    }

    public boolean supportsSynonyms(@NotNull GenericDataSource dataSource) {
        return false;
    }

    public List<? extends GenericSynonym> loadSynonyms(@NotNull DBRProgressMonitor monitor, @NotNull GenericStructContainer container) throws DBException {
        return new ArrayList();
    }

    public boolean supportsTriggers(@NotNull GenericDataSource dataSource) {
        return false;
    }

    public boolean supportsDatabaseTriggers(@NotNull GenericDataSource dataSource) {
        return false;
    }

    public List<? extends GenericTrigger> loadTriggers(DBRProgressMonitor monitor, @NotNull GenericStructContainer container, @Nullable GenericTableBase table) throws DBException {
        return new ArrayList();
    }

    public String getTriggerDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericTrigger trigger) throws DBException {
        return "-- Source code not available";
    }

    public boolean isTableCommentEditable() {
        return false;
    }

    public boolean isTableColumnCommentEditable() {
        return false;
    }
}

