/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import java.util.EnumSet;

@BugPattern(name="OperatorPrecedence", category=BugPattern.Category.JDK, summary="Use grouping parenthesis to make the operator precedence explicit", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"}, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class OperatorPrecedence
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    private static final EnumSet<Tree.Kind> CONDITIONAL = EnumSet.of(Tree.Kind.AND, Tree.Kind.OR, Tree.Kind.XOR, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR);
    private static final EnumSet<Tree.Kind> SHIFT = EnumSet.of(Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT, Tree.Kind.UNSIGNED_RIGHT_SHIFT);
    private static final EnumSet<Tree.Kind> ARITHMETIC = EnumSet.of(Tree.Kind.PLUS, Tree.Kind.MULTIPLY, Tree.Kind.DIVIDE, Tree.Kind.MINUS);
    private static final EnumSet<Tree.Kind> SAFE_ASSOCIATIVE_OPERATORS = EnumSet.of(Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR, Tree.Kind.PLUS);

    public Description matchBinary(BinaryTree tree, VisitorState state) {
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (!(parent instanceof BinaryTree)) {
            return Description.NO_MATCH;
        }
        if (TreeInfo.opPrec(((JCTree.JCBinary)tree).getTag()) == TreeInfo.opPrec(((JCTree.JCBinary)parent).getTag())) {
            return Description.NO_MATCH;
        }
        if (!this.isConfusing(tree.getKind(), parent.getKind())) {
            return Description.NO_MATCH;
        }
        return this.createAppropriateFix(tree, state);
    }

    private boolean isConfusing(Tree.Kind thisKind, Tree.Kind parentKind) {
        if (CONDITIONAL.contains((Object)thisKind) && CONDITIONAL.contains((Object)parentKind)) {
            return true;
        }
        return SHIFT.contains((Object)thisKind) && ARITHMETIC.contains((Object)parentKind) || SHIFT.contains((Object)parentKind) && ARITHMETIC.contains((Object)thisKind);
    }

    private Description createAppropriateFix(BinaryTree tree, VisitorState state) {
        return SAFE_ASSOCIATIVE_OPERATORS.contains((Object)tree.getKind()) && tree.getLeftOperand() instanceof ParenthesizedTree != tree.getRightOperand() instanceof ParenthesizedTree && OperatorPrecedence.parenthesizedChildHasKind(tree, tree.getKind()) ? this.leftOrRightFix(tree, state) : this.basicFix(tree);
    }

    private Description leftOrRightFix(BinaryTree tree, VisitorState state) {
        int endPos;
        int startPos;
        String prefix = "(";
        String postfix = ")";
        if (tree.getRightOperand() instanceof ParenthesizedTree) {
            startPos = ((JCTree)((Object)tree.getRightOperand())).getStartPosition();
            endPos = ((JCTree)((Object)tree.getRightOperand())).getStartPosition() + 1;
            postfix = "";
        } else {
            startPos = state.getEndPosition((Tree)tree.getLeftOperand()) - 1;
            endPos = state.getEndPosition((Tree)tree.getLeftOperand());
            prefix = "";
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.builder().prefixWith((Tree)tree, prefix).replace(startPos, endPos, "").postfixWith((Tree)tree, postfix).build());
    }

    private Description basicFix(BinaryTree tree) {
        return this.describeMatch(tree, (Fix)SuggestedFix.builder().prefixWith((Tree)tree, "(").postfixWith((Tree)tree, ")").build());
    }

    private static boolean parenthesizedChildHasKind(BinaryTree tree, Tree.Kind kind) {
        Tree.Kind childKind = ASTHelpers.stripParentheses((ExpressionTree)(tree.getLeftOperand() instanceof ParenthesizedTree ? tree.getLeftOperand() : tree.getRightOperand())).getKind();
        return childKind == kind;
    }
}

