"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _atom = require("atom");

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _reporterProxy = require("../reporter-proxy");

var _propTypes2 = require("../prop-types");

var _atomTextEditor = _interopRequireDefault(require("../atom/atom-text-editor"));

var _marker = _interopRequireDefault(require("../atom/marker"));

var _markerLayer = _interopRequireDefault(require("../atom/marker-layer"));

var _decoration = _interopRequireDefault(require("../atom/decoration"));

var _gutter = _interopRequireDefault(require("../atom/gutter"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _filePatchHeaderView = _interopRequireDefault(require("./file-patch-header-view"));

var _filePatchMetaView = _interopRequireDefault(require("./file-patch-meta-view"));

var _hunkHeaderView = _interopRequireDefault(require("./hunk-header-view"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _changedFileItem = _interopRequireDefault(require("../items/changed-file-item"));

var _commitDetailItem = _interopRequireDefault(require("../items/commit-detail-item"));

var _commentGutterDecorationController = _interopRequireDefault(require("../controllers/comment-gutter-decoration-controller"));

var _issueishDetailItem = _interopRequireDefault(require("../items/issueish-detail-item"));

var _file = _interopRequireDefault(require("../models/patch/file"));

var _patch = require("../models/patch/patch");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const executableText = {
  [_file["default"].modes.NORMAL]: 'non executable',
  [_file["default"].modes.EXECUTABLE]: 'executable'
};

class MultiFilePatchView extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "renderFilePatchDecorations", (filePatch, index) => {
      const isCollapsed = !filePatch.getRenderStatus().isVisible();
      const isEmpty = filePatch.getMarker().getRange().isEmpty();
      const atEnd = filePatch.getStartRange().start.isEqual(this.props.multiFilePatch.getBuffer().getEndPosition());
      const position = isEmpty && atEnd ? 'after' : 'before';
      return _react["default"].createElement(_react.Fragment, {
        key: filePatch.getPath()
      }, _react["default"].createElement(_marker["default"], {
        invalidate: "never",
        bufferRange: filePatch.getStartRange()
      }, _react["default"].createElement(_decoration["default"], {
        type: "block",
        position: position,
        order: index,
        className: "github-FilePatchView-controlBlock"
      }, _react["default"].createElement(_filePatchHeaderView["default"], {
        itemType: this.props.itemType,
        relPath: filePatch.getPath(),
        newPath: filePatch.getStatus() === 'renamed' ? filePatch.getNewPath() : null,
        stagingStatus: this.props.stagingStatus,
        isPartiallyStaged: this.props.isPartiallyStaged,
        hasUndoHistory: this.props.hasUndoHistory,
        hasMultipleFileSelections: this.props.hasMultipleFileSelections,
        tooltips: this.props.tooltips,
        undoLastDiscard: () => this.undoLastDiscardFromButton(filePatch),
        diveIntoMirrorPatch: () => this.props.diveIntoMirrorPatch(filePatch),
        openFile: () => this.didOpenFile({
          selectedFilePatch: filePatch
        }),
        toggleFile: () => this.props.toggleFile(filePatch),
        isCollapsed: isCollapsed,
        triggerCollapse: () => this.props.multiFilePatch.collapseFilePatch(filePatch),
        triggerExpand: () => this.props.multiFilePatch.expandFilePatch(filePatch)
      }), !isCollapsed && this.renderSymlinkChangeMeta(filePatch), !isCollapsed && this.renderExecutableModeChangeMeta(filePatch))), filePatch.getPatch().getRenderStatus() === _patch.TOO_LARGE && this.renderDiffGate(filePatch, position, index), this.renderHunkHeaders(filePatch, index));
    });

    _defineProperty(this, "undoLastDiscardFromCoreUndo", () => {
      if (this.props.hasUndoHistory) {
        const selectedFilePatches = Array.from(this.getSelectedFilePatches());
        /* istanbul ignore else */

        if (this.props.itemType === _changedFileItem["default"]) {
          this.props.undoLastDiscard(selectedFilePatches[0], {
            eventSource: {
              command: 'core:undo'
            }
          });
        }
      }
    });

    _defineProperty(this, "undoLastDiscardFromButton", filePatch => {
      this.props.undoLastDiscard(filePatch, {
        eventSource: 'button'
      });
    });

    _defineProperty(this, "discardSelectionFromCommand", () => {
      return this.props.discardRows(this.props.selectedRows, this.props.selectionMode, {
        eventSource: {
          command: 'github:discard-selected-lines'
        }
      });
    });

    _defineProperty(this, "didToggleModeChange", () => {
      return Promise.all(Array.from(this.getSelectedFilePatches()).filter(fp => fp.didChangeExecutableMode()).map(this.props.toggleModeChange));
    });

    _defineProperty(this, "didToggleSymlinkChange", () => {
      return Promise.all(Array.from(this.getSelectedFilePatches()).filter(fp => fp.hasTypechange()).map(this.props.toggleSymlinkChange));
    });

    _defineProperty(this, "scrollToFile", ({
      changedFilePath,
      changedFilePosition
    }) => {
      /* istanbul ignore next */
      this.refEditor.map(e => {
        const row = this.props.multiFilePatch.getBufferRowForDiffPosition(changedFilePath, changedFilePosition);

        if (row === null) {
          return null;
        }

        e.scrollToBufferPosition({
          row,
          column: 0
        }, {
          center: true
        });
        e.setCursorBufferPosition({
          row,
          column: 0
        });
        return null;
      });
    });

    (0, _helpers.autobind)(this, 'didMouseDownOnHeader', 'didMouseDownOnLineNumber', 'didMouseMoveOnLineNumber', 'didMouseUp', 'didConfirm', 'didToggleSelectionMode', 'selectNextHunk', 'selectPreviousHunk', 'didOpenFile', 'didAddSelection', 'didChangeSelectionRange', 'didDestroySelection', 'oldLineNumberLabel', 'newLineNumberLabel');
    this.mouseSelectionInProgress = false;
    this.lastMouseMoveLine = null;
    this.nextSelectionMode = null;
    this.refRoot = new _refHolder["default"]();
    this.refEditor = new _refHolder["default"]();
    this.refEditorElement = new _refHolder["default"]();
    this.mounted = false;
    this.subs = new _eventKit.CompositeDisposable();
    this.subs.add(this.refEditor.observe(editor => {
      this.refEditorElement.setter(editor.getElement());

      if (this.props.refEditor) {
        this.props.refEditor.setter(editor);
      }
    }), this.refEditorElement.observe(element => {
      this.props.refInitialFocus && this.props.refInitialFocus.setter(element);
    })); // Synchronously maintain the editor's scroll position and logical selection across buffer updates.

    this.suppressChanges = false;
    let lastScrollTop = null;
    let lastScrollLeft = null;
    let lastSelectionIndex = null;
    this.subs.add(this.props.onWillUpdatePatch(() => {
      this.suppressChanges = true;
      this.refEditor.map(editor => {
        lastSelectionIndex = this.props.multiFilePatch.getMaxSelectionIndex(this.props.selectedRows);
        lastScrollTop = editor.getElement().getScrollTop();
        lastScrollLeft = editor.getElement().getScrollLeft();
        return null;
      });
    }), this.props.onDidUpdatePatch(nextPatch => {
      this.refEditor.map(editor => {
        /* istanbul ignore else */
        if (lastSelectionIndex !== null) {
          const nextSelectionRange = nextPatch.getSelectionRangeForIndex(lastSelectionIndex);

          if (this.props.selectionMode === 'line') {
            this.nextSelectionMode = 'line';
            editor.setSelectedBufferRange(nextSelectionRange);
          } else {
            const nextHunks = new Set(_atom.Range.fromObject(nextSelectionRange).getRows().map(row => nextPatch.getHunkAt(row)).filter(Boolean));
            /* istanbul ignore next */

            const nextRanges = nextHunks.size > 0 ? Array.from(nextHunks, hunk => hunk.getRange()) : [[[0, 0], [0, 0]]];
            this.nextSelectionMode = 'hunk';
            editor.setSelectedBufferRanges(nextRanges);
          }
        }
        /* istanbul ignore else */


        if (lastScrollTop !== null) {
          editor.getElement().setScrollTop(lastScrollTop);
        }
        /* istanbul ignore else */


        if (lastScrollLeft !== null) {
          editor.getElement().setScrollLeft(lastScrollLeft);
        }

        return null;
      });
      this.suppressChanges = false;
      this.didChangeSelectedRows();
    }));
  }

  componentDidMount() {
    this.mounted = true;
    this.measurePerformance('mount');
    window.addEventListener('mouseup', this.didMouseUp);
    this.refEditor.map(editor => {
      // this.props.multiFilePatch is guaranteed to contain at least one FilePatch if <AtomTextEditor> is rendered.
      const [firstPatch] = this.props.multiFilePatch.getFilePatches();
      const [firstHunk] = firstPatch.getHunks();

      if (!firstHunk) {
        return null;
      }

      this.nextSelectionMode = 'hunk';
      editor.setSelectedBufferRange(firstHunk.getRange());
      return null;
    });
    this.subs.add(this.props.config.onDidChange('github.showDiffIconGutter', () => this.forceUpdate()));
    const {
      initChangedFilePath,
      initChangedFilePosition
    } = this.props;
    /* istanbul ignore next */

    if (initChangedFilePath && initChangedFilePosition >= 0) {
      this.scrollToFile({
        changedFilePath: initChangedFilePath,
        changedFilePosition: initChangedFilePosition
      });
    }
    /* istanbul ignore if */


    if (this.props.onOpenFilesTab) {
      this.subs.add(this.props.onOpenFilesTab(this.scrollToFile));
    }
  }

  componentDidUpdate(prevProps) {
    this.measurePerformance('update');

    if (prevProps.refInitialFocus !== this.props.refInitialFocus) {
      prevProps.refInitialFocus && prevProps.refInitialFocus.setter(null);
      this.props.refInitialFocus && this.refEditorElement.map(this.props.refInitialFocus.setter);
    }

    if (this.props.multiFilePatch === prevProps.multiFilePatch) {
      this.nextSelectionMode = null;
    }
  }

  componentWillUnmount() {
    window.removeEventListener('mouseup', this.didMouseUp);
    this.subs.dispose();
    this.mounted = false;
    performance.clearMarks();
    performance.clearMeasures();
  }

  render() {
    const rootClass = (0, _classnames["default"])('github-FilePatchView', {
      [`github-FilePatchView--${this.props.stagingStatus}`]: this.props.stagingStatus
    }, {
      'github-FilePatchView--blank': !this.props.multiFilePatch.anyPresent()
    }, {
      'github-FilePatchView--hunkMode': this.props.selectionMode === 'hunk'
    });

    if (this.mounted) {
      performance.mark('MultiFilePatchView-update-start');
    } else {
      performance.mark('MultiFilePatchView-mount-start');
    }

    return _react["default"].createElement("div", {
      className: rootClass,
      ref: this.refRoot.setter
    }, this.renderCommands(), _react["default"].createElement("main", {
      className: "github-FilePatchView-container"
    }, this.props.multiFilePatch.anyPresent() ? this.renderNonEmptyPatch() : this.renderEmptyPatch()));
  }

  renderCommands() {
    if (this.props.itemType === _commitDetailItem["default"] || this.props.itemType === _issueishDetailItem["default"]) {
      return _react["default"].createElement(_commands["default"], {
        registry: this.props.commands,
        target: this.refRoot
      }, _react["default"].createElement(_commands.Command, {
        command: "github:select-next-hunk",
        callback: this.selectNextHunk
      }), _react["default"].createElement(_commands.Command, {
        command: "github:select-previous-hunk",
        callback: this.selectPreviousHunk
      }), _react["default"].createElement(_commands.Command, {
        command: "github:toggle-patch-selection-mode",
        callback: this.didToggleSelectionMode
      }));
    }

    let stageModeCommand = null;
    let stageSymlinkCommand = null;

    if (this.props.multiFilePatch.didAnyChangeExecutableMode()) {
      const command = this.props.stagingStatus === 'unstaged' ? 'github:stage-file-mode-change' : 'github:unstage-file-mode-change';
      stageModeCommand = _react["default"].createElement(_commands.Command, {
        command: command,
        callback: this.didToggleModeChange
      });
    }

    if (this.props.multiFilePatch.anyHaveTypechange()) {
      const command = this.props.stagingStatus === 'unstaged' ? 'github:stage-symlink-change' : 'github:unstage-symlink-change';
      stageSymlinkCommand = _react["default"].createElement(_commands.Command, {
        command: command,
        callback: this.didToggleSymlinkChange
      });
    }

    return _react["default"].createElement(_commands["default"], {
      registry: this.props.commands,
      target: this.refRoot
    }, _react["default"].createElement(_commands.Command, {
      command: "github:select-next-hunk",
      callback: this.selectNextHunk
    }), _react["default"].createElement(_commands.Command, {
      command: "github:select-previous-hunk",
      callback: this.selectPreviousHunk
    }), _react["default"].createElement(_commands.Command, {
      command: "core:confirm",
      callback: this.didConfirm
    }), _react["default"].createElement(_commands.Command, {
      command: "core:undo",
      callback: this.undoLastDiscardFromCoreUndo
    }), _react["default"].createElement(_commands.Command, {
      command: "github:discard-selected-lines",
      callback: this.discardSelectionFromCommand
    }), _react["default"].createElement(_commands.Command, {
      command: "github:jump-to-file",
      callback: this.didOpenFile
    }), _react["default"].createElement(_commands.Command, {
      command: "github:surface",
      callback: this.props.surface
    }), _react["default"].createElement(_commands.Command, {
      command: "github:toggle-patch-selection-mode",
      callback: this.didToggleSelectionMode
    }), stageModeCommand, stageSymlinkCommand,
    /* istanbul ignore next */
    atom.inDevMode() && _react["default"].createElement(_commands.Command, {
      command: "github:inspect-patch",
      callback: () => {
        // eslint-disable-next-line no-console
        console.log(this.props.multiFilePatch.getPatchBuffer().inspect({
          layerNames: ['patch', 'hunk']
        }));
      }
    }),
    /* istanbul ignore next */
    atom.inDevMode() && _react["default"].createElement(_commands.Command, {
      command: "github:inspect-regions",
      callback: () => {
        // eslint-disable-next-line no-console
        console.log(this.props.multiFilePatch.getPatchBuffer().inspect({
          layerNames: ['unchanged', 'deletion', 'addition', 'nonewline']
        }));
      }
    }),
    /* istanbul ignore next */
    atom.inDevMode() && _react["default"].createElement(_commands.Command, {
      command: "github:inspect-mfp",
      callback: () => {
        // eslint-disable-next-line no-console
        console.log(this.props.multiFilePatch.inspect());
      }
    }));
  }

  renderEmptyPatch() {
    return _react["default"].createElement("p", {
      className: "github-FilePatchView-message icon icon-info"
    }, "No changes to display");
  }

  renderNonEmptyPatch() {
    return _react["default"].createElement(_atomTextEditor["default"], {
      workspace: this.props.workspace,
      buffer: this.props.multiFilePatch.getBuffer(),
      lineNumberGutterVisible: false,
      autoWidth: false,
      autoHeight: false,
      readOnly: true,
      softWrapped: true,
      didAddSelection: this.didAddSelection,
      didChangeSelectionRange: this.didChangeSelectionRange,
      didDestroySelection: this.didDestroySelection,
      refModel: this.refEditor,
      hideEmptiness: true
    }, _react["default"].createElement(_gutter["default"], {
      name: "old-line-numbers",
      priority: 1,
      className: "old",
      type: "line-number",
      labelFn: this.oldLineNumberLabel,
      onMouseDown: this.didMouseDownOnLineNumber,
      onMouseMove: this.didMouseMoveOnLineNumber
    }), _react["default"].createElement(_gutter["default"], {
      name: "new-line-numbers",
      priority: 2,
      className: "new",
      type: "line-number",
      labelFn: this.newLineNumberLabel,
      onMouseDown: this.didMouseDownOnLineNumber,
      onMouseMove: this.didMouseMoveOnLineNumber
    }), _react["default"].createElement(_gutter["default"], {
      name: "github-comment-icon",
      priority: 3,
      className: "comment",
      type: "decorated"
    }), this.props.config.get('github.showDiffIconGutter') && _react["default"].createElement(_gutter["default"], {
      name: "diff-icons",
      priority: 4,
      type: "line-number",
      className: "icons",
      labelFn: _helpers.blankLabel,
      onMouseDown: this.didMouseDownOnLineNumber,
      onMouseMove: this.didMouseMoveOnLineNumber
    }), this.renderPRCommentIcons(), this.props.multiFilePatch.getFilePatches().map(this.renderFilePatchDecorations), this.renderLineDecorations(Array.from(this.props.selectedRows, row => _atom.Range.fromObject([[row, 0], [row, Infinity]])), 'github-FilePatchView-line--selected', {
      gutter: true,
      icon: true,
      line: true
    }), this.renderDecorationsOnLayer(this.props.multiFilePatch.getAdditionLayer(), 'github-FilePatchView-line--added', {
      icon: true,
      line: true
    }), this.renderDecorationsOnLayer(this.props.multiFilePatch.getDeletionLayer(), 'github-FilePatchView-line--deleted', {
      icon: true,
      line: true
    }), this.renderDecorationsOnLayer(this.props.multiFilePatch.getNoNewlineLayer(), 'github-FilePatchView-line--nonewline', {
      icon: true,
      line: true
    }));
  }

  renderPRCommentIcons() {
    if (this.props.itemType !== _issueishDetailItem["default"] || this.props.reviewCommentsLoading) {
      return null;
    }

    return this.props.reviewCommentThreads.map(({
      comments,
      thread
    }) => {
      const {
        path,
        position
      } = comments[0];

      if (!this.props.multiFilePatch.getPatchForPath(path)) {
        return null;
      }

      const row = this.props.multiFilePatch.getBufferRowForDiffPosition(path, position);

      if (row === null) {
        return null;
      }

      const isRowSelected = this.props.selectedRows.has(row);
      return _react["default"].createElement(_commentGutterDecorationController["default"], {
        key: `github-comment-gutter-decoration-${thread.id}`,
        commentRow: row,
        threadId: thread.id,
        workspace: this.props.workspace,
        endpoint: this.props.endpoint,
        owner: this.props.owner,
        repo: this.props.repo,
        number: this.props.number,
        workdir: this.props.workdirPath,
        extraClasses: isRowSelected ? ['github-FilePatchView-line--selected'] : [],
        parent: this.constructor.name
      });
    });
  }

  renderDiffGate(filePatch, position, orderOffset) {
    const showDiff = () => {
      (0, _reporterProxy.addEvent)('expand-file-patch', {
        component: this.constructor.name,
        "package": 'github'
      });
      this.props.multiFilePatch.expandFilePatch(filePatch);
    };

    return _react["default"].createElement(_marker["default"], {
      invalidate: "never",
      bufferRange: filePatch.getStartRange()
    }, _react["default"].createElement(_decoration["default"], {
      type: "block",
      order: orderOffset + 0.1,
      position: position,
      className: "github-FilePatchView-controlBlock"
    }, _react["default"].createElement("p", {
      className: "github-FilePatchView-message icon icon-info"
    }, "Large diffs are collapsed by default for performance reasons.", _react["default"].createElement("br", null), _react["default"].createElement("button", {
      className: "github-FilePatchView-showDiffButton",
      onClick: showDiff
    }, " Load Diff"))));
  }

  renderExecutableModeChangeMeta(filePatch) {
    if (!filePatch.didChangeExecutableMode()) {
      return null;
    }

    const oldMode = filePatch.getOldMode();
    const newMode = filePatch.getNewMode();
    const attrs = this.props.stagingStatus === 'unstaged' ? {
      actionIcon: 'icon-move-down',
      actionText: 'Stage Mode Change'
    } : {
      actionIcon: 'icon-move-up',
      actionText: 'Unstage Mode Change'
    };
    return _react["default"].createElement(_filePatchMetaView["default"], {
      title: "Mode change",
      actionIcon: attrs.actionIcon,
      actionText: attrs.actionText,
      itemType: this.props.itemType,
      action: () => this.props.toggleModeChange(filePatch)
    }, _react["default"].createElement(_react.Fragment, null, "File changed mode", _react["default"].createElement("span", {
      className: "github-FilePatchView-metaDiff github-FilePatchView-metaDiff--removed"
    }, "from ", executableText[oldMode], " ", _react["default"].createElement("code", null, oldMode)), _react["default"].createElement("span", {
      className: "github-FilePatchView-metaDiff github-FilePatchView-metaDiff--added"
    }, "to ", executableText[newMode], " ", _react["default"].createElement("code", null, newMode))));
  }

  renderSymlinkChangeMeta(filePatch) {
    if (!filePatch.hasSymlink()) {
      return null;
    }

    let detail = _react["default"].createElement("div", null);

    let title = '';
    const oldSymlink = filePatch.getOldSymlink();
    const newSymlink = filePatch.getNewSymlink();

    if (oldSymlink && newSymlink) {
      detail = _react["default"].createElement(_react.Fragment, null, "Symlink changed", _react["default"].createElement("span", {
        className: (0, _classnames["default"])('github-FilePatchView-metaDiff', 'github-FilePatchView-metaDiff--fullWidth', 'github-FilePatchView-metaDiff--removed')
      }, "from ", _react["default"].createElement("code", null, oldSymlink)), _react["default"].createElement("span", {
        className: (0, _classnames["default"])('github-FilePatchView-metaDiff', 'github-FilePatchView-metaDiff--fullWidth', 'github-FilePatchView-metaDiff--added')
      }, "to ", _react["default"].createElement("code", null, newSymlink)), ".");
      title = 'Symlink changed';
    } else if (oldSymlink && !newSymlink) {
      detail = _react["default"].createElement(_react.Fragment, null, "Symlink", _react["default"].createElement("span", {
        className: "github-FilePatchView-metaDiff github-FilePatchView-metaDiff--removed"
      }, "to ", _react["default"].createElement("code", null, oldSymlink)), "deleted.");
      title = 'Symlink deleted';
    } else {
      detail = _react["default"].createElement(_react.Fragment, null, "Symlink", _react["default"].createElement("span", {
        className: "github-FilePatchView-metaDiff github-FilePatchView-metaDiff--added"
      }, "to ", _react["default"].createElement("code", null, newSymlink)), "created.");
      title = 'Symlink created';
    }

    const attrs = this.props.stagingStatus === 'unstaged' ? {
      actionIcon: 'icon-move-down',
      actionText: 'Stage Symlink Change'
    } : {
      actionIcon: 'icon-move-up',
      actionText: 'Unstage Symlink Change'
    };
    return _react["default"].createElement(_filePatchMetaView["default"], {
      title: title,
      actionIcon: attrs.actionIcon,
      actionText: attrs.actionText,
      itemType: this.props.itemType,
      action: () => this.props.toggleSymlinkChange(filePatch)
    }, _react["default"].createElement(_react.Fragment, null, detail));
  }

  renderHunkHeaders(filePatch, orderOffset) {
    const toggleVerb = this.props.stagingStatus === 'unstaged' ? 'Stage' : 'Unstage';
    const selectedHunks = new Set(Array.from(this.props.selectedRows, row => this.props.multiFilePatch.getHunkAt(row)));
    return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement(_markerLayer["default"], null, filePatch.getHunks().map((hunk, index) => {
      const containsSelection = this.props.selectionMode === 'line' && selectedHunks.has(hunk);
      const isSelected = this.props.selectionMode === 'hunk' && selectedHunks.has(hunk);
      let buttonSuffix = '';

      if (containsSelection) {
        buttonSuffix += 'Selected Line';

        if (this.props.selectedRows.size > 1) {
          buttonSuffix += 's';
        }
      } else {
        buttonSuffix += 'Hunk';

        if (selectedHunks.size > 1) {
          buttonSuffix += 's';
        }
      }

      const toggleSelectionLabel = `${toggleVerb} ${buttonSuffix}`;
      const discardSelectionLabel = `Discard ${buttonSuffix}`;
      const startPoint = hunk.getRange().start;
      const startRange = new _atom.Range(startPoint, startPoint);
      return _react["default"].createElement(_marker["default"], {
        key: `hunkHeader-${index}`,
        bufferRange: startRange,
        invalidate: "never"
      }, _react["default"].createElement(_decoration["default"], {
        type: "block",
        order: orderOffset + 0.2,
        className: "github-FilePatchView-controlBlock"
      }, _react["default"].createElement(_hunkHeaderView["default"], {
        refTarget: this.refEditorElement,
        hunk: hunk,
        isSelected: isSelected,
        stagingStatus: this.props.stagingStatus,
        selectionMode: "line",
        toggleSelectionLabel: toggleSelectionLabel,
        discardSelectionLabel: discardSelectionLabel,
        tooltips: this.props.tooltips,
        keymaps: this.props.keymaps,
        toggleSelection: () => this.toggleHunkSelection(hunk, containsSelection),
        discardSelection: () => this.discardHunkSelection(hunk, containsSelection),
        mouseDown: this.didMouseDownOnHeader,
        itemType: this.props.itemType
      })));
    })));
  }

  renderLineDecorations(ranges, lineClass, {
    line,
    gutter,
    icon,
    refHolder
  }) {
    if (ranges.length === 0) {
      return null;
    }

    const holder = refHolder || new _refHolder["default"]();
    return _react["default"].createElement(_markerLayer["default"], {
      handleLayer: holder.setter
    }, ranges.map((range, index) => {
      return _react["default"].createElement(_marker["default"], {
        key: `line-${lineClass}-${index}`,
        bufferRange: range,
        invalidate: "never"
      });
    }), this.renderDecorations(lineClass, {
      line,
      gutter,
      icon
    }));
  }

  renderDecorationsOnLayer(layer, lineClass, {
    line,
    gutter,
    icon
  }) {
    if (layer.getMarkerCount() === 0) {
      return null;
    }

    return _react["default"].createElement(_markerLayer["default"], {
      external: layer
    }, this.renderDecorations(lineClass, {
      line,
      gutter,
      icon
    }));
  }

  renderDecorations(lineClass, {
    line,
    gutter,
    icon
  }) {
    return _react["default"].createElement(_react.Fragment, null, line && _react["default"].createElement(_decoration["default"], {
      type: "line",
      className: lineClass,
      omitEmptyLastRow: false
    }), gutter && _react["default"].createElement(_react.Fragment, null, _react["default"].createElement(_decoration["default"], {
      type: "line-number",
      gutterName: "old-line-numbers",
      className: lineClass,
      omitEmptyLastRow: false
    }), _react["default"].createElement(_decoration["default"], {
      type: "line-number",
      gutterName: "new-line-numbers",
      className: lineClass,
      omitEmptyLastRow: false
    }), _react["default"].createElement(_decoration["default"], {
      type: "gutter",
      gutterName: "github-comment-icon",
      className: `github-editorCommentGutterIcon empty ${lineClass}`,
      omitEmptyLastRow: false
    })), icon && _react["default"].createElement(_decoration["default"], {
      type: "line-number",
      gutterName: "diff-icons",
      className: lineClass,
      omitEmptyLastRow: false
    }));
  }

  toggleHunkSelection(hunk, containsSelection) {
    if (containsSelection) {
      return this.props.toggleRows(this.props.selectedRows, this.props.selectionMode, {
        eventSource: 'button'
      });
    } else {
      const changeRows = new Set(hunk.getChanges().reduce((rows, change) => {
        rows.push(...change.getBufferRows());
        return rows;
      }, []));
      return this.props.toggleRows(changeRows, 'hunk', {
        eventSource: 'button'
      });
    }
  }

  discardHunkSelection(hunk, containsSelection) {
    if (containsSelection) {
      return this.props.discardRows(this.props.selectedRows, this.props.selectionMode, {
        eventSource: 'button'
      });
    } else {
      const changeRows = new Set(hunk.getChanges().reduce((rows, change) => {
        rows.push(...change.getBufferRows());
        return rows;
      }, []));
      return this.props.discardRows(changeRows, 'hunk', {
        eventSource: 'button'
      });
    }
  }

  didMouseDownOnHeader(event, hunk) {
    this.nextSelectionMode = 'hunk';
    this.handleSelectionEvent(event, hunk.getRange());
  }

  didMouseDownOnLineNumber(event) {
    const line = event.bufferRow;

    if (line === undefined || isNaN(line)) {
      return;
    }

    this.nextSelectionMode = 'line';

    if (this.handleSelectionEvent(event.domEvent, [[line, 0], [line, Infinity]])) {
      this.mouseSelectionInProgress = true;
    }
  }

  didMouseMoveOnLineNumber(event) {
    if (!this.mouseSelectionInProgress) {
      return;
    }

    const line = event.bufferRow;

    if (this.lastMouseMoveLine === line || line === undefined || isNaN(line)) {
      return;
    }

    this.lastMouseMoveLine = line;
    this.nextSelectionMode = 'line';
    this.handleSelectionEvent(event.domEvent, [[line, 0], [line, Infinity]], {
      add: true
    });
  }

  didMouseUp() {
    this.mouseSelectionInProgress = false;
  }

  handleSelectionEvent(event, rangeLike, opts) {
    if (event.button !== 0) {
      return false;
    }

    const isWindows = process.platform === 'win32';

    if (event.ctrlKey && !isWindows) {
      // Allow the context menu to open.
      return false;
    }

    const options = _objectSpread({
      add: false
    }, opts); // Normalize the target selection range


    const converted = _atom.Range.fromObject(rangeLike);

    const range = this.refEditor.map(editor => editor.clipBufferRange(converted)).getOr(converted);

    if (event.metaKey ||
    /* istanbul ignore next */
    event.ctrlKey && isWindows) {
      this.refEditor.map(editor => {
        let intersects = false;
        let without = null;

        for (const selection of editor.getSelections()) {
          if (selection.intersectsBufferRange(range)) {
            // Remove range from this selection by truncating it to the "near edge" of the range and creating a
            // new selection from the "far edge" to the previous end. Omit either side if it is empty.
            intersects = true;
            const selectionRange = selection.getBufferRange();
            const newRanges = [];

            if (!range.start.isEqual(selectionRange.start)) {
              // Include the bit from the selection's previous start to the range's start.
              let nudged = range.start;

              if (range.start.column === 0) {
                const lastColumn = editor.getBuffer().lineLengthForRow(range.start.row - 1);
                nudged = [range.start.row - 1, lastColumn];
              }

              newRanges.push([selectionRange.start, nudged]);
            }

            if (!range.end.isEqual(selectionRange.end)) {
              // Include the bit from the range's end to the selection's end.
              let nudged = range.end;
              const lastColumn = editor.getBuffer().lineLengthForRow(range.end.row);

              if (range.end.column === lastColumn) {
                nudged = [range.end.row + 1, 0];
              }

              newRanges.push([nudged, selectionRange.end]);
            }

            if (newRanges.length > 0) {
              selection.setBufferRange(newRanges[0]);

              for (const newRange of newRanges.slice(1)) {
                editor.addSelectionForBufferRange(newRange, {
                  reversed: selection.isReversed()
                });
              }
            } else {
              without = selection;
            }
          }
        }

        if (without !== null) {
          const replacementRanges = editor.getSelections().filter(each => each !== without).map(each => each.getBufferRange());

          if (replacementRanges.length > 0) {
            editor.setSelectedBufferRanges(replacementRanges);
          }
        }

        if (!intersects) {
          // Add this range as a new, distinct selection.
          editor.addSelectionForBufferRange(range);
        }

        return null;
      });
    } else if (options.add || event.shiftKey) {
      // Extend the existing selection to encompass this range.
      this.refEditor.map(editor => {
        const lastSelection = editor.getLastSelection();
        const lastSelectionRange = lastSelection.getBufferRange(); // You are now entering the wall of ternery operators. This is your last exit before the tollbooth

        const isBefore = range.start.isLessThan(lastSelectionRange.start);
        const farEdge = isBefore ? range.start : range.end;
        const newRange = isBefore ? [farEdge, lastSelectionRange.end] : [lastSelectionRange.start, farEdge];
        lastSelection.setBufferRange(newRange, {
          reversed: isBefore
        });
        return null;
      });
    } else {
      this.refEditor.map(editor => editor.setSelectedBufferRange(range));
    }

    return true;
  }

  didConfirm() {
    return this.props.toggleRows(this.props.selectedRows, this.props.selectionMode);
  }

  didToggleSelectionMode() {
    const selectedHunks = this.getSelectedHunks();
    this.withSelectionMode({
      line: () => {
        const hunkRanges = selectedHunks.map(hunk => hunk.getRange());
        this.nextSelectionMode = 'hunk';
        this.refEditor.map(editor => editor.setSelectedBufferRanges(hunkRanges));
      },
      hunk: () => {
        let firstChangeRow = Infinity;

        for (const hunk of selectedHunks) {
          const [firstChange] = hunk.getChanges();
          /* istanbul ignore else */

          if (firstChange && (!firstChangeRow || firstChange.getStartBufferRow() < firstChangeRow)) {
            firstChangeRow = firstChange.getStartBufferRow();
          }
        }

        this.nextSelectionMode = 'line';
        this.refEditor.map(editor => {
          editor.setSelectedBufferRanges([[[firstChangeRow, 0], [firstChangeRow, Infinity]]]);
          return null;
        });
      }
    });
  }

  selectNextHunk() {
    this.refEditor.map(editor => {
      const nextHunks = new Set(this.withSelectedHunks(hunk => this.getHunkAfter(hunk) || hunk));
      const nextRanges = Array.from(nextHunks, hunk => hunk.getRange());
      this.nextSelectionMode = 'hunk';
      editor.setSelectedBufferRanges(nextRanges);
      return null;
    });
  }

  selectPreviousHunk() {
    this.refEditor.map(editor => {
      const nextHunks = new Set(this.withSelectedHunks(hunk => this.getHunkBefore(hunk) || hunk));
      const nextRanges = Array.from(nextHunks, hunk => hunk.getRange());
      this.nextSelectionMode = 'hunk';
      editor.setSelectedBufferRanges(nextRanges);
      return null;
    });
  }

  didOpenFile({
    selectedFilePatch
  }) {
    const cursorsByFilePatch = new Map();
    this.refEditor.map(editor => {
      const placedRows = new Set();

      for (const cursor of editor.getCursors()) {
        const cursorRow = cursor.getBufferPosition().row;
        const hunk = this.props.multiFilePatch.getHunkAt(cursorRow);
        const filePatch = this.props.multiFilePatch.getFilePatchAt(cursorRow);
        /* istanbul ignore next */

        if (!hunk) {
          continue;
        }

        let newRow = hunk.getNewRowAt(cursorRow);
        let newColumn = cursor.getBufferPosition().column;

        if (newRow === null) {
          let nearestRow = hunk.getNewStartRow();

          for (const region of hunk.getRegions()) {
            if (!region.includesBufferRow(cursorRow)) {
              region.when({
                unchanged: () => {
                  nearestRow += region.bufferRowCount();
                },
                addition: () => {
                  nearestRow += region.bufferRowCount();
                }
              });
            } else {
              break;
            }
          }

          if (!placedRows.has(nearestRow)) {
            newRow = nearestRow;
            newColumn = 0;
            placedRows.add(nearestRow);
          }
        }

        if (newRow !== null) {
          // Why is this needed? I _think_ everything is in terms of buffer position
          // so there shouldn't be an off-by-one issue
          newRow -= 1;
          const cursors = cursorsByFilePatch.get(filePatch);

          if (!cursors) {
            cursorsByFilePatch.set(filePatch, [[newRow, newColumn]]);
          } else {
            cursors.push([newRow, newColumn]);
          }
        }
      }

      return null;
    });
    const filePatchesWithCursors = new Set(cursorsByFilePatch.keys());

    if (selectedFilePatch && !filePatchesWithCursors.has(selectedFilePatch)) {
      const [firstHunk] = selectedFilePatch.getHunks();
      const cursorRow = firstHunk ? firstHunk.getNewStartRow() - 1 :
      /* istanbul ignore next */
      0;
      return this.props.openFile(selectedFilePatch, [[cursorRow, 0]], true);
    } else {
      const pending = cursorsByFilePatch.size === 1;
      return Promise.all(Array.from(cursorsByFilePatch, value => {
        const [filePatch, cursors] = value;
        return this.props.openFile(filePatch, cursors, pending);
      }));
    }
  }

  getSelectedRows() {
    return this.refEditor.map(editor => {
      return new Set(editor.getSelections().map(selection => selection.getBufferRange()).reduce((acc, range) => {
        for (const row of range.getRows()) {
          if (this.isChangeRow(row)) {
            acc.push(row);
          }
        }

        return acc;
      }, []));
    }).getOr(new Set());
  }

  didAddSelection() {
    this.didChangeSelectedRows();
  }

  didChangeSelectionRange(event) {
    if (!event || event.oldBufferRange.start.row !== event.newBufferRange.start.row || event.oldBufferRange.end.row !== event.newBufferRange.end.row) {
      this.didChangeSelectedRows();
    }
  }

  didDestroySelection() {
    this.didChangeSelectedRows();
  }

  didChangeSelectedRows() {
    if (this.suppressChanges) {
      return;
    }

    const nextCursorRows = this.refEditor.map(editor => {
      return editor.getCursorBufferPositions().map(position => position.row);
    }).getOr([]);
    const hasMultipleFileSelections = this.props.multiFilePatch.spansMultipleFiles(nextCursorRows);
    this.props.selectedRowsChanged(this.getSelectedRows(), this.nextSelectionMode || 'line', hasMultipleFileSelections);
  }

  oldLineNumberLabel({
    bufferRow,
    softWrapped
  }) {
    const hunk = this.props.multiFilePatch.getHunkAt(bufferRow);

    if (hunk === undefined) {
      return this.pad('');
    }

    const oldRow = hunk.getOldRowAt(bufferRow);

    if (softWrapped) {
      return this.pad(oldRow === null ? '' : '•');
    }

    return this.pad(oldRow);
  }

  newLineNumberLabel({
    bufferRow,
    softWrapped
  }) {
    const hunk = this.props.multiFilePatch.getHunkAt(bufferRow);

    if (hunk === undefined) {
      return this.pad('');
    }

    const newRow = hunk.getNewRowAt(bufferRow);

    if (softWrapped) {
      return this.pad(newRow === null ? '' : '•');
    }

    return this.pad(newRow);
  }
  /*
   * Return a Set of the Hunks that include at least one editor selection. The selection need not contain an actual
   * change row.
   */


  getSelectedHunks() {
    return this.withSelectedHunks(each => each);
  }

  withSelectedHunks(callback) {
    return this.refEditor.map(editor => {
      const seen = new Set();
      return editor.getSelectedBufferRanges().reduce((acc, range) => {
        for (const row of range.getRows()) {
          const hunk = this.props.multiFilePatch.getHunkAt(row);

          if (!hunk || seen.has(hunk)) {
            continue;
          }

          seen.add(hunk);
          acc.push(callback(hunk));
        }

        return acc;
      }, []);
    }).getOr([]);
  }
  /*
   * Return a Set of FilePatches that include at least one editor selection. The selection need not contain an actual
   * change row.
   */


  getSelectedFilePatches() {
    return this.refEditor.map(editor => {
      const patches = new Set();

      for (const range of editor.getSelectedBufferRanges()) {
        for (const row of range.getRows()) {
          const patch = this.props.multiFilePatch.getFilePatchAt(row);
          patches.add(patch);
        }
      }

      return patches;
    }).getOr(new Set());
  }

  getHunkBefore(hunk) {
    const prevRow = hunk.getRange().start.row - 1;
    return this.props.multiFilePatch.getHunkAt(prevRow);
  }

  getHunkAfter(hunk) {
    const nextRow = hunk.getRange().end.row + 1;
    return this.props.multiFilePatch.getHunkAt(nextRow);
  }

  isChangeRow(bufferRow) {
    const changeLayers = [this.props.multiFilePatch.getAdditionLayer(), this.props.multiFilePatch.getDeletionLayer()];
    return changeLayers.some(layer => layer.findMarkers({
      intersectsRow: bufferRow
    }).length > 0);
  }

  withSelectionMode(callbacks) {
    const callback = callbacks[this.props.selectionMode];
    /* istanbul ignore if */

    if (!callback) {
      throw new Error(`Unknown selection mode: ${this.props.selectionMode}`);
    }

    return callback();
  }

  pad(num) {
    const maxDigits = this.props.multiFilePatch.getMaxLineNumberWidth();

    if (num === null) {
      return _helpers.NBSP_CHARACTER.repeat(maxDigits);
    } else {
      return _helpers.NBSP_CHARACTER.repeat(maxDigits - num.toString().length) + num.toString();
    }
  }

  measurePerformance(action) {
    /* istanbul ignore else */
    if ((action === 'update' || action === 'mount') && performance.getEntriesByName(`MultiFilePatchView-${action}-start`).length > 0) {
      performance.mark(`MultiFilePatchView-${action}-end`);
      performance.measure(`MultiFilePatchView-${action}`, `MultiFilePatchView-${action}-start`, `MultiFilePatchView-${action}-end`);
      const perf = performance.getEntriesByName(`MultiFilePatchView-${action}`)[0];
      performance.clearMarks(`MultiFilePatchView-${action}-start`);
      performance.clearMarks(`MultiFilePatchView-${action}-end`);
      performance.clearMeasures(`MultiFilePatchView-${action}`);
      (0, _reporterProxy.addEvent)(`MultiFilePatchView-${action}`, {
        "package": 'github',
        filePatchesLineCounts: this.props.multiFilePatch.getFilePatches().map(fp => fp.getPatch().getChangedLineCount()),
        duration: perf.duration
      });
    }
  }

}

exports["default"] = MultiFilePatchView;

_defineProperty(MultiFilePatchView, "propTypes", {
  // Behavior controls
  stagingStatus: _propTypes["default"].oneOf(['staged', 'unstaged']),
  isPartiallyStaged: _propTypes["default"].bool,
  itemType: _propTypes2.ItemTypePropType.isRequired,
  // Models
  repository: _propTypes["default"].object.isRequired,
  multiFilePatch: _propTypes2.MultiFilePatchPropType.isRequired,
  selectionMode: _propTypes["default"].oneOf(['hunk', 'line']).isRequired,
  selectedRows: _propTypes["default"].object.isRequired,
  hasMultipleFileSelections: _propTypes["default"].bool.isRequired,
  hasUndoHistory: _propTypes["default"].bool,
  // Review comments
  reviewCommentsLoading: _propTypes["default"].bool,
  reviewCommentThreads: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    thread: _propTypes["default"].object.isRequired,
    comments: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired
  })),
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  keymaps: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  pullRequest: _propTypes["default"].object,
  // Callbacks
  selectedRowsChanged: _propTypes["default"].func,
  // Action methods
  switchToIssueish: _propTypes["default"].func,
  diveIntoMirrorPatch: _propTypes["default"].func,
  surface: _propTypes["default"].func,
  openFile: _propTypes["default"].func,
  toggleFile: _propTypes["default"].func,
  toggleRows: _propTypes["default"].func,
  toggleModeChange: _propTypes["default"].func,
  toggleSymlinkChange: _propTypes["default"].func,
  undoLastDiscard: _propTypes["default"].func,
  discardRows: _propTypes["default"].func,
  onWillUpdatePatch: _propTypes["default"].func,
  onDidUpdatePatch: _propTypes["default"].func,
  // External refs
  refEditor: _propTypes2.RefHolderPropType,
  refInitialFocus: _propTypes2.RefHolderPropType,
  // for navigating the PR changed files tab
  onOpenFilesTab: _propTypes["default"].func,
  initChangedFilePath: _propTypes["default"].string,
  initChangedFilePosition: _propTypes["default"].number,
  // for opening the reviews dock item
  endpoint: _propTypes2.EndpointPropType,
  owner: _propTypes["default"].string,
  repo: _propTypes["default"].string,
  number: _propTypes["default"].number,
  workdirPath: _propTypes["default"].string
});

_defineProperty(MultiFilePatchView, "defaultProps", {
  onWillUpdatePatch: () => new _eventKit.Disposable(),
  onDidUpdatePatch: () => new _eventKit.Disposable(),
  reviewCommentsLoading: false,
  reviewCommentThreads: []
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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