"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BOTTOM = exports.MIDDLE = exports.TOP = void 0;

class Position {
  constructor(name, cssClass) {
    this.name = name.toLowerCase();
    this.cssClass = cssClass;
  }

  getName() {
    return this.name;
  }

  when(actions) {
    const chosen = actions[this.name] || actions["default"] || (() => {
      throw new Error(`Unexpected conflict side position: ${this.name}`);
    });

    return chosen();
  }

  getBlockCSSClass() {
    return this.cssClass + 'Block';
  }

  toString() {
    return `<Position: ${this.name.toUpperCase()}>`;
  }

}

const TOP = new Position('TOP', 'github-ConflictTop');
exports.TOP = TOP;
const MIDDLE = new Position('MIDDLE', 'github-ConflictMiddle');
exports.MIDDLE = MIDDLE;
const BOTTOM = new Position('BOTTOM', 'github-ConflictBottom');
exports.BOTTOM = BOTTOM;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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