/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Immediate;
import sun.jvm.hotspot.asm.ImmediateOrRegister;
import sun.jvm.hotspot.asm.Instruction;
import sun.jvm.hotspot.asm.RTLDataTypes;
import sun.jvm.hotspot.asm.RTLOperations;
import sun.jvm.hotspot.asm.sparc.SPARCInstructionFactory;
import sun.jvm.hotspot.asm.sparc.SPARCOpcodes;
import sun.jvm.hotspot.asm.sparc.SPARCRegisters;

abstract class InstructionDecoder
implements SPARCOpcodes,
RTLDataTypes,
RTLOperations {
    InstructionDecoder() {
    }

    static int extractSignedIntFromNBits(int value, int num_bits) {
        return value << 32 - num_bits >> 32 - num_bits;
    }

    static int getSourceRegister1(int instruction) {
        return (instruction & 0x7C000) >>> 14;
    }

    static int getSourceRegister2(int instruction) {
        return instruction & 0x1F;
    }

    static int getDestinationRegister(int instruction) {
        return (instruction & 0x3E000000) >>> 25;
    }

    static int getConditionCode(int instruction) {
        return (instruction & 0x1E000000) >>> 25;
    }

    static boolean isIBitSet(int instruction) {
        return (instruction & 0x2000) != 0;
    }

    static ImmediateOrRegister getOperand2(int instruction) {
        boolean iBit = InstructionDecoder.isIBitSet(instruction);
        ImmediateOrRegister operand2 = null;
        operand2 = iBit ? new Immediate(new Short((short)InstructionDecoder.extractSignedIntFromNBits(instruction, 13))) : SPARCRegisters.getRegister(InstructionDecoder.getSourceRegister2(instruction));
        return operand2;
    }

    static int getOpf(int instruction) {
        return (instruction & 0x3FE0) >>> 5;
    }

    abstract Instruction decode(int var1, SPARCInstructionFactory var2);
}

