/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.resource;

import com.sun.javafx.tools.resource.PackagerResource;
import com.sun.javafx.tools.resource.ResourceTraversal;
import java.io.File;

public abstract class DetailedResourceTraversal
implements ResourceTraversal {
    private String lastRelativePath = "";
    private boolean lastIsDirectory = true;

    @Override
    public final boolean traverse(PackagerResource packagerResource, File file, String string) {
        boolean bl = file.isDirectory();
        if (!this.traverseBetween(this.lastRelativePath, this.lastIsDirectory, string, bl)) {
            return false;
        }
        this.lastRelativePath = string;
        this.lastIsDirectory = bl;
        return bl ? true : this.traverseFile(packagerResource, file, string);
    }

    public final void finish() {
        this.traverseBetween(this.lastRelativePath, this.lastIsDirectory, "", true);
        this.lastRelativePath = "";
        this.lastIsDirectory = true;
    }

    protected abstract boolean enterDirectory(String var1);

    protected abstract boolean exitDirectory(String var1);

    protected abstract boolean traverseFile(PackagerResource var1, File var2, String var3);

    private boolean traverseBetween(String string, boolean bl, String string2, boolean bl2) {
        int n = DetailedResourceTraversal.getCommonPathLength(string, string2);
        return this.traverseDown(string, bl, n) && this.traverseUp(string2, bl2, n);
    }

    private boolean traverseDown(String string, boolean bl, int n) {
        if (string.length() == n) {
            return true;
        }
        if (bl && !this.exitDirectory(string)) {
            return false;
        }
        int n2 = DetailedResourceTraversal.findPrevSeparator(string, string.length() - 1, n);
        while (n2 > n) {
            if (!this.exitDirectory(string.substring(0, n2))) {
                return false;
            }
            n2 = DetailedResourceTraversal.findPrevSeparator(string, n2 - 1, n);
        }
        return true;
    }

    private boolean traverseUp(String string, boolean bl, int n) {
        if (string.length() == n) {
            return true;
        }
        int n2 = string.length();
        int n3 = DetailedResourceTraversal.findNextSeparator(string, n + 1, n2);
        while (n3 < n2) {
            if (!this.enterDirectory(string.substring(0, n3))) {
                return false;
            }
            n3 = DetailedResourceTraversal.findNextSeparator(string, n3 + 1, n2);
        }
        return !bl || this.enterDirectory(string);
    }

    private static int findPrevSeparator(String string, int n, int n2) {
        int n3 = string.lastIndexOf(47, n);
        return n3 < n2 ? n2 : n3;
    }

    private static int findNextSeparator(String string, int n, int n2) {
        int n3 = string.indexOf(47, n);
        return n3 == -1 || n3 > n2 ? n2 : n3;
    }

    private static int getCommonPathLength(String string, String string2) {
        int n;
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n2 = 0;
        for (n = 0; n < cArray.length && n < cArray2.length && cArray[n] == cArray2[n]; ++n) {
            if (cArray[n] != '/') continue;
            n2 = n;
        }
        if (n == cArray.length) {
            if (n == cArray2.length || cArray2[n] == '/') {
                n2 = n;
            }
        } else if (n == cArray2.length && cArray[n] == '/') {
            n2 = n;
        }
        return n2;
    }
}

