/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.util.TreeSet;
import org.zaproxy.zap.model.Tech;

public class TechSet {
    public static final TechSet AllTech = new TechSet(Tech.builtInTopLevelTech);
    private TreeSet<Tech> includeTech = new TreeSet();
    private TreeSet<Tech> excludeTech = new TreeSet();

    public TechSet() {
    }

    public TechSet(Tech[] include) {
        this(include, null);
    }

    public TechSet(Tech[] include, Tech[] exclude) {
        if (include != null) {
            for (Tech tech : include) {
                this.include(tech);
            }
        }
        if (exclude != null) {
            for (Tech tech : exclude) {
                this.exclude(tech);
            }
        }
    }

    public TechSet(TechSet techSet) {
        this.includeTech.addAll(techSet.includeTech);
        this.excludeTech.addAll(techSet.excludeTech);
    }

    public void include(Tech tech) {
        this.excludeTech.remove(tech);
        this.includeTech.add(tech);
    }

    public void exclude(Tech tech) {
        this.includeTech.remove(tech);
        this.excludeTech.add(tech);
    }

    public boolean includes(Tech tech) {
        if (tech == null) {
            return false;
        }
        if (this.excludeTech.contains(tech)) {
            return false;
        }
        if (this.includeTech.contains(tech)) {
            return true;
        }
        return this.includes(tech.getParent());
    }

    public boolean includesAny(Tech ... techs) {
        if (techs == null || techs.length == 0) {
            return false;
        }
        for (Tech tech : techs) {
            if (!this.includes(tech)) continue;
            return true;
        }
        return false;
    }

    public TreeSet<Tech> getIncludeTech() {
        TreeSet<Tech> copy = new TreeSet<Tech>();
        copy.addAll(this.includeTech);
        return copy;
    }

    public TreeSet<Tech> getExcludeTech() {
        TreeSet<Tech> copy = new TreeSet<Tech>();
        copy.addAll(this.excludeTech);
        return copy;
    }

    public void print() {
        System.out.println("TechSet: " + this.hashCode());
        for (Tech tech : this.includeTech) {
            System.out.println("\tInclude: " + tech);
        }
        for (Tech tech : this.excludeTech) {
            System.out.println("\tExclude: " + tech);
        }
    }
}

