'use strict';
const fileType = require('file-type');

const imageExts = new Set([
	'jpg',
	'png',
	'gif',
	'webp',
	'flif',
	'cr2',
	'tif',
	'bmp',
	'jxr',
	'psd',
	'ico',
	'bpg',
	'jp2',
	'jpm',
	'jpx',
	'heic',
	'cur',
	'dcm'
]);

const imageType = input => {
	const ret = fileType(input);
	return imageExts.has(ret && ret.ext) ? ret : null;
};

module.exports = imageType;
module.exports.default = imageType;

Object.defineProperty(imageType, 'minimumBytes', {value: fileType.minimumBytes});
