/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.update;

import java.io.IOException;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.IRequestProcessor;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.DirectoryPruner;
import org.netbeans.lib.cvsclient.command.ICvsFiles;
import org.netbeans.lib.cvsclient.command.IOCommandException;
import org.netbeans.lib.cvsclient.command.IUpdatingCommand;
import org.netbeans.lib.cvsclient.command.KeywordSubstitution;
import org.netbeans.lib.cvsclient.command.update.UpdateMessageParser;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.DualListener;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.progress.RangeProgressViewer;
import org.netbeans.lib.cvsclient.progress.receiving.FileInfoAndDirectoryResponseProgressHandler;
import org.netbeans.lib.cvsclient.progress.sending.FileStateRequestsProgressHandler;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.Requests;

public final class UpdateCommand
extends AbstractCommand
implements IUpdatingCommand {
    private boolean buildDirectories;
    private boolean cleanCopy;
    private boolean pruneDirectories;
    private boolean resetStickyOnes;
    private boolean useHeadIfNotFound;
    private String updateByDate;
    private String updateByRevision;
    private KeywordSubstitution keywordSubst;
    private String mergeRevision1;
    private String mergeRevision2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(IRequestProcessor requestProcessor, IEventSender eventSender, ICvsListenerRegistry listenerRegistry, IClientEnvironment clientEnvironment, IProgressViewer progressViewer) throws CommandException, AuthenticationException {
        ICvsFiles cvsFiles;
        try {
            cvsFiles = this.scanFileSystem(clientEnvironment);
        }
        catch (IOException ex) {
            throw new IOCommandException(ex);
        }
        Requests requests = new Requests(CommandRequest.UPDATE, clientEnvironment);
        requests.addArgumentRequest(this.isBuildDirectories(), "-d");
        requests.addArgumentRequest(this.isCleanCopy(), "-C");
        requests.addArgumentRequest(this.isResetStickyOnes(), "-A");
        requests.addArgumentRequest(this.isUseHeadIfNotFound(), "-f");
        requests.addArgumentRequest(this.getUpdateByDate(), "-D");
        requests.addArgumentRequest(this.getUpdateByRevision(), "-r");
        requests.addArgumentRequests(this.getMergeRevision1(), "-j");
        requests.addArgumentRequests(this.getMergeRevision2(), "-j");
        requests.addArgumentRequest(this.getKeywordSubst(), "-k");
        this.addFileRequests(cvsFiles, requests, clientEnvironment);
        requests.addLocalPathDirectoryRequest();
        this.addArgumentRequests(requests);
        DirectoryPruner directoryPruner = null;
        if (this.isPruneDirectories()) {
            directoryPruner = new DirectoryPruner(clientEnvironment);
            directoryPruner.registerListeners(listenerRegistry);
        }
        FileStateRequestsProgressHandler requestsProgressHandler = new FileStateRequestsProgressHandler(new RangeProgressViewer(progressViewer, 0.0, 0.5), cvsFiles);
        FileInfoAndDirectoryResponseProgressHandler responseProgressViewer = new FileInfoAndDirectoryResponseProgressHandler(new RangeProgressViewer(progressViewer, 0.5, 1.0), cvsFiles);
        UpdateMessageParser updateMessageParser = new UpdateMessageParser(eventSender, clientEnvironment.getCvsFileSystem());
        DualListener listener = new DualListener(updateMessageParser, responseProgressViewer);
        listener.registerListeners(listenerRegistry);
        try {
            boolean bl = requestProcessor.processRequests(requests, requestsProgressHandler);
            return bl;
        }
        finally {
            listener.unregisterListeners(listenerRegistry);
            if (directoryPruner != null) {
                directoryPruner.unregisterListeners(listenerRegistry);
                try {
                    directoryPruner.pruneEmptyDirectories();
                }
                catch (IOException ex) {
                    throw new IOCommandException(ex);
                }
            }
        }
    }

    @Override
    public String getCvsCommandLine() {
        StringBuffer cvsCommandLine = new StringBuffer("update ");
        cvsCommandLine.append(this.getCvsArguments());
        this.appendFileArguments(cvsCommandLine);
        return cvsCommandLine.toString();
    }

    @Override
    public void resetCvsCommand() {
        super.resetCvsCommand();
        this.setRecursive(true);
        this.setCleanCopy(false);
        this.setBuildDirectories(false);
        this.setPruneDirectories(false);
        this.setResetStickyOnes(false);
        this.setUseHeadIfNotFound(false);
        this.setUpdateByDate(null);
        this.setUpdateByRevisionOrTag(null);
        this.setKeywordSubst(null);
        this.setMergeRevision1(null);
        this.setMergeRevision2(null);
    }

    @Override
    protected void addModifiedRequest(FileObject fileObject, Entry entry, Requests requests, IClientEnvironment clientEnvironment) {
        if (this.isCleanCopy()) {
            if (!this.getGlobalOptions().isDoNoChanges()) {
                String newFileName = ".#" + fileObject.getName() + '.' + entry.getRevision();
                try {
                    clientEnvironment.getLocalFileWriter().renameLocalFile(fileObject, clientEnvironment.getCvsFileSystem(), newFileName);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            return;
        }
        super.addModifiedRequest(fileObject, entry, requests, clientEnvironment);
    }

    public void setBuildDirectories(boolean buildDirectories) {
        this.buildDirectories = buildDirectories;
    }

    private boolean isBuildDirectories() {
        return this.buildDirectories;
    }

    public void setCleanCopy(boolean cleanCopy) {
        this.cleanCopy = cleanCopy;
    }

    private boolean isCleanCopy() {
        return this.cleanCopy;
    }

    public void setPruneDirectories(boolean pruneDirectories) {
        this.pruneDirectories = pruneDirectories;
    }

    private boolean isPruneDirectories() {
        return this.pruneDirectories;
    }

    private boolean isResetStickyOnes() {
        return this.resetStickyOnes;
    }

    @Override
    public void setResetStickyOnes(boolean resetStickyOnes) {
        this.resetStickyOnes = resetStickyOnes;
    }

    private boolean isUseHeadIfNotFound() {
        return this.useHeadIfNotFound;
    }

    @Override
    public void setUseHeadIfNotFound(boolean useHeadIfNotFound) {
        this.useHeadIfNotFound = useHeadIfNotFound;
    }

    private String getUpdateByDate() {
        return this.updateByDate;
    }

    @Override
    public void setUpdateByDate(String updateByDate) {
        this.updateByDate = UpdateCommand.getTrimmedString(updateByDate);
    }

    public String getUpdateByRevision() {
        return this.updateByRevision;
    }

    @Override
    public void setUpdateByRevisionOrTag(String updateByRevision) {
        this.updateByRevision = UpdateCommand.getTrimmedString(updateByRevision);
    }

    private KeywordSubstitution getKeywordSubst() {
        return this.keywordSubst;
    }

    public void setKeywordSubst(KeywordSubstitution keywordSubst) {
        this.keywordSubst = keywordSubst;
    }

    private String getMergeRevision1() {
        return this.mergeRevision1;
    }

    public void setMergeRevision1(String mergeRevision1) {
        this.mergeRevision1 = UpdateCommand.getTrimmedString(mergeRevision1);
    }

    private String getMergeRevision2() {
        return this.mergeRevision2;
    }

    public void setMergeRevision2(String mergeRevision2) {
        this.mergeRevision2 = UpdateCommand.getTrimmedString(mergeRevision2);
    }

    private String getCvsArguments() {
        StringBuilder cvsArguments = new StringBuilder();
        if (this.isCleanCopy()) {
            cvsArguments.append("-C ");
        }
        if (!this.isRecursive()) {
            cvsArguments.append("-l ");
        }
        if (this.isBuildDirectories()) {
            cvsArguments.append("-d ");
        }
        if (this.isPruneDirectories()) {
            cvsArguments.append("-P ");
        }
        if (this.isResetStickyOnes()) {
            cvsArguments.append("-A ");
        }
        if (this.isUseHeadIfNotFound()) {
            cvsArguments.append("-f ");
        }
        if (this.getKeywordSubst() != null) {
            cvsArguments.append("-k");
            cvsArguments.append(this.getKeywordSubst());
            cvsArguments.append(' ');
        }
        if (this.getUpdateByRevision() != null) {
            cvsArguments.append("-r ");
            cvsArguments.append(this.getUpdateByRevision());
            cvsArguments.append(' ');
        }
        if (this.getUpdateByDate() != null) {
            cvsArguments.append("-D ");
            cvsArguments.append(this.getUpdateByDate());
            cvsArguments.append(' ');
        }
        if (this.getMergeRevision1() != null) {
            cvsArguments.append("-j ");
            cvsArguments.append(this.getMergeRevision1());
            cvsArguments.append(' ');
            if (this.getMergeRevision2() != null) {
                cvsArguments.append("-j ");
                cvsArguments.append(this.getMergeRevision2());
                cvsArguments.append(' ');
            }
        }
        return cvsArguments.toString();
    }

    @Override
    public void setUpdateByRevisionOrDate(String revision, String date) {
        this.setUpdateByRevisionOrTag(revision);
        this.setUpdateByDate(date);
    }
}

