/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.tools;

import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractToolsUsagesCollector
extends ProjectUsagesCollector {
    private static final Predicate<ScopeToolState> BUNDLED = state -> {
        IdeaPluginDescriptor descriptor = AbstractToolsUsagesCollector.getIdeaPluginDescriptor(state);
        return descriptor != null && descriptor.isBundled() && PluginManagerMain.isDevelopedByJetBrains(descriptor);
    };
    private static final Predicate<ScopeToolState> LISTED = state -> {
        IdeaPluginDescriptor descriptor = AbstractToolsUsagesCollector.getIdeaPluginDescriptor(state);
        return descriptor != null && !descriptor.isBundled() && StatisticsUtilKt.isSafeToReportFrom(descriptor);
    };
    private static final Predicate<ScopeToolState> ENABLED = state -> !state.getTool().isEnabledByDefault() && state.isEnabled();
    private static final Predicate<ScopeToolState> DISABLED = state -> state.getTool().isEnabledByDefault() && !state.isEnabled();

    private static IdeaPluginDescriptor getIdeaPluginDescriptor(ScopeToolState state) {
        InspectionEP extension = state.getTool().getExtension();
        return extension != null ? (IdeaPluginDescriptor)ObjectUtils.tryCast((Object)extension.getPluginDescriptor(), IdeaPluginDescriptor.class) : null;
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        if (project == null) {
            AbstractToolsUsagesCollector.$$$reportNull$$$0(0);
        }
        List<ScopeToolState> tools = InspectionProjectProfileManager.getInstance(project).getCurrentProfile().getAllTools();
        Set<UsageDescriptor> set = this.filter(tools.stream()).map(ScopeToolState::getTool).map(this::getInspectionToolId).map(UsageDescriptor::new).collect(Collectors.toSet());
        if (set == null) {
            AbstractToolsUsagesCollector.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    protected String getInspectionToolId(InspectionToolWrapper tool) {
        String string = tool.getLanguage() + "." + tool.getID();
        if (string == null) {
            AbstractToolsUsagesCollector.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected abstract Stream<ScopeToolState> filter(@NotNull Stream<ScopeToolState> var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionToolId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUsages";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DisabledListedToolsUsagesCollector
    extends AbstractListedToolsUsagesCollector {
        @Override
        @NotNull
        public String getGroupId() {
            if ("statistics.disabled.listed.tools" == null) {
                DisabledListedToolsUsagesCollector.$$$reportNull$$$0(0);
            }
            return "statistics.disabled.listed.tools";
        }

        @Override
        @NotNull
        protected Stream<ScopeToolState> filter(@NotNull Stream<ScopeToolState> tools) {
            if (tools == null) {
                DisabledListedToolsUsagesCollector.$$$reportNull$$$0(1);
            }
            Stream<ScopeToolState> stream = tools.filter(DISABLED).filter(LISTED);
            if (stream == null) {
                DisabledListedToolsUsagesCollector.$$$reportNull$$$0(2);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$DisabledListedToolsUsagesCollector";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tools";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$DisabledListedToolsUsagesCollector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "filter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DisabledBundledToolsUsagesCollector
    extends AbstractToolsUsagesCollector {
        @Override
        @NotNull
        public String getGroupId() {
            if ("statistics.disabled.bundled.tools" == null) {
                DisabledBundledToolsUsagesCollector.$$$reportNull$$$0(0);
            }
            return "statistics.disabled.bundled.tools";
        }

        @Override
        @NotNull
        protected Stream<ScopeToolState> filter(@NotNull Stream<ScopeToolState> tools) {
            if (tools == null) {
                DisabledBundledToolsUsagesCollector.$$$reportNull$$$0(1);
            }
            Stream<ScopeToolState> stream = tools.filter(DISABLED).filter(BUNDLED);
            if (stream == null) {
                DisabledBundledToolsUsagesCollector.$$$reportNull$$$0(2);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$DisabledBundledToolsUsagesCollector";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tools";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$DisabledBundledToolsUsagesCollector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "filter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class EnabledListedToolsUsagesCollector
    extends AbstractListedToolsUsagesCollector {
        @Override
        @NotNull
        public String getGroupId() {
            if ("statistics.enabled.listed.tools" == null) {
                EnabledListedToolsUsagesCollector.$$$reportNull$$$0(0);
            }
            return "statistics.enabled.listed.tools";
        }

        @Override
        @NotNull
        protected Stream<ScopeToolState> filter(@NotNull Stream<ScopeToolState> tools) {
            if (tools == null) {
                EnabledListedToolsUsagesCollector.$$$reportNull$$$0(1);
            }
            Stream<ScopeToolState> stream = tools.filter(ENABLED).filter(LISTED);
            if (stream == null) {
                EnabledListedToolsUsagesCollector.$$$reportNull$$$0(2);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$EnabledListedToolsUsagesCollector";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tools";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$EnabledListedToolsUsagesCollector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "filter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class EnabledBundledToolsUsagesCollector
    extends AbstractToolsUsagesCollector {
        @Override
        @NotNull
        public String getGroupId() {
            if ("statistics.enabled.bundled.tools" == null) {
                EnabledBundledToolsUsagesCollector.$$$reportNull$$$0(0);
            }
            return "statistics.enabled.bundled.tools";
        }

        @Override
        @NotNull
        protected Stream<ScopeToolState> filter(@NotNull Stream<ScopeToolState> tools) {
            if (tools == null) {
                EnabledBundledToolsUsagesCollector.$$$reportNull$$$0(1);
            }
            Stream<ScopeToolState> stream = tools.filter(ENABLED).filter(BUNDLED);
            if (stream == null) {
                EnabledBundledToolsUsagesCollector.$$$reportNull$$$0(2);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$EnabledBundledToolsUsagesCollector";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tools";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$EnabledBundledToolsUsagesCollector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "filter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static abstract class AbstractListedToolsUsagesCollector
    extends AbstractToolsUsagesCollector {
        protected AbstractListedToolsUsagesCollector() {
        }

        @Override
        @NotNull
        protected String getInspectionToolId(InspectionToolWrapper tool) {
            String string = tool.getLanguage() + "." + tool.getExtension().getPluginId() + "." + tool.getID();
            if (string == null) {
                AbstractListedToolsUsagesCollector.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$AbstractListedToolsUsagesCollector", "getInspectionToolId"));
        }
    }
}

