/*
 * Decompiled with CFR 0.152.
 */
package git4idea.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.changes.GitCommittedChangeList;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.history.browser.SHAHash;
import git4idea.repo.GitRepository;
import git4idea.util.StringScanner;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitChangeUtils {
    public static final String COMMITTED_CHANGELIST_FORMAT = "%ct%n%H%n%P%n%an%x20%x3C%ae%x3E%n%cn%x20%x3C%ce%x3E%n%s%n%x03%n%b%n%x03";
    private static final Logger LOG = Logger.getInstance(GitChangeUtils.class);

    private GitChangeUtils() {
    }

    public static void parseChanges(Project project, VirtualFile vcsRoot, @Nullable GitRevisionNumber thisRevision, GitRevisionNumber parentRevision, String s, Collection<Change> changes, Set<String> ignoreNames) throws VcsException {
        StringScanner sc = new StringScanner(s);
        GitChangeUtils.parseChanges(project, vcsRoot, thisRevision, parentRevision, sc, changes, ignoreNames);
        if (sc.hasMoreData()) {
            throw new IllegalStateException("Unknown file status: " + sc.line());
        }
    }

    public static Collection<String> parseDiffForPaths(String rootPath, StringScanner s) throws VcsException {
        ArrayList<String> result2 = new ArrayList<String>();
        while (s.hasMoreData()) {
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            if ("CADUMR".indexOf(s.peek()) == -1) break;
            assert ('M' != s.peek()) : "Moves are not yet handled";
            String[] tokens = s.line().split("\t");
            String path = tokens[tokens.length - 1];
            path = rootPath + File.separator + GitUtil.unescapePath(path);
            path = FileUtil.toSystemDependentName((String)path);
            result2.add(path);
        }
        return result2;
    }

    private static void parseChanges(Project project, VirtualFile vcsRoot, @Nullable GitRevisionNumber thisRevision, @Nullable GitRevisionNumber parentRevision, StringScanner s, Collection<Change> changes, Set<String> ignoreNames) throws VcsException {
        while (s.hasMoreData()) {
            ContentRevision after;
            ContentRevision before;
            FileStatus status = null;
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            if ("CADUMRT".indexOf(s.peek()) == -1) {
                return;
            }
            String[] tokens = s.line().split("\t");
            String path = tokens[tokens.length - 1];
            switch (tokens[0].charAt(0)) {
                case 'A': 
                case 'C': {
                    before = null;
                    status = FileStatus.ADDED;
                    after = GitContentRevision.createRevision(vcsRoot, path, (VcsRevisionNumber)thisRevision, project, true);
                    break;
                }
                case 'U': {
                    status = FileStatus.MERGED_WITH_CONFLICTS;
                }
                case 'M': {
                    if (status == null) {
                        status = FileStatus.MODIFIED;
                    }
                    before = GitContentRevision.createRevision(vcsRoot, path, (VcsRevisionNumber)parentRevision, project, true);
                    after = GitContentRevision.createRevision(vcsRoot, path, (VcsRevisionNumber)thisRevision, project, true);
                    break;
                }
                case 'D': {
                    status = FileStatus.DELETED;
                    before = GitContentRevision.createRevision(vcsRoot, path, (VcsRevisionNumber)parentRevision, project, true);
                    after = null;
                    break;
                }
                case 'R': {
                    status = FileStatus.MODIFIED;
                    before = GitContentRevision.createRevision(vcsRoot, tokens[1], (VcsRevisionNumber)parentRevision, project, true);
                    after = GitContentRevision.createRevision(vcsRoot, path, (VcsRevisionNumber)thisRevision, project, true);
                    break;
                }
                case 'T': {
                    status = FileStatus.MODIFIED;
                    before = GitContentRevision.createRevision(vcsRoot, path, (VcsRevisionNumber)parentRevision, project, true);
                    after = GitContentRevision.createRevisionForTypeChange(project, vcsRoot, path, (VcsRevisionNumber)thisRevision, true);
                    break;
                }
                default: {
                    throw new VcsException("Unknown file status: " + Arrays.asList(tokens));
                }
            }
            if (ignoreNames != null && ignoreNames.contains(path)) continue;
            changes.add(new Change(before, after, status));
        }
    }

    @NotNull
    public static GitRevisionNumber resolveReference(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull String reference) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(0);
        }
        if (vcsRoot == null) {
            GitChangeUtils.$$$reportNull$$$0(1);
        }
        if (reference == null) {
            GitChangeUtils.$$$reportNull$$$0(2);
        }
        GitLineHandler handler = GitChangeUtils.createRefResolveHandler(project, vcsRoot, reference);
        String output = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
        StringTokenizer stk = new StringTokenizer(output, "\n\r \t", false);
        if (!stk.hasMoreTokens()) {
            try {
                GitLineHandler dh = new GitLineHandler(project, vcsRoot, GitCommand.LOG);
                dh.addParameters("-1", "HEAD");
                dh.setSilent(true);
                String out = Git.getInstance().runCommand(dh).getOutputOrThrow(new int[0]);
                LOG.info("Diagnostic output from 'git log -1 HEAD': [" + out + "]");
                dh = GitChangeUtils.createRefResolveHandler(project, vcsRoot, reference);
                out = Git.getInstance().runCommand(dh).getOutputOrThrow(new int[0]);
                LOG.info("Diagnostic output from 'git rev-list -1 --timestamp HEAD': [" + out + "]");
            }
            catch (VcsException e) {
                LOG.info("Exception while trying to get some diagnostics info", (Throwable)e);
            }
            throw new VcsException(String.format("The string '%s' does not represent a revision number. Output: [%s]\n Root: %s", reference, output, vcsRoot));
        }
        Date timestamp = GitUtil.parseTimestampWithNFEReport(stk.nextToken(), handler, output);
        GitRevisionNumber gitRevisionNumber = new GitRevisionNumber(stk.nextToken(), timestamp);
        if (gitRevisionNumber == null) {
            GitChangeUtils.$$$reportNull$$$0(3);
        }
        return gitRevisionNumber;
    }

    @NotNull
    private static GitLineHandler createRefResolveHandler(@NotNull Project project, @NotNull VirtualFile root, @NotNull String reference) {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(4);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(5);
        }
        if (reference == null) {
            GitChangeUtils.$$$reportNull$$$0(6);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.REV_LIST);
        handler.addParameters("--timestamp", "--max-count=1", reference);
        handler.endOptions();
        handler.setSilent(true);
        GitLineHandler gitLineHandler = handler;
        if (gitLineHandler == null) {
            GitChangeUtils.$$$reportNull$$$0(7);
        }
        return gitLineHandler;
    }

    public static boolean isHeadMissing(VcsException e) {
        String errorText = "fatal: bad revision 'HEAD'\n";
        return e.getMessage().equals("fatal: bad revision 'HEAD'\n");
    }

    public static GitCommittedChangeList getRevisionChanges(Project project, VirtualFile root, String revisionName, boolean skipDiffsForMerge, boolean local, boolean revertable) throws VcsException {
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.SHOW);
        h.setSilent(true);
        h.addParameters("--name-status", "--first-parent", "--no-abbrev", "-M", "--pretty=format:%ct%n%H%n%P%n%an%x20%x3C%ae%x3E%n%cn%x20%x3C%ce%x3E%n%s%n%x03%n%b%n%x03", "--encoding=UTF-8", revisionName, "--");
        String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        StringScanner s = new StringScanner(output);
        return GitChangeUtils.parseChangeList(project, root, s, skipDiffsForMerge, h, local, revertable);
    }

    @Nullable
    public static SHAHash commitExists(Project project, VirtualFile root, String anyReference, List<VirtualFile> paths, String ... parameters) {
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        h.setSilent(true);
        h.addParameters(parameters);
        h.addParameters("--max-count=1", "--pretty=%H", "--encoding=UTF-8", anyReference, "--");
        if (paths != null && !paths.isEmpty()) {
            h.addRelativeFiles(paths);
        }
        try {
            String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]).trim();
            if (StringUtil.isEmptyOrSpaces((String)output)) {
                return null;
            }
            return new SHAHash(output);
        }
        catch (VcsException e) {
            return null;
        }
    }

    public static GitCommittedChangeList parseChangeList(Project project, VirtualFile root, StringScanner s, boolean skipDiffsForMerge, GitHandler handler, boolean local, boolean revertable) throws VcsException {
        ArrayList<Change> changes = new ArrayList<Change>();
        Date commitDate = GitUtil.parseTimestampWithNFEReport(s.line(), handler, s.getAllText());
        String revisionNumber = s.line();
        String parentsLine = s.line();
        String[] parents = parentsLine.length() == 0 ? ArrayUtil.EMPTY_STRING_ARRAY : parentsLine.split(" ");
        String authorName = s.line();
        String committerName = s.line();
        committerName = GitUtil.adjustAuthorName(authorName, committerName);
        String commentSubject = s.boundedToken('\u0003', true);
        s.nextLine();
        String commentBody = s.boundedToken('\u0003', true);
        String fullComment = commentSubject.length() == 0 ? commentBody : (commentBody.length() == 0 ? commentSubject : commentSubject + "\n" + commentBody);
        GitRevisionNumber thisRevision = new GitRevisionNumber(revisionNumber, commitDate);
        if (skipDiffsForMerge || parents.length <= 1) {
            String[] parentRevision = parents.length > 0 ? GitChangeUtils.resolveReference(project, root, parents[0]) : null;
            GitChangeUtils.parseChanges(project, root, thisRevision, (GitRevisionNumber)(local ? null : parentRevision), s, changes, null);
        } else {
            for (String parent : parents) {
                GitRevisionNumber parentRevision = GitChangeUtils.resolveReference(project, root, parent);
                GitLineHandler diffHandler = new GitLineHandler(project, root, GitCommand.DIFF);
                diffHandler.setSilent(true);
                diffHandler.addParameters("--name-status", "-M", parentRevision.getRev(), thisRevision.getRev());
                String diff = Git.getInstance().runCommand(diffHandler).getOutputOrThrow(new int[0]);
                GitChangeUtils.parseChanges(project, root, thisRevision, parentRevision, diff, changes, null);
                if (changes.size() > 0) break;
            }
        }
        String changeListName = String.format("%s(%s)", commentSubject, revisionNumber);
        return new GitCommittedChangeList(changeListName, fullComment, committerName, thisRevision, commitDate, changes, GitVcs.getInstance(project), revertable);
    }

    public static long longForSHAHash(String revisionNumber) {
        return Long.parseLong(revisionNumber.substring(0, 15), 16) << 4 + Integer.parseInt(revisionNumber.substring(15, 16), 16);
    }

    @NotNull
    public static Collection<Change> getDiff(@NotNull Project project, @NotNull VirtualFile root, @Nullable String oldRevision, @Nullable String newRevision, @Nullable Collection<FilePath> dirtyPaths) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(8);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(9);
        }
        Collection<Change> collection = GitChangeUtils.getDiff(project, root, oldRevision, newRevision, dirtyPaths, true);
        if (collection == null) {
            GitChangeUtils.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    private static Collection<Change> getDiff(@NotNull Project project, @NotNull VirtualFile root, @Nullable String oldRevision, @Nullable String newRevision, @Nullable Collection<FilePath> dirtyPaths, boolean detectRenames) throws VcsException {
        GitRevisionNumber newRev;
        GitRevisionNumber oldRev;
        String range;
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(11);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(12);
        }
        LOG.assertTrue(oldRevision != null || newRevision != null, (Object)"Both old and new revisions can't be null");
        if (newRevision == null) {
            range = oldRevision + "..";
            oldRev = GitChangeUtils.resolveReference(project, root, oldRevision);
            newRev = null;
        } else if (oldRevision == null) {
            range = ".." + newRevision;
            oldRev = null;
            newRev = GitChangeUtils.resolveReference(project, root, newRevision);
        } else {
            range = oldRevision + ".." + newRevision;
            oldRev = GitChangeUtils.resolveReference(project, root, oldRevision);
            newRev = GitChangeUtils.resolveReference(project, root, newRevision);
        }
        String output = GitChangeUtils.getDiffOutput(project, root, range, dirtyPaths, false, detectRenames);
        ArrayList<Change> changes = new ArrayList<Change>();
        GitChangeUtils.parseChanges(project, root, newRev, oldRev, output, changes, Collections.emptySet());
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            GitChangeUtils.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<Change> getStagedChanges(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(14);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(15);
        }
        GitLineHandler diff = new GitLineHandler(project, root, GitCommand.DIFF);
        diff.addParameters("--name-status", "--cached", "-M");
        String output = Git.getInstance().runCommand(diff).getOutputOrThrow(new int[0]);
        ArrayList<Change> changes = new ArrayList<Change>();
        GitChangeUtils.parseChanges(project, root, null, GitRevisionNumber.HEAD, output, changes, Collections.emptySet());
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            GitChangeUtils.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    public static List<File> getUnmergedFiles(@NotNull GitRepository repository) throws VcsException {
        GitCommandResult result2;
        if (repository == null) {
            GitChangeUtils.$$$reportNull$$$0(17);
        }
        if (!(result2 = Git.getInstance().getUnmergedFiles(repository)).success()) {
            throw new VcsException(result2.getErrorOutputAsJoinedString());
        }
        String output = StringUtil.join(result2.getOutput(), (String)"\n");
        HashSet unmergedPaths = ContainerUtil.newHashSet();
        StringScanner s = new StringScanner(output);
        while (s.hasMoreData()) {
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            s.boundedToken('\t');
            String relative = s.line();
            unmergedPaths.add(GitUtil.unescapePath(relative));
        }
        VirtualFile root = repository.getRoot();
        List list = ContainerUtil.map((Collection)unmergedPaths, path -> new File(root.getPath(), (String)path));
        if (list == null) {
            GitChangeUtils.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public static Collection<Change> getDiffWithWorkingDir(@NotNull Project project, @NotNull VirtualFile root, @NotNull String oldRevision, @Nullable Collection<FilePath> dirtyPaths, boolean reverse) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(19);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(20);
        }
        if (oldRevision == null) {
            GitChangeUtils.$$$reportNull$$$0(21);
        }
        Collection<Change> collection = GitChangeUtils.getDiffWithWorkingDir(project, root, oldRevision, dirtyPaths, reverse, true);
        if (collection == null) {
            GitChangeUtils.$$$reportNull$$$0(22);
        }
        return collection;
    }

    @NotNull
    private static Collection<Change> getDiffWithWorkingDir(@NotNull Project project, @NotNull VirtualFile root, @NotNull String oldRevision, @Nullable Collection<FilePath> dirtyPaths, boolean reverse, boolean detectRenames) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(23);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(24);
        }
        if (oldRevision == null) {
            GitChangeUtils.$$$reportNull$$$0(25);
        }
        String output = GitChangeUtils.getDiffOutput(project, root, oldRevision, dirtyPaths, reverse, detectRenames);
        ArrayList<Change> changes = new ArrayList<Change>();
        GitRevisionNumber revisionNumber = GitChangeUtils.resolveReference(project, root, oldRevision);
        GitChangeUtils.parseChanges(project, root, reverse ? revisionNumber : null, reverse ? null : revisionNumber, output, changes, Collections.emptySet());
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            GitChangeUtils.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    @NotNull
    private static String getDiffOutput(@NotNull Project project, @NotNull VirtualFile root, @NotNull String diffRange, @Nullable Collection<FilePath> dirtyPaths, boolean reverse, boolean detectRenames) throws VcsException {
        GitLineHandler handler;
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(27);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(28);
        }
        if (diffRange == null) {
            GitChangeUtils.$$$reportNull$$$0(29);
        }
        if ((handler = GitChangeUtils.getDiffHandler(project, root, diffRange, dirtyPaths, reverse, detectRenames)).isLargeCommandLine()) {
            handler = GitChangeUtils.getDiffHandler(project, root, diffRange, null, reverse, detectRenames);
        }
        String string = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
        if (string == null) {
            GitChangeUtils.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public static String getDiffOutput(@NotNull Project project, @NotNull VirtualFile root, @NotNull String diffRange, @Nullable Collection<FilePath> dirtyPaths) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(31);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(32);
        }
        if (diffRange == null) {
            GitChangeUtils.$$$reportNull$$$0(33);
        }
        String string = GitChangeUtils.getDiffOutput(project, root, diffRange, dirtyPaths, false, true);
        if (string == null) {
            GitChangeUtils.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    private static GitLineHandler getDiffHandler(@NotNull Project project, @NotNull VirtualFile root, @NotNull String diffRange, @Nullable Collection<FilePath> dirtyPaths, boolean reverse, boolean detectRenames) {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(35);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(36);
        }
        if (diffRange == null) {
            GitChangeUtils.$$$reportNull$$$0(37);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.DIFF);
        if (reverse) {
            handler.addParameters("-R");
        }
        handler.addParameters("--name-status", "--diff-filter=ADCMRUXT");
        if (detectRenames) {
            handler.addParameters("-M");
        }
        handler.addParameters(diffRange);
        handler.setSilent(true);
        handler.setStdoutSuppressed(true);
        handler.endOptions();
        if (dirtyPaths != null) {
            handler.addRelativePaths(dirtyPaths);
        }
        GitLineHandler gitLineHandler = handler;
        if (gitLineHandler == null) {
            GitChangeUtils.$$$reportNull$$$0(38);
        }
        return gitLineHandler;
    }

    @Nullable
    public static Collection<Change> getDiffWithWorkingTree(@NotNull GitRepository repository, @NotNull String refToCompare, boolean detectRenames) {
        Collection<Change> changes;
        if (repository == null) {
            GitChangeUtils.$$$reportNull$$$0(39);
        }
        if (refToCompare == null) {
            GitChangeUtils.$$$reportNull$$$0(40);
        }
        try {
            changes = GitChangeUtils.getDiffWithWorkingDir(repository.getProject(), repository.getRoot(), refToCompare, null, false, detectRenames);
        }
        catch (VcsException e) {
            LOG.warn("Couldn't collect diff", (Throwable)e);
            changes = null;
        }
        return changes;
    }

    @Nullable
    public static Collection<Change> getDiff(@NotNull GitRepository repository, @NotNull String oldRevision, @NotNull String newRevision, boolean detectRenames) {
        if (repository == null) {
            GitChangeUtils.$$$reportNull$$$0(41);
        }
        if (oldRevision == null) {
            GitChangeUtils.$$$reportNull$$$0(42);
        }
        if (newRevision == null) {
            GitChangeUtils.$$$reportNull$$$0(43);
        }
        try {
            return GitChangeUtils.getDiff(repository.getProject(), repository.getRoot(), oldRevision, newRevision, null, detectRenames);
        }
        catch (VcsException e) {
            LOG.info("Couldn't collect changes between " + oldRevision + " and " + newRevision, (Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 22: 
            case 26: 
            case 30: 
            case 34: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 22: 
            case 26: 
            case 30: 
            case 34: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 22: 
            case 26: 
            case 30: 
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/changes/GitChangeUtils";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 15: 
            case 20: 
            case 24: 
            case 28: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 17: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 21: 
            case 25: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRevision";
                break;
            }
            case 29: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffRange";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refToCompare";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/changes/GitChangeUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReference";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createRefResolveHandler";
                break;
            }
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiff";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getStagedChanges";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnmergedFiles";
                break;
            }
            case 22: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffWithWorkingDir";
                break;
            }
            case 30: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffOutput";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 22: 
            case 26: 
            case 30: 
            case 34: 
            case 38: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRefResolveHandler";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getDiff";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getStagedChanges";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getUnmergedFiles";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDiffWithWorkingDir";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getDiffOutput";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getDiffHandler";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getDiffWithWorkingTree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 22: 
            case 26: 
            case 30: 
            case 34: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

