/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import java.util.Set;
import javax.validation.constraints.Min;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.sejda.common.collection.NullSafeSet;
import org.sejda.model.parameter.AbstractSplitByPageParameters;

public class SplitByEveryXPagesParameters
extends AbstractSplitByPageParameters {
    @Min(value=1L)
    private int step = 1;

    public SplitByEveryXPagesParameters(int step) {
        this.step = step;
    }

    @Override
    public Set<Integer> getPages(int upperLimit) {
        NullSafeSet<Integer> pages = new NullSafeSet<Integer>();
        for (int i = this.step; i <= upperLimit; i += this.step) {
            pages.add(i);
        }
        return pages;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append(this.step).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.step).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SplitByEveryXPagesParameters)) {
            return false;
        }
        SplitByEveryXPagesParameters parameter = (SplitByEveryXPagesParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(this.step, parameter.step).isEquals();
    }
}

