/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.core.CoreJavaCodeStyleManager;
import com.intellij.core.CoreJavaCodeStyleSettingsFacade;
import com.intellij.core.CoreJavaFileManager;
import com.intellij.core.CoreJavaPsiImplementationHelper;
import com.intellij.core.CoreLanguageLevelProjectExtension;
import com.intellij.core.CorePackageIndex;
import com.intellij.core.CoreProjectEnvironment;
import com.intellij.lang.jvm.facade.JvmFacade;
import com.intellij.lang.jvm.facade.JvmFacadeImpl;
import com.intellij.mock.MockFileIndexFacade;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JvmPsiConversionHelper;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.impl.JavaPsiFacadeImpl;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.JvmPsiConversionHelperImpl;
import com.intellij.psi.impl.PsiElementFactoryImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.source.resolve.JavaResolveCache;
import com.intellij.psi.impl.source.resolve.PsiResolveHelperImpl;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class JavaCoreProjectEnvironment
extends CoreProjectEnvironment {
    private final JavaFileManager myFileManager;
    private final PackageIndex myPackageIndex;

    public JavaCoreProjectEnvironment(@NotNull Disposable parentDisposable, @NotNull CoreApplicationEnvironment applicationEnvironment2) {
        if (parentDisposable == null) {
            JavaCoreProjectEnvironment.$$$reportNull$$$0(0);
        }
        if (applicationEnvironment2 == null) {
            JavaCoreProjectEnvironment.$$$reportNull$$$0(1);
        }
        super(parentDisposable, applicationEnvironment2);
        this.myProject.registerService(PsiElementFactory.class, new PsiElementFactoryImpl(this.myPsiManager));
        this.myProject.registerService(JavaPsiImplementationHelper.class, this.createJavaPsiImplementationHelper());
        this.myProject.registerService(PsiResolveHelper.class, new PsiResolveHelperImpl(this.myPsiManager));
        this.myProject.registerService(LanguageLevelProjectExtension.class, new CoreLanguageLevelProjectExtension());
        this.myProject.registerService(JavaResolveCache.class, new JavaResolveCache(this.myMessageBus));
        this.myProject.registerService(JavaCodeStyleSettingsFacade.class, new CoreJavaCodeStyleSettingsFacade());
        this.myProject.registerService(JavaCodeStyleManager.class, new CoreJavaCodeStyleManager());
        this.myProject.registerService(ControlFlowFactory.class, new ControlFlowFactory(this.myPsiManager));
        this.myPackageIndex = this.createCorePackageIndex();
        this.myProject.registerService(PackageIndex.class, this.myPackageIndex);
        this.myFileManager = this.createCoreFileManager();
        this.myProject.registerService(JavaFileManager.class, this.myFileManager);
        this.myProject.registerService(JvmPsiConversionHelper.class, new JvmPsiConversionHelperImpl());
        this.registerJavaPsiFacade();
        this.myProject.registerService(JvmFacade.class, new JvmFacadeImpl(this.myProject, this.myMessageBus));
    }

    protected void registerJavaPsiFacade() {
        JavaPsiFacadeImpl javaPsiFacade = new JavaPsiFacadeImpl(this.myProject, this.myPsiManager, this.myFileManager, this.myMessageBus);
        this.myProject.registerService(JavaPsiFacade.class, javaPsiFacade);
    }

    protected CoreJavaPsiImplementationHelper createJavaPsiImplementationHelper() {
        return new CoreJavaPsiImplementationHelper(this.myProject);
    }

    protected JavaFileManager createCoreFileManager() {
        return new CoreJavaFileManager(this.myPsiManager);
    }

    protected PackageIndex createCorePackageIndex() {
        return new CorePackageIndex();
    }

    public void addJarToClassPath(File path2) {
        assert (path2.isFile());
        VirtualFile root2 = this.getEnvironment().getJarFileSystem().findFileByPath(path2 + "!/");
        if (root2 == null) {
            throw new IllegalArgumentException("trying to add non-existing file to classpath: " + path2);
        }
        this.addSourcesToClasspath(root2);
    }

    public void addSourcesToClasspath(@NotNull VirtualFile root2) {
        if (root2 == null) {
            JavaCoreProjectEnvironment.$$$reportNull$$$0(2);
        }
        assert (root2.isDirectory());
        ((CoreJavaFileManager)this.myFileManager).addToClasspath(root2);
        ((CorePackageIndex)this.myPackageIndex).addToClasspath(root2);
        ((MockFileIndexFacade)this.myFileIndexFacade).addLibraryRoot(root2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationEnvironment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        objectArray2[1] = "com/intellij/core/JavaCoreProjectEnvironment";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addSourcesToClasspath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

