"use strict";

var _markdown_vis = require("./markdown_vis");

var _markdown_fn = require("./markdown_fn");

var _registries = require("../../interpreter/public/registries");

var _public = require("../../visualizations/public");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var VisTypeMarkdownPlugin =
/*#__PURE__*/
function () {
  function VisTypeMarkdownPlugin() {
    _classCallCheck(this, VisTypeMarkdownPlugin);
  }

  _createClass(VisTypeMarkdownPlugin, [{
    key: "setup",
    value: function setup(_ref) {
      var visualizations = _ref.visualizations,
          data = _ref.data;
      visualizations.types.VisTypesRegistryProvider.register(function () {
        return _markdown_vis.markdownVis;
      });
      data.expressions.registerFunction(_markdown_fn.kibanaMarkdown);
    }
  }, {
    key: "start",
    value: function start() {}
  }, {
    key: "stop",
    value: function stop() {}
  }]);

  return VisTypeMarkdownPlugin;
}();

new VisTypeMarkdownPlugin().setup({
  visualizations: _public.visualizations,
  data: {
    expressions: {
      registerFunction: function registerFunction(fn) {
        return _registries.functionsRegistry.register(fn);
      }
    }
  }
});