/**
 * @file `Filterable` represents data structures which can be _partitioned_/_filtered_.
 *
 * Adapted from https://github.com/LiamGoodacre/purescript-filterable/blob/master/src/Data/Filterable.purs
 */
import { getCompactableComposition } from './Compactable';
import { some, none } from './Option';
export function getFilterableComposition(F, G) {
    const FC = Object.assign({}, getCompactableComposition(F, G), { partitionMap: (fga, f) => {
            const left = FC.filterMap(fga, a => f(a).fold(some, () => none));
            const right = FC.filterMap(fga, a => f(a).fold(() => none, some));
            return { left, right };
        }, partition: (fga, p) => {
            const left = FC.filter(fga, a => !p(a));
            const right = FC.filter(fga, p);
            return { left, right };
        }, filterMap: (fga, f) => F.map(fga, ga => G.filterMap(ga, f)), filter: (fga, f) => F.map(fga, ga => G.filter(ga, f)) });
    return FC;
}
